Rem
Rem Copyright (c) 2008, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      xoqu111.sql - migration script for upgrading olap api component
Rem
Rem    DESCRIPTION
Rem      Upgrade OLAP API from 11.1.0
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dbardwel    07/17/09 - drop snapi types
Rem    dbardwel    08/19/08 - Updates for olap data security for 11.2
Rem    jhartsin    02/21/08 - Creation

execute sys.dbms_registry.upgrading('XOQ');

-- drop ODBO support
DROP PACKAGE DBMS_XSOQ_ODBO;
DROP VIEW olap_oledb_measdims_pvt;
DROP VIEW olap_oledb_listdims_pvt;
DROP VIEW olap_oledb_stdhiers_pvt;
DROP VIEW olap_oledb_stdlevels_pvt;
DROP VIEW olap_oledb_cubedims_pvt;
DROP VIEW olap_oledb_custprops_pvt;
DROP VIEW olap_oledb_level_type_pvt;
DROP VIEW olap_oledb_cardinality_pvt;
DROP VIEW olap_oledb_dflt_mbr_pvt;
DROP VIEW olap_oledb_reg_attrs_pvt;
DROP VIEW olap_oledb_cubes;
DROP VIEW olap_oledb_dimensions;
DROP VIEW olap_oledb_hierarchies;
DROP VIEW olap_oledb_levels;
DROP VIEW olap_oledb_properties;
DROP VIEW olap_oledb_measures;
DROP VIEW olap_oledb_actions;
DROP VIEW olap_oledb_functions;
DROP VIEW olap_oledb_sets;
DROP TYPE Olapi_MDX_Rowset_Impl_t FORCE;
DROP FUNCTION Olapi_MDX_Rowset_Table;
DROP VIEW olap_oledb_mdproperties;
DROP TABLE olap_oledb_mdprops;
DROP TABLE olap_oledb_mdpropvals;
DROP TABLE olap_oledb_keywords;
DROP TABLE olap_oledb_functions_pvt;

-- data security for 11.2
@@awmxsrol.sql
@@awmcrxdb.plb

-- drop snapi types. Depending on where the upgrade comes from,
-- snapi type may or may not be present. Guard the drops with
-- exception handling.
begin
  execute immediate 'DROP TYPE GenExtraStruct FORCE';
  execute immediate 'DROP TYPE GenPKTStruct FORCE';
  execute immediate 'DROP PACKAGE GenSnapiInterface';
  exception when others then null;
end;
/

execute sys.dbms_registry.upgraded('XOQ');

