
package common;

import java.lang.reflect.Member;

public interface OJVMMBean { 
 
  public void exitSession(int status);
  public void exitCall(int status);
  public boolean inEndOfCall();

  // read-only, "Linux Port" or "Windows Port"
  public String getPlatform();

  public boolean definePackage(String name);

  // correspond to public void setCallExitPolicy(int policy)
  public void exitCallWhenMainThreadTerminates();
  public void exitCallWhenAllNonDaemonThreadsTerminate();
  public void exitCallWhenAllThreadsTerminate();

  // one of "ExitCallWhenMainThreadTerminates" "ExitCallWhenAllNonDaemonThreadsTerminate" "ExitCallWhenAllThreadsTerminate"
  public String  getCallExitPolicy();

  // boolean writeable attribute
  // corresponds to OracleRuntime.getThreadTerminationPolicy
  public boolean getForceActiveThreadTherminationAtCallEnd();
  public void setForceActiveThreadTherminationAtCallEnd(boolean val);

  // long writeable attribute
  public long getMaxMemorySize();
  public void setMaxMemorySize(long maxSize);

  // long writeable attribute
  public long getMaxRunspaceSize();
  public void setMaxRunspaceSize(long maxSize);

  // long read-only attribute
  public long getMaxSessionSize();
  // long read-only attribute
  public long getSessionSoftLimit();
  
  // long read-only attribute
  public long getSessionSize();

  // long writeable attribute
  public long getNewspaceSize();
  public void setNewspaceSize(long size);

  // boolean writeable attribute
  // corresponds to OracleRuntime's newspaceEnabled, enableNewspace.
  public boolean getNewspaceEnabled();
  public void setNewspaceEnabled(boolean enable);

  // byte writeable attribute
  public byte getNewspaceMaxGeneration();
  public void setNewspaceMaxGeneration(byte arg);

  // byte read-only attribute
  public byte getMinNewspaceTenurePolicy();
  // byte read-only attribute
  public byte getDefaultNewspaceTenurePolicy();

  // byte writeable attribute
  // corresponds to OracleRuntime's setNewspaceTenurePolicy, getNewspaceTenurePolicy
  public byte getNewspaceTenureGeneration();
  public void setNewspaceTenureGeneration(byte arg);

  // long writeable attribute
  public long getSessionGCThreshold();
  public void setSessionGCThreshold(long size);


  // corresponds to OracleRuntime.getSessionGCPolicy returns one of
  // "do SGC at end of call", "do not SGC at end of call", " use SGC threshold", or
  // "tracking SGC threshold".
  public String getSessionGCPolicy(); 

  // correspond to OracleRuntime.setSessionGCPolicy
  public String  doSGCEndOfCall();
  public String  doNotSGCEndOfCall();
  public String  useSGCThreshold();
  public String  trackingSGCThreshold();

  // int writeable attribute
  public int getThreadStackSize();
  public void setThreadStackSize(int size);

  // int read-only attribute
  public int getJavaStackSize();

  public Class loadedClass(ClassLoader loader, String name);

  public String intern(String str);

  // long writeable attribute
  public long getInternTableMaxSize();
  public void setInternTableMaxSize(long size);

  // long read-only attribute
  public long getInternTableSize();
  // long read-only attribute
  public long getJavaPoolSize();

  public int memcode(Object obj);

  public String dumpAllHeaps(String pathname) throws java.io.IOException;
  public String dumpJITSymbolsForVTune(String filename) throws java.io.IOException;

  public String nop(Object obj);

  public int memtype(Object obj);

  public Class getCallerClass();

  // correspond to OracleRuntime's setSoftRefPolicy, getSoftRefPolicy
  public String getSoftRefPolicy();
  public String ageSoftRefPolicy();
  public String callsSoftRefPolicy();

  // long writeable attribute
  public void setSoftRefPolicyValue(long value);
  public long getSoftRefPolicyValue();

  public boolean loadersAreTheSame(Class cl1, Class cl2);
  public String jitSomeMethods(Member methods[]);
  public String unjitSomeMethods(Member methods[], boolean[] permanent);
  public byte [] computeMD5(byte [] bits);
  public String emitStackTrace();
  public String startGCSpy(int port);

} 
 
