
package common;

public interface WorkLoadMBean { 

  //---- operations ----

  public void stop();
  public void start();

  //---- attributes ----

  // debug,trace
  public boolean getTrace();
  public void setTrace(boolean val);

  // workload iteration constants.
  // these can be changed at any time to adjust workload dynamically.
  public int getCount1max();
  public void setCount1max(int val);

  public int getCount2max();
  public void setCount2max(int val);

  public int getCount3max();
  public void setCount3max(int val);

  public int getSleepMSecs();
  public void setSleepMSecs(int val);

  public int getDurationMaxMins();
  public void setDurationMaxMins(int val);

  // workload iteration counters. These can be changed at any time to
  // adjust workload dynamically. In doing so, make sure a counter is
  // less than its llimit above.
  public int getCount1();
  public void setCount1(int val);

  public int getCount2();
  public void setCount2(int val);

  public int getCount3();
  public void setCount3(int val);

  // workload iteration details.
  public int getTableSize();
  public String getJunk();

} 
