
package jmxserv;

import javax.management.StandardMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.vm.IdNotFoundException;

public class FilePermission extends StandardMBean implements common.FilePermissionMBean { 

  public FilePermission() throws NotCompliantMBeanException {
    super(common.FilePermissionMBean.class);
  }

  private String grantee = "SCOTT";
  public String getGrantee() { return grantee; }
  public void setGrantee(String val) { grantee = val; }

  //jsp/ SLOT String fileName "FooBar";
  private String fileName = "FooBar";

  public void setFileName (String value) { 
    this.fileName = value; 
  }

  public String getFileName () {
    return fileName; 
  }

  //jsp/ SLOT boolean read;
  private boolean read = true;

  public void setRead (boolean value) { 
    this.read = value; 
  }

  public boolean getRead () {
    return read; 
  }

  //jsp/ SLOT boolean write;
  private boolean write;

  public void setWrite (boolean value) { 
    this.write = value; 
  }

  public boolean getWrite () {
    return write; 
  }

  //jsp/ SLOT boolean execute;
  private boolean execute;

  public void setExecute (boolean value) { 
    this.execute = value; 
  }

  public boolean getExecute () {
    return execute; 
  }

  //jsp/ SLOT boolean delete;
  private boolean delete;

  public void setDelete (boolean value) { 
    this.delete = value; 
  }

  public boolean getDelete () {
    return delete; 
  }

  public String grant () {
    try {
      PolicyTableManager.grant(grantee, "SYS:java.io.FilePermission", fileName, makeAttrString());
    } catch (Exception e) {
      return "got exception: " + e;
    }
    return "OK";
  }

  public String revoke () {
    try {
      PolicyTableManager.revoke(grantee, "SYS:java.io.FilePermission", fileName, makeAttrString());
    } catch (Exception e) {
      return "got exception: " + e;
    }
    return "OK";
  }


  private String makeAttrString () {
    String attributes = "";
    if (read) attributes    += (attributes.length() > 0 ? "," : "") + "read";
    if (write) attributes   += (attributes.length() > 0 ? "," : "") + "write";
    if (execute) attributes += (attributes.length() > 0 ? "," : "") + "execute";
    if (delete) attributes  += (attributes.length() > 0 ? "," : "") + "delete";
    return attributes;
  }

}




