
package jmxserv;

import java.lang.reflect.Member;
import javax.management.StandardMBean;
import javax.management.NotCompliantMBeanException;

import oracle.aurora.vm.OracleRuntime;

public class OJVM  extends StandardMBean implements common.OJVMMBean { 

  public OJVM() throws NotCompliantMBeanException {
    super(common.OJVMMBean.class);
  }
 
  public void exitSession(int status) { OracleRuntime.exitSession(status); }
  public void exitCall(int status) { OracleRuntime.exitCall(status); }
  public boolean inEndOfCall() { return OracleRuntime.inEndOfCall(); }

  // read-only attribute. Valid values are "Linux Port" or "Windows Port"
  public String getPlatform() { 
    switch (OracleRuntime.getPlatform()) {
    case OracleRuntime.WINDOWS_PORT: return "Windows Port";
    case OracleRuntime.LINUX_PORT: return "Linux Port";
    default: return "Uknown";
    }
  }

  public boolean definePackage(String name) { return OracleRuntime.definePackage(name); }

  // correspond to public void setCallExitPolicy(int policy)
  public void exitCallWhenMainThreadTerminates() { 
    OracleRuntime.setCallExitPolicy(OracleRuntime.EXIT_CALL_WHEN_MAIN_THREAD_TERMINATES);
  }
  public void exitCallWhenAllNonDaemonThreadsTerminate() { 
    OracleRuntime.setCallExitPolicy(OracleRuntime.EXIT_CALL_WHEN_ALL_NON_DAEMON_THREADS_TERMINATE);
  }
  public void exitCallWhenAllThreadsTerminate() { 
    OracleRuntime.setCallExitPolicy(OracleRuntime.EXIT_CALL_WHEN_ALL_THREADS_TERMINATE);
  }

  // one of "ExitCallWhenMainThreadTerminates" "ExitCallWhenAllNonDaemonThreadsTerminate" "ExitCallWhenAllThreadsTerminate"
  public String getCallExitPolicy() {
    switch (OracleRuntime.getCallExitPolicy()) {
    case OracleRuntime.EXIT_CALL_WHEN_MAIN_THREAD_TERMINATES:
      return "ExitCallWhenMainThreadTerminates";
    case OracleRuntime.EXIT_CALL_WHEN_ALL_NON_DAEMON_THREADS_TERMINATE:
      return "ExitCallWhenAllNonDaemonThreadsTerminate";
    case OracleRuntime.EXIT_CALL_WHEN_ALL_THREADS_TERMINATE:
      return "ExitCallWhenAllThreadsTerminate";
    default: return "Unknown";
    }
  }

  // boolean writeable attribute
  // corresponds to OracleRuntime.getThreadTerminationPolicy
  public boolean getForceActiveThreadTherminationAtCallEnd() {
    return OracleRuntime.getThreadTerminationPolicy(true);
  }
  public void setForceActiveThreadTherminationAtCallEnd(boolean val) {
    OracleRuntime.setThreadTerminationPolicy(val);
  }

  // long writeable attribute
  public long getMaxMemorySize() { return OracleRuntime.getMaxMemorySize(); }
  public void setMaxMemorySize(long maxSize) { OracleRuntime.setMaxMemorySize(maxSize); }

  // long writeable attribute
  public long getMaxRunspaceSize() { return OracleRuntime.getMaxRunspaceSize(); }
  public void setMaxRunspaceSize(long maxSize) { OracleRuntime.setMaxRunspaceSize(maxSize); }

  // long read-only attribute
  public long getMaxSessionSize() { return OracleRuntime.getMaxSessionSize(); }
  // long read-only attribute
  public long getSessionSoftLimit() { return OracleRuntime.getSessionSoftLimit(); }
  
  // long read-only attribute
  public long getSessionSize() { return OracleRuntime.getSessionSize(); }

  // long writeable attribute
  public long getNewspaceSize() { return OracleRuntime.getNewspaceSize(); }
  public void setNewspaceSize(long size) { OracleRuntime.setNewspaceSize(size); }

  // boolean writeable attribute
  // corresponds to OracleRuntime's newspaceEnabled, enableNewspace.
  public boolean getNewspaceEnabled() { return OracleRuntime.newspaceEnabled();}
  public void setNewspaceEnabled(boolean enable) { OracleRuntime.enableNewspace(enable); }

  // byte writeable attribute
  public byte getNewspaceMaxGeneration() { return OracleRuntime.getNewspaceMaxGeneration(); }
  public void setNewspaceMaxGeneration(byte arg) { 
    OracleRuntime.setNewspaceMaxGeneration(arg); 
  }

  // byte read-only attribute
  public byte getMinNewspaceTenurePolicy() { 
    return OracleRuntime.minNewspaceTenurePolicy; 
  }
  // byte read-only attribute
  public byte getDefaultNewspaceTenurePolicy() {
    return OracleRuntime.defaultNewspaceTenurePolicy; 
  }

  // byte writeable attribute
  // corresponds to OracleRuntime's setNewspaceTenurePolicy, getNewspaceTenurePolicy
  public byte getNewspaceTenureGeneration() { 
    return OracleRuntime.getNewspaceTenurePolicy(); 
  }
  public void setNewspaceTenureGeneration(byte arg) { 
    OracleRuntime.setNewspaceTenurePolicy(arg); 
  }

  // long writeable attribute
  public long getSessionGCThreshold() { return OracleRuntime.getSessionGCThreshold(); }
  public void setSessionGCThreshold(long size) { OracleRuntime.setSessionGCThreshold(size); }

  // corresponds to OracleRuntime.getSessionGCPolicy returns one of
  // "do SGC at end of call", "do not SGC at end of call", " use SGC threshold", or
  // "tracking SGC threshold".
  public String getSessionGCPolicy() {
    switch (OracleRuntime.getSessionGCPolicy()) {
    case OracleRuntime.doSGCEndOfCall: return "do SGC at end of call";
    case OracleRuntime.doNotSGCEndOfCall: 
    case -2: // eoapag.h says it is internal version of "force off", or OracleRuntime.doNotSGCEndOfCall
      return "do not SGC at end of call";
    case OracleRuntime.useSGCThreshold: return "use SGC threshold";
    case OracleRuntime.trackingSGCThreshold: return "tracking SGC threshold";
    default: return "unknown: " + OracleRuntime.getSessionGCPolicy();
    }
  }

  static String OKString =  "Operation Completed Successfully";

  static private String reformat (Exception e) {
    String text = ""+e;
    int idx;
    while ((idx = text.indexOf(": ")) > -1) {
      String newtext = 
        text.substring(0, idx) + ":\n" + text.substring(idx+2);
      text = newtext;
    }
    while ((idx = text.indexOf(") ")) > -1) {
      String newtext = 
        text.substring(0, idx) + ")\n" + text.substring(idx+2);
      text = newtext;
    }
    while ((idx = text.indexOf(". ")) > -1) {
      String newtext = 
        text.substring(0, idx) + ".\n" + text.substring(idx+2);
      text = newtext;
    }
    return text;
  }

  // correspond to OracleRuntime.setSessionGCPolicy
  // correspond to OracleRuntime.setSessionGCPolicy
  public String doSGCEndOfCall() { 
    try {
    OracleRuntime.setSessionGCPolicy(OracleRuntime.doSGCEndOfCall); 
    return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public String doNotSGCEndOfCall() { 
    try {
    
    OracleRuntime.setSessionGCPolicy(OracleRuntime.doNotSGCEndOfCall); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public String useSGCThreshold() { 
    try {
    
    OracleRuntime.setSessionGCPolicy(OracleRuntime.useSGCThreshold); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public String trackingSGCThreshold() { 
    try {
    
    OracleRuntime.setSessionGCPolicy(OracleRuntime.trackingSGCThreshold); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

  // int writeable attribute
  public int getThreadStackSize() { return OracleRuntime.getThreadStackSize();}
  public void setThreadStackSize(int size) { OracleRuntime.setThreadStackSize(size); }

  // int read-only attribute
  public int getJavaStackSize() { return OracleRuntime.getJavaStackSize(); }

  public Class loadedClass(ClassLoader loader, String name) {
    return OracleRuntime.loadedClass(loader, name); 
  }

  public String intern(String str) { 
    try {
      return OracleRuntime.intern(str);
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

  // long writeable attribute
  public long getInternTableMaxSize() { return OracleRuntime.getInternTableMaxSize(); }
  public void setInternTableMaxSize(long size) { OracleRuntime.setInternTableMaxSize(size); }

  // long read-only attribute
  public long getInternTableSize() { return OracleRuntime.getInternTableSize(); }
  // long read-only attribute
  public long getJavaPoolSize() { return OracleRuntime.getJavaPoolSize(); }

  public int memcode(Object obj) { return OracleRuntime.memcode(obj); }

  public String dumpAllHeaps(String pathname) throws java.io.IOException { 
    try {
    
    OracleRuntime.dumpAllHeaps(pathname); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public String dumpJITSymbolsForVTune(String filename) throws java.io.IOException {

    try {
        OracleRuntime.dumpJITSymbolsForVTune(filename); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

  public String nop(Object obj) { 
    try {
    OracleRuntime.nop(obj);     return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

  public int memtype(Object obj) { return OracleRuntime.memtype(obj); }

  public Class getCallerClass() { return OracleRuntime.getCallerClass(); }

  // correspond to OracleRuntime's setSoftRefPolicy, getSoftRefPolicy
  public String getSoftRefPolicy() { 
    switch (OracleRuntime.getSoftRefPolicy()) {
    case OracleRuntime.SOFTREFPOLICY_AGE: return "age soft ref policy";
    case OracleRuntime.SOFTREFPOLICY_CALLS: return "calls soft ref policy";
    default: return "unknown: " + OracleRuntime.getSoftRefPolicy();
    }
  }

  public String ageSoftRefPolicy() { 
    try {
    
    OracleRuntime.setSoftRefPolicy(OracleRuntime.SOFTREFPOLICY_AGE, 
                                   OracleRuntime.getSoftRefPolicyValue()); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public String callsSoftRefPolicy() {

    try {
        OracleRuntime.setSoftRefPolicy(OracleRuntime.SOFTREFPOLICY_CALLS, 
                                   OracleRuntime.getSoftRefPolicyValue()); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

  // long writeable attribute
  public long getSoftRefPolicyValue() { return OracleRuntime.getSoftRefPolicyValue(); }
  public void setSoftRefPolicyValue(long value) { 
    OracleRuntime.setSoftRefPolicy(OracleRuntime.getSoftRefPolicy(), value);
  }

  public boolean loadersAreTheSame(Class cl1, Class cl2) {
    return OracleRuntime.loadersAreTheSame(cl1, cl2);
  }

  public String jitSomeMethods(Member methods[]) { 
    try {
    
    int ret = OracleRuntime.jitSomeMethods(methods); 
      return OKString + " count: " + ret;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

  public String unjitSomeMethods(Member methods[], boolean[] permanent) {

    try {
        OracleRuntime.unjitSomeMethods(methods, permanent);
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public byte [] computeMD5(byte [] bits) { 
    return OracleRuntime.computeMD5(bits); 
  }
  public String emitStackTrace() { 
    try {
    
    OracleRuntime.emitStackTrace(); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }
  public String startGCSpy(int port) { 
    try {
    
    OracleRuntime.startGCSpy(port); 
      return OKString;
    } catch (Exception e) {
      return "Operation Failed with Exception " + reformat(e);
    }
  }

}
       
