
package jmxserv;

import javax.management.StandardMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.vm.IdNotFoundException;

public class PermissionManager extends StandardMBean implements common.PermissionManagerMBean { 

  public PermissionManager() throws NotCompliantMBeanException {
    super(common.PermissionManagerMBean.class);
  }

  public String[] schemaList (String schemaName) {
    return null;
  } 
  public String[] schemaPermissions (String schemaName) {
    return null;
  }
  public String[] schemaId (String schemaName) {
    return null;
  }

  public String grant (String granteeSchemaName, String permission, String name, String attributes)
  {
    return _grant(granteeSchemaName, permission, name, attributes);
  } 
  public String grantStar (String granteeSchemaName, String permission)
  {
    return _grant(granteeSchemaName, permission, "*", "*");
  } 
  public String grantFilePermission (String granteeSchemaName, String fileName, 
                                      boolean read, boolean write, boolean execute, boolean delete)
  {
    String attributes = "";
    if (read) attributes = "read";
    if (write) attributes += attributes.length() > 0 ? ",write" : "write";
    if (execute) attributes += attributes.length() > 0 ? ",execute" : "execute";
    if (execute) attributes += attributes.length() > 0 ? ",delete" : "delete";

    return _grant(granteeSchemaName, "SYS:java.io.FilePermission", fileName, attributes);
  }

  public String grantFilePermission (String granteeSchemaName, String fileName,  String rwxString)
  {
    String attributes = null;
    if (rwxString != null) {
      rwxString = rwxString.toLowerCase();
      if (rwxString.indexOf('r') > -1) attributes = "read";
      if (rwxString.indexOf('w') > -1) 
        attributes += attributes.length() > 0 ? ",write" : "write";
      if (rwxString.indexOf('x') > -1) 
        attributes += attributes.length() > 0 ? ",execute" : "execute";
    }
    return _grant(granteeSchemaName, "SYS:java.io.FilePermission", fileName, attributes);
  }

  public String grantPropertyPermission (String granteeSchemaName, String propertyName, 
                                          boolean read, boolean write)
  {
    return null;
  }
  public String grantRuntimePermission (String granteeSchemaName, String targetName)
  {
    return _grant(granteeSchemaName, "SYS:java.lang.RuntimePermission", targetName, null);
  }
  public String grantPolicy (String granteeSchemaName, String permission, String name, String attributes)
  {
    return null;
  } 

  // Override customization hook:
  // Supply a customized description for parameters.
  protected String getDescription(MBeanOperationInfo op,
                                  MBeanParameterInfo param,
                                  int sequence) {
    if (op.getName().equals("grantRuntimePermission")) {
      switch (sequence) {
      case 0: return "Name of the DB schema to which a permission is granted";
      case 1: return "Target permission name such as loadLibrary, etc.";
      default: return null;
      }
    }
    return null;
  }

  // Override customization hook:
  // Supply a customized name for parameters,
  protected String getParameterName(MBeanOperationInfo op,
                                    MBeanParameterInfo param,
                                    int sequence) {
    if (op.getName().equals("grantRuntimePermission")) {
      switch (sequence) {
      case 0: return "granteeSchemaName";
      case 1: return "targetName";
      default : return null;
      }
    }
    return null;
  }

  //-----------------------------------------
  // private stuff

  String _grant (String granteeSchemaName, String permission, String name, String attributes)
  {
    try {
      PolicyTableManager.grant(granteeSchemaName, permission, name, attributes);
    } catch (Exception e) {
      return "got exception: " + e;
    }
    return "OK";
  }
}
     




