
package jmxserv;

import javax.management.StandardMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.vm.IdNotFoundException;

public class PropertyPermission extends StandardMBean implements common.PropertyPermissionMBean { 

  public PropertyPermission() throws NotCompliantMBeanException {
    super(common.PropertyPermissionMBean.class);
  }

  private String grantee = "SCOTT";
  public String getGrantee() { return grantee; }
  public void setGrantee(String val) { grantee = val; }

  //jsp/ SLOT String propertyName "FooBar";
  private String propertyName = "FooBar";

  public void setPropertyName (String value) { 
    this.propertyName = value; 
  }

  public String getPropertyName () {
    return propertyName; 
  }

  //jsp/ SLOT boolean read;
  private boolean read = true;

  public void setRead (boolean value) { 
    this.read = value; 
  }

  public boolean getRead () {
    return read; 
  }

  //jsp/ SLOT boolean write;
  private boolean write;

  public void setWrite (boolean value) { 
    this.write = value; 
  }

  public boolean getWrite () {
    return write; 
  }

  public String grant () {
    try {
      PolicyTableManager.grant(grantee, "SYS:java.util.PropertyPermission", propertyName, makeAttrString());
    } catch (Exception e) {
      return "got exception: " + e;
    }
    return "OK";
  }

  public String revoke () {
    try {
      PolicyTableManager.revoke(grantee, "SYS:java.util.PropertyPermission", propertyName, makeAttrString());
    } catch (Exception e) {
      return "got exception: " + e;
    }
    return "OK";
  }


  private String makeAttrString () {
    String attributes = "";
    if (read) attributes    += (attributes.length() > 0 ? "," : "") + "read";
    if (write) attributes   += (attributes.length() > 0 ? "," : "") + "write";
    return attributes;
  }

}




