#!/usr/local/bin/perl
# 
# $Header: oracle_apache.pl 30-jan-2005.23:32:25 ssuggala Exp $
#
# oracle_apache.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      oracle_apache.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssuggala    01/30/05 - ssuggala_standalone_apache
#    ssuggala    01/27/05 - Creation
# 
my ($emdRoot,$hostName) = @ARGV;

# use java from 'appropriate' location
my $JAVA_HOME="";

if (defined($ENV{JRE_HOME}))
{
  $JAVA_HOME = $ENV{JRE_HOME};
}
if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME/bin"))
{
  if (defined($ENV{JAVA_HOME}))
  {
    $JAVA_HOME = $ENV{JAVA_HOME};
  }
  if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME/bin"))
  {
    if (-e "$emdRoot/jre/1.4.1")
    {
      $JAVA_HOME="$emdRoot/jre/1.4.1";
    }
    elsif (-e "$emdRoot/jdk")
    {
      $JAVA_HOME="$emdRoot/jdk";
    }
  }
}
die "Cannot determine JAVA_HOME\n" if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME/bin"));

# OS-specific path/classpath separators
my $pathSep = "/";
my $cpSep = ":";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $pathSep = "\\";
  $cpSep = ";";
}

# start the output array
my @nonIASHomes;
my @processedLines;
push (@processedLines, "\<Targets\>\n");

# get list of homes 
open (HOMES_READER, "$JAVA_HOME/bin/java -cp $emdRoot/jlib/emConfigInstall.jar$cpSep$emdRoot/jlib/share.jar$cpSep$emdRoot/oui/jlib/OraInstaller.jar$cpSep$emdRoot/jlib/srvm.jar$cpSep$emdRoot/sysman/jlib/emcoreAgent.jar$cpSep$emdRoot/sysman/jlib/emCORE.jar$cpSep$emdRoot/sysman/jlib/emagentSDK.jar oracle.sysman.emSDK.conf.InventoryLoader listhomes |");

# walk the list
while($homeLine = <HOMES_READER>)
{
  $homeLine =~ s/^\s*//;
  chomp($homeLine);

  # check if iAS install, skip if so
  if (-e $homeLine . "/config/ias.properties")
  {
    next;
  }

  #If not iAS install add it as non iAS Home
  push(@nonIASHomes, $homeLine);
}
close HOMES_READER;

#Get all the standalone apache homes
foreach $nonIASHome (@nonIASHomes)
{
    chomp($nonIASHome);

    #check if only Apache 2.0 installed
    if( (-e $nonIASHome . "/opmn/bin/opmnctl") and (-e $nonIASHome . "/ohs/conf/httpd.conf") )
    {
        my $opmnctl_cmd = $nonIASHome . "/opmn/bin/opmnctl status -l";
        my $opmn_status = `$opmnctl_cmd`;
        #print "$opmn_status\n";

        my @lines = split (/\n/ , $opmn_status);

        my $instance = "";
        my $httpProcess = "";

        for (@lines)
        {
            chomp($_);
            if( /^$/ )
            {
                next;
            }
            elsif( /standalone$/ )
            {
                $instance = $_;
            }
            elsif( /^HTTP_Server/ )
            {
                $httpProcess = $_;
                last;
            }
        }

        if( !($instance =~ /^$/) and !($httpProcess =~ /^$/) )
        {
            my @tokens = split (/:/ , $instance);
            chomp($tokens[1]);
            if($tokens[1] =~ m/standalone/)
            {
                $httpProcess =~ s/\s*//g;
                my @processTokens = split (/\|/ , $httpProcess);
                if ($httpProcess =~ m/Alive/)
                {
                    my $prePortIndex = index($processTokens[-1], ':') + 1;
                    my $postPortIndex = index($processTokens[-1], ',');
                    my $port = substr($processTokens[-1],  $prePortIndex, ($postPortIndex - $prePortIndex));
                    my $ohsLogDir = $nonIASHome . "/ohs/logs";
                    my $logFileName = "access_log";
                    if( !(-e $ohsLogDir . "/" . $logFileName ) )
                    {
                        $logFileName = "chronos_log";
                    }

                    push (@processedLines, "  <Target TYPE=\"oracle_apache\" NAME=\"$nonIASHome\.$hostName\_HTTP Server\" DISPLAY_NAME=\"HTTP_Server\">\n");
                    push (@processedLines, "    <Property NAME=\"HTTPMachine\" VALUE=\"$hostName\"/>\n");
                    push (@processedLines, "    <Property NAME=\"HTTPPort\" VALUE=\"$port\"/>\n");
                    push (@processedLines, "    <Property NAME=\"version\" VALUE=\"stdApache10.1.2\"/>\n");
                    push (@processedLines, "    <Property NAME=\"OracleHome\" VALUE=\"$nonIASHome\"/>\n");
                    push (@processedLines, "    <Property NAME=\"logFileDir\" VALUE=\"$ohsLogDir\"/>\n");
                    push (@processedLines, "    <Property NAME=\"logFileName\" VALUE=\"$logFileName\"/>\n");
                    push (@processedLines, "  </Target>\n");
                }
            }
        }
    }
}

# finish up the stream and send it out
push (@processedLines, "\<\/Targets\>\n");
print @processedLines;
exit 0;

