set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4160 - Scheme Authentication Login
--
-- Application Export:
--   Application:     4160
--   Name:            Scheme Authentication Login
--   Date and Time:   08:02 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 7
--     Items:              16
--     Computations:        2
--     Validations:         7
--     Processes:           6
--     Regions:            16
--     Buttons:             3
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               1
--     Computations:        0
--     Processes:           0
--     Parent Tabs:         4
--     Tab Sets:            1
--        Tabs:             1
--     NavBars:             0
--     Lists:               0
--     Shortcuts:           0
--     Themes:              0
--     Templates:
--        Page:             3
--        List:             0
--        Report:           0
--        Label:            2
--        Region:           1
--     Messages:            0
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4160;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4160);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4160);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4160,
  p_display_id=> 4160,
  p_owner => 'APEX_030200',
  p_name  => 'Scheme Authentication Login',
  p_alias => 'A198386125886429563',
  p_page_view_logging => 'YES',
  p_default_page_template=> 24029824597247454.416 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 24029824597247454.416 + wwv_flow_api.g_id_offset,
  p_error_template    => 24029824597247454.416 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4155:1:&SESSION.',
  p_flow_language     => 'pt-br',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'DATABASE',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'N',
  p_vpd               => '',
  p_csv_encoding    => 'Y',
  p_theme_id => 101,
  p_substitution_string_01 => 'PRODUCT_NAME',
  p_substitution_value_01  => 'Application Express',
  p_substitution_string_02 => 'APPLICATION_ICON',
  p_substitution_value_02  => 'oracle_platform_white.gif',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => 'Espaço de Trabalho: &COMPANY.',
  p_substitution_string_04 => 'MSG_LANGUAGE',
  p_substitution_value_04  => 'Idioma',
  p_substitution_string_05 => 'MSG_COPYRIGHT',
  p_substitution_value_05  => 'Copyright &copy; 1999, 2006, Oracle. Todos os direitos reservados e de titularidade da Oracle Corporation. Proibida a reprodução total ou parcial.',
  p_substitution_string_06 => 'MSG_USER',
  p_substitution_value_06  => 'Usuário',
  p_substitution_string_07 => 'MSG_JSCRIPT',
  p_substitution_value_07  => 'Você deve executar este produto com o JavaScript ativado.',
  p_substitution_string_08 => 'MSG_TBL_SUMMARY',
  p_substitution_value_08  => 'Tabela de Layout de Página',
  p_substitution_string_09 => 'CLOSE',
  p_substitution_value_09  => 'Fechar',
  p_substitution_string_10 => 'DATE_FORMAT',
  p_substitution_value_10  => 'dd/mm/rr',
  p_substitution_string_11 => 'LONG_DATE_FORMAT',
  p_substitution_value_11  => 'fmDay dd "de" Month "de" yyyy',
  p_substitution_string_12 => 'TIME_FORMAT',
  p_substitution_value_12  => 'hh24:mi:ss',
  p_substitution_string_13 => 'DATE_TIME_FORMAT',
  p_substitution_value_13  => 'dd/mm/rr hh24:mi:ss',
  p_substitution_string_14 => 'RETURN_TO_APPLICATION',
  p_substitution_value_14  => 'Retornar à Aplicação',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518143501',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 26310914319937994.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/t_page_1
wwv_flow_api.create_tab (
  p_id=> 519013824056522.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'One',
  p_tab_sequence=> 1,
  p_tab_name=> 'T_PAGE_1',
  p_tab_text => 'Página&nbsp;1',
  p_tab_step => 1,
  p_tab_also_current_for_pages => '',
  p_tab_parent_tabset=>'main',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment  => 'Tab generated by create flow wizard');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/parent/one
wwv_flow_api.create_toplevel_tab (
  p_id=> 519104518056523.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'main',
  p_tab_sequence=> 1,
  p_tab_name  => 'One',
  p_tab_text  => 'Um',
  p_tab_target=> 'f?p=4155:1:&SESSION',
  p_current_on_tabset=> 'One',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment=> '');
 
--application/shared_components/navigation/tabs/parent/two
wwv_flow_api.create_toplevel_tab (
  p_id=> 519229449056523.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'main',
  p_tab_sequence=> 2,
  p_tab_name  => 'Two',
  p_tab_text  => 'Dois',
  p_tab_target=> 'f?p=4155:10:&SESSION',
  p_current_on_tabset=> 'Two',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment=> '');
 
--application/shared_components/navigation/tabs/parent/three
wwv_flow_api.create_toplevel_tab (
  p_id=> 519313755056523.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'main',
  p_tab_sequence=> 3,
  p_tab_name  => 'Three',
  p_tab_text  => 'Três',
  p_tab_target=> 'f?p=4155:10:&SESSION',
  p_current_on_tabset=> 'Three',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment=> '');
 
--application/shared_components/navigation/tabs/parent/four
wwv_flow_api.create_toplevel_tab (
  p_id=> 519415313056523.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'main',
  p_tab_sequence=> 4,
  p_tab_name  => 'Four',
  p_tab_text  => 'Quatro',
  p_tab_target=> 'f?p=4155:10:&SESSION',
  p_current_on_tabset=> 'Four',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment=> '');
 
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.416
prompt  ...PAGE 1.416: Página Pública para Log-out
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Página Pública para Log-out',
  p_step_title=> 'Página Pública para Log-out',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 24029824597247454.416+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'O log-out foi bem-sucedido. Você foi redirecionado para cá depois de usar um link de log-out fornecido por um esquema de autenticação. Para redirecionar para uma página do seu fluxo, faça o seguinte:'||chr(10)||
'<ul>'||chr(10)||
'<li>Crie uma página no fluxo e dê a ela o apelido PUBLIC_PAGE.'||chr(10)||
'<li>Na página de atributos de página do Flow Builder, selecione o atributo de Página Pública "Sim - Esta página é pública".'||chr(10)||
'<li>Alte';

s:=s||'re o URL de log-out no modelo de autenticação para redirecionar para essa nova página após a execução do procedure de log-out. Por exemplo, usando a API, crie o URL de log-out:<p>'||chr(10)||
'<pre>'||chr(10)||
'  wwv_flow_custom_auth_std.log-out?p_this_flow=&amp;FLOW_ID&amp;p_next_flow_page_sess=&amp;FLOW_ID:PUBLIC_PAGE:&amp;SESSION'||chr(10)||
'</pre>'||chr(10)||
'<p>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_plug (
  p_id=> 7642519848874484.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.416,
  p_plug_name=> 'Informações',
  p_region_name=>'',
  p_plug_template=> 517201101056507.416+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.416
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_50.41
prompt  ...PAGE 50.416: Alterar Senha do Usuário Final
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 50.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Alterar Senha do Usuário Final',
  p_step_title=> 'Alterar Senha do Usuário Final',
  p_step_sub_title => 'Change End User Password',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 24029824597247454.416+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8191332504492034.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.416,
  p_plug_name=> 'Return to Application',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'REQUEST_EQUALS_CONDITION',
  p_plug_display_when_condition => 'CONFIRM',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':P50_PASSWORD := null;'||chr(10)||
':P50_CONFIRM_PASSWORD := null;'||chr(10)||
':P50_ENTER_CURRENT_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 8191525547492034.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.416,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8191706236492034.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 50.416,
  p_plug_name=> 'Alterar Senha',
  p_region_name=>'',
  p_plug_template=> 517201101056507.416+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1939532588110833.416+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'REQUEST_NOT_EQUAL_CONDITION',
  p_plug_display_when_condition => 'CONFIRM',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 50.416,
  p_button_sequence=> 20,
  p_button_plug_id => 8191706236492034+wwv_flow_api.g_id_offset,
  p_button_name    => 'Save',
  p_button_image_alt=> 'Aplicar Alterações',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 8192117938492035.416 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 50.416,
  p_button_sequence=> 10,
  p_button_plug_id => 8191332504492034+wwv_flow_api.g_id_offset,
  p_button_name    => 'RETURN',
  p_button_image_alt=> 'Retornar',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>8196217320492038.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_branch_action=> 'f?p=&APP_ID.:50:&SESSION.:CONFIRM:&DEBUG.:50::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>8191925642492034.416+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 20-NOV-2006 22:03 by SSPADAFO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nome do usuário cuja senha será alterada';

wwv_flow_api.create_page_item(
  p_id=>8192329780492035.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_name=>'P50_USER_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 8191706236492034.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nome do Usuário:',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 517018400056507.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'I',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe a nova senha';

wwv_flow_api.create_page_item(
  p_id=>8192820569492035.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_name=>'P50_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 8191706236492034.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Informar Nova Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535106471295136.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Entre novamente com a nova senha';

wwv_flow_api.create_page_item(
  p_id=>8193305833492036.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_name=>'P50_CONFIRM_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 8191706236492034.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Confirmar Nova Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535106471295136.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Digite sua senha atual.';

wwv_flow_api.create_page_item(
  p_id=>8193806723492036.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_name=>'P50_ENTER_CURRENT_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 8191706236492034.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Informar Senha Atual',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 107535106471295136.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>14788218055836214.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_name=>'P50_SESSION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 8191706236492034.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>15093006941824438.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_name=>'P50_USER_SGID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 8191706236492034.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'I',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 15093732698841347.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_computation_sequence => 10,
  p_computation_item=> 'P50_USER_SGID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'for c1 in (select security_group_id from wwv_flow_sessions$ '||chr(10)||
'           where id=:P50_SESSION) loop'||chr(10)||
'  return c1.security_group_id;'||chr(10)||
'end loop;',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 12378622409765411.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 50.416,
  p_computation_sequence => 20,
  p_computation_item=> 'P50_USER_NAME',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare '||chr(10)||
'  l_instance number := wwv_flow.g_instance;'||chr(10)||
'  l_un varchar2(256) := null;'||chr(10)||
'begin'||chr(10)||
'  wwv_flow.g_instance := :P50_SESSION;'||chr(10)||
'  l_un := wwv_flow_security.get_expired_user_name;'||chr(10)||
'  wwv_flow.g_instance := l_instance;'||chr(10)||
'  return l_un;'||chr(10)||
'end;',
  p_compute_when => 'CONFIRM',
  p_compute_when_type=>'REQUEST_NOT_EQUAL_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8194403614492037.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_validation_name => 'P50_ENTER_CURRENT_PASSWORD',
  p_validation_sequence=> .5,
  p_validation => 'P50_ENTER_CURRENT_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique a senha.',
  p_when_button_pressed=> 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_associated_item=> 8193806723492036.416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8194629425492037.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_validation_name => 'P50_PASSWORD Not Null',
  p_validation_sequence=> 1,
  p_validation => 'P50_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique a senha.',
  p_when_button_pressed=> 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_associated_item=> 8192820569492035.416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 07-AUG-2002 16:59');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8194822652492037.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_validation_name => 'P50_CONFIRM_PASSWORD Not Null',
  p_validation_sequence=> 2,
  p_validation => 'P50_CONFIRM_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o valor de Confirmar Senha.',
  p_when_button_pressed=> 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_associated_item=> 8193305833492036.416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 07-AUG-2002 16:59');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8195026061492037.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_validation_name => 'passwd = confirm passwd',
  p_validation_sequence=> 10,
  p_validation => 'if :P50_PASSWORD != :P50_CONFIRM_PASSWORD then'||chr(10)||
'  :P50_PASSWORD := null;'||chr(10)||
'  :P50_CONFIRM_PASSWORD := null;'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'A senha de confirmação não coincide com a senha.',
  p_validation_condition=> ':P50_PASSWORD is not null and :P50_CONFIRM_PASSWORD is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_associated_item=> 8193305833492036.416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 8195417294492037.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_validation_name => 'Validate Current Password',
  p_validation_sequence=> 40,
  p_validation => 'wwv_flow_security.g_security_group_id := :P50_USER_SGID;'||chr(10)||
'return wwv_flow_user_api.is_login_password_valid('||chr(10)||
'  p_username=>:P50_USER_NAME,'||chr(10)||
'  p_password=>:P50_ENTER_CURRENT_PASSWORD);',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Senha Inválida',
  p_validation_condition=> 'P50_ENTER_CURRENT_PASSWORD',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_associated_item=> 8193806723492036.416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 25690303485866343.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_validation_name => 'strong password verification',
  p_validation_sequence=> 102,
  p_validation => 'return wwv_flow_security.strong_password_validation('||chr(10)||
'      p_username       => :P50_USER_NAME,'||chr(10)||
'      p_password       => :P50_PASSWORD,'||chr(10)||
'      p_old_password   => :P50_ENTER_CURRENT_PASSWORD,'||chr(10)||
'      p_workspace_name => wwv_flow_security.find_company_name(:WORKSPACE_ID));',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Erro',
  p_validation_condition=> 'P50_ENTER_CURRENT_PASSWORD',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_associated_item=> .416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'  l_p varchar2(256) := v(''P50_PASSWORD'');'||chr(10)||
'begin'||chr(10)||
'  wwv_flow_security.g_security_group_id := :P50_USER_SGID;'||chr(10)||
'  wwv_flow.update_cache_with_write(''P50_PASSWORD'',null);'||chr(10)||
'  wwv_flow.update_cache_with_write(''P50_CONFIRM_PASSWORD'',null);'||chr(10)||
'  wwv_flow.update_cache_with_write(''P50_ENTER_CURRENT_PASSWORD'',null);'||chr(10)||
'  wwv_flow_api.g_fnd_user_password_action := true;'||chr(10)||
'  update wwv_flow_fnd_user '||chr(10)||
'    set web_';

p:=p||'password = l_p, first_password_use_occurred = ''Y'''||chr(10)||
'  where security_group_id = wwv_flow_security.g_security_group_id '||chr(10)||
'    and user_id = (select user_id '||chr(10)||
'                    from wwv_flow_fnd_user '||chr(10)||
'                   where security_group_id = wwv_flow_security.g_security_group_id '||chr(10)||
'                     and user_name = upper(:P50_USER_NAME));'||chr(10)||
'  wwv_flow_api.g_fnd_user_password_action := false;'||chr(10)||
'  wwv_f';

p:=p||'low_security.purge_expired_user_header(:P50_SESSION);'||chr(10)||
'  commit;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 8195726390492038.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'change password',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erro ao alterar a senha.',
  p_process_when_button_id=>8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_process_when=>':P50_PASSWORD = :P50_CONFIRM_PASSWORD',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'Senha alterada.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'50';

wwv_flow_api.create_page_process(
  p_id     => 8195926102492038.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>8191925642492034.416 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'  l_gotourl varchar2(4000);'||chr(10)||
'begin'||chr(10)||
'  wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'  for c1 in (select item_value from wwv_flow_data where flow_instance = :APP_SESSION'||chr(10)||
'             and item_name=''FSP_AFTER_LOGIN_URL'') loop'||chr(10)||
'    l_gotourl := c1.item_value;'||chr(10)||
'  end loop;'||chr(10)||
'  owa_util.redirect_url(apex_util.prepare_url(l_gotourl));'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 8195508618492037.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'return',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>8192117938492035.416 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'if nvl(:REQUEST,''xy5993-'') <> ''CONFIRM'' then '||chr(10)||
'  wwv_flow.g_notification := wwv_flow_lang.system_message(''PASSWORD_MUST_BE_CHANGED'');'||chr(10)||
'end if;';

wwv_flow_api.create_page_process(
  p_id     => 12382112282781418.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 50.416,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set notification',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 50.416
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_100.4
prompt  ...PAGE 100.416: Ajuda para Efetuar Log-in para Credenciais de Acesso Livre
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 100.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Ajuda para Efetuar Log-in para Credenciais de Acesso Livre',
  p_step_title=> 'Ajuda para Efetuar Log-in para Credenciais de Acesso Livre',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 24029824597247454.416+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Informe um identificador que identificará você como o usuário da aplicação durante esta sessão. Isso definirá o valor da variável APP_USER.';

wwv_flow_api.create_page_plug (
  p_id=> 1444625059752884.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 100.416,
  p_plug_name=> 'Ajuda de Log-in',
  p_region_name=>'',
  p_plug_template=> 517201101056507.416+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare l_text varchar2(2000);'||chr(10)||
'begin'||chr(10)||
'for c1 in (select attribute_03 from wwv_flow_custom_auth_setups where id = :F4155_P1000_SETUP_ID) loop'||chr(10)||
'l_text := c1.attribute_03;'||chr(10)||
'end loop;'||chr(10)||
'if l_text is not null and length(l_text) > 0 then'||chr(10)||
'htp.p(''<p class="fielddata">''||l_text||''</p>'');'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 1447318573807780.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 100.416,
  p_plug_name=> 'More Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 100.416
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_110.4
prompt  ...PAGE 110.416: Ajuda de Log-in para Credenciais de Conta do &PRODUCT_NAME.
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 110.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Ajuda de Log-in para Credenciais de Conta do &PRODUCT_NAME.',
  p_step_title=> 'Ajuda de Log-in para Credenciais de Conta do &PRODUCT_NAME.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 24029824597247454.416+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Informe o nome do usuário e a senha da conta do &PRODUCT_NAME. Cada site do &PRODUCT_NAME. possui seu próprio repositório de contas de usuários. A aplicação na qual você está efetuando log-in pertence ao espaço de trabalho &F4150_P110_COMPANY. Lembre-se de que as senhas fazem distinção entre maiúsculas e minúsculas.';

wwv_flow_api.create_page_plug (
  p_id=> 1445106490757012.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 110.416,
  p_plug_name=> 'Login Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare l_text varchar2(2000);'||chr(10)||
'begin'||chr(10)||
'for c1 in (select attribute_03 from wwv_flow_custom_auth_setups where id = :F4155_P1000_SETUP_ID) loop'||chr(10)||
'l_text := c1.attribute_03;'||chr(10)||
'end loop;'||chr(10)||
'if l_text is not null and length(l_text) > 0 then'||chr(10)||
'htp.p(''<p>''||l_text);'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 1449204899841766.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 110.416,
  p_plug_name=> 'More Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1451408418946779.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 110.416,
  p_name=>'F4150_P110_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1445106490757012.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '(unknown)',
  p_prompt=>'P110 Company',
  p_source=>'declare '||chr(10)||
'  l_sgid number := null;'||chr(10)||
'  l_flow_id number := null;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select id from wwv_flows '||chr(10)||
'    where custom_authentication_process = ''.''||:F4155_P1000_SETUP_ID||''.'') loop'||chr(10)||
'  l_flow_id := c1.id;'||chr(10)||
'  end loop;'||chr(10)||
'  for c1 in (select security_group_id from wwv_flows '||chr(10)||
'    where id = l_flow_id) loop       '||chr(10)||
'    l_sgid := c1.security_group_id;'||chr(10)||
'  end loop;'||chr(10)||
'        '||chr(10)||
'  return wwv_flow_security.find_company_name(p_security_group_id=>l_sgid);'||chr(10)||
'end;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 110.416
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_120.4
prompt  ...PAGE 120.416: Ajuda para Efetuar Log-in para Credenciais LDAP
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 120.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Ajuda para Efetuar Log-in para Credenciais LDAP',
  p_step_title=> 'Ajuda para Efetuar Log-in para Credenciais LDAP',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 24029824597247454.416+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Informe o nome de usuário e a senha para autenticação no diretório LDAP identificado na página de log-in. Lembre-se de que as senhas podem fazer distinção entre maiúsculas e minúsculas.';

wwv_flow_api.create_page_plug (
  p_id=> 1445611338758376.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 120.416,
  p_plug_name=> 'Ajuda de Log-in',
  p_region_name=>'',
  p_plug_template=> 517201101056507.416+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare l_text varchar2(2000);'||chr(10)||
'begin'||chr(10)||
'for c1 in (select attribute_03 from wwv_flow_custom_auth_setups where id = :F4155_P1000_SETUP_ID) loop'||chr(10)||
'l_text := c1.attribute_03;'||chr(10)||
'end loop;'||chr(10)||
'if l_text is not null and length(l_text) > 0 then'||chr(10)||
'htp.p(''<p>''||l_text);'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 1449809401843007.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 120.416,
  p_plug_name=> 'More Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 120.416
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_130.4
prompt  ...PAGE 130.416: Ajuda de Log-in para Credenciais de Conta do Banco de Dados
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 130.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Ajuda de Log-in para Credenciais de Conta do Banco de Dados',
  p_step_title=> 'Ajuda de Log-in para Credenciais de Conta do &PRODUCT_NAME.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Informe o nome de um esquema de banco de dados no campo de nome do usuário e a senha do esquema de banco de dados no campo de senha.';

wwv_flow_api.create_page_plug (
  p_id=> 69359231960281442.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 130.416,
  p_plug_name=> 'Login Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare l_text varchar2(2000);'||chr(10)||
'begin'||chr(10)||
'for c1 in (select attribute_03 from wwv_flow_custom_auth_setups where id = :F4155_P1000_SETUP_ID) loop'||chr(10)||
'l_text := c1.attribute_03;'||chr(10)||
'end loop;'||chr(10)||
'if l_text is not null and length(l_text) > 0 then'||chr(10)||
'htp.p(''<p>''||l_text);'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 69359425115281444.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 130.416,
  p_plug_name=> 'More Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>69359628843281448.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 130.416,
  p_name=>'F4150_P130_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 69359231960281442.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '(unknown)',
  p_prompt=>'P130 Company',
  p_source=>'declare '||chr(10)||
'  l_sgid number := null;'||chr(10)||
'  l_flow_id number := null;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select id from wwv_flows '||chr(10)||
'    where custom_authentication_process = ''.''||:F4155_P1000_SETUP_ID||''.'') loop'||chr(10)||
'  l_flow_id := c1.id;'||chr(10)||
'  end loop;'||chr(10)||
'  for c1 in (select security_group_id from wwv_flows '||chr(10)||
'    where id = l_flow_id) loop       '||chr(10)||
'    l_sgid := c1.security_group_id;'||chr(10)||
'  end loop;'||chr(10)||
'        '||chr(10)||
'  return wwv_flow_security.find_company_name(p_security_group_id=>l_sgid);'||chr(10)||
'end;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 130.416
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_1000.
prompt  ...PAGE 1000.416: Log-in
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<script type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
'function submitenter(myfield,e)'||chr(10)||
'{'||chr(10)||
'var keycode;'||chr(10)||
'if (window.event) keycode = window.event.keyCode;'||chr(10)||
'else if (e) keycode = e.which;'||chr(10)||
'else return true;'||chr(10)||
''||chr(10)||
'if (keycode == 13)'||chr(10)||
'   {'||chr(10)||
'   doSubmit(''LOGIN_BUTTON'');'||chr(10)||
'   return false;'||chr(10)||
'   }'||chr(10)||
'else'||chr(10)||
'   return true;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
' function putFocus() {'||chr(10)||
'  document.wwv_flow.p_t04.focus();'||chr(10)||
' }'||chr(10)||
'//-->'||chr(10)||
'</SCRIPT>';

wwv_flow_api.create_page(
  p_id     => 1000.416,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Log-in',
  p_step_title=> 'Log-in',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 515426975056506.416+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164935',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1000.416,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Informe suas credenciais neste form para iniciar uma nova sessão nessa aplicação do &PRODUCT_NAME. Há ajuda disponível sobre <a href="&F4155_P1000_LOGIN_HELP">problemas de log-in</a> comuns.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 1402815470381580.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1000.416,
  p_plug_name=> 'Tips',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

wwv_flow_api.create_page_plug (
  p_id=> 1484625910339788.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1000.416,
  p_plug_name=> 'left',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 57075215208721471.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1000.416,
  p_plug_name=> '&LOGIN_NAME.',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated by create flow wizard');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 57080610862891705.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1000.416,
  p_plug_name=> 'Hidden Fields',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 57079816296853917.416 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1000.416,
  p_button_sequence=> 10,
  p_button_plug_id => 57075215208721471+wwv_flow_api.g_id_offset,
  p_button_name    => 'LOGIN_BUTTON',
  p_button_image_alt=> 'Log-in',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>34456324362177919.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_branch_action=> '1000',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'PLSQL_EXPRESSION',
  p_branch_condition=> 'wwv_flow.g_notification is not null',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 25-APR-2003 23:39 by SSPADAFO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Não há texto de ajuda disponível';

wwv_flow_api.create_page_item(
  p_id=>476622691412236.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_USERNAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 57075215208721471.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nome do usuário',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="1"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 517018400056507.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Não há texto de ajuda disponível';

wwv_flow_api.create_page_item(
  p_id=>477505160416649.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 57075215208721471.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Senha',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'PASSWORD_WITH_ENTER_SUBMIT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="2"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'F4155_P1000_PASSWORD',
  p_display_when2=>'no-password-required',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_field_template => 517018400056507.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_encrypt_session_state_yn=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>485932199001641.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_FLOW_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 57075215208721471.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1385208320963232.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_FOOTNOTE_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 57075215208721471.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '&F4155_P1000_FOOTNOTE.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 517018400056507.416+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1430825232564185.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_LOGIN_HELP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 1402815470381580.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'P1000 Login Help',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1441703804737288.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_SETUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 57080610862891705.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'P1000 Setup Id',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>9071511746635487.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'F4155_P1000_FOOTNOTE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 57080610862891705.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="tiptext"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>57184595646965683.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1000.416,
  p_name=>'LOGIN_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 57080610862891705.416+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '&PRODUCT_NAME.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'login_name',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 57188216053643298.416 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1000.416,
  p_validation_name => 'pass req',
  p_validation_sequence=> 10,
  p_validation => 'F4155_P1000_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Forneça uma senha.',
  p_associated_item=> .416 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'ON_ERROR_PAGE',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_custom_auth_std.login('||chr(10)||
'    p_uname=>htf.escape_sc(:F4155_P1000_USERNAME),'||chr(10)||
'    p_password=>:F4155_P1000_PASSWORD,'||chr(10)||
'    p_session_id=>:FLOW_SESSION,'||chr(10)||
'    p_flow_page=>:F4155_P1000_FLOW_PAGE);';

wwv_flow_api.create_page_process(
  p_id     => 475708492408121.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1000.416,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1000';

wwv_flow_api.create_page_process(
  p_id     => 501401789522753.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1000.416,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'F4155_P1000_PASSWORD',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_process_when2=>'no-password-required',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1000.416
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4160
--
--application/shared_components/user_interface/templates/page/columbus_login_and_logout_page_from_4999_pt_br
prompt  ......Page template 515426975056506.416
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'||chr(10)||
'';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><br /></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<div id="htmldbLogo2">#LOGO#</div>'||chr(10)||
'<div class="htmldbSep"><br/></div>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div class="htmldbBreadcrumbRegion"><br /></div>'||chr(10)||
'<a name="SkipRepNav"></a>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td ';

c3:=c3||'valign="top">#REGION_POSITION_01#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top">#REGION_POSITION_02##REGION_POSITION_04##BOX_BODY#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top" style="width:100%"><div style="float:right;">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 515426975056506.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> '(Columbus) Login and Logout Page From 4999.pt-br',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 101,
  p_theme_class_id => 6,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80966020820422852,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly_pt_br
prompt  ......Page template 515622318056506.416
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>';

c2:=c2||'</body>'||chr(10)||
'</html>';

c3:=c3||'<br />#BOX_BODY#';

wwv_flow_api.create_template(
  p_id=> 515622318056506.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'printer-friendly.pt-br',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 101,
  p_theme_class_id => 5,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80874804748045950,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup_info_pt_br
prompt  ......Page template 24029824597247454.416
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD# style="margin:5px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'||chr(10)||
'';

c2:=c2||'#FORM_CLOSE#'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div>#REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##BOX_BODY#</div>'||chr(10)||
'<div style="text-align:middle;">#REGION_POSITION_08#</div>';

wwv_flow_api.create_template(
  p_id=> 24029824597247454.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup Info.pt-br',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 101,
  p_theme_class_id => 4,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 19940022257958945,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/wizard_box
prompt  ......region template 517201101056507.416
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 517201101056507.416 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 101,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 18253116293565611,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 517201101056507.416 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
prompt  ...report templates
--
prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/formfield_optional
prompt  ......label template 517018400056507.416
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 517018400056507.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 0,
  p_reference_id=> 17388415351892041,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/formfield_required
prompt  ......label template 107535106471295136.416
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 107535106471295136.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelRequired" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999"><img src="#IMAGE_PREFIX#requiredicon_status2.gif" alt="" />',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 101,
  p_theme_class_id => 0,
  p_reference_id=> 17388508175892042,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 518927322056521.416
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 518927322056521.416 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif',
  p_popup_icon_attr=>'width="18" height="18" alt="#LIST_OF_VALUES#" title="#LIST_OF_VALUES#"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Diálogo Pesquisar',
  p_page_html_head=>'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
'<head>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" type="text/css" />'||chr(10)||
'<script src="#IMAGE_PREFIX#javascript/apex_builder.js" type="text/javascript"></script>'||chr(10)||
'<style>a{font-size:12px;}</style>'||chr(10)||
'</head>',
  p_page_body_attr=>'onload="first_field()" class="htmldbPopup"',
  p_before_field_text=>'',
  p_page_heading_text=>'<div style="padding:2px;"><table><tr><td valign="top"><img src="#IMAGE_PREFIX#magnifying_glass_white_bg.gif" /></td><td>',
  p_page_footer_text =>'</td></tr></table></div>',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Pesquisa',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Fechar',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Próximo >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Anterior',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'500',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Linha(s) #FIRST_ROW# - #LAST_ROW#</div><center>',
  p_result_rows_per_pg=>200,
  p_before_result_set=>'<div style="padding-left:6px;">',
  p_theme_id  => 101,
  p_theme_class_id => 1,
  p_reference_id       => 17343114994581872,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
prompt  ...application themes
--
prompt  ...build options used by application 4160
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4160
--
--application/shared_components/globalization/dyntranslations
prompt  ...dynamic translations used by application: 4160
--
--application/shared_components/globalization/language
prompt  ...Language Maps for Application 4160
--
 
begin
 
null;
 
end;
/

prompt  ...Shortcuts
--
prompt  ...web services (9iR2 or better)
--
prompt  ...shared queries
--
prompt  ...report layouts
--
prompt  ...authentication schemes
--
--application/end_environment
commit;
commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
