set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4555 - APEX - Login
--
-- Application Export:
--   Application:     4555
--   Name:            APEX - Login
--   Date and Time:   08:06 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 9
--     Items:              19
--     Computations:        1
--     Validations:        18
--     Processes:          23
--     Regions:            28
--     Buttons:            12
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               3
--     Computations:        1
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             0
--     Lists:               4
--     Shortcuts:           3
--     Themes:              0
--     Templates:
--        Page:             2
--        List:             1
--        Report:           1
--        Label:            3
--        Region:          11
--     Messages:            0
--     Build Options:       1
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4555;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4555);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4555);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4555,
  p_display_id=> 4555,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - Login',
  p_alias => 'A198395119587471702',
  p_page_view_logging => 'YES',
  p_default_page_template=> 9095301378087765.4555 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 60929357198712420.4555 + wwv_flow_api.g_id_offset,
  p_error_template    => 60929357198712420.4555 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_page_protection_enabled_y_n=> 'N',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4550:1:&SESSION.',
  p_flow_language     => 'pt-br',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => 'development_service_home_login',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(487415230967122 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. ',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'N',
  p_vpd               => '',
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_substitution_string_01 => 'PRODUCT_NAME',
  p_substitution_value_01  => 'Application Express',
  p_substitution_string_02 => 'REGISTER_LINK',
  p_substitution_value_02  => 'development_service_signup',
  p_substitution_string_03 => 'CLOSE',
  p_substitution_value_03  => 'Fechar',
  p_substitution_string_04 => 'DATE_FORMAT',
  p_substitution_value_04  => 'dd/mm/rr',
  p_substitution_string_05 => 'LONG_DATE_FORMAT',
  p_substitution_value_05  => 'fmDay dd "de" Month "de" yyyy',
  p_substitution_string_06 => 'TIME_FORMAT',
  p_substitution_value_06  => 'hh24:mi:ss',
  p_substitution_string_07 => 'DATE_TIME_FORMAT',
  p_substitution_value_07  => 'dd/mm/rr hh24:mi:ss',
  p_substitution_string_08 => 'RETURN_TO_APPLICATION',
  p_substitution_value_08  => 'Retornar à Aplicação',
  p_substitution_string_09 => 'MSG_LANGUAGE',
  p_substitution_value_09  => 'Idioma',
  p_substitution_string_10 => 'MSG_COMPANY',
  p_substitution_value_10  => 'Espaço de Trabalho: &COMPANY.',
  p_substitution_string_11 => 'MSG_COPYRIGHT',
  p_substitution_value_11  => 'Copyright &copy; 1999, 2006, Oracle. Todos os direitos reservados e de titularidade da Oracle Corporation. Proibida a reprodução total ou parcial.',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518143632',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
--application/shared_components/logic/application_items/error_occurred
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 47291523209584096.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'ERROR_OCCURRED',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4550_service_request_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 16763020509404219.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4550_SERVICE_REQUEST_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 510231751281890.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/f4550_service_request_url
wwv_flow_api.create_flow_computation (
  p_id => 16766113976430755.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'F4550_SERVICE_REQUEST_URL',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'declare l_url varchar2(255) := null;'||chr(10)||
'begin'||chr(10)||
'l_url := wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW'');'||chr(10)||
'if l_url = ''EMAIL'' then'||chr(10)||
'   l_url := ''4700'';'||chr(10)||
'end if;'||chr(10)||
'return ''f?p=''||l_url||'':1'';'||chr(10)||
'end;',
  p_compute_when=> 'nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''),''MANUAL'') <> ''MANUAL''',
  p_compute_when_type=> 'PLSQL_EXPRESSION',
  p_computation_error_message=>'',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/hr_or_new
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20203615154961597.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'HR_OR_NEW',
  p_lov_query=> '.'||to_char(20203615154961597 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20203830364961608.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>20203615154961597.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Desbloquear o exemplo de conta do usuário HR',
  p_lov_return_value=>'HR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20204016953961621.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>20203615154961597.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Criar uma nova conta de usuário',
  p_lov_return_value=>'NEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/language_pref
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LANGUAGE_PREF',
  p_lov_query=> '.'||to_char(91126801753691270 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91127127653691273.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Chinês (China)',
  p_lov_return_value=>'zh-cn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91127305990691273.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Chinês (Taiwan)',
  p_lov_return_value=>'zh-tw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91127504317691273.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Inglês',
  p_lov_return_value=>'en',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91127702350691274.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Francês',
  p_lov_return_value=>'fr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91127924193691274.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Alemão',
  p_lov_return_value=>'de',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91128105057691274.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Italiano',
  p_lov_return_value=>'it',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91128314741691274.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Japonês',
  p_lov_return_value=>'ja',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91128529839691275.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Coreano',
  p_lov_return_value=>'ko',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91128730790691277.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Português (Brasil)',
  p_lov_return_value=>'pt-br',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91128912347691277.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>91126801753691270.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Espanhol',
  p_lov_return_value=>'es',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/roles
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20420213496266810.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ROLES',
  p_lov_query=> '.'||to_char(20420213496266810 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20420400631266813.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>20420213496266810.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Desenvolvimento de Banco de Dados (RECURSO)',
  p_lov_return_value=>'RESOURCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20420610391266814.4555 + wwv_flow_api.g_id_offset,
  p_lov_id=>20420213496266810.4555 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Administrativo (DBA)',
  p_lov_return_value=>'DBA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.455
prompt  ...PAGE 1.4555: Home Page de Log-in
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'start_login.htm';

ph:=ph||'<style type="text/css">'||chr(10)||
'    /* Set for same widht in IE and FF*/'||chr(10)||
'    #F4550_P11_PASSWORD,#F4550_P11_USERNAME,#F4550_P11_COMPANY{width:200px;}'||chr(10)||
'.htmldbLoginTop{margin:0 0 10px 0;}'||chr(10)||
'	.htmldbLoginTop th {background-color:#aaaaaa;}'||chr(10)||
'	.htmldbLoginTop th.L{background-repeat : no-repeat;background-image:url(#IMAGE_PREFIX#htmldb/builder/left_curve.gif);width:10px;vertical-align:top;background-position : top ';

ph:=ph||'left;}'||chr(10)||
'	.htmldbLoginTop th.C{text-align:center;font-weight:bold;font-size:14px;color:#ffffff}'||chr(10)||
'	.htmldbLoginTop th.R{background-repeat : no-repeat;background-image:url(#IMAGE_PREFIX#htmldb/builder/right_curve.gif);width:10px;vertical-align:top;background-position : top right;}'||chr(10)||
'	.htmldbLoginBottom{margin:0 0 10px 0;}'||chr(10)||
'	.htmldbLoginBottom th {background-color:#eeeeee;}'||chr(10)||
'	.htmldbLoginBottom th.LF{backgr';

ph:=ph||'ound-repeat : no-repeat;;width:10px;vertical-align:top;background-position : top left;}'||chr(10)||
'	.htmldbLoginBottom th.CF{text-align:center;font-weight:bold;font-size:12px;color:#ffffff}'||chr(10)||
'.htmldbLoginBottom th.RF{'||chr(10)||
'background-repeat:no-repeat;'||chr(10)||
'width:10px;vertical-align:top;'||chr(10)||
'background-position: top right;}'||chr(10)||
''||chr(10)||
''||chr(10)||
'</style>';

wwv_flow_api.create_page(
  p_id     => 1.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Home Page de Log-in',
  p_step_title=> 'Log-in de &PRODUCT_NAME.',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_group_id => 222575208632450607+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 9095301378087765.4555+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165105',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => 'intro_login');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4555,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4555,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 174366009353.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_plug_name=> 'Title',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 5734329754154454.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_plug_name=> 'Tarefas',
  p_region_name=>'',
  p_plug_template=> 155944222672692886.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 17,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 115315832368341144 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':F4550_P1_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 23202206656699152.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 30251320176465048.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_plug_name=> 'Log-in',
  p_region_name=>'',
  p_plug_template=> 21134717674904665.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> 'Informe o espaço de trabalho e as credenciais do Application Express. <br /><br />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select decode(task_link,null,task_name,''<a href="''||task_link||''">''||task_name||''</a>'') d'||chr(10)||
'from wwv_flow_customized_tasks where displayed = ''Y'' and display_location = ''WORKSPACE_LOGIN'' order by display_sequence';

wwv_flow_api.create_report_region (
  p_id=> 59842604093647546.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_name=> 'Tarefas Específicas de Site',
  p_region_name=>'',
  p_template=> 155944222672692886.4555+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_03',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'select 1 from wwv_flow_customized_tasks where displayed = ''Y'' and display_location = ''WORKSPACE_LOGIN''',
  p_display_condition_type=> 'EXISTS',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 59856615437669702.4555+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Dados não encontrados.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 59843226474647566.4555 + wwv_flow_api.g_id_offset,
  p_region_id=> 59842604093647546.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'D',
  p_column_display_sequence=> 1,
  p_column_heading=> 'D',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107302106181329608.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_plug_name=> 'Getting Started',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.prn(wwv_flow_platform.get_preference( p_preference_name => ''LOGIN_MESSAGE''));';

wwv_flow_api.create_page_plug (
  p_id=> 138313119334276541.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4555,
  p_plug_name=> 'Mensagem de Log-in',
  p_region_name=>'',
  p_plug_template=> 308969701495595527.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_BOX_BODY',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 22004211512581791.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1.4555,
  p_button_sequence=> 10,
  p_button_plug_id => 30251320176465048+wwv_flow_api.g_id_offset,
  p_button_name    => 'LOGIN_BUTTON',
  p_button_image_alt=> 'Log-in',
  p_button_position=> 'BELOW_BOX',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'tabindex="4"  class="htmldbButton"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 107299518863323821.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1.4555,
  p_button_sequence=> 20,
  p_button_plug_id => 30251320176465048+wwv_flow_api.g_id_offset,
  p_button_name    => 'GETTING_STARTED',
  p_button_image   => 'template:'||to_char(20301506730451152+wwv_flow_api.g_id_offset),
  p_button_image_alt=> 'Clique aqui para saber mais sobre como começar.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&p_session=&SESSION.&p_flow_id=4550&p_step_id=1'');',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>9141131880673724.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4555,
  p_branch_action=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'BEFORE_HEADER',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_required_patch=> 9152708051846605.4555 + wwv_flow_api.g_id_offset,
  p_branch_comment=> 'Created 27-SEP-2005 22:56 by SSPADAFO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<div class="htmldbInfoBodyP">Informe seu espaço de trabalho. O atributo de espaço de trabalho não faz distinção entre maiúsculas e minúsculas.</div>'||chr(10)||
'<div class="htmldbInfoBodyP">Este é um serviço de desenvolvimento on-line que permite acesso a um banco de dados privado virtual. Como o mesmo nome de usuário pode existir em vários espaços de trabalho, você deverá informar seu espaço de trabalho ao u';

h:=h||'sar este serviço.</div>';

wwv_flow_api.create_page_item(
  p_id=>30250621039456935.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4555,
  p_name=>'F4550_P1_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 30251320176465048.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Espaço de Trabalho',
  p_source=>'wwv_flow_utilities.get_company_from_cookie;',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="1"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<div class="htmldbInfoBodyP">Informe seu nome de usuário. O nome de usuário não faz distinção entre maiúsculas e minúsculas.</div>'||chr(10)||
'<div class="htmldbInfoBodyP">Depois que você estiver autenticado e partindo do pressuposto de que você possui as credenciais apropriadas, será possível criar usuários adicionais.</div>';

wwv_flow_api.create_page_item(
  p_id=>30251012844458645.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4555,
  p_name=>'F4550_P1_USERNAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 30251320176465048.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nome do usuário',
  p_source=>'wwv_flow_utilities.get_un_from_cookie',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="2"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<div class="htmldbInfoBodyP">Informe sua senha. Senhas fazem distinção entre maiúsculas e minúsculas. Essa senha é específica para esse serviço. Observe que cada espaço de trabalho pode ter vários usuários.</div>'||chr(10)||
'<div class="htmldbInfoBodyP">Se esquecer sua senha, selecione <span class="fielddatabold">Redefinir Senha</span>.</div>';

wwv_flow_api.create_page_item(
  p_id=>30251520608467092.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4555,
  p_name=>'F4550_P1_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 30251320176465048.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="3"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 14794408194619070.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_validation_name => 'F4550_P1_COMPANY Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4550_P1_COMPANY',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o espaço de trabalho.',
  p_associated_item=> 30250621039456935.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 14794718743619076.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_validation_name => 'F4550_P1_USERNAME Not Null',
  p_validation_sequence=> 2,
  p_validation => 'F4550_P1_USERNAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o nome do usuário.',
  p_associated_item=> 30251012844458645.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 14795009696619077.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_validation_name => 'F4550_P1_PASSWORD Not Null',
  p_validation_sequence=> 3,
  p_validation => 'F4550_P1_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique a senha.',
  p_associated_item=> 30251520608467092.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if :F4550_P1_COMPANY = ''INTERNAL'' and '||chr(10)||
'      #OWNER#.wwv_flow_security.disable_admin_login then'||chr(10)||
'      sys.owa_util.mime_header(''text/html'',false);'||chr(10)||
'      sys.owa_util.redirect_url(''f?p=4550:10'');'||chr(10)||
'  end if;'||chr(10)||
'  if wwv_flow_security.disable_workspace_login then'||chr(10)||
'      #OWNER#.wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      sys.owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      sys.owa_util.http_he';

p:=p||'ader_close;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 362587120355512597.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'disabled login check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare l_p varchar2(256) := v(''F4550_P1_PASSWORD'');'||chr(10)||
'begin'||chr(10)||
'  wwv_flow_login.builder ('||chr(10)||
'    p_username => :F4550_P1_USERNAME,'||chr(10)||
'    p_workspace=> :F4550_P1_COMPANY,'||chr(10)||
'    p_password => l_p);'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 359371008265397285.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_process_sequence=> 11,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_last_agent varchar2(4000) := sys.owa_util.get_cgi_env(''HTTP_USER_AGENT'');'||chr(10)||
'  l_last_ip    varchar2(4000) := sys.owa_util.get_cgi_env(''REMOTE_ADDR'');'||chr(10)||
'  l_user       varchar2(255) := #OWNER#.v(''USER'');'||chr(10)||
'  l_sgid       number;'||chr(10)||
'begin'||chr(10)||
'for c1 in (select PROVISIONING_COMPANY_ID '||chr(10)||
'           from #OWNER#.WWV_FLOW_COMPANIES '||chr(10)||
'           where SHORT_NAME = upper(:F4550_P1_COMPANY)) loop'||chr(10)||
'   l_sgid :=';

p:=p||' c1.PROVISIONING_COMPANY_ID;'||chr(10)||
''||chr(10)||
'update #OWNER#.wwv_flow_fnd_user '||chr(10)||
'   set last_login = sysdate, '||chr(10)||
'       BUILDER_LOGIN_COUNT = nvl(BUILDER_LOGIN_COUNT,0) + 1,'||chr(10)||
'       last_agent = l_last_agent,'||chr(10)||
'       last_ip    = l_last_ip'||chr(10)||
'where  USER_NAME = l_user and '||chr(10)||
'       SECURITY_GROUP_ID = l_sgid;'||chr(10)||
'end loop;'||chr(10)||
'exception when others then null;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 79900621516189928.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_process_sequence=> 15,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Log Login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1';

wwv_flow_api.create_page_process(
  p_id     => 491225097024458.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if not #OWNER#.wwv_flow_security.ip_check then'||chr(10)||
'      #OWNER#.wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      sys.owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      sys.owa_util.http_header_close;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 297447517593238309.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ip range check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if wwv_flow_security.disable_workspace_login then'||chr(10)||
'      #OWNER#.wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      sys.owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      sys.owa_util.http_header_close;'||chr(10)||
'      sys.htp.p(wwv_flow_lang.system_message(''WWV_FLOW_FND_USER_API.CHECK_USER''));'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 362585625418504590.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4555,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'disabled login check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_2.455
prompt  ...PAGE 2.4555: Nenhum Cookie
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 2.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Nenhum Cookie',
  p_step_title=> 'Nenhum Cookie',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165105',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 134636703889796037.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4555,
  p_plug_name=> 'No Cookies',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_3.455
prompt  ...PAGE 3.4555: Alterar Senha
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 3.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Alterar Senha',
  p_step_title=> 'Alterar Senha',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 9095301378087765.4555+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165105',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'A senha do usuário &P11_USERNAME. foi alterada.';

wwv_flow_api.create_page_plug (
  p_id=> 9191423473355180.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4555,
  p_plug_name=> 'Confirmar',
  p_region_name=>'',
  p_plug_template=> 249669609896384376.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1939532588110834.4555+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'REQUEST_EQUALS_CONDITION',
  p_plug_display_when_condition => 'CONFIRM',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':F4550_P3_PASSWORD := null;'||chr(10)||
':P3_OLD_PASSWORD := null;'||chr(10)||
':F4550_P3_CONFIRM_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 20491613569572633.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4555,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 97733238886811093.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4555,
  p_plug_name=> 'Alterar Senha',
  p_region_name=>'',
  p_plug_template=> 249669128792384373.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_BOX_BODY',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1939532588110834.4555+ wwv_flow_api.g_id_offset,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'REQUEST_NOT_IN_CONDITION',
  p_plug_display_when_condition => 'CONFIRM,LOCKED',
  p_plug_header=> '<p>A senha da conta expirou e deve ser alterada.</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 97746535656858508.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4555,
  p_button_sequence=> 10,
  p_button_plug_id => 9191423473355180+wwv_flow_api.g_id_offset,
  p_button_name    => 'Done',
  p_button_image_alt=> 'Concluído',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:11,3::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 9206729762461036.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4555,
  p_button_sequence=> 5,
  p_button_plug_id => 97733238886811093+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Cancelar',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4555,
  p_button_sequence=> 20,
  p_button_plug_id => 97733238886811093+wwv_flow_api.g_id_offset,
  p_button_name    => 'Save',
  p_button_image_alt=> 'Aplicar Alterações',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>167163108516013326.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4555,
  p_branch_action=> 'f?p=&FLOW_ID.:3:&SESSION.:CONFIRM:&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>97747647431861978.4555+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 24-JUN-2004 21:21 by SSPADAFO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe a antiga senha';

wwv_flow_api.create_page_item(
  p_id=>9182307711312734.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4555,
  p_name=>'P3_OLD_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 97733238886811093.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Antiga Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Nome do usuário cuja senha será alterada';

wwv_flow_api.create_page_item(
  p_id=>97737538442826475.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4555,
  p_name=>'F4550_P3_USER_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 97733238886811093.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nome do Usuário',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'I',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe a nova senha';

wwv_flow_api.create_page_item(
  p_id=>97738659564831833.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4555,
  p_name=>'F4550_P3_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 97733238886811093.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nova Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Entre novamente com a nova senha';

wwv_flow_api.create_page_item(
  p_id=>97739354173834337.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4555,
  p_name=>'F4550_P3_CONFIRM_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 97733238886811093.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Confirmar Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 9202515863428641.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_validation_name => 'P3_OLD_PASSWORD',
  p_validation_sequence=> 10,
  p_validation => 'P3_OLD_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'A antiga senha deve ser especificada.',
  p_when_button_pressed=> 97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_associated_item=> 9182307711312734.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 97742065159844462.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_validation_name => 'F4550_P3_PASSWORD Not Null',
  p_validation_sequence=> 20,
  p_validation => 'F4550_P3_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique a nova senha.',
  p_when_button_pressed=> 97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_associated_item=> 97738659564831833.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 07-AUG-2002 16:59');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 97742336858844467.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_validation_name => 'F4550_P3_CONFIRM_PASSWORD Not Null',
  p_validation_sequence=> 30,
  p_validation => 'F4550_P3_CONFIRM_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o valor de Confirmar Senha.',
  p_associated_item=> 97739354173834337.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 07-AUG-2002 16:59');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 97743950494851242.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_validation_name => 'passwd = confirm passwd',
  p_validation_sequence=> 40,
  p_validation => 'if v(''F4550_P3_PASSWORD'') != v(''F4550_P3_CONFIRM_PASSWORD'') then'||chr(10)||
'  :F4550_P3_PASSWORD := null;'||chr(10)||
'  :F4550_P3_CONFIRM_PASSWORD := null;'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'A senha de confirmação não coincide com a senha.',
  p_when_button_pressed=> 97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_associated_item=> 97739354173834337.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 9224322920790224.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_validation_name => 'check old password',
  p_validation_sequence=> 50,
  p_validation => 'if wwv_flow_security.check_db_password('||chr(10)||
'    p_username=>v(''F4550_P3_USER_NAME''),'||chr(10)||
'    p_password=>v(''P3_OLD_PASSWORD'')) in (''0'',''PASSWORD EXPIRED'') then'||chr(10)||
'  return true;'||chr(10)||
'else'||chr(10)||
'  return false;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'A antiga senha não está correta.',
  p_validation_condition=> ':F4550_P3_PASSWORD is not null and :F4550_P3_CONFIRM_PASSWORD is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'  l_sql varchar2(100);'||chr(10)||
'  l_p varchar2(256) := v(''F4550_P3_PASSWORD'');'||chr(10)||
'begin'||chr(10)||
'  begin'||chr(10)||
'    wwv_flow.update_cache_with_write(''F4550_P3_PASSWORD'',null);'||chr(10)||
'    wwv_flow.update_cache_with_write(''P3_OLD_PASSWORD'',null);'||chr(10)||
'    wwv_flow.update_cache_with_write(''F4550_P3_CONFIRM_PASSWORD'',null);'||chr(10)||
'  end;'||chr(10)||
'  l_sql := ''alter user ''||:F4550_P3_USER_NAME||'' identified by ''||l_p;'||chr(10)||
'execute immediate l_sql;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 97750634955873615.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'change password',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erro ao alterar a senha.',
  p_process_when_button_id=>97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_process_when=>':F4550_P3_PASSWORD = :F4550_P3_CONFIRM_PASSWORD',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> 'Senha alterada.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'3';

wwv_flow_api.create_page_process(
  p_id     => 60831518199464684.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4555,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>97747647431861978.4555 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_4.455
prompt  ...PAGE 4.4555: Localizar Meu Espaço de Trabalho
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 4.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Localizar Meu Espaço de Trabalho',
  p_step_title=> 'Localizar Meu Espaço de Trabalho',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165106',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22878608880410975.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4555,
  p_plug_name=> 'Localizar Meu Espaço de Trabalho',
  p_region_name=>'',
  p_plug_template=> 249669128792384373.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> 'Você receberá todos os nomes do espaço de trabalho associados a este endereço de e-mail.',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 22883630052445491.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4555,
  p_button_sequence=> 10,
  p_button_plug_id => 22878608880410975+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Cancelar',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 26487014153670357.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4555,
  p_button_sequence=> 20,
  p_button_plug_id => 22878608880410975+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_image_alt=> 'Localizar Espaço de Trabalho',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>26487310047670358.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4555,
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:4::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>26487014153670357.4555+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>22891903920551475.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4555,
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>22883630052445491.4555+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 13-DEC-2006 01:54 by RAJU');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe o endereço de e-mail associado ao seu espaço de trabalho. Iremos enviar o nome do espaço de trabalho para este e-mail.';

wwv_flow_api.create_page_item(
  p_id=>22881822648433869.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4555,
  p_name=>'F4550_P4_EMAIL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 22878608880410975.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seu endereço de e-mail em nosso banco de dados',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 14882217773748275.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 22955710724969695.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 4.4555,
  p_validation_name => 'F4550_P4_EMAIL must be valid',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
'  l_at number;'||chr(10)||
'  l_dot number;'||chr(10)||
'begin'||chr(10)||
'  l_at := instr(nvl(:F4550_P4_EMAIL,''x''),''@'');'||chr(10)||
'  l_dot := instr(nvl(:F4550_P4_EMAIL,''x''),''.'',l_at);'||chr(10)||
'  return l_at > 1 and l_dot > 1 and (l_dot - l_at) > 1;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'O formato de endereço de e-mail está incorreto.',
  p_when_button_pressed=> 26487014153670357.4555 + wwv_flow_api.g_id_offset,
  p_associated_item=> 22881822648433869.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_fnd_developer_api.f4550_send_workspace ('||chr(10)||
'   p_email_address => :F4550_P4_EMAIL );';

wwv_flow_api.create_page_process(
  p_id     => 22891011754544211.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4555,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'send workspace name',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Erro',
  p_process_when_button_id=>26487014153670357.4555 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Se &F4550_P4_EMAIL. já existir em nossos registros, enviaremos os nomes de espaços de trabalho associados a este endereço de e-mail. Se tiver problemas para receber os nomes de espaços de trabalho, entre em contato com o administrador.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_7.455
prompt  ...PAGE 7.4555: Redefinir Senha
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 7.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Redefinir Senha',
  p_step_title=> 'Redefinir Senha',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 222577907724459883+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165106',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 47285769528327391.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4555,
  p_plug_name=> 'Redefinir Senha',
  p_region_name=>'',
  p_plug_template=> 249669128792384373.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'115315832368341144';

wwv_flow_api.create_page_plug (
  p_id=> 74608502164703922.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4555,
  p_plug_name=> 'Tasks',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 74614416147717398 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 14635328375431475.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4555,
  p_button_sequence=> 1,
  p_button_plug_id => 47285769528327391+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Cancelar',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 47286811980358498.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4555,
  p_button_sequence=> 10,
  p_button_plug_id => 47285769528327391+wwv_flow_api.g_id_offset,
  p_button_name    => 'resetpassword',
  p_button_image_alt=> 'Redefinir Senha',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>60120000609053928.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_branch_action=> 'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_branch_condition_type=> 'ITEM_IS_NOT_NULL',
  p_branch_condition=> 'ERROR_OCCURRED',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 12-JAN-2007 17:19 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>60096028904579631.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 12-JAN-2007 16:00 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>22923025971699756.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_name=>'F4550_P7_ERROR_TEXT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 47285769528327391.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'<span class="instructiontext">Você não forneceu uma combinação válida de nome de espaço de trabalho e endereço de e-mail.</span>',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'ERROR_OCCURRED',
  p_display_when_type=>'ITEM_IS_NOT_NULL',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>22936513812743509.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_name=>'F4550_P7_NEWTABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 7,
  p_item_plug_id => 47285769528327391.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'ERROR_OCCURRED',
  p_display_when_type=>'ITEM_IS_NOT_NULL',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe o espaço de trabalho.  Caso não saiba qual é o seu espaço de trabalho, use o link Localizar Meu Espaço de Trabalho.';

wwv_flow_api.create_page_item(
  p_id=>47286220449334625.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_name=>'F4550_P7_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 47285769528327391.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Espaço de Trabalho',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 14882217773748275.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe seu endereço de e-mail para que possamos enviar a senha.';

wwv_flow_api.create_page_item(
  p_id=>47286414702337991.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_name=>'F4550_P7_EMAIL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 47285769528327391.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seu endereço de e-mail em nosso banco de dados',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 14882217773748275.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 22910528694672171.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4555,
  p_computation_sequence => 10,
  p_computation_item=> 'ERROR_OCCURRED',
  p_computation_point=> 'AFTER_FOOTER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 74605102595685181.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 7.4555,
  p_validation_name => 'F4550_P7_EMAIL Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4550_P7_EMAIL',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'O e-mail deve ser especificado.',
  p_associated_item=> 47286414702337991.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 23-JAN-2007 07:29');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 74605307525685181.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 7.4555,
  p_validation_name => 'F4550_P7_COMPANY Not Null',
  p_validation_sequence=> 2,
  p_validation => 'F4550_P7_COMPANY',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o espaço de trabalho.',
  p_associated_item=> 47286220449334625.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 23-JAN-2007 07:29');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 359674223295887132.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 7.4555,
  p_validation_name => 'do not allow internal',
  p_validation_sequence=> 10,
  p_validation => 'nvl(upper(:F4550_P7_COMPANY),''x'') != ''INTERNAL''',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Operação de redefinição de senha não suportada para o espaço de trabalho INTERNAL.',
  p_associated_item=> 47286220449334625.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_fnd_developer_api.f4550_reset_password ('||chr(10)||
'  p_email_address=> :F4550_P7_EMAIL,'||chr(10)||
'  p_workspace_name=> :F4550_P7_COMPANY );';

wwv_flow_api.create_page_process(
  p_id     => 47291128490577452.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4555,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'change password',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Não foi possível redefinir a senha.',
  p_process_when_button_id=>47286811980358498.4555 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'A solicitação redefinir senha foi enviada para processamento.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_8.455
prompt  ...PAGE 8.4555: Confirmação de Log-out
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 8.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Confirmação de Log-out',
  p_step_title=> 'Confirmação de Log-out',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 222579123308464377+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165106',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<h1>'' || wwv_flow_lang.system_message(''YOU_ARE_NOW_LOGGED_OUT'') || ''</h1>'');'||chr(10)||
'htp.prn(''<br />'');'||chr(10)||
'htp.p(''<a href="apex" class="htmldbInstruct">''||wwv_flow_lang.system_message(''LOGIN'')||''</a>'');';

wwv_flow_api.create_page_plug (
  p_id=> 47289611174520429.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4555,
  p_plug_name=> 'Confirmação de Log-out',
  p_region_name=>'',
  p_plug_template=> 308969701495595527.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>9143113011706116.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4555,
  p_branch_action=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'BEFORE_HEADER',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_required_patch=> 9152708051846605.4555 + wwv_flow_api.g_id_offset,
  p_branch_comment=> 'Created 27-SEP-2005 23:02 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>47290514531564696.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4555,
  p_branch_action=> '&P8_NEXTPAGE.',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-MAR-2001 19:57 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>72005820105419587.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4555,
  p_name=>'P8_NEXTPAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 47289611174520429.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_sessions$ where id = :flow_session;';

wwv_flow_api.create_page_process(
  p_id     => 48179495483070440.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4555,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'clean up session state',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_9.455
prompt  ...PAGE 9.4555: Confirmação de Log-out
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 9.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Confirmação de Log-out',
  p_step_title=> 'Confirmação de Log-out',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 9095301378087765.4555+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165106',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<h1>'' || wwv_flow_lang.system_message(''YOU_ARE_NOW_LOGGED_OUT'') || ''</h1>'');'||chr(10)||
'htp.prn(''<br />'');'||chr(10)||
'htp.p(''<a href="apex" class="htmldbInstruct">''||wwv_flow_lang.system_message(''LOGIN'')||''</a>'');';

wwv_flow_api.create_page_plug (
  p_id=> 322068013750423668.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4555,
  p_plug_name=> 'Confirmação de Log-out',
  p_region_name=>'',
  p_plug_template=> 308969701495595527.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>322068917107467935.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4555,
  p_branch_action=> '&P9_NEXTPAGE.',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 22-MAR-2001 19:57 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>346784222681322826.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4555,
  p_name=>'P9_NEXTPAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 322068013750423668.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '11',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_sessions$ where id = :flow_session;';

wwv_flow_api.create_page_process(
  p_id     => 322957898058973679.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9.4555,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'clean up session state',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_10.45
prompt  ...PAGE 10.4555: Log-in na Administração Interna
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<style>'||chr(10)||
'#P10_USERNAME ,#P10_PASSWORD{width:200px;}'||chr(10)||
''||chr(10)||
'</style>';

wwv_flow_api.create_page(
  p_id     => 10.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Log-in na Administração Interna',
  p_step_title=> '&PRODUCT_NAME. Serviços de Administração',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_group_id => 222575208632450607+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 9095301378087765.4555+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165106',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>10.4555,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 1043922209309491.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4555,
  p_plug_name=> '&PRODUCT_NAME. Serviços de Administração',
  p_region_name=>'',
  p_plug_template=> 14581217810376673.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 3,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':P10_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 23205800319914944.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4555,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 23,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Esta interface permite que o administrador gerencie todos os aspectos do serviço, incluindo a criação, a remoção e o gerenciamento de espaços de trabalho.';

wwv_flow_api.create_page_plug (
  p_id=> 61702507141217977.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4555,
  p_plug_name=> 'Mensagem de Log-in',
  p_region_name=>'',
  p_plug_template=> 61771527068337270.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'61885431289518270';

wwv_flow_api.create_page_plug (
  p_id=> 61888212026522164.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4555,
  p_plug_name=> 'Tarefas',
  p_region_name=>'',
  p_plug_template=> 155944222672692886.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 13,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 61885431289518270 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'NEVER',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 1045428295309521.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4555,
  p_button_sequence=> 20,
  p_button_plug_id => 1043922209309491+wwv_flow_api.g_id_offset,
  p_button_name    => 'LOGIN_BUTTON',
  p_button_image_alt=> 'Log-in',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe seu nome do usuário. O nome do usuário faz distinção entre maiúsculas e minúsculas. Recebida a autenticação e presumindo-se que você tenha as credenciais corretas, você pode criar nomes de usuário adicionais.';

wwv_flow_api.create_page_item(
  p_id=>1046305318309559.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4555,
  p_name=>'P10_USERNAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1043922209309491.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nome do usuário',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 25,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe sua senha. As senhas fazem distinção entre maiúsculas e minúsculas. Se você esquecer a senha, clique no link "esqueceu sua senha". Observe que cada espaço de trabalho pode ter vários usuários.';

wwv_flow_api.create_page_item(
  p_id=>1046904764309561.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4555,
  p_name=>'P10_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 1043922209309491.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 25,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 44225917854582269.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>359654713065770666.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4555,
  p_name=>'P10_LOGIN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 1043922209309491.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'LOGIN_BUTTON',
  p_prompt=>'Log-in',
  p_source=>'LOGIN_BUTTON',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 1047801276309579.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_validation_name => 'P10_USERNAME Not Null',
  p_validation_sequence=> 2,
  p_validation => 'P10_USERNAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o nome do usuário.',
  p_associated_item=> 1046305318309559.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 1048123136309580.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_validation_name => 'P10_PASSWORD Not Null',
  p_validation_sequence=> 3,
  p_validation => 'P10_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique a senha.',
  p_associated_item=> 1046904764309561.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if wwv_flow_security.disable_admin_login then'||chr(10)||
'      #OWNER#.wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      sys.owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      sys.owa_util.http_header_close;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 239007203778570571.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'disabled login check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare l_p varchar2(256) := #OWNER#.v(''P10_PASSWORD'');'||chr(10)||
'begin'||chr(10)||
'  #OWNER#.wwv_flow_login.administrator ('||chr(10)||
'    p_username => :P10_USERNAME,'||chr(10)||
'    p_password => l_p);'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 359608213674439626.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'10';

wwv_flow_api.create_page_process(
  p_id     => 1048720322309594.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear Items on this page',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if not #OWNER#.wwv_flow_security.ip_check then'||chr(10)||
'      #OWNER#.wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      sys.owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      sys.owa_util.http_header_close;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 297445926120231391.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ip range check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if #OWNER#.wwv_flow_security.disable_admin_login then'||chr(10)||
'      #OWNER#.wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      sys.owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      sys.owa_util.http_header_close;'||chr(10)||
'      sys.htp.p(wwv_flow_lang.system_message(''WWV_FLOW_FND_USER_API.CHECK_USER''));'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 362591402740535889.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4555,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'disabled login check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10.4555
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_11.45
prompt  ...PAGE 11.4555: Home Page de Log-in
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<style>'||chr(10)||
'#P11_USERNAME ,#P11_PASSWORD{width:200px;}'||chr(10)||
'</style>'||chr(10)||
'<style type="text/css">'||chr(10)||
'	.htmldbLoginTop{margin:0 0 10px 0;}'||chr(10)||
'	.htmldbLoginTop th {background-color:#aaaaaa;}'||chr(10)||
'	.htmldbLoginTop th.L{background-repeat : no-repeat;background-image:url(#IMAGE_PREFIX#htmldb/builder/left_curve.gif);width:10px;vertical-align:top;background-position : top left;}'||chr(10)||
'	.htmldbLoginTop th.C{text-align:center;font-weigh';

ph:=ph||'t:bold;font-size:14px;color:#ffffff}'||chr(10)||
'	.htmldbLoginTop th.R{background-repeat : no-repeat;background-image:url(#IMAGE_PREFIX#htmldb/builder/right_curve.gif);width:10px;vertical-align:top;background-position : top right;}'||chr(10)||
'	.htmldbLoginBottom{margin:0 0 10px 0;}'||chr(10)||
'	.htmldbLoginBottom th {background-color:#eeeeee;}'||chr(10)||
'	.htmldbLoginBottom th.LF{background-repeat : no-repeat;);width:10px;vertical-align:top;b';

ph:=ph||'ackground-position : top left;}'||chr(10)||
'	.htmldbLoginBottom th.CF{text-align:center;font-weight:bold;font-size:12px;color:#ffffff}'||chr(10)||
'	.htmldbLoginBottom th.RF{background-repeat : no-repeat;);width:10px;vertical-align:top;background-position : top right;}'||chr(10)||
'</style>'||chr(10)||
'<script>'||chr(10)||
''||chr(10)||
'function pg11_CheckCookie(pThis){'||chr(10)||
'  SetCookie (''ISCOOKIE'',''true'');'||chr(10)||
'  flow = GetCookie (''ISCOOKIE'');'||chr(10)||
'if(flow){'||chr(10)||
' return;'||chr(10)||
'}else{'||chr(10)||
' html_Show';

ph:=ph||'Element(''CookieTest'');'||chr(10)||
'} '||chr(10)||
'return;'||chr(10)||
'}'||chr(10)||
''||chr(10)||
''||chr(10)||
'function pg11_GO (field, event) {'||chr(10)||
'  var keyCode = event.keyCode ? event.keyCode : '||chr(10)||
'                event.which ? event.which : event.charCode;'||chr(10)||
'  if (keyCode == 9) {'||chr(10)||
'	  html_GetElement(''LOGIN'').focus();'||chr(10)||
'  }'||chr(10)||
'}'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 11.4555,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Home Page de Log-in',
  p_step_title=> 'Log-in de &PRODUCT_NAME.',
  p_html_page_onload=>'onload="pg11_CheckCookie(this);"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 9095301378087765.4555+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409165106',
  p_page_is_public_y_n=> 'Y',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4555,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'2370922717381617';

wwv_flow_api.create_page_plug (
  p_id=> 2372620770390552.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'Links',
  p_region_name=>'',
  p_plug_template=> 155944222672692886.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 9101817486130207 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2376609950406299.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'Welcome',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':P11_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 20499119792848842.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20982304569513152.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> '&nbsp;',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.prn(wwv_flow_platform.get_preference( p_preference_name => ''LOGIN_MESSAGE''));';

wwv_flow_api.create_page_plug (
  p_id=> 21359618388559040.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'Advertência:',
  p_region_name=>'',
  p_plug_template=> 308969701495595527.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_FOOTER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.prn(''<noscript>'');'||chr(10)||
'htp.prn(''<div class="htmldbNotification">''||wwv_flow_lang.system_message(''4550_JAVASCRIPT_ENABLED'')||''</div>'');'||chr(10)||
'htp.prn(''</noscript>'');';

wwv_flow_api.create_page_plug (
  p_id=> 27757202486631095.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'No Javascript Enabled',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.prn(''<div class="htmldbNotification" id="CookieTest" style="display:none;">''||wwv_flow_lang.system_message(''4550_COOKIES_ENABLED'')||''</div>'');';

wwv_flow_api.create_page_plug (
  p_id=> 27775212881838952.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'No Cookies Enabled',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 305029722752368287.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4555,
  p_plug_name=> 'Log-in no Banco de Dados',
  p_region_name=>'',
  p_plug_template=> 21134717674904665.4555+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> 'Informe o nome do usuário e a senha do banco de dados. <br /><br />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 274804400965182087.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4555,
  p_button_sequence=> 10,
  p_button_plug_id => 305029722752368287+wwv_flow_api.g_id_offset,
  p_button_name    => 'LOGIN',
  p_button_image_alt=> 'Log-in',
  p_button_position=> 'BELOW_BOX',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'id="LOGIN" tabindex="4"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 19627809293374054.4555 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 11.4555,
  p_button_sequence=> 20,
  p_button_plug_id => 305029722752368287+wwv_flow_api.g_id_offset,
  p_button_name    => 'GETTING_STARTED',
  p_button_image   => 'template:'||to_char(20301506730451152+wwv_flow_api.g_id_offset),
  p_button_image_alt=> 'Clique aqui para saber mais sobre como começar.',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:popupURL(''wwv_flow_help.show_get_started'');',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>248572018822471873.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4555,
  p_branch_action=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'BEFORE_HEADER',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_required_patch=> -9152708051846605.4555 + wwv_flow_api.g_id_offset,
  p_branch_comment=> 'Created 07-JUL-2006 00:43 by SSPADAFO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Informe o seu nome de usuário de banco de dados Oracle.';

wwv_flow_api.create_page_item(
  p_id=>305029415420361884.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4555,
  p_name=>'P11_USERNAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 305029722752368287.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nome do usuário',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="2"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 9107221009165036.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Digite sua senha de banco de dados correspondente.';

wwv_flow_api.create_page_item(
  p_id=>305029923184370331.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4555,
  p_name=>'P11_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 305029722752368287.4555+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Senha',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'tabindex="3"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 9107221009165036.4555+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 289573121319522315.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_validation_name => 'P11_USERNAME Not Null',
  p_validation_sequence=> 2,
  p_validation => 'P11_USERNAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique o nome do usuário.',
  p_associated_item=> 305029415420361884.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 289573412272522316.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_validation_name => 'P11_PASSWORD Not Null',
  p_validation_sequence=> 3,
  p_validation => 'P11_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Especifique a senha.',
  p_associated_item=> 305029923184370331.4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 10262607355014837.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_validation_name => 'check locked status',
  p_validation_sequence=> 10,
  p_validation => 'for c1 in (select 1 from sys.dba_users '||chr(10)||
'      where username=upper(:P11_USERNAME) and account_status like ''%LOCKED%'') loop'||chr(10)||
'  return false;'||chr(10)||
'end loop;'||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'A conta está bloqueada. Um administrador pode desbloquear a conta.',
  p_associated_item=> .4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 10252001777710471.4555 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_validation_name => 'check password for expired account',
  p_validation_sequence=> 13,
  p_validation => 'if wwv_flow_security.check_db_password('||chr(10)||
'    p_username=>:P11_USERNAME,'||chr(10)||
'    p_password=>v(''P11_PASSWORD'')) in (''0'', ''PASSWORD EXPIRED'') then'||chr(10)||
'  return true;'||chr(10)||
'else'||chr(10)||
'  return false;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Credenciais de log-in inválidas.',
  p_validation_condition=> 'select 1 from sys.dba_users where username=upper(:P11_USERNAME) and account_status like ''EXPIRED%'' and not exists (select 1 from sys.dba_users where username=upper(:P11_USERNAME) and account_status like ''%LOCKED'')',
  p_validation_condition_type=> 'EXISTS',
  p_associated_item=> .4555 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_locked boolean := false;'||chr(10)||
'  l_expired boolean := false;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select 1 from sys.dba_users '||chr(10)||
'      where username=upper(:P11_USERNAME) and account_status like ''EXPIRED%'') loop'||chr(10)||
'    l_expired := true;'||chr(10)||
'  end loop;'||chr(10)||
'  :F4550_P3_USER_NAME := :P11_USERNAME;'||chr(10)||
'  if l_expired then '||chr(10)||
'    wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'    owa_util.redirect_url('||chr(10)||
'     ''f?p=&APP_ID.:3:&SESSION.::&DE';

p:=p||'BUG.:11'');'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 9210807833596690.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check account status and expiry',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'l_p varchar2(256) := v(''P11_PASSWORD'');'||chr(10)||
'begin'||chr(10)||
'  begin'||chr(10)||
'    wwv_flow.update_cache_with_write(''P11_PASSWORD'',null);'||chr(10)||
'  end;'||chr(10)||
'  wwv_flow_login.xe_login ('||chr(10)||
'    p_username => :P11_USERNAME,'||chr(10)||
'    p_password  => l_p);'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 634149410841300524.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_process_sequence=> 11,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_last_agent varchar2(4000) := owa_util.get_cgi_env(''HTTP_USER_AGENT'');'||chr(10)||
'  l_last_ip    varchar2(4000) := owa_util.get_cgi_env(''REMOTE_ADDR'');'||chr(10)||
'  l_user       varchar2(255) := v(''USER'');'||chr(10)||
'  l_sgid       number;'||chr(10)||
'begin'||chr(10)||
'for c1 in (select PROVISIONING_COMPANY_ID '||chr(10)||
'           from WWV_FLOW_COMPANIES '||chr(10)||
'           where SHORT_NAME = upper(:P11_USERNAME)) loop'||chr(10)||
'   l_sgid := c1.PROVISIONING_COMPANY_ID;';

p:=p||''||chr(10)||
''||chr(10)||
'update wwv_flow_fnd_user '||chr(10)||
'   set last_login = sysdate, '||chr(10)||
'       BUILDER_LOGIN_COUNT = nvl(BUILDER_LOGIN_COUNT,0) + 1,'||chr(10)||
'       last_agent = l_last_agent,'||chr(10)||
'       last_ip    = l_last_ip'||chr(10)||
'where  USER_NAME = l_user and '||chr(10)||
'       SECURITY_GROUP_ID = l_sgid;'||chr(10)||
'end loop;'||chr(10)||
'exception when others then null;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 93529500469201904.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_process_sequence=> 15,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Log Login',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'11';

wwv_flow_api.create_page_process(
  p_id     => 1582214154454356.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if not wwv_flow_security.ip_check then'||chr(10)||
'      wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      owa_util.http_header_close;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 572225920169141548.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_process_sequence=> 30,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ip range check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  if wwv_flow_security.disable_workspace_login then'||chr(10)||
'      wwv_flow.g_unrecoverable_error := true;'||chr(10)||
'      owa_util.status_line(404, ''Page Not Found'');'||chr(10)||
'      owa_util.http_header_close;'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 637364027994407829.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4555,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'disabled login check',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 11.4555
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/lists/xe_login_tasks
 
begin
 
wwv_flow_api.create_list (
  p_id=> 9101817486130207.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'xe_login_tasks',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 85971030932131423 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 30788420658965222.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 9101817486130207.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>1,
  p_list_item_link_text=> 'Contrato de Licença',
  p_list_item_link_target=> 'javascript:popupURL(''#IMAGE_PREFIX#doc/ee_db_xe_agmt.htm'');',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 9102910691137732.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 9101817486130207.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>2,
  p_list_item_link_text=> 'Documentação',
  p_list_item_link_target=> 'javascript:popupURL(''http://www.oracle.com/technology/xe/documentation'');',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 9103217271139617.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 9101817486130207.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>3,
  p_list_item_link_text=> 'Registro no Fórum',
  p_list_item_link_target=> 'javascript:popupURL(''http://www.oracle.com/technology/xe/registration'');',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 9102602380135347.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 9101817486130207.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>4,
  p_list_item_link_text=> 'Fórum de Discussão',
  p_list_item_link_target=> 'javascript:popupURL(''http://www.oracle.com/technology/xe/forum'');',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 9102224412132295.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 9101817486130207.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>5,
  p_list_item_link_text=> 'Página do Produto',
  p_list_item_link_target=> 'javascript:popupURL(''http://www.oracle.com/technology/xe'');',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/reset_password
 
begin
 
wwv_flow_api.create_list (
  p_id=> 61885431289518270.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Reset Password',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 85971030932131423 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 61887004061519876.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 61885431289518270.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'Redefinir Senha',
  p_list_item_link_target=> 'f?p=&FLOW_ID.:7:&SESSION.::&DEBUG.:::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/find_my_workspace
 
begin
 
wwv_flow_api.create_list (
  p_id=> 74614416147717398.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'find_my_workspace',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 85971030932131423 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 74615226612717400.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 74614416147717398.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> 'Localizar Meu Espaço de Trabalho',
  p_list_item_link_target=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/home_page_links
 
begin
 
wwv_flow_api.create_list (
  p_id=> 115315832368341144.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'home_page_links',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 85971030932131423 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 155871030948668683.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 115315832368341144.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> 'Redefinir Senha',
  p_list_item_link_target=> 'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 11365419809816264.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 115315832368341144.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> 'Solicitar um Espaço de Trabalho',
  p_list_item_link_target=> '&F4550_SERVICE_REQUEST_URL.',
  p_list_item_disp_cond_type=> 'ITEM_IS_NOT_NULL',
  p_list_item_disp_condition=> 'F4550_SERVICE_REQUEST_URL',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_text_10=> 'javascript:popUp2(''&F4550_SERVICE_REQUEST_URL.'',''1000'',''600'');',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 22951230716918778.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 115315832368341144.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> 'Localizar Meu Espaço de Trabalho',
  p_list_item_link_target=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 107485020575108727.4555 + wwv_flow_api.g_id_offset,
  p_list_id=> 115315832368341144.4555 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>40,
  p_list_item_link_text=> 'Página do Produto',
  p_list_item_link_target=> 'javascript:popupURL(''http://www.oracle.com/technology/products/database/application_express/index.html'');',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4555
--
--application/shared_components/user_interface/templates/page/xe_login_pt_br
prompt  ......Page template 9095301378087765.4555
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'||chr(10)||
'';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><br /></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<div id="htmldbLogo2">#LOGO#</div>'||chr(10)||
'<div class="htmldbSep"><br/></div>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div class="htmldbBreadcrumbRegion"><br /></div>'||chr(10)||
'<a name="SkipRepNav"></a>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td ';

c3:=c3||'valign="top">#REGION_POSITION_01#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top">#REGION_POSITION_02##REGION_POSITION_04##BOX_BODY#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top" style="width:100%"><div style="float:right;">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 9095301378087765.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> ' XE Login.pt-br',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 3,
  p_theme_class_id => 6,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80966020820422852,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/login_page_standard_from_4999_pt_br
prompt  ......Page template 60929357198712420.4555
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'||chr(10)||
'';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><br /></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<div id="htmldbLogo2">#LOGO#</div>'||chr(10)||
'<div class="htmldbSep"><br/></div>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div class="htmldbBreadcrumbRegion"><br /></div>'||chr(10)||
'<a name="SkipRepNav"></a>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td ';

c3:=c3||'valign="top">#REGION_POSITION_01#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top">#REGION_POSITION_02##REGION_POSITION_04##BOX_BODY#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top" style="width:100%"><div style="float:right;">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 60929357198712420.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login Page Standard From 4999.pt-br',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 3,
  p_theme_class_id => 6,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80966020820422852,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/a_button_login_page_only
prompt  ......Button Template 20301506730451152.4555
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" title="#LABEL#" style="text-align:center;font-size:10px;display:block;margin:2px;">#LABEL#</a>';

wwv_flow_api.create_button_templates (
  p_id=>20301506730451152.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> '<a> button login page only',
  p_translate_this_template => 'N',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_template_comment       => '<table class="xpbutton" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tbody class="FFFFFF">'||chr(10)||
'<tr>'||chr(10)||
'<td class="L" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>'||chr(10)||
'<td class="C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="R" width="4"><img src="#IMAGE_PREFIX#1px_trans.gif" alt="" height="1" width="4"/></td>'||chr(10)||
'</tr>'||chr(10)||
'</tbody>'||chr(10)||
'</table>');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/4999_report_region_c_htmldbrr
prompt  ......region template 14581217810376673.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbRR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE##CREATE##CREATE2#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.create_plug_template (
  p_id       => 14581217810376673.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> '4999, Report Region (c:htmldbRR) ',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 17354512447599941,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||'class="htmldbInstruct"';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 14581217810376673.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/gray_box_c_htmldbgbr_no_top_link
prompt  ......region template 20998922571674600.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbGBR" cellspacing="0" cellpadding="0" border="0" summary="" id="#REGION_ID#" >'||chr(10)||
'<thead>'||chr(10)||
'<tr>'||chr(10)||
'<th class="T">#TITLE#</th>'||chr(10)||
'<th class="BT">#CLOSE#&nbsp;#EDIT##EXPAND##HELP##DELETE##COPY#</th>'||chr(10)||
'</tr>'||chr(10)||
'</thead>'||chr(10)||
'<tbody>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2" class="B">#CREATE#</td>'||chr(10)||
'</tr>'||chr(10)||
'</tbody>'||chr(10)||
'</table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 20998922571674600.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Gray Box (c:htmldbGBR) (No Top Link)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 20998922571674600.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/login_region
prompt  ......region template 21134717674904665.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="htmldbLoginTop" summary="" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<th class="L"><br /></th>'||chr(10)||
'<th class="C">#TITLE#</th>'||chr(10)||
'<th class="R"><br /></th>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" style="font-size:12px;padding:6px;">#BODY#<img src="#IMAGE_PREFIX#1px_trans.gif" height="2" width="260" alt=""/></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr class="htmldbLoginBottom">'||chr(10)||
'<th class="LF"><br /></th>'||chr(10)||
'<th c';

t:=t||'lass="CF">#CREATE#</th>'||chr(10)||
'<th class="RF"><br /></th>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 21134717674904665.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Login Region',
  p_plug_table_bgcolor     => '#F7F7E7',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#F7F7E7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 21134717674904665.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/login_region_4550_1
prompt  ......region template 21235720615514804.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbLoginR" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th><th class="T" width="100%"><br /></th></tr></thead><tbody><tr><td class="B" align="left">#BODY#<div style="float:right;">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE##CREATE##CREATE2#<img src="#IMAGE_PREFIX#htmldb/builder/1px_trans.gif" alt="" height="1" width="5" />#P';

t:=t||'REVIOUS##NEXT#</div></td><td><br /></td></tr></tbody></table>';

t2:=t2||'class="instructiontext"';

wwv_flow_api.create_plug_template (
  p_id       => 21235720615514804.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Login Region (4550:1)',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 21231024255484301,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||'class="instructiontext"';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 21235720615514804.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/untitled_fixed_width_c_htmldbuntitledfixed_600_from_4999
prompt  ......region template 61771527068337270.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="htmldbNBNT600" id="#REGION_STATIC_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 61771527068337270.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Untitled Fixed Width (c:htmldbUntitledFixed) (600)  From 4999',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 0,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 73709023269539317,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 61771527068337270.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/tasks_c_htmldbtasks_from_4999
prompt  ......region template 155944222672692886.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="htmldbTasks" summary="" id="#REGION_STATIC_ID#"><tbody><tr><th class="L"><br /></th><th class="C">#TITLE#</th><th class="R"><br /></th></tr><tr><td colspan="3" class="B">#BODY#</td></tr></tbody></table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 155944222672692886.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Tasks (c:htmldbTasks)  From 4999',
  p_plug_table_bgcolor     => '#F7F7E7',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#F7F7E7',
  p_plug_font_size => '-1',
  p_reference_id=> 30436620668141833,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 155944222672692886.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_box_fail
prompt  ......region template 164531513018211411.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody class="Fail"><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 164531513018211411.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box (Fail)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 160023608986860686,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 164531513018211411.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_box
prompt  ......region template 249669128792384373.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 249669128792384373.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 18253116293565611,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 249669128792384373.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_box_confirm
prompt  ......region template 249669609896384376.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody class="Confirm"><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 249669609896384376.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box (Confirm)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 186682507972859454,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 249669609896384376.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/report_region_600px_c_htmldbrr600_buttons_bottom
prompt  ......region template 249678929399401352.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbRR600" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="T">#TITLE#</th></tr></thead><tbody><tr><td class=B">#BODY#</td></tr><tr><td class="BT" valign="bottom">#CLOSE#&nbsp;&nbsp;#EDIT##DELETE##CREATE##CREATE2#<img src="#IMAGE_PREFIX#htmldb/builder/1px_trans.gif" alt="" height="1" width="5" />#PREVIOUS##NEXT#</td></tr></tbody></';

t:=t||'table>';

t2:=t2||'class="instructiontext"';

wwv_flow_api.create_plug_template (
  p_id       => 249678929399401352.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report Region 600px (c:htmldbRR600)(Buttons Bottom)',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 354965805166572999,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||'class="instructiontext"';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 249678929399401352.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/instructions_600px_c_htmldbinstruct600_from_4999
prompt  ......region template 308969701495595527.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="htmldbInstruct600" id="#REGION_STATIC_ID#">#BODY#</div>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 308969701495595527.4555 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Instructions 600px c:(htmldbInstruct600)  From 4999',
  p_plug_table_bgcolor     => '#FFFFFF',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_plug_heading_bgcolor => '#FFFFFF',
  p_plug_font_size => '-1',
  p_reference_id=> 354966506413573024,
  p_translate_this_template => 'N',
  p_template_comment       => 'No region formatting');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 308969701495595527.4555 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/unordered_list
prompt  ......list template 85971030932131423.4555
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>85971030932131423.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'unordered list',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="htmldbUl">',
  p_list_template_after_rows=>'</ul>',
  p_reference_id=>60219508156141083,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/quick_pick_c_htmldbquickpick_li_from_4999
prompt  ......report template 59856615437669702.4555
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 59856615437669702.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Quick Pick (c:htmldbQuickPick) (li) from 4999',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<ul class="htmldbUl">',
  p_row_template_after_rows =>'</ul>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'OMIT',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_theme_id  => 0,
  p_theme_class_id => 0,
  p_reference_id=> 17383712077884846,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 59856615437669702.4555 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/htmldb_greenarealabel
prompt  ......label template 9107221009165036.4555
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 9107221009165036.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'htmldb_GreenAreaLabel',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbGALabel" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 57728329098847875,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/formfield_required
prompt  ......label template 14882217773748275.4555
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 14882217773748275.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelRequired" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999"><img src="#IMAGE_PREFIX#requiredicon_status2.gif" alt="" />',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 17388508175892042,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/formfield_optional
prompt  ......label template 44225917854582269.4555
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 44225917854582269.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 17388415351892041,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 14576615815371062.4555
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 14576615815371062.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif',
  p_popup_icon_attr=>'width="18" height="18" alt="#LIST_OF_VALUES#" title="#LIST_OF_VALUES#"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Diálogo Pesquisar',
  p_page_html_head=>'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
'<head>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" type="text/css" />'||chr(10)||
'<script src="#IMAGE_PREFIX#javascript/apex_builder.js" type="text/javascript"></script>'||chr(10)||
'<style>a{font-size:12px;}</style>'||chr(10)||
'</head>',
  p_page_body_attr=>'onload="first_field()" class="htmldbPopup"',
  p_before_field_text=>'',
  p_page_heading_text=>'<div style="padding:2px;"><table><tr><td valign="top"><img src="#IMAGE_PREFIX#magnifying_glass_white_bg.gif" /></td><td>',
  p_page_footer_text =>'</td></tr></table></div>',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Pesquisa',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Fechar',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Próximo >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Anterior',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'500',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Linha(s) #FIRST_ROW# - #LAST_ROW#</div><center>',
  p_result_rows_per_pg=>200,
  p_before_result_set=>'<div style="padding-left:6px;">',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_reference_id       => 17343114994581872,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
prompt  ...application themes
--
prompt  ...build options used by application 4555
--
 
begin
 
--application/shared_components/logic/build_options/xe
wwv_flow_api.create_build_option (
  p_id=> 9152708051846605.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_build_option_name=> 'XE',
  p_build_option_status=> 'EXCLUDE',
  p_build_option_comment=> '');
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4555
--
--application/shared_components/globalization/dyntranslations
prompt  ...dynamic translations used by application: 4555
--
--application/shared_components/globalization/language
prompt  ...Language Maps for Application 4555
--
 
begin
 
null;
 
end;
/

prompt  ...Shortcuts
--
--application/shared_components/user_interface/shortcuts/thedate
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'return to_char(sysdate, ''MM.DD.YYYY'')';

wwv_flow_api.create_shortcut (
 p_id=> 174421670078.4555 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'THEDATE',
 p_shortcut_type=> 'FUNCTION_BODY',
 p_shortcut=> c1);
end;
null;
 
end;
/

--application/shared_components/user_interface/shortcuts/item_help
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION'')" tabindex="999"><img src="#IMAGE_PREFIX#infoicon_status_gray.gif" width="16" height="16" /></a>';

wwv_flow_api.create_shortcut (
 p_id=> 14805026971629745.4555 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'ITEM_HELP',
 p_shortcut_type=> 'HTML_TEXT',
 p_error_text=> 'Não é possível mostrar a ajuda.',
 p_reference_id=> 24184979678,
 p_shortcut=> c1);
end;
null;
 
end;
/

--application/shared_components/user_interface/shortcuts/welcometext
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'Obtenha acesso instantâneo a um conjunto on-line integrado para desenvolvimento de aplicações. O &PRODUCT_NAME. permite criar aplicações web dinâmicas e robustas, e aproveitar todo o potencial do banco de dados Oracle, tudo isso com seu browser favorito.';

wwv_flow_api.create_shortcut (
 p_id=> 47306820184100081.4555 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'WELCOMETEXT',
 p_shortcut_type=> 'HTML_TEXT',
 p_shortcut=> c1);
end;
null;
 
end;
/

prompt  ...web services (9iR2 or better)
--
prompt  ...shared queries
--
prompt  ...report layouts
--
prompt  ...authentication schemes
--
--application/shared_components/security/authentication/internal_4550
prompt  ......scheme 487415230967122.4555
 
begin
 
declare
  s1 varchar2(32767) := null;
  s2 varchar2(32767) := null;
  s3 varchar2(32767) := null;
  s4 varchar2(32767) := null;
  s5 varchar2(32767) := null;
begin
s1:=s1||'return wwv_flow_security.internal_page_sentry;';

s2 := null;
s3 := null;
s4:=s4||'-BUILTIN-';

s5:=s5||'owa_cookie.send('||chr(10)||
'  name=>''ORA_WWV_REMEMBER_UN'','||chr(10)||
'  value=>upper(:F4550_P1_USERNAME)||'':''||:F4550_P1_COMPANY,'||chr(10)||
'  expires=> sysdate+180,'||chr(10)||
'  path=> owa_util.get_cgi_env(''SCRIPT_NAME''));';

wwv_flow_api.create_auth_setup (
  p_id=> 487415230967122.4555 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> '$INTERNAL-4550$',
  p_description=>'Scheme for internal application 4550 using custom Login Page and account credentials verification',
  p_page_sentry_function=> s1,
  p_sess_verify_function=> s2,
  p_pre_auth_process=> s3,
  p_auth_function=> s4,
  p_post_auth_process=> s5,
  p_invalid_session_page=>'1',
  p_invalid_session_url=>'',
  p_cookie_name=>'ORA_WWV_USER',
  p_cookie_path=>'&CGI_SCRIPT_NAME.',
  p_cookie_domain=>'',
  p_use_secure_cookie_yn=>'',
  p_ldap_host=>'',
  p_ldap_port=>'',
  p_ldap_string=>'',
  p_attribute_01=>'',
  p_attribute_02=>'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_attribute_03=>'',
  p_attribute_04=>'',
  p_attribute_05=>'',
  p_attribute_06=>'',
  p_attribute_07=>'',
  p_attribute_08=>'',
  p_required_patch=>'');
end;
null;
 
end;
/

--application/end_environment
commit;
commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
