Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      unload_pt-br.sql
Rem
Rem    DESCRIPTION
Rem      Deinstall Brazilian Portuguese version of Application Express applications.  This script will be used to remove
Rem      the Brazilian Portuguese version of Application Express applications from an existing Application Express instance.
Rem
Rem    NOTES
Rem      To be run from SQL*Plus as the Application Express owner or current_schema set to Application Express owner.
Rem 
Rem    REQUIREMENTS
Rem      Requires connection to the target database as the Application Express owner (FLOWS_XXXXXX) or
Rem      connection as SYS and issuing 'ALTER SESSION SET CURRENT_SCHEMA = FLOWS_XXXXXX'.
Rem
Rem    ARGUMENTS
Rem      None
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem      jkallman   09/01/2004 - Created
Rem      jkallman   09/23/2005 - Added XE and 4200
Rem      jkallman   09/29/2005 - Remove 4200
Rem      jkallman   01/15/2007 - Added 4400


prompt .  ____   ____           ____        ____ 
prompt . /    \ |    \   /\    /     |     /    
prompt .|      ||    /  /  \  |      |    |    
prompt .|      ||---    ----  |      |    |---

prompt .|      ||   \  /    \ |      |    |  
prompt . \____/ |    \/      \ \____ |____ \____
prompt .
prompt . Application Express Hosted Development Service Brazilian Portuguese Language Deinstall
prompt ............................................................................


set define '^'
set concat on
set concat .
set verify off
set termout on

declare
    l_applications dbms_sql.number_table;
    l_offset       number := 5;
begin
    l_applications(l_applications.count+1)  := 4000;
    l_applications(l_applications.count+1)  := 4050;
    l_applications(l_applications.count+1)  := 4155;
    l_applications(l_applications.count+1)  := 4300;
    l_applications(l_applications.count+1)  := 4350;
    l_applications(l_applications.count+1)  := 4400;
    l_applications(l_applications.count+1)  := 4411;
    l_applications(l_applications.count+1)  := 4500;
    l_applications(l_applications.count+1)  := 4550;
    l_applications(l_applications.count+1)  := 4700;
    --
    wwv_flow_security.g_security_group_id := 10;
    for i in 1..l_applications.count loop
        wwv_flow_api.remove_flow( l_applications(i) + l_offset );
        commit;
    end loop;
    --
end;
/

