#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/webapps/em/WEB-INF/perl/config/config_common.pl /st_emdbsa_11.2/4 2009/06/15 17:29:05 hasriniv Exp $
#
# config_common.pl
# 
# Copyright (c) 2008, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      config_common.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hasriniv    01/29/09 - Code Sync
#    hasriniv    08/12/08 - 
#    rimmidi     05/06/08 - Code slap from 11gc to 10.2.0.5
#    rimmidi     05/06/08 - Creation
# 
require "emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";
use strict;
use File::Basename;
use File::Copy;
use File::Temp qw/ tempfile tempdir /;
use File::stat;
use vars qw/$hostUserID $OS $NT $S $TEMP $CP $MV $PS $DF $DELIMITER $Registry/;

#### GLOBAL Platform-specific flags for all EM OSs ####
if($^O =~ /solaris/i){
  $OS = "SOL2";
	$NT = 0;
  $S = '/';
  $TEMP = "/tmp";
	$CP = "/bin/cp";
	$MV = "/bin/mv";
	$PS = "/bin/ps";
  $DF = "/bin/df -k"
}
elsif($^O =~ /MSWin32/i){
  $OS = "NT";
	$NT = 1;
  eval 'use Win32::TieRegistry';
  $S = '\\';
	if(exists($ENV{TMP})){
		$TEMP = $ENV{TMP};
	}
	elsif(exists($ENV{TEMP})){
		$TEMP = $ENV{TEMP};
	}
	else{
		$TEMP = $ENV{SYSTEMDRIVE} . "\\temp"; # Bug# 5642432
	}
	## The %SystemDrive% variable seems to come back in TEMP;
	##  substitute in the value
	$TEMP =~ s/%SystemDrive%/$ENV{SYSTEMDRIVE}/i;
	$CP = "copy";
	$MV = "rename";
	$PS = "ps";
}
elsif($^O =~ /aix/i){
  $NT = 0;
  $S = '/';
  $TEMP = "/tmp";
	$CP = "/bin/cp";
	$MV = "/bin/mv";
	$PS = "/bin/ps";
  $DF = "/bin/df -Pk"
}
elsif($^O =~ /linux/i){
  $OS = "LINUX";
  $NT = 0;
  $S = '/';
  $TEMP = "/tmp";
	$CP = "/bin/cp";
	$MV = "/bin/mv";
	$PS = "/bin/ps";
  $DF = "/bin/df -k"
}
elsif($^O =~ /hpux/i){
  $NT = 0;
  $S = '/';
  $TEMP = "/tmp";
	$CP = "/bin/cp";
	$MV = "/bin/mv";
	$PS = "/bin/ps";
  $DF = "/usr/bin/df -Pk"
}
## Operating system unknown (probably Unix)
else{
  $OS = "";
	$NT = 0;
  $S = '/';
  $TEMP = "/tmp";
	$CP = "/bin/cp";
	$MV = "/bin/mv";
	$PS = "/bin/ps";
  $DF = "/bin/df -k"
}

sub isWinOS
{
  my $isWin = "NOK";
  if($^O =~ /MSWin/i)
   {
     $isWin = "OK";
   }
   return $isWin;
}


## The delimiter is used to separate paramters passed in perl routines from Java
## code.  In most cases, it is used to separate file names.
$DELIMITER = ":::";

# --------- OS platform-specific (for "getFreePort" only) -------------

# Run command $netstat, the listening ports information shows at each row
# of $column.
# paramForGetFreePort()
sub paramForGetFreePort
{
  my $netstat = ""; 
  my $key = "";
  my $column = "";
  my $separator = "";
  
  
  if($^O =~ /solaris/i)
  {
    EMD_PERL_DEBUG("config_common.paramForGetFreePort(): OS platform: Solaris");
    $netstat = '/bin/netstat -an ';
    $key = "LISTEN";
    $column = 0;
    $separator = ".";
  }
  elsif($^O =~ /MSWin32/i)
  {
    EMD_PERL_DEBUG("config_common.paramForGetFreePort(): OS platform: MSWin32");
    $netstat = 'netstat -an ';
    $key = "LISTENING";
    $column = 1;
    $separator = ":";
  }
  elsif($^O =~ /linux/i)
  {
    EMD_PERL_DEBUG("config_common.paramForGetFreePort(): OS platform: Linux");
    $netstat = '/bin/netstat -an ';
    $key = "LISTEN";
    $column = 3;
    $separator = ":";
  }
  #Add other platforms here
  else #may be Unix
  {
    EMD_PERL_DEBUG("config_common.paramForGetFreePort(): OS platform: Unknown");
    $netstat = '/bin/netstat -an ';
    $key = "LISTEN";
    $column = 0;
    $separator = ".";
  }

  return ($netstat, $key, $column, $separator);
}
# --------- OS platform-specific (END) -----------------------------------
# This method is platform specific, will be dealt with later.
# Get free port for a host
# getFreePort()
sub getFreePort
{
  (my $netstat, my $key, my $column, my $separator) = &paramForGetFreePort();
  EMD_PERL_DEBUG("config_common.getFreePort(): netstat: $netstat, column: $column, key: $key");

  my $freePort = 1521; #the starting port to be checked
  my $usedPortCol = "";
  my $usedPort = "";
  my $row;
  my @tokens;
  my $separatorIndex = 0;
  my $found = 1;
  
  my @temp = `$netstat`;

  if(@temp > 1)
  {
    EMD_PERL_DEBUG("config_common.getFreePort(): examining listening port");
    while($found == 1)
    {
      $found = 0;
      foreach $row (@temp)
      {
        chop($row);
        if ($row =~ /$key/)  #only ckeck rows containing key
        {
          $_ = $row;
          @tokens = split; 
          $usedPortCol = $tokens[$column];
          $separatorIndex = rindex($usedPortCol, $separator);
          $usedPort = substr($usedPortCol, $separatorIndex + 1);
          if($freePort eq $usedPort)
          {
            EMD_PERL_DEBUG("config_common.getFreePort(): Port is being used: $freePort");
            $freePort = $freePort + 1;
            $found = 1;
            last;
          }
        }
      }
    }
	}
  
  EMD_PERL_DEBUG("config_common.getFreePort(): Free port: $freePort");
  
  return $freePort;
}

# Set environment variables
# To set TNS_ADMIN to non-default value, pass listener.ora full file name
# as the third argument.
# Call sub set_env_var() in emd_common.pl
# set_env(oracleHome, oracleSid)
sub set_env
{
  EMD_PERL_DEBUG("config_common.set_env(): *** START ***");

  my($oracleHome, $oracleSid, $listenerFile) = @_;
  if(!$listenerFile)
  {
    &set_env_var($oracleHome, $oracleSid);
  }
  else
  {
    my($idx) = rindex($listenerFile,"$S");
    if($idx == -1){
      EMD_PERL_DEBUG("config_common.set_env(): Cannot determine TNS_ADMIN");
      exit(1);
    }
    my($tns) = substr($listenerFile,0,$idx);
    &set_env_var($oracleHome, $oracleSid, undef(), $tns);
  }
  
  EMD_PERL_DEBUG("config_common.set_env(): *** END ***");
}
# Get the dirname from a given full file name
# getDirname(fullFileName)
sub getDirname
{
  my ($fullFileName) = @_;
  EMD_PERL_DEBUG("config_common.getDirname(): getting dir name from $fullFileName");

  my $dirname = dirname $fullFileName
    or EMD_PERL_ERROR("db_common.getDirname(): could not get dir name from $fullFileName");
    
  EMD_PERL_DEBUG("config_common.getDirname(): Dir name of $fullFileName is $dirname");
  
  return $dirname;
}
# Create a zero size file.
# createZeroSizeFile(dirName)
sub createZeroSizeFile
{
  my ($dirName) = @_;

  #create dir if not exist
  &mkDir($dirName);
  
  my $fh;
  my $fileName;
  
  if(!$NT)
  {
    EMD_PERL_DEBUG("config_common.createZeroSizeFile: To create a zero size file");
    ($fh, $fileName) = tempfile(DIR => $dirName);
  }
  else
  {
    EMD_PERL_DEBUG("config_common.createZeroSizeFile: To create a zero size file on NT");
    $fileName = "$dirName\\"."config.$$";
    #Open and close this file
    open (ZERO_FILE, ">$fileName") 
      || die "Unable to open a file for ZERO_FILE\n";
    print ZERO_FILE "";
    close ZERO_FILE || die "Bad ZERO_FILE";
  }
  
  EMD_PERL_DEBUG("config_common.createZeroSizeFile: File name: $fileName");

  if(!$NT)
  {
    close $fh;
  }

  return $fileName;
}
# Create a specified directory.
# Return OK if succeed, otherwise, return NOK.
# OK is returned if the specified directory already exists.
# mkDir(dirName)
sub mkDir
{
  my ($dirName) = @_;
  EMD_PERL_DEBUG("config_common.mkDir(): Create directory $dirName");
  my $dirExist = &dirExists($dirName);
  if($dirExist eq "OK")
  {
    EMD_PERL_DEBUG("config_common.mkDir(): Directory $dirName already exists");
    return "OK";
  }

  my (@create);
  push(@create, $dirName);

  #create parent directories if necessary
  my($parent) = dirname($dirName);
  while(! -e "$parent")
  {
    EMD_PERL_DEBUG("config_common.mkDir(): Need to create $parent");
    push(@create, $parent);
    $parent = dirname($parent);
  }

  while($dirName = pop(@create))
  {
    EMD_PERL_DEBUG("config_common.mkDir(): Creating $dirName");
    if(!mkdir($dirName, 0750)){
      EMD_PERL_ERROR("db_common.mkDir(): mkdir $dirName failed");
      ## Actually want this error to come out in the job output
      print "mkdir ${dirName}: $!\n";
      return "NOK";
    }
    EMD_PERL_DEBUG("config_common.mkDir(): chmod 0750 $dirName");
    chmod (0750, $dirName);
  }
  
  return "OK";
}
# Check if a specified directory exists
# Return OK if the directory exists, otherwise, return NOK.
# dirExists(dirName)
sub dirExists
{
  my ($dirName) = @_;
  if(! -e "$dirName")
  {
    EMD_PERL_DEBUG("config_common.dirExists(): Directory $dirName does not exist");
    return "NOK";
  }
  elsif(! -d "$dirName")
  {
    EMD_PERL_DEBUG("config_common.dirExists(): $dirName is not a directory");
    return "NOK";
  }
  
  EMD_PERL_DEBUG("config_common.dirExists(): Directory $dirName exists");
  
  return "OK";
}
# Copy a file from source to destination location
# copyFile(sourceFile, destFile)
sub copyFile
{
  my ($sourceFile, $destFile) = @_;
  EMD_PERL_DEBUG("config_common.copyFile(): copying $sourceFile to $destFile");

  copy($sourceFile, $destFile)
    or ((EMD_PERL_ERROR("db_common.copyFile(): $sourceFile could not be copied as $destFile")) && (die "Can't copy '$sourceFile' to '$destFile': $!") || (die "Can't copy '$sourceFile' to '$destFile': $!"));
    
  EMD_PERL_DEBUG("config_common.copyFile(): File $sourceFile has been copied as $destFile");
}
# Remove a file for a given file name
# removeFile(fileName)
sub removeFile
{
  my ($fileName) = @_;

  EMD_PERL_DEBUG("config_common.removeFile(): To remove file $fileName");
  
  unlink $fileName
    or warn "Could not remove '$fileName': $!";
}
# Set environment variables
# set_env_var(oracleHome, oracleSid)
sub set_env_var
{
    my $PATH_SP= ":";
    if($NT)
    {
	$PATH_SP=";";
    }
    ($ENV{ORACLE_HOME},$ENV{ORACLE_SID}, my $isDB10iOrHigher, my $tns) = @_;
   

	if(defined($ENV{LD_LIBRARY_PATH})){
    $ENV{LD_LIBRARY_PATH} = "$ENV{ORACLE_HOME}${S}lib${PATH_SP}$ENV{LD_LIBRARY_PATH}";
	}
	else{
    $ENV{LD_LIBRARY_PATH} = "$ENV{ORACLE_HOME}${S}lib";
	}

	if(defined($ENV{SHLIB_PATH})){
    $ENV{SHLIB_PATH} = "$ENV{ORACLE_HOME}${S}lib${PATH_SP}$ENV{SHLIB_PATH}";
	}
	else{
    $ENV{SHLIB_PATH} = "$ENV{ORACLE_HOME}${S}lib";
	}

	if(defined($ENV{LIBPATH})){
    $ENV{LIBPATH} = "$ENV{ORACLE_HOME}${S}lib${PATH_SP}$ENV{LIBPATH}";
	}
	else{
    $ENV{LIBPATH} = "$ENV{ORACLE_HOME}${S}lib";
	}

	if(defined($ENV{PATH})){
    $ENV{PATH} = "$ENV{ORACLE_HOME}${S}bin${PATH_SP}$ENV{PATH}";
	}
	else{
    $ENV{PATH} = "$ENV{ORACLE_HOME}${S}bin";
	}

  if (!defined($isDB10iOrHigher))
  {
    $isDB10iOrHigher = "FALSE";
  }
  if($isDB10iOrHigher =~ /TRUE/i)
  {
    $ENV{ORA_NLS} = "$ENV{ORACLE_HOME}${S}nlsrtl${S}admin${S}nlsdata";
    $ENV{ORA_NLS32} = "$ENV{ORACLE_HOME}${S}nlsrtl${S}admin${S}nlsdata";
    $ENV{ORA_NLS33} = "$ENV{ORACLE_HOME}${S}nlsrtl${S}admin${S}nlsdata";
  }
  else
  {
    $ENV{ORA_NLS} = "";
    $ENV{ORA_NLS32} = "";
    $ENV{ORA_NLS33} = "";
  }

  #not sure what should be the right behavior
  #provide ways to set TNS_ADMIN
  if(!$tns)
  {
    if(defined($ENV{TNS_ADMIN})){
      #$ENV{TNS_ADMIN} = "$ENV{ORACLE_HOME}${S}network${S}admin${PATH_SP}$ENV{TNS_ADMIN}";
    }
    else{
      $ENV{TNS_ADMIN} = "$ENV{ORACLE_HOME}${S}network${S}admin";
    }
    if($NT)
    {
      $ENV{TNS_ADMIN} = getTNS_ADMINOnNT();
    }
  }
  else
  {
    $ENV{TNS_ADMIN} = "$tns";
  }
  
  EMD_PERL_DEBUG("config_common.set_env_var(): ORACLE_HOME: $ENV{ORACLE_HOME}");
  EMD_PERL_DEBUG("config_common.set_env_var(): ORACLE_SID: $ENV{ORACLE_SID}");
  EMD_PERL_DEBUG("config_common.set_env_var(): LD_LIBRARY_PATH: $ENV{LD_LIBRARY_PATH}");
  EMD_PERL_DEBUG("config_common.set_env_var(): SHLIB_PATH: $ENV{SHLIB_PATH}");
  EMD_PERL_DEBUG("config_common.set_env_var(): LIBPATH: $ENV{LIBPATH}");
  EMD_PERL_DEBUG("config_common.set_env_var(): PATH: $ENV{PATH}");
  EMD_PERL_DEBUG("config_common.set_env_var(): ORA_NLS: $ENV{ORA_NLS}");
  EMD_PERL_DEBUG("config_common.set_env_var(): ORA_NLS32: $ENV{ORA_NLS32}");
  EMD_PERL_DEBUG("config_common.set_env_var(): ORA_NLS33: $ENV{ORA_NLS33}");
  EMD_PERL_DEBUG("config_common.set_env_var(): TNS_ADMIN: $ENV{TNS_ADMIN}");
}
# Get the basename from a given full file name
# getBasename(fullFileName)
sub getBasename
{
  my ($fullFileName) = @_;
  EMD_PERL_DEBUG("config_common.getBasename(): getting basename from $fullFileName");

  my $basename = basename $fullFileName
    or EMD_PERL_ERROR("db_common.getBasename(): could not get basename from $fullFileName");
    
  EMD_PERL_DEBUG("config_common.getBasename(): Basename of $fullFileName is $basename");
  
  return $basename;
}
# Create a temporary file
# create_temp_file()
# return fileHandle and fileName
sub create_temp_file
{
  my ($suffix) = @_;
  my $dir = tempdir(CLEANUP => 1);
  my $temp_fh;
  my $temp_filename;
  
  if(defined($suffix))
  {
     ($temp_fh, $temp_filename) = tempfile(DIR => $dir, SUFFIX => $suffix );
  }
  else
  {
    ($temp_fh, $temp_filename) = tempfile(DIR => $dir);
  }
  
  EMD_PERL_DEBUG("config_common.create_temp_file(): Temp file name: $temp_filename");

  #For NT only
  &tempLocFallback();

  if(!$NT)
  {
    #cd to OH to deal with a perl behavior change
    #When removing the temp file/dir, the perl executor needs r+x permission
    #in the current directory.
    #When executing remote ops, the current dir is agent sysman/emd dir,
    #which does not give r+x permission to g+o users.
    #Change to OH, which gives r+x to g+o.
    #If callers change to other dir after calling this sub, we assume they
    #have r+x permission in the dir, otherwise, they could not chdir to there.
    chdir $ENV{ORACLE_HOME}
      or (chdir $TEMP);
  }
  
  return ( $temp_fh, $temp_filename);
}
#This is NT specific. Sometimes, $TEMP does not work, this 
#method provides some fallback.
sub tempLocFallback
{
  if(!$NT)
  {
    return;
  }

  my $fallback = "N";
  my $filename = "$TEMP\\"."test_temp_location.$$";
  EMD_PERL_DEBUG("config_common.tempLocFallback(): Test filename: $filename");

  my(@res) = `echo "This is a test!" >$filename 2>&1`;
    
  #Test opening the temp file
  open (OUT_PUT, "$filename") || ($fallback = "Y");

  if($fallback eq "N")
  {
    close OUT_PUT;
    &removeFile($filename);
    EMD_PERL_DEBUG("config_common.tempLocFallback(): Tested TEMP location: $TEMP");
    return;
  }

  ${TEMP} = $ENV{SYSTEMDRIVE} . "\\TEMP"; #Bug# 5642432
  &mkDir(${TEMP}); #Bug# 5642432

  EMD_PERL_DEBUG("config_common.tempLocFallback(): TEMP location fallback to: $TEMP");
}
# Get output from file
# getOutputFromFile(filename)
sub getOutputFromFile
{
  EMD_PERL_DEBUG("config_common.getOutputFromFile(): *** START ***");

  my ($filename) = @_;
  
  #Open the file to get output
  open (OUT_PUT, "$filename") || die "Unable to open file $filename for OUT_PUT\n";
  my @output_content = <OUT_PUT>;
  my $mesg = "@output_content";
  close OUT_PUT;

  EMD_PERL_DEBUG("config_common.getOutputFromFile(): *** END ***");
  
  return $mesg;
}
# Run given srvctl command
# The caller is responsible to close the returned fileHandle
# runSrvctlCommand(command, hideOutput) will print standard output
# if hideOutput is not "Y"
sub runSrvctlCommand
{
  EMD_PERL_DEBUG("config_common.runSrvctlCommand(): *** START ***");

  my ($command, $hideOutput) = @_;
  my $srvctlFullCommand = "$ENV{ORACLE_HOME}/bin/srvctl $command";
  EMD_PERL_DEBUG("config_common.runSrvctlCommand: srvctl command :\n$command");

  (my $fh, my $filename) = &create_temp_file();

  if($NT)
  {
    $filename = "$TEMP\\"."config_common.$$";
    EMD_PERL_DEBUG("config_common.runSrvctlCommand(): temp file: $filename");
    open(SRVCTL_CMD, "|$srvctlFullCommand >$filename")
      || die "Cannot open pipe for SRVCTL_CMD";
    print SRVCTL_CMD $command;
    close SRVCTL_CMD || print "Could not close pipe for SRVCTL_CMD";
  }
  else
  {
    open(SRVCTL_CMD, "|$srvctlFullCommand >$filename")
      || die "Cannot open pipe for SRVCTL_CMD";
    print SRVCTL_CMD $command;
    close SRVCTL_CMD || print "Could not close pipe for SRVCTL_CMD";
  }

  #Open the temp file to print output to standard output and debug trace file
  open (OUT_PUT, "$filename") || die "Unable to open tempfile for OUT_PUT\n";
  my @output_content = <OUT_PUT>;
  my $output_string = "@output_content";
  close OUT_PUT;

  if( $hideOutput ne "Y" )
  {
    print STDOUT $output_string;
  }

  EMD_PERL_DEBUG("config_common.runSrvctlCommand(): OUT_PUT:\n$output_string");

  
  EMD_PERL_DEBUG("config_common.runSrvctlCommand(): *** END ***");

  return ($fh, $filename);
}
# Run given cluvfy command
# The caller is responsible to close the returned fileHandle
# runCluvfyCommand(command, hideOutput) will print standard output
# if hideOutput is not "Y"
sub runCluvfyCommand
{
  EMD_PERL_DEBUG("config_common.runCluvfyCommand(): *** START ***");

  my ($command, $hideOutput) = @_;
  my $cluvfyFullCommand = "$ENV{ORACLE_HOME}/bin/cluvfy $command";

  EMD_PERL_DEBUG("config_common.runCluvfyCommand: cluvfy command :\n$command");

  (my $fh, my $filename) = &create_temp_file();

  if($NT)
  {
    $filename = "$TEMP\\"."config_common.$$";
    EMD_PERL_DEBUG("config_common.runCluvfyCommand(): temp file: $filename");
    open(CLUVFY_CMD, "|$cluvfyFullCommand >$filename")
      || die "Cannot open pipe for CLUVFY_CMD";
    print CLUVFY_CMD $command;
    close CLUVFY_CMD || print "Could not close pipe for CLUVFY_CMD";
  }
  else
  {
    open(CLUVFY_CMD, "|$cluvfyFullCommand >$filename")
      || die "Cannot open pipe for CLUVFY_CMD";
    print CLUVFY_CMD $command;
    close CLUVFY_CMD || print "Could not close pipe for CLUVFY_CMD";
  }

  #Open the temp file to print output to standard output and debug trace file
  open (OUT_PUT, "$filename") || die "Unable to open tempfile for OUT_PUT\n";
  my @output_content = <OUT_PUT>;
  my $output_string = "@output_content";
  close OUT_PUT;

  if( $_[1] ne "Y" )
  {
    print STDOUT $output_string;
  }

  EMD_PERL_DEBUG("config_common.runCluvfyCommand(): OUT_PUT:\n$output_string");

  
  EMD_PERL_DEBUG("config_common.runCluvfyCommand(): *** END ***");

  return ($fh, $filename);
}
# Get Oracle Base
# Gets oracle base setting in the agent environment, else calls orabase utility
# if oracle base is still not found, defaults to the oracle home
sub getOracleBase
{
  EMD_PERL_DEBUG("config_common.getOracleBase():  *** START ***");
  
  my $oracleBase = "";
  my ( $oracleHome ) = @_;
  EMD_PERL_DEBUG("config_common.getOracleBase(): Given ORACLE_HOME: $oracleHome");

  # Check if oracle base is available in the env
  $oracleBase = getORACLE_BASE();
  my $dirExist = dirExists($oracleBase);
  if( $dirExist eq "OK")
  {
    EMD_PERL_DEBUG("config_common.getOracleBase(): Oracle base from the environment is : $oracleBase");
    return $oracleBase;
  }
  $oracleBase = getOracleBaseUsingOrabase($oracleHome);
  $dirExist = dirExists($oracleBase);
  if( $dirExist eq "OK")
  {
    EMD_PERL_DEBUG("config_common.getOracleBase(): Oracle base from orabase utility : $oracleBase");
    return $oracleBase;
  }
  # Check if ORACLE_HOME dir exist and return if exists
  $dirExist = dirExists($oracleHome);
  if( $dirExist ne "OK")
  {
    EMD_PERL_DEBUG("config_common.getOracleBase(): Invalid ORACLE_HOME dir: $oracleHome");
    return $oracleBase;
  }
  EMD_PERL_DEBUG("config_common.getOracleBase(): Defaulting oracle base to be same as oracle home  : $oracleHome");
  return $oracleHome;
}
# Get Oracle Base using ORACLE_HOME/bin/orabase utility
# if ORACLE_HOME version is >= 11.1.0.6
# Returns either ORACLE_BASE else empty string "".
sub getOracleBaseUsingOrabase
{
  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): *** START ***");
  
  my $oracleBase = "";
  my ( $oracleHome ) = @_;
  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): Given ORACLE_HOME: $oracleHome");
  
  # Check if ORACLE_HOME dir exist?
  my $dirExist = dirExists($oracleHome);
  if( $dirExist ne "OK")
  {
    EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): Invalid ORACLE_HOME dir: $oracleHome");
    return $oracleBase;
  }
  
  # Set ORACLE_HOME env. variable
  set_env_var($oracleHome, "");
  
  # Get locale set in the env.
  my $nls_lang = $ENV{NLS_LANG};
  
  # Set locale to 'American_America.al32utf8'
  $ENV{NLS_LANG} = 'American_America.al32utf8';
  
  # Run SQLPLUS command for knowing the version
  my $sqlVersionCmd = $oracleHome . $S . "bin" . $S . "sqlplus -v";
  my @versionString = `$sqlVersionCmd 2>&1`;
  my $versionString = "@versionString";
  chomp ( $versionString );
  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): SQLPLUS output: $versionString");

  # Check for the string "SQL*Plus:" in the output?
  my $sqlplusPos = index($versionString, "SQL*Plus:");
  if( $sqlplusPos < 0)
  {
    EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): Bad SQLPLUS in Oracle Home: $oracleHome");
    return $oracleBase;
  }
  
  # Set back the locale if defined earlier
  if(defined($nls_lang))
  {
    $ENV{NLS_LANG} =$nls_lang;
  }

  # Extract the version from the putput
  # The length of Recovery Manager: plus a space is 18
  my $sqlVersion = trim(substr($versionString, $sqlplusPos + 18, 11));
  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): SQLPLUS Version: $sqlVersion");

  # Check if version is greater than 11.1.0.6 as
  # orabase is supported only in 11.1.0.6 and higher versions
  if(&compareVer($sqlVersion, "11.1.0.6") <= 0)
  {
    EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): $sqlVersion is not supported.");
    return $oracleBase;
  }
  
  # Construct the orabase command
  my $orabaseCmd = $oracleHome . $S . "bin" . $S . "orabase";
  
  # Run orabase command
  my @oracleBase = `$orabaseCmd 2>&1`;
  $oracleBase = "@oracleBase";
  chomp ( $oracleBase );
  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): orabase output: $oracleBase");
  
  # Check if ORACLE_BASE dir exist?
  $dirExist = dirExists($oracleBase);
  if( $dirExist ne "OK")
  {
    EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): Invalid ORACLE_BASE dir: $oracleBase");
    $oracleBase = "";
  }

  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): returning ORACLE_BASE: $oracleBase");
  EMD_PERL_DEBUG("config_common.getOracleBaseUsingOrabase(): *** END ***");
  return $oracleBase;
}
sub compareVersion
{
  EMD_PERL_DEBUG("config_common.compareVersion(): *** START ***");
  my ($version1, $version2) = @_;

  EMD_PERL_DEBUG("config_common.compareVersion(): version1: $version1");
  EMD_PERL_DEBUG("config_common.compareVersion(): version2: $version2");

  my $compareValue = 0;
  my $separator = '\.';
  my @version1s = split /$separator/, $version1;
  my @version2s = split /$separator/, $version2;
  my ($v1, $v2);
  my $index = 0;

  while(($#version1s >= $index) && ($#version2s >= $index))
  {
    $v1 = $version1s[$index];
    $v2 = $version2s[$index];

    if($v1 < $v2)
    {
      $compareValue = -1;
      last;
    }
    elsif ($v1 > $v2)
    {
      $compareValue = 1;
      last;
    }

    $index ++;
  }

  EMD_PERL_DEBUG("config_common.compareVersion(): compareValue: $compareValue");
  EMD_PERL_DEBUG("config_common.compareVersion(): *** END ***");
  return $compareValue;
}
1;
