#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/webapps/em/WEB-INF/perl/db/rac/config_host_util.pl /st_emdbsa_11.2/2 2009/03/30 20:50:25 shasingh Exp $
#
# config_host_util.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      config_host_util.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    shasingh    03/24/09 - bug: 8362748
#    shasingh    03/09/09 - script to cofig host
#    shasingh    03/09/09 - Creation
# 

use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";

my $LOG_CATEGORY = "config_host_util_o.pl: ";
unset_lib_path_env();

 sub config_dbconsole_on_node
 {
    my ($oh,$db_unq_name,$db_sevice_name, $node_name) = @_;
    
    my($err_msg,$output) = config_node($oh,$db_unq_name,$db_sevice_name, $node_name);
    
    if($err_msg ne "")
    {
        print $err_msg;
        return (-1);
    }
    else
    {
        print $output;
        return (0);
    }
    
 }
 
 sub check_dbconsole_setup_on_node
 {
    my ($oh,$db_unq_name, $node_name) = @_;
    # add code for pre check of node config 
    return (0);
    
 }


sub config_node
{

 my ($oh,$db_unq_name, $db_sevice_name, $node_name) = @_;
 my $cmd = "$oh/bin/emca -addNode db -silent -DB_UNIQUE_NAME $db_unq_name -MODIFY_NODE $node_name -SERVICE_NAME $db_sevice_name";

 my ( $err, $output ) = executeCommand( $cmd, $oh);
 EMD_PERL_DEBUG("$LOG_CATEGORY config_node -> $cmd returned (err=$err, output=$output)");
 
 my $err_msg = get_err_msg($err,$output); 
 return $err_msg if $err_msg ne "";
 
 ($err_msg,$output);
}


# execute the supplied command
sub executeCommand
{
 my ( $cmd, $oh ) = @_;
 $ENV{ORACLE_HOME} = $oh;
 my $err    = "";
 my $output = "";
 if ( open( CMDOUTPUT, "$cmd 2>&1 |" )) 
 {
  my @outputs = <CMDOUTPUT>;
  $output = join "", @outputs;
  if ( !close(CMDOUTPUT) ) 
  {
   # close error
   if ( $output ne "" ) 
   {
    $err    = "\"${cmd}\" returned: \"" . $output . "\"";
    $output = "";
   }
   else
   {
    $err = "bad \"$cmd\": $! $?";
   }
  }
 }
 else
 {
  # open error
  $err = "cannot execute \"$cmd\": $!";
 }

 EMD_PERL_ERROR("executeCommand: $cmd: $err") if ( $err ne "" );
 ( $err, $output );
}

sub get_err_msg
{
   my($err,$output)=@_;
    
   my $err_msg="";
 
   if($err ne "")
   {
     $err_msg = $err;
   }
   elsif ($output =~ /PRKP-/ || $output =~ /PRKH-/ || $output =~ /PRKO-/ || $output =~ /CRS-/ || $output =~ /ORA-/)
   {
     $err_msg = $output;
   }
   
  ($err_msg);
} 


# unset the *LD_* env variable for proper function of srvctl
sub unset_lib_path_env 
{
 delete $ENV{LD_LIBRARY_PATH};
 delete $ENV{SHLIB_PATH};
 delete $ENV{LIBPATH};
 delete $ENV{DYLD_LIBRARY_PATH};
}
