#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/webapps/em/WEB-INF/perl/db/rac/rac_services_o.pl /st_emdbsa_11.2/12 2009/06/05 19:00:08 pardutta Exp $
#
# rac_services_o.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      rac_services_o.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pardutta    06/03/09 - Service roles.
#    rsamaved    02/26/09 - fix relocate service for policy managed database
#    shasingh    02/04/09 - taf policy for policy managed
#    rsamaved    10/02/08 - fix service stop problem on individual instances
#    shasingh    08/25/08 - modified 'srvgrp' to 'srvpool' for srvctl command
#    rsamaved    08/11/08 - service modify changes for service centric db
#    shasingh    08/05/08 - 
#    rsamaved    07/29/08 - remove TAF option for service centric services
#    rsamaved    05/13/08 - use -n for service centric database
#    pboopath    05/07/08 - srvctl modify change
#    pboopath    05/06/08 - server group srvctl modify change
#    pboopath    03/27/08 - use use node name to stop services in service
#                           centric d
#    pboopath    12/02/07 - parsing changes by ravi
#    pboopath    08/27/07 - services singleton/uniform changes
#    vkapur      06/28/05 - bug 4456046 
#    vkapur      03/14/05 - er 4175890: use srvctl status service -S 1 
#    vkapur      10/22/04 - vkapur_rac_services_ui_review
#    vkapur      10/21/04 - Creation
# 

use Cwd;
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";


#########################  Services #############################

# note: Rac Services functionality is only for 10g+ databases


# Usage: get_service_status(dbName, [sv1...svK])
# Calls: srvctl status service -f -S 1 -d dbName -s sv1,sv2...svK
#

sub get_service_status
{
    my ($dbName, $sv_names) = @_;

    EMD_PERL_DEBUG("rac_services_o:get_service_status dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:get_service_status sv_names=$sv_names");

    $cmd = constructSRVCTLCmd ($dbName, $sv_names, "", "status", "-S 1");
    
    return &executeSRVCTL($cmd);

}

# Usage: get_servgrp_config()
# Calls: srvctl config srvgrp -S 1
#

sub get_servgroup_config
{
    #my ($dbName, $sv_names) = @_;

    EMD_PERL_DEBUG("rac_services_o:get_servgroup_config dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:get_servgroup_config sv_names=$sv_names");
    my $srvctl_cmd = "$ENV{ORACLE_HOME}/bin/srvctl config srvpool -S 1";
    
    ## Output Format
    #@=result[0]: res_name={ora.<svrgrp_name>} srvgrp_name={server group name} importance={srvgrp importance} min={min} max={max} parent={parent group list} configured_servers={configured servers list}
    # Temporary Code
    #$cmd ="#@=result[0]: name={srgrp1} sglist={stadb55} \n#@=result[1]: name={sg2} sglist={stadb55}"."\n"; 
    #print $cmd."\n";
    # End of Temporary Code
    return &executeSRVCTL($srvctl_cmd);
    return (0);
}

# Usage: get_servgrp_status()
# Calls: srvctl config status -S 1
#

sub get_servgroup_status
{
    #my ($dbName, $sv_names) = @_;

    EMD_PERL_DEBUG("rac_services_o:get_servgroup_status dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:get_servgroup_status sv_names=$sv_names");
    my $srvctl_cmd = "$ENV{ORACLE_HOME}/bin/srvctl status srvpool -S 1";
    
    # Output Format
    # @=result[0]: srvgrp_name={server group name} active_servers={Active servers list}
    # Temporary Code
    #$cmd ="#@=result[0]: name={srgrp1} sglist={stadb55} \n#@=result[1]: name={sg2} sglist={stadb55}"."\n"; 
    #print $cmd;
    # End of Temporary Code
    return &executeSRVCTL($srvctl_cmd);
    return (0);
}

# Usage: get_service_status(dbName, [sv1...svK])
# Calls: srvctl config service -f -S 1 -d dbName -s sv1,sv2...svK
#
# needed for back compatibility with 10.1 db's

sub get_service_config
{
    my ($dbName, $sv_names) = @_;

    EMD_PERL_DEBUG("rac_services_o:get_service_config dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:get_service_config sv_names=$sv_names");

    $cmd = constructSRVCTLCmd ($dbName, $sv_names, "", "config", "-S 1");
    
    $returnCode = &executeSRVCTL($cmd);

    return $returnCode;
}

#Usage: get_status_database(dbName)
#Calls: srvctl status database -d dbName
sub get_status_database
{
  my($dbName)= @_;
  EMD_PERL_DEBUG("rac_services_o:get_status_database dbName=$dbName"); 
  $cmd = constructSRVCTLAllCmd($dbName,"database","","","status","-S 1");
  return &executeSRVCTL($cmd);
}

# Usage: do_service_add(dbName, servName, pref_list, avail_list, taf_policy)
# Calls: srvctl add service -d dbName -s servName -r <pref_list> -a <avail_list> -P <taf_policy>
sub do_service_add
{
    my ($dbName, $servName, $roles, $pref_list, $avail_list, $taf_policy) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_add dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_add servName=$servName");
    EMD_PERL_DEBUG("rac_services_o:do_service_add roles=$roles");
    EMD_PERL_DEBUG("rac_services_o:do_service_add pref_list=$pref_list");
    EMD_PERL_DEBUG("rac_services_o:do_service_add avail_list=$avail_list");
    EMD_PERL_DEBUG("rac_services_o:do_service_add taf_policy=$taf_policy");

    my $rolesOption = "";
    if(defined($roles) && ($roles ne "")) {
        $rolesOption = "-l $roles ";
    }
 
    $options = $rolesOption."-r $pref_list";
    
    if ($avail_list) {
	$options = "$options -a $avail_list";
    }
    
    $options = "$options -P $taf_policy";

    $cmd = constructSRVCTLCmd ($dbName, $servName, "", "add", $options);
    
    return &executeSRVCTL($cmd);
}

# Usage: do_service_add_su(dbName, servName, servGrp, singleOrUnif, taf_policy)
# Calls: srvctl add service -d dbName -s servName -g <server_group> -c {UNIFORM | SINGLETON} -P <taf_policy>
sub do_service_add_su
{
    my ($dbName, $servName, $servGrp, $roles, $singleOrUnif, $failOverType, $failOverMethod, $failOverDelay, $failOverRetries) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_add dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_add servName=$servName");
    EMD_PERL_DEBUG("rac_services_o:do_service_add servGrp=$servGrp");
    EMD_PERL_DEBUG("rac_services_o:do_service_add roles=$roles");
    EMD_PERL_DEBUG("rac_services_o:do_service_add singleOrUnif=$singleOrUnif"); 
    EMD_PERL_DEBUG("rac_services_o:do_service_add taf_policy=$taf_policy");

    my $rolesOption = "";
    if(defined($roles) && ($roles ne "")) {
        $rolesOption = "-l $roles ";
    }

    $options = "-g $servGrp ".$rolesOption."-c $singleOrUnif -e $failOverType -m $failOverMethod -w $failOverDelay -z $failOverRetries";
    
    ##$options = "$options -P $taf_policy";

    $cmd = constructSRVCTLCmd ($dbName, $servName, "", "add", $options);
    return &executeSRVCTL($cmd);
}

# Usage: do_service_modify(dbName, servName, pref_list, avail_list, taf_policy)
# Calls: srvctl modify service -d dbName -s servName -n -i <pref_list> -a <avail_list> -P <taf_policy>
sub do_service_modify
{
    my ($dbName, $servName, $roles, $pref_list, $avail_list, $taf_policy) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_modify dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify servName=$servName");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify roles=$roles");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify pref_list=$pref_list");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify avail_list=$avail_list");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify taf_policy=$taf_policy");

    $options = "-n -i $pref_list";
    
    if ($avail_list) {
	$options = "$options -a $avail_list";
    }
    
    $cmd = constructSRVCTLCmd ($dbName, $servName, "", "modify", $options);
    
    $returnCode = &executeSRVCTL($cmd);

    if ($returnCode != 0) {
	return $returnCode;
    }
    
    my $rolesOption = "";
    if(defined($roles) && ($roles ne "")) {
    	$rolesOption = "-l $roles";
    }

    EMD_PERL_DEBUG("srvctl version = $version");
    if (!($version eq '10.1')) {
        # need to modify taf policy separately (10.2 only):
        $cmd = constructSRVCTLCmd ($dbName, $servName, "", "modify", "-P $taf_policy $rolesOption");
    }

    return &executeSRVCTL($cmd);
}

# Usage: do_service_modify_su(dbName, servName, srvGrp, singleOrUnif, taf_policy)
# Calls: srvctl modify service -d dbName -s servName  -g srvGrp -c singleOrUnif  -P <taf_policy>
sub do_service_modify_su
{
    my ($dbName, $servName, $srvGrp, $roles, $singleOrUnif, $failOverType, $failOverMethod, $failOverDelay, $failOverRetries) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_modify dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify servName=$servName");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify serverGroup=$srvGrp");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify roles=$roles");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify singleOrUnif=$singleOrUnif");
    EMD_PERL_DEBUG("rac_services_o:do_service_modify taf_policy=$taf_policy");

    my $rolesOption = "";
    if(defined($roles) && ($roles ne "")) {
    	$rolesOption = "-l $roles ";
    }

    $options = $rolesOption."-c $singleOrUnif -e $failOverType -m $failOverMethod -w $failOverDelay -z $failOverRetries";
    
    
    $cmd = constructSRVCTLCmd ($dbName, $servName, "", "modify", $options);
    
    return &executeSRVCTL($cmd);

###    $returnCode = &executeSRVCTL($cmd);
###    
###    if ($returnCode != 0) {
###	return $returnCode;
###    }
###
###    EMD_PERL_DEBUG("srvctl version = $version");
###    if (!($version eq '10.1')) {
###        # need to modify taf policy separately (10.2 only):
###        $cmd = constructSRVCTLCmd ($dbName, $servName, "", "modify", "-P $taf_policy");
###    }
###
###    return &executeSRVCTL($cmd);
}

# Usage: do_service_remove(dbName, servName, doDisconnect)
# Calls: srvctl remove service -d dbName -s servName [-f]
sub do_service_remove
{
    my ($dbName, $servName, $doDisconnect) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_remove dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_remove servName=$servName");
    EMD_PERL_DEBUG("rac_services_o:do_service_remove doDisconnect=$doDisconnect");

    $cmd = constructSRVCTLCmd ($dbName, $servName, "", "remove", "-f");
    
    return &executeSRVCTL($cmd);    
}


# Usage: do_service_enable(dbName, [sv1...svK], inst_name)
# Calls: srvctl enable service -d dbName -s [sv1,...,svK] -i inst_name
# Requires: inst_name, if specified, must be registered to all [sv1...svk]

sub do_service_enable
{
    my ($dbName, $sv_names, $inst_name) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_enable dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_enable sv_names=$sv_names");
    EMD_PERL_DEBUG("rac_services_o:do_service_enable inst_name=$inst_name");

    $cmd = constructSRVCTLCmd ($dbName, $sv_names, $inst_name, "enable");
    
    return &executeSRVCTL($cmd);
}


# Usage: do_service_disable(dbName, [sv1...svK], inst_name)
# Calls: srvctl disable service -d dbName -s [sv1,...,svK] -i inst_name
# Requires: inst_name, if specified, must be registered to all [sv1...svk]

sub do_service_disable
{
    my ($dbName, $sv_names, $inst_name) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_disable dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_disable sv_names=$sv_names");
    EMD_PERL_DEBUG("rac_services_o:do_service_disable inst_name=$inst_name");

    $cmd = constructSRVCTLCmd ($dbName, $sv_names, $inst_name, "disable");
    
    return &executeSRVCTL($cmd);
}


# Usage: do_service_start(dbName, [sv1...svK], inst_name)
# Calls: srvctl start service -d dbName -s [sv1,...,svK] -i inst_name
# Requires: inst_name, if specified, must be registered to all [sv1...svk]

sub do_service_start
{
    my ($dbName, $sv_names, $inst_name) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_start dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_start sv_names=$sv_names");
    EMD_PERL_DEBUG("rac_services_o:do_service_start inst_name=$inst_name");

    $cmd = constructSRVCTLCmd ($dbName, $sv_names, $inst_name, "start");
    
    return &executeSRVCTL($cmd);
}


# Usage: do_service_stop(dbName, [sv1...svK], inst_name, [doDisconnect])
# Calls: srvctl stop service -d dbName -s [sv1,...,svK] -i inst_name [-f]
# Requires: inst_name, if specified, must be registered to all [sv1...svk]

sub do_service_stop
{
    my ($dbName, $sv_names, $inst_name, $doDisconnect) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_stop dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_stop sv_names=$sv_names");
    EMD_PERL_DEBUG("rac_services_o:do_service_stop inst_name=$inst_name");
    EMD_PERL_DEBUG("rac_services_o:do_service_stop doDisconnect=$doDisconnect");
    if ($doDisconnect) {
	$option = "-f";
    }

    $cmd = constructSRVCTLCmd ($dbName, $sv_names, $inst_name, "stop", $option);
    
    return &executeSRVCTL($cmd);
}


# Usage: do_service_relocate(dbName, sv_name, from_inst, to_inst)
# Calls: srvctl relocate service -d dbName -s sv_name -i from_inst -t to_inst
# Requires: sv_name is currently running on from_inst, and to_inst is a 
#           registered instance

sub do_service_relocate
{
    my ($dbName, $sv_name, $srvpool_name, $from_inst, $to_inst) = @_;

    EMD_PERL_DEBUG("rac_services_o:do_service_relocate dbName=$dbName");
    EMD_PERL_DEBUG("rac_services_o:do_service_relocate sv_name=$sv_name");
    EMD_PERL_DEBUG("rac_services_o:do_service_relocate srvpool_name=$srvpool_name");
    EMD_PERL_DEBUG("rac_services_o:do_service_relocate from_inst=$from_inst");
    EMD_PERL_DEBUG("rac_services_o:do_service_relocate to_inst=$to_inst");

    if (defined($srvpool_name) && $srvpool_name ne "null")
    {
        $cmd = constructSRVCTLCmd ($dbName, "$sv_name:$srvpool_name", $to_inst, "relocate", "-c $from_inst");
    }
    else
    {
        $cmd = constructSRVCTLCmd ($dbName, "$sv_name", $from_inst, "relocate", "-t $to_inst");
    }
    
    return &executeSRVCTL($cmd);
}



# Constructs a SRVCTL cmd to perform a service operation
#
# dbName The database name (db_unique_name)
# serviceList A list of services to operate on or NULL to operate on all 
# instanceList A list of SID(s) to operate on or NULL to operate on all 
# opCmd SRVCTL command verb: {start, stop, status, config}
# extraOptions Any extra command-line options (e.g., "-S 1", "-r pref_list", etc)
#
# Returns string of form:
#    srvctl $opCmd service -d $dbName [-s serviceList] [-i $instanceList] [$extraOptions]
#
sub constructSRVCTLCmd
{
    my($dbName, $serviceList, $instanceList, $opCmd, $extraOptions) = @_;    
    return constructSRVCTLAllCmd($dbName,"service", $serviceList, $instanceList, $opCmd, $extraOptions);
}
sub constructSRVCTLAllCmd{
 
    my($dbName, $obj,$serviceList, $instanceList, $opCmd, $extraOptions) = @_;    
    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd dbName=$dbName");    
    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd dbName=$obj");    
    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd serviceList=$serviceList");    
    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd instanceList=$instanceList");    
    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd opCmd=$opCmd");    
    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd extraOptions=$extraOptions");    

    my $srvctl_cmd;
    my @serviceNameAndGroup = split(/:/, $serviceList); 
    $serviceList = $serviceNameAndGroup[0];
    my $serverGroupName = $serviceNameAndGroup[1];


    $srvctl_cmd = "$ENV{ORACLE_HOME}/bin/srvctl $opCmd $obj -d $dbName";

    # append service list
    if (defined($serviceList) && !($serviceList eq ""))
    {
	$srvctl_cmd = "$srvctl_cmd -s $serviceList";
    }

    # append instance list    
    if (defined($instanceList) && !($instanceList eq ""))
    {
        if (defined($serverGroupName) && ($serverGroupName ne "null"))
        {
	    $srvctl_cmd = "$srvctl_cmd -n $instanceList";
        }
        else
        {
	    $srvctl_cmd = "$srvctl_cmd -i $instanceList";
        }
    }

    # append extra options
    if ($extraOptions && !($extraOptions eq "")) {
	$srvctl_cmd = "$srvctl_cmd $extraOptions";
    }    

    EMD_PERL_DEBUG("rac_services_o:constructSRVCTLCmd srvctl_cmd= $srvctl_cmd");
    return $srvctl_cmd
}


# 
# executeSRVCTL
#
# Runs $srvctl_cmd, print output and return error code if found
#
sub executeSRVCTL
{
    my ($srvctl_cmd) = @_;

    print "Srvctl command: $srvctl_cmd\n";
    
    chomp ($result = `$srvctl_cmd`);
    if ($? != 0) {
	# fatal error
	print "$result\n";
	return ($? >> 8);
    }

    print $result."\n";
    EMD_PERL_DEBUG("result from srvctl=$result\n");

    return has_ec($result);
}

# Purpose: find following error codes in input string:
#          "PRKP"
#          "PRKH"
#          "PRKO"
#          "CRS"
#          "ORA"
sub has_ec
{
    $in_str = $_[0];

#    print "error code detector: $in_str\n";

    if ($in_str =~ /PRKP-/ || $in_str =~ /PRKH-/ || $in_str =~ /PRKO-/ || $in_str =~ /CRS-/ || $in_str =~ /ORA-/) {
	return(-1);  # error mesg
    }
    else {
	return(0);
    }
    
}


## The following method is written to workaround bug 3469118.
## For pre-10g NT rac, if PATH env doesn't include $oracleHome/bin, 
## the srvctl will return error when invoked not within $oracleHome/bin. 
## The workaround for this bug is to change the current dir to $oracleHome/bin 
## before calling srvctl and set it back when finished
##
# Return the original current dir if it's changed
# Otherwise return ""
sub changeCWDForSrvctlIfNecessary
{
    my ($oracleHome, $srvctlVersion) = @_;
    my $orgDIR = "";
    
    if (get_osType() eq 'WIN' && $srvctlVersion eq '9.2')
    {    
        # This is a NT pre-10g srvctl
        $orgDIR = getcwd;
        chdir "$oracleHome/bin";
    }
    
    $orgDIR;
}
