#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/webapps/em/WEB-INF/perl/db/rac/srv_pool_util_o.pl /stpl_db_11.2.0.1.0_gen/1 2010/02/03 11:04:32 pardutta Exp $
#
# srv_pool_util_o.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      srv_pool_util_o.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pardutta    02/02/10 - bug9341646
#    shasingh    01/22/09 - Subroutine for getting database server pools
#    shasingh    09/26/08 - server pool related info utility
#    shasingh    09/26/08 - Creation
# 

use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";

my $LOG_CATEGORY = "srv_pool_util_o.pl: ";
unset_lib_path_env();

sub print_avail_srvpool_for_db
{
	my ($oh) = @_;
	my($err_msg,$srv_pools_ref) = get_srvpools_exclude_admng_db_pools($oh);
	if($err_msg ne "")
	{
		print $err_msg;
		return (-1);
	}
	else
	{
		print "@$srv_pools_ref";
		return (0);
	}
}

sub print_db_and_avail_srvpool
{
    my ($oh,$db_name) = @_;
    my($err_msg,$avail_srv_pools_ref) = get_srvpools_exclude_admng_db_pools($oh);
    if($err_msg ne "")
    {
        print $err_msg;
        return (-1);
    }
    
    my($err_msg,$db_srv_pools_ref) = get_db_srv_pool_list($oh,$db_name);
    if($err_msg ne "")
    {
        print $err_msg;
        return (-1);
    }
    
   print "@$db_srv_pools_ref"."#"."@$avail_srv_pools_ref";
   return (0);
}

 sub do_change_db_srv_pools_assoc
 {
 	my ($oh, $db_name,@pools) = @_;
 	
 	my($err_msg,$output) = change_db_srv_pool_list($oh, $db_name,@pools);
 	
 	if($err_msg ne "")
    {
        print $err_msg;
        return (-1);
    }
    else
    {
    	print $output;
        return (0);
    }
 	
 }



sub get_srvpools_exclude_admng_db_pools
{
	my ($oh) = @_;
	
	my ($all_pools_ref,$all_admng_db_pools_ref,$err_msg) = ("","","");
   
   ($err_msg,$all_pools_ref) = get_all_srv_pool($oh);
    return $err_msg if $err_msg ne "";
   
   ($err_msg,$all_admng_db_pools_ref) = get_all_admin_mng_db_srv_pool($oh);
    return $err_msg if $err_msg ne "";
	
    my %seen; # lookup table
    my @pools;
  
    @seen{@$all_admng_db_pools_ref} = ();
    foreach my $pool (@$all_pools_ref) {
     push(@pools, $pool) unless exists $seen{$pool};
    }
    
    ($err_msg, \@pools);
}

#Evaluate the server group resource name and it's max size for given server group
sub get_all_srv_pool
{
 my ($oh) = @_;
  
 my $cmd = "$oh/bin/srvctl config srvpool -S 1";
 my ( $err, $output ) = executeCommand( $cmd, $oh);
 EMD_PERL_DEBUG("$LOG_CATEGORY get_all_srv_pool-> $cmd returned (err=$err, output=$output)");
 
 my $err_msg = get_err_msg($err,$output); 
 return $err_msg if $err_msg ne "";
 
 my @srvpoolarray = ();
 if($err eq "")
 {
  my @lns = split /\n/, $output;
  for my $ln (@lns)
  {
   if ($ln =~ /res_name\s*=\s*\{(.*?)\}/i)
   {
   	push(@srvpoolarray,$1);
    EMD_PERL_DEBUG("$LOG_CATEGORY get_all_srv_pool-> Server Pool Res Name : $1 ");
   }
  }
 }
 
 ($err_msg,\@srvpoolarray); 
}

#Evaluate the server pool resource name hosting 'ADMIN_MANAGED' database type
sub get_all_admin_mng_db_srv_pool
{
 my ($oh) = @_;
  
 my $cmd = "$oh/bin/srvctl config database -S 1";
 my ( $err, $output ) = executeCommand( $cmd, $oh);
 EMD_PERL_DEBUG("$LOG_CATEGORY get_all_admin_mng_db_srv_pool-> $cmd returned (err=$err, output=$output)");
 
 my $err_msg = get_err_msg($err,$output); 
 return $err_msg if $err_msg ne "";
 
 my @ad_mng_db_srvpoolarray = ();
 if($err eq "")
 {
  my @lns = split /\n/, $output;
  for my $ln (@lns)
  {
   if ($ln =~ /res_name\s*=\s*\{.*?\}.*?srvpool\s*=\s*\{(.*?)\}.*?db_type\s*=\s*\{\s*ADMIN_MANAGED\s*\}/i)
   {
    push(@ad_mng_db_srvpoolarray,$1);
    EMD_PERL_DEBUG("$LOG_CATEGORY get_all_admin_mng_db_srv_pool-> Server Pool Res Name : $1 ");
   }
  }
 }
 
 ($err_msg,\@ad_mng_db_srvpoolarray); 
}

sub get_db_srv_pool_list
{
 my ($oh,$db_name) = @_;
  
 my $cmd = "$oh/bin/srvctl config database -d $db_name -S 1";
 my ( $err, $output ) = executeCommand( $cmd, $oh);
 EMD_PERL_DEBUG("$LOG_CATEGORY get_db_srv_pool_list-> $cmd returned (err=$err, output=$output)");
 
 my $err_msg = get_err_msg($err,$output); 
 return $err_msg if $err_msg ne "";
 
 my @db_srvpool_array = ();
 if($err eq "")
 {
  my @lns = split /\n/, $output;
  for my $ln (@lns)
  {
   if ($ln =~ /res_name\s*=\s*\{.*?\.$db_name\..*?\}.*?srvpool\s*=\s*\{(.*?)\}/i)
   {
   	 @db_srvpool_array = split( /\,/, $1) ;
     EMD_PERL_DEBUG("$LOG_CATEGORY get_db_srv_pool_list-> server pool value : $1 ");
    last;
   }
  }
 }
 
 ($err_msg,\@db_srvpool_array); 
}


#Evaluate the server pool resource name hosting 'ADMIN_MANAGED' database type
sub change_db_srv_pool_list
{
 my ($oh, $db_name,@pools) = @_;
 my $pool_list = join ",", @pools; 
 my $cmd = "$oh/bin/srvctl modify database -d $db_name -g \"$pool_list\"";
 my ( $err, $output ) = executeCommand( $cmd, $oh);
 EMD_PERL_DEBUG("$LOG_CATEGORY change_db_srv_pool_list-> $cmd returned (err=$err, output=$output)");
 
 my $err_msg = get_err_msg($err,$output); 
 return $err_msg if $err_msg ne "";
 
 ($err_msg,$output);
}


# execute the supplied command
sub executeCommand
{
 my ( $cmd, $oh ) = @_;
 $ENV{ORACLE_HOME} = $oh;
 my $err    = "";
 my $output = "";
 if ( open( CMDOUTPUT, "$cmd 2>&1 |" )) 
 {
  my @outputs = <CMDOUTPUT>;
  $output = join "", @outputs;
  if ( !close(CMDOUTPUT) ) 
  {
   # close error
   if ( $output ne "" ) 
   {
    $err    = "\"${cmd}\" returned: \"" . $output . "\"";
    $output = "";
   }
   else
   {
    $err = "bad \"$cmd\": $! $?";
   }
  }
 }
 else
 {
  # open error
  $err = "cannot execute \"$cmd\": $!";
 }

 EMD_PERL_ERROR("executeCommand: $cmd: $err") if ( $err ne "" );
 ( $err, $output );
}

sub get_err_msg
{
   my($err,$output)=@_;
	
   my $err_msg="";
 
   if($err ne "")
   {
   	 $err_msg = $err;
   }
   elsif ($output =~ /PRKP-/ || $output =~ /PRKH-/ || $output =~ /PRKO-/ || $output =~ /CRS-/ || $output =~ /ORA-/)
   {
   	 $err_msg = $output;
   }
   
  ($err_msg);
} 


# unset the *LD_* env variable for proper function of srvctl
sub unset_lib_path_env 
{
 delete $ENV{LD_LIBRARY_PATH};
 delete $ENV{SHLIB_PATH};
 delete $ENV{LIBPATH};
 delete $ENV{DYLD_LIBRARY_PATH};
}
