<?xml version="1.0" ?>
<!--
NAME
    cmkufull.xsl
DESCRIPTION
    Convert mdapi FULL_TYPE_T to FULL_TYPE document (editable XML)
    CM currently handles the type spec and the type body together,
    so there is no split between the specification and the body,
    as there is in kufull.xsl.

MODIFIED    MM/DD/YY
    pkalire 05/15/08 - Merge 11GC functionality
    abodge  06/20/05 - abodge_support_udt
    abodge  06/20/05 - More UDT work 
    abodge  06/16/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template name="getSourceLines">
  <xsl:param name="SourceObj"/>  
  <SOURCE>
    <xsl:if test="$SourceObj">
      <xsl:for-each select="$SourceObj/SOURCE_LINES_ITEM">
        <xsl:value-of select="SOURCE"/>
      </xsl:for-each>
    </xsl:if>
  </SOURCE>   
</xsl:template>

<xsl:template match="FULL_TYPE_T">
 <FULL_TYPE>
  <xsl:call-template name="DoSchemaWithMapping">
   <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <NAME>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
  </NAME> 
  <TYPE_SPECIFICATION>
    <xsl:choose>
     <xsl:when test="TYPE_T/SCHEMA_OBJ/STATUS=1">  
      <STATUS>
        <xsl:text>VALID</xsl:text>
      </STATUS> 
     </xsl:when>
     <xsl:otherwise>
      <STATUS>
        <xsl:text>INVALID</xsl:text>
      </STATUS> 
     </xsl:otherwise>       
    </xsl:choose>
    <xsl:call-template name="getSourceLines">
      <xsl:with-param name="SourceObj" select="TYPE_T/SOURCE_LINES"/>
    </xsl:call-template>    
  </TYPE_SPECIFICATION>
  <xsl:if test="TYPE_BODY_T">
   <TYPE_BODY>
    <xsl:choose>
     <xsl:when test="TYPE_T/SCHEMA_OBJ/STATUS=1">  
      <STATUS>
        <xsl:text>VALID</xsl:text>
      </STATUS> 
     </xsl:when>
     <xsl:otherwise>
      <STATUS>
        <xsl:text>INVALID</xsl:text>
      </STATUS> 
     </xsl:otherwise>       
    </xsl:choose>
    <xsl:call-template name="getSourceLines">
     <xsl:with-param name="SourceObj" select="TYPE_BODY_T/SOURCE_LINES"/>
    </xsl:call-template>    
   </TYPE_BODY>
  </xsl:if>
 </FULL_TYPE>
</xsl:template>

</xsl:stylesheet>
