<?xml version="1.0" ?>
<!--
NAME
    cmkuiot.xsl
DESCRIPTION
    XSLT stylesheet for XML => CMXML conversion of IOT ADTs

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       07/29/04 - support partition iot overflow 
    lhan        07/13/04 - lhan_xsl_0713
    lhan        07/13/04 - lhan_xsl_0713
    lhan        07/13/04 - initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- IOT overflow table -->
<xsl:template name="DoIOV">
 <xsl:param name="Node" select="''"/>
  <OVERFLOW>

   <xsl:if test="($Node/INCLCOL_NAME)">
    <xsl:element name="INCLUDING">
     <xsl:value-of select="$Node/INCLCOL_NAME"/>
    </xsl:element>
   </xsl:if>

   <xsl:choose>
    <xsl:when test="($Node/PROPERTY mod 64)>=32">	<!-- PIOT -->
     <xsl:call-template name="DoPIOTSegAttrs">
      <xsl:with-param name="ParentNode" select="$Node/PART_OBJ/OVPARTOBJ"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoSegmentAttributes">
      <xsl:with-param name="ParentNode" select="$Node/IOV"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </OVERFLOW>
</xsl:template>

</xsl:stylesheet>
