<?xml version="1.0" ?>
<!--
NAME
    cmkuproc.xsl
DESCRIPTION
    Convert mdapi PROCEDURE_T, FUNCTION_T, PACKAGE_T document to respective PROCEDURE, FUNCTION, PACKAGE document (editable XML)

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    rpattabh    01/29/08 - bug 6698577 case and whitespace are not ignored when
                           comparing pl/sql objects
    xshen       03/08/05 - fix schema mapping 
    abodge      09/02/04 - Do schema-mapping stuff 
    ngade       08/02/04 - 
    ngade       07/30/04 - ngade_cm_0726
    ngade       07/26/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="../kucommon.xsl"/>
<xsl:import href="../kusource.xsl"/>
<!-- Top-level parameters -->
<xsl:param name="PRETTY">1</xsl:param>
<xsl:param name="SQLTERMINATOR">0</xsl:param>
<xsl:param name="EXPORT">0</xsl:param>
<!-- params for parse -->
<xsl:param name="PRS_DDL">0</xsl:param>
<xsl:param name="PRS_DELIM">\{]`</xsl:param>
<xsl:param name="PRS_VERB">0</xsl:param>
<xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
<xsl:param name="PRS_SCHEMA">0</xsl:param>
<xsl:param name="PRS_NAME">0</xsl:param>
<xsl:param name="PRS_GRANTEE">0</xsl:param>
<xsl:param name="PRS_GRANTOR">0</xsl:param>
<xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
<xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
<xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>

<!-- kusource.xsl will only work in text output mode -->
<xsl:output method="xml"/>

<!-- Used for constraints matching -->
<xsl:param name="MATCH_CONSTR_BY_DEFINITION">1</xsl:param>
<xsl:param name="IGNORE_NAME_DIFFERENCES">1</xsl:param>


<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template name="getPlsqlAttributes">
  <xsl:param name="SchemaObj"/>
  <xsl:param name="SourceObj"/>  
  <!-- schemaName -->
    <xsl:call-template name="DoSchemaWithMapping">
     <xsl:with-param name="CurrentSchema" select="$SchemaObj/OWNER_NAME"/>
    </xsl:call-template>
  <!-- name -->
  <NAME>
    <xsl:value-of select="$SchemaObj/NAME"/>
  </NAME>
  <xsl:choose>
       <xsl:when test="$SchemaObj/STATUS=1">  
       <STATUS>
        <xsl:text>VALID</xsl:text>
       </STATUS>
    </xsl:when>
    <xsl:otherwise>
       <STATUS>
        <xsl:text>INVALID</xsl:text>
       </STATUS>
    </xsl:otherwise>       
  </xsl:choose>
  <SOURCE>
    <xsl:if test="$SourceObj">
      <xsl:call-template name="getSourceLines" />
    </xsl:if>
  </SOURCE>
</xsl:template>

 <xsl:template name="getSourceLines">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='PROCEDURE_T'">PROCEDURE</xsl:when>
     <xsl:when test="local-name(.)='FUNCTION_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='PWDVFC_T'">FUNCTION</xsl:when>
     <xsl:when test="local-name(.)='PACKAGE_T'">PACKAGE</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:call-template name="ProcObjType">
   <xsl:with-param name="NodeName" select="local-name(.)"/>
  </xsl:call-template>
  <xsl:text>&#x20;</xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
    <xsl:choose>
     <xsl:when test="local-name(.)='PACKAGE_T'">
      <xsl:apply-templates select="SOURCE_LINES"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="SOURCE_LINES">
       <xsl:with-param name="OBJTYPE">1</xsl:with-param>
      </xsl:apply-templates>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoSourceLines">
     <xsl:with-param name="SourceLines" select="SOURCE_LINES"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text" select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/SOURCE"/>
  </xsl:call-template>
 </xsl:template>

 <xsl:template name="ProcObjType">
  <xsl:param name="NodeName" select="''"/>
  <xsl:choose>
   <xsl:when test="$NodeName='PROCEDURE_T'">PROCEDURE</xsl:when>
   <xsl:when test="$NodeName='FUNCTION_T'">FUNCTION</xsl:when>
   <xsl:when test="$NodeName='PWDVFC_T'">FUNCTION</xsl:when>
   <xsl:when test="$NodeName='PACKAGE_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='PACKAGE_SPEC_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='PACKAGE_BODY_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='ALTER_PROCEDURE_T'">PROCEDURE</xsl:when>
   <xsl:when test="$NodeName='ALTER_FUNCTION_T'">FUNCTION</xsl:when>
   <xsl:when test="$NodeName='ALTER_PACKAGE_SPEC_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='ALTER_PACKAGE_BODY_T'">PACKAGE</xsl:when>
   <xsl:when test="$NodeName='TYPE_BODY_T'">TYPE</xsl:when>
   <xsl:when test="$NodeName='TYPE_T'">TYPE</xsl:when>
   <xsl:otherwise>**NOT FOUND**</xsl:otherwise>
  </xsl:choose>
 </xsl:template>

<xsl:template match="PROCEDURE_T">
  <PROCEDURE>
    <xsl:call-template name="getPlsqlAttributes">
      <xsl:with-param name="SchemaObj" select="SCHEMA_OBJ"/>
      <xsl:with-param name="SourceObj" select="SOURCE_LINES"/>      
    </xsl:call-template>
  </PROCEDURE>
</xsl:template>

<xsl:template match="FUNCTION_T">
  <FUNCTION>
    <xsl:call-template name="getPlsqlAttributes">
      <xsl:with-param name="SchemaObj" select="SCHEMA_OBJ"/>
      <xsl:with-param name="SourceObj" select="SOURCE_LINES"/>            
    </xsl:call-template>
  </FUNCTION>
</xsl:template>

<xsl:template match="PACKAGE_T">
  <PACKAGE>
    <xsl:call-template name="getPlsqlAttributes">
      <xsl:with-param name="SchemaObj" select="SCHEMA_OBJ"/>
      <xsl:with-param name="SourceObj" select="SOURCE_LINES"/>
    </xsl:call-template>    
  </PACKAGE>
</xsl:template>

<xsl:template match="PACKAGE_BODY_T">
  <PACKAGE_BODY>
    <xsl:call-template name="getPlsqlAttributes">
      <xsl:with-param name="SchemaObj" select="SCHEMA_OBJ"/>
      <xsl:with-param name="SourceObj" select="SOURCE_LINES"/>
    </xsl:call-template>    
  </PACKAGE_BODY>
</xsl:template>

</xsl:stylesheet>
