<?xml version="1.0"?>
<!--
NAME
    kuaddl.xsl
DESCRIPTION
    Convert ALTER_XML document to ALTER_DDL document

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne     09/26/06 - 
    lbarton     09/21/06 - add PRS_DDL support
    rapayne     05/25/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <!-- Output method must be xml for copy-of to work  -->
 <xsl:output method="xml" omit-xml-declaration="yes"/>
 <!-- Templates -->
 <!-- *******************************************************************
Top level template for all objects
******************************************************************** -->
 <xsl:template match="*|/">
  <xsl:apply-templates/>
 </xsl:template>
 <xsl:template match="sxml:ALTER_XML">
  <!-- Extract all of the SQL ALTER statements -->
  <xsl:for-each select="sxml:ALTER_LIST/sxml:ALTER_LIST_ITEM">
   <xsl:if test="$PRS_DDL=1">
    <!-- generate an artifical ROW parse item -->
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>D</xsl:text>
    <xsl:value-of select="position()"/>
    <xsl:value-of select="$PRS_DELIM"/>
    <!-- extract parse items -->
    <xsl:for-each select="sxml:PARSE_LIST/sxml:PARSE_LIST_ITEM">
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>A</xsl:text>
     <xsl:value-of select="sxml:ITEM"/>
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>B</xsl:text>
     <xsl:value-of select="sxml:VALUE"/>
    </xsl:for-each>
   </xsl:if>
   <xsl:apply-templates select="sxml:SQL"/>
   <xsl:for-each select="sxml:SQL_LIST/sxml:SQL_LIST_ITEM">
    <xsl:apply-templates select="."/>
    <xsl:if test="not(position()=last()) and $PRS_DDL=0">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
   </xsl:for-each>
   <xsl:if test="not(position()=last()) and $PRS_DDL=0">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:SQL">
  <!-- *******************************************************************
Template: SQL
******************************************************************** -->
  <xsl:if test="$PRS_DDL=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>C</xsl:text>
  </xsl:if>
  <xsl:value-of select="."/>
  <xsl:if test="$SQLTERMINATOR=1">;</xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SQL_LIST_ITEM">
  <!-- *******************************************************************
Template: SQL_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRS_DDL=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>C</xsl:text>
  </xsl:if>
  <xsl:for-each select="*">
   <xsl:choose>
    <xsl:when test="local-name(.)='TEXT'">
     <xsl:value-of select="." disable-output-escaping="yes"/>
    </xsl:when>
    <xsl:when test="local-name(.)='ELEMENTS'">
     <xsl:copy-of select="./*"/>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
  <xsl:if test="$SQLTERMINATOR=1">
/</xsl:if>
 </xsl:template>
</xsl:stylesheet>
