<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 

NAME
    kualob.xsl
DESCRIPTION
    Convert column diffs in sxml TABLE diff document to ALTER_XML document
    This is for diffs in LOBs, UDTs, nested tables and VARRAYs.

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    rapayne     06/30/08 - handle securefile/basicfile diff when moving/modifying lobs
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    lbarton     03/06/08 - xmltype col properties
    htseng      12/27/06 - add objtype for support materialized view
    lbarton     09/22/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kustablc.xsl"/>
 <!-- Templates -->
 <xsl:template name="ModifyLob">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <xsl:param name="LobProperties" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyLob
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
 LobProperties - LOB_PROPERTIES
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_LOB</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:choose>
        <!-- use the more expensive MOVE LOB option if we have to -->
        <xsl:when test="$LobProperties/sxml:STORAGE_TABLE/sxml:TABLESPACE/@value1 or
                  $LobProperties/sxml:STORAGE_TABLE/sxml:STORAGE_IN_ROW/@value1 or
                  $LobProperties/sxml:STORAGE_TABLE/sxml:SECUREFILE/@value1 or
                  $LobProperties/sxml:STORAGE_TABLE/sxml:CHUNK/@value1 or
                  $LobProperties/sxml:STORAGE_TABLE/sxml:NAME/@src or
                  $LobProperties/sxml:STORAGE_TABLE/sxml:SECUREFILE/@src">
        <xsl:text> MOVE LOB (</xsl:text>
        <xsl:call-template name="QuotedName">
         <xsl:with-param name="NameNode" select="$NameNode"/>
        </xsl:call-template>
        <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:DATATYPE='XMLTYPE'">.XMLDATA</xsl:if>
        <xsl:text>) STORE AS </xsl:text>
        <xsl:choose>
         <xsl:when test="$LobProperties/sxml:STORAGE_TABLE/sxml:SECUREFILE/@src=2">
          <xsl:text>SECUREFILE </xsl:text>
         </xsl:when>
         <xsl:when test="$LobProperties/sxml:STORAGE_TABLE/sxml:BASICFILE/@src=2 or 
                                     $LobProperties/sxml:STORAGE_TABLE/sxml:SECUREFILE/@src=1">
          <xsl:text>BASICFILE </xsl:text>
         </xsl:when>
        </xsl:choose>
        <xsl:if test="$LobProperties/sxml:STORAGE_TABLE/sxml:NAME and
                           not($LobProperties/sxml:STORAGE_TABLE/sxml:NAME/@src='1')">
         <xsl:call-template name="QuotedName">
           <xsl:with-param name="NameNode" select="$LobProperties/sxml:STORAGE_TABLE/sxml:NAME"/>
          </xsl:call-template>
         </xsl:if>
         <xsl:apply-templates select="$LobProperties">
          <xsl:with-param name="DataType" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:DATATYPE"/>
         </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text> MODIFY LOB (</xsl:text>
         <xsl:call-template name="QuotedName">
          <xsl:with-param name="NameNode" select="$NameNode"/>
         </xsl:call-template>
         <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:DATATYPE='XMLTYPE'">.XMLDATA</xsl:if>
         <xsl:text>) </xsl:text>
         <xsl:apply-templates select="$LobProperties">
          <xsl:with-param name="DataType" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:DATATYPE"/>
          <xsl:with-param name="ModifyLobStorage">1</xsl:with-param>
         </xsl:apply-templates>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
     <!-- This does not seem applicable in the non-nested table case...
<xsl:if test="$LobProperties/sxml:STORAGE_TABLE/sxml:NAME/@value1">
      <xsl:element name="SQL_LIST_ITEM">
       <xsl:element name="TEXT">
        <xsl:text>ALTER TABLE </xsl:text>
        <xsl:call-template name="SchemaName">
         <xsl:with-param name="ParentNode" select="$LobProperties/sxml:STORAGE_TABLE"/>
        </xsl:call-template>
        <xsl:text> RENAME TO </xsl:text>
        <xsl:call-template name="QuotedName">
         <xsl:with-param name="NameNode" select="$LobProperties/sxml:STORAGE_TABLE/sxml:NAME"/>
        </xsl:call-template>
       </xsl:element>
      </xsl:element>
     </xsl:if-->
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyUDT">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyUDT
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">SUBSTITUTABLE_COLUMN</xsl:with-param>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:SUBSTITUTABLE='Y' and not ($ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:OF_TYPE)"/>
      <xsl:otherwise>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">SUBSTITUTABLE_COLUMN</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:choose>
        <xsl:when test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:SUBSTITUTABLE='Y' and not ($ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:OF_TYPE)">
         <xsl:text>ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:text> MODIFY COLUMN </xsl:text>
         <xsl:call-template name="QuotedName">
          <xsl:with-param name="NameNode" select="$NameNode"/>
         </xsl:call-template>
         <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:SUBSTITUTABLE"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>-- Cannot ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:text> MODIFY COLUMN </xsl:text>
         <xsl:call-template name="QuotedName">
          <xsl:with-param name="NameNode" select="$NameNode"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyNestedTable">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: ModifyNestedTable
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
******************************************************************** -->
  <!-- RETURN AS -->
  <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:RETURN_AS/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="ModifyNTReturnAs">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="ModifyNTReturnAs">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Storage Table physical properties -->
  <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES//*[@value1] or $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES//*[@src]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="ModifyNTStorageTablePhysical">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="ModifyNTStorageTablePhysical">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Storage Table column properties -->
  <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLE_PROPERTIES/sxml:COLUMN_PROPERTIES//*[@value1] or $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLE_PROPERTIES/sxml:COLUMN_PROPERTIES//*[@src]">
   <xsl:call-template name="ColProperties">
    <xsl:with-param name="ParentNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE"/>
    <xsl:with-param name="ColListNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLE_PROPERTIES/sxml:COLUMN_PROPERTIES/sxml:COL_LIST"/>
    <xsl:with-param name="ColProperties" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:TABLE_PROPERTIES/sxml:COLUMN_PROPERTIES"/>
   </xsl:call-template>
  </xsl:if>
  <!-- Storage Table Name -->
  <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="ModifyNTStorageTableName">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="ModifyNTStorageTableName">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ModifyNTReturnAs">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyNTReturnAs
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">COLLECTION_RETRIEVAL</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY NESTED TABLE </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$NameNode"/>
       </xsl:call-template>
       <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:RETURN_AS"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyNTStorageTableName">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyNTStorageTableName
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RENAME_STORAGE_TABLE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE"/>
       </xsl:call-template>
       <xsl:text> RENAME TO </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyNTStorageTablePhysical">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyNTStorageTablePhysical
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">STORAGE_TABLE_PHYSICAL_PROPERTIES</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/@src and $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/@src">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">NESTED_TABLE_ORGANIZATION</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:choose>
        <xsl:when test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/@src and $ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/@src">
         <xsl:text>-- Cannot ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE"/>
         </xsl:call-template>
         <xsl:text> segment attributes </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE"/>
         </xsl:call-template>
         <xsl:text> MOVE </xsl:text>
         <!-- one of these will work: either heap table -->
         <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES">
          <xsl:with-param name="DoCompress">N</xsl:with-param>
         </xsl:apply-templates>
         <!-- or IOT -->
         <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES">
          <xsl:with-param name="DoCompress">N</xsl:with-param>
         </xsl:apply-templates>
         <!-- and if it's an IOT, these will also work -->
         <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:PCTTHRESHOLD"/>
         <xsl:apply-templates select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:NESTED_TABLE_PROPERTIES/sxml:STORAGE_TABLE/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:OVERFLOW"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyXMLType">
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyXMLType
Parameters:
 TableNode  - parent of table SCHEMA/NAME
 NameNode   - column name
 ColProperties - TABLE_PROPERTIES/COLUMN_PROPERTIES
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:XMLTYPE_PROPERTIES/sxml:XMLTYPE_STORAGE/sxml:STORE_AS/@value1">
    <xsl:choose>
     <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                          $PRS_CLAUSE_TYPE=1 or
                                          $PRS_COLUMN_ATTRIBUTE=1 or
                                          $PRS_ALTERABLE=1 or
                                          $PRS_XPATH=1)">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]"/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
        <xsl:with-param name="Item">NAME</xsl:with-param>
        <xsl:with-param name="Value1" select="$NameNode"/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">XMLTYPE_STORAGE_TYPE</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:when>
     <xsl:when test="$Action='SQL'">
      <xsl:element name="SQL_LIST">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>-- Cannot ALTER TABLE </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:text> MODIFY COLUMN </xsl:text>
         <xsl:call-template name="QuotedName">
          <xsl:with-param name="NameNode" select="$NameNode"/>
         </xsl:call-template>
        </xsl:element>
       </xsl:element>
      </xsl:element>
     </xsl:when>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:XMLTYPE_PROPERTIES/sxml:XMLTYPE_STORAGE/sxml:LOB_PROPERTIES//*[@value1]">
    <xsl:call-template name="ModifyLob">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="NameNode" select="$NameNode"/>
     <xsl:with-param name="ColProperties" select="$ColProperties"/>
     <xsl:with-param name="LobProperties" select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM[sxml:NAME=$NameNode]/sxml:XMLTYPE_PROPERTIES/sxml:XMLTYPE_STORAGE/sxml:LOB_PROPERTIES"/>
     <xsl:with-param name="Action" select="$Action"/>
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
