<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 

NAME
    kuamv.xsl
DESCRIPTION
    Convert sxml MATERIALIZED_VIEW diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge       01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    lbarton      03/06/08 - change interface to ModifyLob
    rapayne      01/22/07 - import kuamvl.xsl
    htseng       12/07/06 - differ features support 
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <xsl:import href="kuatpar.xsl"/>
 <xsl:import href="kuatcol.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="DROP_MISSING_COLUMNS">1</xsl:param>
 <xsl:param name="NOT_NULL_METHOD">AUTOMATIC</xsl:param>
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_TYPE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_STATE">0</xsl:param>
 <xsl:param name="PRS_XPATH">0</xsl:param>
 <!-- params for parse inherited from kuamvl.xsl -->
 <!-- Templates -->
 <xsl:template match="sxml:MATERIALIZED_VIEW">
  <!-- *******************************************************************
Template: TABLE - top-level template for tables.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">MATERIALIZED_VIEW</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2 -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- alter_iot_clauses -->
    <xsl:call-template name="AlterMVIOT">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- Physical_attributes_clause, table_compression -->
    <xsl:if test="sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES//@value1
               or sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS/@value1">
     <xsl:call-template name="MViewPhysical">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
    </xsl:if>
    <!-- Alter CACHE if appropriate -->
    <xsl:call-template name="AlterCache">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW</xsl:with-param>
     <xsl:with-param name="OnTable"> </xsl:with-param>
    </xsl:call-template>
    <!-- Alter PARALLEL if appropriate -->
    <xsl:call-template name="AlterParallel">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW</xsl:with-param>
     <xsl:with-param name="OnTable"> </xsl:with-param>
    </xsl:call-template>
    <!-- LOB storage clause -->
    <xsl:call-template name="AlterMVLob">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ColProperties" select="sxml:COLUMN_PROPERTIES"/>
    </xsl:call-template>
    <!-- alter_table_partitioning -->
    <xsl:call-template name="AlterMVPartition">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType" select="'MATERIALIZED VIEW'"/>
    </xsl:call-template>
    <!-- cant not alter between USING_NO_INDEX and USING INDEX-->
    <!-- create mv with using no index and then alter mv using index, there is -->
    <!-- no error but metadata does not make any change   -->
    <xsl:if test="sxml:USING_NO_INDEX/@src='2'">
     <xsl:call-template name="UnAlterMVmisc">
      <xsl:with-param name="ParentNode" select="."/>
      <xsl:with-param name="AlterNode">USING_NO_INDEX</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- USING INDEX -->
    <xsl:if test="sxml:INDEX_ATTRIBUTES/@src='2' or
                 sxml:INDEX_ATTRIBUTES/sxml:INITRANS/@value1 or 
    		 sxml:INDEX_ATTRIBUTES/sxml:PCTFREE/@value1 or 
                 sxml:INDEX_ATTRIBUTES/sxml:PCTUSED/@value1 or 
                 sxml:INDEX_ATTRIBUTES/sxml:STORAGE//@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterUsingIndex">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterUsingIndex">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- REFRESH -->
    <xsl:if test="sxml:REFRESH//@src or sxml:REFRESH//@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterRefresh">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:if test="sxml:REFRESH//@src='2' or sxml:REFRESH//@value1">
       <xsl:call-template name="AlterRefresh">
        <xsl:with-param name="ParentNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:if>
     </xsl:element>
    </xsl:if>
    <!-- FOR UPDATE -->
    <xsl:if test="sxml:FOR_UPDATE/@src">
     <xsl:call-template name="UnAlterMVmisc">
      <xsl:with-param name="ParentNode" select="."/>
      <xsl:with-param name="AlterNode">FOR_UPDATE</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- SUBQUERY  -->
    <xsl:if test="sxml:SUBQUERY/@src or sxml:SUBQUERY/@value1">
     <xsl:call-template name="UnAlterMVmisc">
      <xsl:with-param name="ParentNode" select="."/>
      <xsl:with-param name="AlterNode">SUBQUERY</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- Enable/disable  QUERY REWRITE -->
    <xsl:if test="sxml:QUERY_REWRITE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterQueryRewrite">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterQueryRewrite">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterMVPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterMVPartition
Current node: 
Parameters:
 ParentNode - 
 
******************************************************************** -->
  <xsl:choose>
   <!-- Range partition  -->
   <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:if test="$ParentNode/sxml:RANGE_PARTITIONING/@src">
     <xsl:call-template name="UnAlterPartition">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RANGE_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="PartitionType">
      <xsl:choose>
       <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING/sxml:LIST_SUBPARTITIONING">RANGE-LIST</xsl:when>
       <xsl:otherwise>RANGE</xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RANGE_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <!-- List partition  -->
   <xsl:when test="$ParentNode/sxml:LIST_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:if test="$ParentNode/sxml:LIST_PARTITIONING/@src">
     <xsl:call-template name="UnAlterPartition">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="ParentNode" select="$ParentNode/sxml:LIST_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="PartitionType">LIST</xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:LIST_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <!-- Hash partition  -->
   <xsl:when test="$ParentNode/sxml:HASH_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:if test="$ParentNode/sxml:HASH_PARTITIONING/@src">
     <xsl:call-template name="UnAlterPartition">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="ParentNode" select="$ParentNode/sxml:HASH_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="PartitionType">HASH</xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:HASH_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVIOT">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterMVIOT
Current node: 
Parameters:
 ParentNode - 
 IOTNode - sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE[@src] or
       $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE[@src] or
       $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:EXTERNAL_TABLE[@src] or
       $ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:CLUSTER_TABLE[@src]">
    <xsl:call-template name="MVInxOrg">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="PhysicalPropertiesNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES"/>
    </xsl:call-template>
   </xsl:when>
   <!-- alter_iot_clauses -->
   <xsl:otherwise>
    <xsl:call-template name="AlterIOT">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="'MATERIALIZED_VIEW'"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="MVInxOrg">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PhysicalPropertiesNode" select="''"/>
  <!-- *******************************************************************
Template: MVInxOrg - detects non-alterable case:
  can't interconvert between MV index organizations (heap, IOT, external, cluster)
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 PhysicalPropertiesNode - PHYSICAL_PROPERTIES
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_ALTERABLE=1 or
                  $PRS_XPATH=1">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PhysicalPropertiesNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">MV_INDEX_ORGANIZATION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
   <xsl:element name="SQL_LIST">
    <xsl:element name="SQL_LIST_ITEM">
     <xsl:element name="TEXT">
      <xsl:text>-- can not alter Materialized view index organization </xsl:text>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="MViewPhysical">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: MViewPhysical
Current node: 
Parameters:
 ParentNode - 
******************************************************************** -->
  <!-- Physical_Attributes -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="AlterMViewPhysical">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="AlterMViewPhysical">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterMViewPhysical">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMViewPhysical
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <!-- Physical_Attributes -->
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
       <!-- Table_compression -->
       <xsl:call-template name="AlterCompress">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE"/>
       </xsl:call-template>
       <!-- Logging_clause-->
       <xsl:call-template name="AlterLogging">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="UnAlterMVmisc">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="AlterNode" select="''"/>
  <!-- *******************************************************************
Template: UnAlterMVmisc
  can't do alter 
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:if test="($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:choose>
        <xsl:when test="$AlterNode='USING_NO_INDEX'">
         <xsl:text>USING_NO_INDEX</xsl:text>
        </xsl:when>
        <xsl:when test="$AlterNode='FOR_UPDATE'">
         <xsl:text>FOR UPDATE</xsl:text>
        </xsl:when>
        <xsl:when test="$AlterNode='SUBQUERY'">
         <xsl:text>SUBQUERY</xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
   <xsl:element name="SQL_LIST">
    <xsl:element name="SQL_LIST_ITEM">
     <xsl:element name="TEXT">
      <xsl:choose>
       <xsl:when test="$AlterNode='USING_NO_INDEX'">
        <xsl:text>-- can not alter USING_NO_INDEX</xsl:text>
       </xsl:when>
       <xsl:when test="$AlterNode='FOR_UPDATE'">
        <xsl:text>-- can not alter FOR UPDATE</xsl:text>
       </xsl:when>
       <xsl:when test="$AlterNode='SUBQUERY'">
        <xsl:text>-- can not alter SUBQUERY</xsl:text>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="UnAlterPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <!-- *******************************************************************
Template: UnAlterPartition
  can't do alter between RANGE, LIST, HASH 
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:if test="($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$TableNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">cannot ADD,DROP between RANGE,LIST,HASH</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
   <xsl:element name="SQL_LIST">
    <xsl:element name="SQL_LIST_ITEM">
     <xsl:element name="TEXT">
      <xsl:text>-- cannot ADD,DROP between RANGE,LIST,HASH</xsl:text>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterUsingIndex">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterUsingIndex
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">USING_INDEX</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:PCTFREE/@value1">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">PCTFREE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:PCTUSED/@value1">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">PCTUSED</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:PCTFREE/@value1 or
$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:PCTUSED/@value1">
      <xsl:element name="SQL_LIST">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>-- can not alter USING INDEX PCTFREE or PCTUSE</xsl:text>
        </xsl:element>
       </xsl:element>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <xsl:element name="SQL_LIST">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ParentNode"/>
         </xsl:call-template>
         <xsl:text> USING INDEX</xsl:text>
         <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:INITRANS">
          <xsl:text> INITRANS </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:INITRANS"/>
         </xsl:if>
         <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:TABLESPACEX">
          <xsl:text> TABLESPACE </xsl:text>
          <xsl:value-of select="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:TABLESPACE"/>
         </xsl:if>
         <!-- storage_clause -->
         <xsl:if test="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:STORAGE">
          <xsl:call-template name="AlterStorage">
           <xsl:with-param name="ParentNode" select="$ParentNode/sxml:INDEX_ATTRIBUTES/sxml:STORAGE"/>
          </xsl:call-template>
         </xsl:if>
        </xsl:element>
       </xsl:element>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterRefresh">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterRefresh
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_MV_REFRESH</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:START_WITH/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH/START_WITH (DATE)</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:NEXT/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH NEXT (DATE) </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:WITH_PRIMARY_KEY/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH WITH PRIMARY KEY</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:FAST/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH FAST </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:FORCE/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH FORCE </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:COMPLETE/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH COMPLETE </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:WITH_ROWID/@src">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">REFRESH WITH ROWID </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO REFRESH ON COMMIT </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='2'">
      <xsl:choose>
       <xsl:when test="$ParentNode/sxml:REFRESH/sxml:FAST"/>
       <xsl:otherwise>
        <xsl:call-template name="AddParseItem">
         <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
         <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
         <xsl:with-param name="Value1">UNDO REFRESH ON COMMIT</xsl:with-param>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:NAME/@src='2' or $ParentNode/sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:NAME/@value1 or $ParentNode/sxml:REFRESH/sxml:LOCAL_ROLLBACK_SEGMENT/sxml:DEFAULT/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">LOCAL_ROLLBACK_SEGMENT</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> REFRESH</xsl:text>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:COMPLETE/@src='2'">
        <xsl:text> COMPLETE</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:ON_COMMIT/@src='2' and
		     $ParentNode/sxml:REFRESH/sxml:FAST">
        <xsl:text> ON COMMIT</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:FAST/@src='2'">
        <xsl:text> FAST</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:WITH_PRIMARY_KEY/@src='2'">
        <xsl:text> WITH PRIMARY KEY</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:START_WITH/@src='2' 
		or $ParentNode/sxml:REFRESH/sxml:START_WITH/@value1">
        <xsl:text> START WITH </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:START_WITH"/>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:NEXT/@src='2' 
		or $ParentNode/sxml:REFRESH/sxml:NEXT/@value1">
        <xsl:text> NEXT </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:NEXT"/>
       </xsl:if>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME/@src='2' or $ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME/@value1">
         <xsl:text> USING MASTER ROLLBACK SEGMENT </xsl:text>
         <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:NAME"/>
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:REFRESH/sxml:MASTER_ROLLBACK_SEGMENT/sxml:DEFAULT/@src='2'">
         <xsl:text> USING DEFAULT MASTER ROLLBACK SEGMENT </xsl:text>
        </xsl:when>
       </xsl:choose>
       <xsl:if test="$ParentNode/sxml:REFRESH/sxml:CONSTRAINTS/@src='2' or $ParentNode/sxml:REFRESH/sxml:CONSTRAINTS/@value1">
        <xsl:text> USING </xsl:text>
        <xsl:value-of select="$ParentNode/sxml:REFRESH/sxml:CONSTRAINTS"/>
        <xsl:text> CONSTRAINTS </xsl:text>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterQueryRewrite">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterQueryRewrite
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">QUERY_REWRITE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$ParentNode/sxml:QUERY_REWRITE/@src='1'">
         <xsl:text> DISABLE QUERY REWRITE</xsl:text>
        </xsl:when>
        <xsl:when test="$ParentNode/sxml:QUERY_REWRITE/@src='2'">
         <xsl:text> ENABLE QUERY REWRITE</xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVLob">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ColProperties" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLob
Current node: 
Parameters:
 ParentNode - 
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:for-each select="$ColProperties/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:if test="(sxml:DATATYPE='CLOB' or
                 sxml:DATATYPE='BLOB' or
                 sxml:DATATYPE='NCLOB') and
                 sxml:LOB_PROPERTIES//*[@value1]">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:call-template name="ModifyLob">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="$ColProperties"/>
      <xsl:with-param name="LobProperties" select="sxml:LOB_PROPERTIES"/>
      <xsl:with-param name="ObjType" select="'MATERIALIZED VIEW'"/>
      <xsl:with-param name="Action">PARSE</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="ModifyLob">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
      <xsl:with-param name="ColProperties" select="$ColProperties"/>
      <xsl:with-param name="LobProperties" select="sxml:LOB_PROPERTIES"/>
      <xsl:with-param name="ObjType" select="'MATERIALIZED VIEW'"/>
      <xsl:with-param name="Action">SQL</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
