<?xml version="1.0"?>
<!--
NAME
    kuamvl.xsl
DESCRIPTION
    Convert sxml MATERIALIZED_VIEW_LOG diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge       01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge       11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne      07/12/07 - 
    pkaliren     02/09/07 - Removing alter partition in MVLog
    htseng       01/02/07 - differ features support 
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <xsl:import href="kuatpar.xsl"/>
 <xsl:import href="kuamv.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="DROP_MISSING_COLUMNS">1</xsl:param>
 <xsl:param name="NOT_NULL_METHOD">AUTOMATIC</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_TYPE">0</xsl:param>
 <xsl:param name="PRS_CONSTRAINT_STATE">0</xsl:param>
 <xsl:param name="PRS_PARTITION_TYPE">0</xsl:param>
 <xsl:param name="PRS_XPATH">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:MATERIALIZED_VIEW_LOG">
  <!-- *******************************************************************
Template: MATERIALIZED_VIEW_LOG - top-level template for materialized view log.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">MATERIALIZED_VIEW_LOG</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="./sxml:ON_TABLE"/>
   </xsl:call-template>
   -->
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- SEGMENT_ATTRIBUTES -->
    <xsl:call-template name="AlterMVLSegAttrib">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
    </xsl:call-template>
    <!-- Alter CACHE if appropriate -->
    <xsl:call-template name="AlterCache">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
     <xsl:with-param name="OnTable" select="./sxml:ON_TABLE"/>
    </xsl:call-template>
    <!-- Parallel_clause -->
    <xsl:call-template name="AlterParallel">
     <xsl:with-param name="ObjectNode" select="."/>
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
     <xsl:with-param name="OnTable" select="./sxml:ON_TABLE"/>
    </xsl:call-template>
    <!-- alter_table_partitioning -->
    <xsl:call-template name="AlterMVLPartition">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="ObjType">MATERIALIZED VIEW LOG</xsl:with-param>
    </xsl:call-template>
    <!-- RECORDS node includes ROWID, SEQUENCE, OBJECT_ID, PRIMARY_KEY and COL_LIST nodes  -->
    <xsl:if test="sxml:RECORDS//@src or sxml:RECORDS//@value1 or
    sxml:RECORDS//@src or sxml:RECORDS//@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterRecords">
       <xsl:with-param name="ParentNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:if test="sxml:RECORDS/*/@src='2' or
          sxml:INCLUDING_NEW_VALUES/@src">
       <xsl:call-template name="AlterRecords">
        <xsl:with-param name="ParentNode" select="."/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:if>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterMVLSegAttrib">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLSegAttrib
       <SEGMENT_ATTRIBUTES> are composed of physical attributes, storage and logging
Current node: 
Parameters:
 ParentNode - 
 ObjType - MATERIALIZED VIEW LOG
 OnTable -
******************************************************************** -->
  <!-- PHYSICAL_ATTRIBUTES (INITRANS, PCTFREE, and/or PCTUSED) -->
  <xsl:if test="sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterMVLPhysical">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterMVLPhysical">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Logging_clause-->
  <xsl:if test="./sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterMVLogging">
     <xsl:with-param name="LoggingNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING"/>
     <xsl:with-param name="OnTableNode" select="$ParentNode/sxml:ON_TABLE"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterMVLogging">
     <xsl:with-param name="LoggingNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING"/>
     <xsl:with-param name="OnTableNode" select="$ParentNode/sxml:ON_TABLE"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Tablespace  is NOT alterable -->
  <xsl:if test="./sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE[@value1]">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    <xsl:with-param name="Reason">MODIFY TABLESPACE</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterMVLPhysical">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLPhysical
Current node: 
Parameters:
 ParentNode - Object node (e.g., MATERIALIZED_VIEW_LOG
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">PHYSICAL_ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW LOG ON </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:ON_TABLE"/>
       </xsl:call-template>
       <!-- Physical_Attributes -->
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVLogging">
  <xsl:param name="LoggingNode" select="''"/>
  <xsl:param name="OnTableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLogging
Logging node: 
Parameters:
  LoggingNode - LOGGING node
 OnTableNode - ON_TABLE node
 Action - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                               $PRS_CLAUSE_TYPE=1 or
                          					$PRS_CONSTRAINT_TYPE=1 or
				                          	$PRS_CONSTRAINT_STATE=1 or
                               $PRS_ALTERABLE=1 or
                               $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$LoggingNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">LOGGING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW LOG ON </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$OnTableNode"/>
       </xsl:call-template>
       <xsl:apply-templates select="$LoggingNode"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterMVLPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjType" select="''"/>
  <!-- *******************************************************************
Template: AlterMVLPartition
Current node: 
Parameters:
 ParentNode - 
 
******************************************************************** -->
  <xsl:choose>
   <!-- Range partition  -->
   <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:if test="$ParentNode/sxml:RANGE_PARTITIONING/@src">
     <xsl:call-template name="UnAlterPartition">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RANGE_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="PartitionType">
      <xsl:choose>
       <xsl:when test="$ParentNode/sxml:RANGE_PARTITIONING/sxml:LIST_SUBPARTITIONING">RANGE-LIST</xsl:when>
       <xsl:otherwise>RANGE</xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RANGE_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <!-- List partition  -->
   <xsl:when test="$ParentNode/sxml:LIST_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:if test="$ParentNode/sxml:LIST_PARTITIONING/@src">
     <xsl:call-template name="UnAlterPartition">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="ParentNode" select="$ParentNode/sxml:LIST_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="PartitionType">LIST</xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:LIST_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <!-- Hash partition  -->
   <xsl:when test="$ParentNode/sxml:HASH_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:if test="$ParentNode/sxml:HASH_PARTITIONING/@src">
     <xsl:call-template name="UnAlterPartition">
      <xsl:with-param name="TableNode" select="$ParentNode"/>
      <xsl:with-param name="ParentNode" select="$ParentNode/sxml:HASH_PARTITIONING"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="PartitionType">HASH</xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:HASH_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterRecords">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterRecords - The RECORD node contains 
    ROWID:      Only ADDS are supported
    COL_LIST: Only ADDS are supported
Parameters:
 ParentNode - parent of RECORDS node
 Action   - PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:RECORDS"/>
     </xsl:call-template>
     <!-- Add PARSE_ITEM for ROWID  (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:ROWID/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO ROWID</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:ROWID/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_ROWID</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for PRIMARY_KEY (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO PRIMARY_KEY</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_PRIMARY_KEY</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for SEQUENCE (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:SEQUENCE/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO SEQUENCE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:SEQUENCE/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_SEQUENCE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for OBJECT_ID  (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">UNDO OBJECT_ID </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">ADD_OBJECT_ID </xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <!-- Add PARSE_ITEM for COL_LIST (if appropriate) -->
     <xsl:choose>
      <xsl:when test="$ParentNode/sxml:RECORDS/sxml:COL_LIST//*[@value1] or
     $ParentNode/sxml:RECORDS/sxml:COL_LIST//*[@src] or 
$ParentNode/sxml:RECORDS/sxml:COL_LIST/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">MODIFY COL_LIST</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParentNode/sxml:RECORDS/sxml:COL_LIST/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ADD COL_LIST</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <!-- otherwise we assume that other non-COL_LIST record nodes were modified -->
     </xsl:choose>
     <!-- Add PARSE_ITEM for INCLUDING_NEW_VALUES (if appropriate) -->
     <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='1'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">EXCLUDING_NEW_VALUE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='2'">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
       <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
       <xsl:with-param name="Value1">INCLUDING_NEW_VALUE</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER MATERIALIZED VIEW LOG ON </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:ON_TABLE"/>
       </xsl:call-template>
       <xsl:text> ADD</xsl:text>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
        <xsl:text> OBJECT ID</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2'">
        <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2'">
         <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:text> PRIMARY KEY</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:ROWID/@src='2'">
        <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2' or
               $ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2'">
         <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:text> ROWID</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:SEQUENCE/@src='2'">
        <xsl:if test="$ParentNode/sxml:RECORDS/sxml:OBJECT_ID/@src='2' or
               $ParentNode/sxml:RECORDS/sxml:PRIMARY_KEY/@src='2' or
               $ParentNode/sxml:RECORDS/sxml:ROWID/@src='2'">
         <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:text> SEQUENCE</xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:RECORDS/sxml:COL_LIST/@src='2'">
        <xsl:text> (</xsl:text>
        <xsl:call-template name="AlterCOL_LIST">
         <xsl:with-param name="ColListItems" select="$ParentNode/sxml:RECORDS/sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
        </xsl:call-template>
        <xsl:text>)</xsl:text>
       </xsl:if>
       <!-- New_values_clause -->
       <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='2'">
        <xsl:text> INCLUDING NEW VALUES </xsl:text>
       </xsl:if>
       <xsl:if test="$ParentNode/sxml:INCLUDING_NEW_VALUES/@src='1'">
        <xsl:text> EXCLUDING NEW VALUES </xsl:text>
       </xsl:if>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
