<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> 
<xsl:import href="kuacomm.xsl"/>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_XPATH">0</xsl:param>
<!-- Templates -->
 <xsl:template match="PROFILE">
 <!-- *******************************************************************
Template: PROFILE - top-level template.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">PROFILE</xsl:element>
   <xsl:element name="ALTER_LIST">
   <xsl:for-each select="PROFILE_LIST/PROFILE_LIST_ITEM">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterProfileAttr">
     <xsl:with-param name="PartNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
     <xsl:call-template name="AlterProfileAttr">
     <xsl:with-param name="PartNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
   </xsl:for-each>
  </xsl:element>
  </xsl:element>
 </xsl:template>

<xsl:template name="AlterProfileAttr">
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterProfileAttr
Parameters:
 PartNode  <PROFILE_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$PartNode/@NAME"></xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_PROFILE_ATTRS</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text> LIMIT </xsl:text>
       <xsl:value-of select="$PartNode/@NAME"/>
       <xsl:text> </xsl:text>
       <xsl:apply-templates select="$PartNode/VALUE/processing-instruction('UPDATE')"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>

<xsl:template match="processing-instruction('UPDATE')">
  <xsl:value-of select="."/>
</xsl:template>
</xsl:stylesheet>
