<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 

NAME
    kuatpar.xsl
DESCRIPTION
    Convert partition diffs in sxml TABLE diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    lbarton     03/13/08 - Bug 6724820: table compression
    htseng      12/21/06 - support materialized view
    htseng      11/13/06 - drop subpartition
    htseng      11/07/06 - more work
    htseng      11/03/06 -  add modify partition
    lbarton     11/02/06 - 
    rapayne     09/22/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuspard.xsl"/>
 <!-- Templates -->
 <xsl:template name="AlterTablePartitions">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AlterTablePartitions
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:choose>
   <!-- Range partition  -->
   <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterIntervalPartitioning">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="PartitionType">
      <xsl:choose>
       <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING/sxml:LIST_SUBPARTITIONING">RANGE-LIST</xsl:when>
       <xsl:otherwise>RANGE</xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:RANGE_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <!-- List partition  -->
   <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="PartitionType">LIST</xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:LIST_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
   <!-- Hash partition  -->
   <xsl:when test="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING">
    <!-- Table tablespace is not alterable for iot and partition  -->
    <xsl:call-template name="UnAlterTbs">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE |
$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING/sxml:DEFAULT_PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
    </xsl:call-template>
    <xsl:call-template name="AlterPartitions">
     <xsl:with-param name="TableNode" select="$ParentNode"/>
     <xsl:with-param name="PartitionType">HASH</xsl:with-param>
     <xsl:with-param name="ParentNode" select="$ParentNode/sxml:RELATIONAL_TABLE/sxml:TABLE_PROPERTIES/sxml:HASH_PARTITIONING"/>
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AddPartitions">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <!-- *******************************************************************
Template: AddPartitions
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 PartitionType - RANGE, LIST, or HASH
 PartListNode - PARTITION
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="AddPartition">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="PartNode" select="$PartNode"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="AddPartition">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="PartNode" select="$PartNode"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AddPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddPartition
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 PartitionType - RANGE, LIST, or HASH
 PartNode - PARTITION_LIST_ITEM
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> ADD </xsl:text>
       <xsl:call-template name="BeginAddPartition">
        <xsl:with-param name="PartitionType" select="$PartitionType"/>
        <xsl:with-param name="PartitionItem" select="$PartNode"/>
       </xsl:call-template>
       <xsl:call-template name="CompleteAddPartition">
        <xsl:with-param name="ParentNode" select="$PartNode"/>
        <xsl:with-param name="PartitionType" select="$PartitionType"/>
        <xsl:with-param name="Punctuate">N</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DropPartitions">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PartListNode" select="''"/>
  <!-- *******************************************************************
Template: DropPartitions
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 PartListNode - PARTITION_LIST
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="DropPartition">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="PartNode" select="$PartNode"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="DropPartition">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="PartNode" select="$PartNode"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DropPartition">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropPartition
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 ColNode - PARTITION_LIST_ITEM
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PartNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ParentNode"/>
       </xsl:call-template>
       <xsl:text> DROP PARTITION </xsl:text>
       <xsl:call-template name="SourceName">
        <xsl:with-param name="NameNode" select="$PartNode/sxml:NAME"/>
       </xsl:call-template>
       <xsl:text> </xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterPartitions">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: AlterPartitions
ParentNode:sxml:RANGE_PARTITIONING
		LIST_PARTITIONING
		HASH_PARTITIONING
******************************************************************** -->
  <xsl:for-each select="$ParentNode/sxml:PARTITION_LIST/sxml:PARTITION_LIST_ITEM">
   <xsl:choose>
    <xsl:when test="./@src='1'">
     <xsl:call-template name="DropPartitions">
      <xsl:with-param name="ParentNode" select="$TableNode"/>
      <xsl:with-param name="PartNode" select="."/>
      <xsl:with-param name="ObjType" select="$ObjType"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="./@src='2'">
     <xsl:call-template name="AddPartitions">
      <xsl:with-param name="ParentNode" select="$TableNode"/>
      <xsl:with-param name="PartitionType" select="$PartitionType"/>
      <xsl:with-param name="PartNode" select="."/>
      <xsl:with-param name="ObjType" select="$ObjType"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="ModifyPartitions">
      <xsl:with-param name="TableNode" select="$TableNode"/>
      <xsl:with-param name="PartitionType" select="$PartitionType"/>
      <xsl:with-param name="PartNode" select="."/>
      <xsl:with-param name="ObjType" select="$ObjType"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="ModifyPartitions">
  <xsl:param name="PartNode" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: ModifyPartitions
ParentNode:sxml:PARTITION_LIST 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="sxml:SUBPARTITION_LIST">
    <xsl:if test="sxml:NAME/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="RenPartName">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$PartNode"/>
       <xsl:with-param name="PartType">PARTITION</xsl:with-param>
       <xsl:with-param name="PartName" select="sxml:NAME"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:if test="sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE//@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING/@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS/@value1 or
                sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS/@src!='1'">
     <xsl:element name="ALTER_LIST_ITEM">
      <!-- Composite-partitioning (modify_table_default_attrs) -->
      <xsl:call-template name="ModifyDefaultAttr">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$PartNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="ModifyDefaultAttr">
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="ParentNode" select="$PartNode"/>
       <xsl:with-param name="ObjType" select="$ObjType"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <xsl:for-each select="sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM">
     <xsl:if test="./@src or sxml:NAME/@value1 or sxml:TABLESPACE/@value1 or sxml:VALUES/@value1 or sxml:COMPRESS/@value1">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="ModifySubparts">
        <xsl:with-param name="TableNode" select="$TableNode"/>
        <xsl:with-param name="PartName" select="$PartNode/sxml:NAME"/>
        <xsl:with-param name="SubPartItems" select="$PartNode/sxml:SUBPARTITION_LIST/sxml:SUBPARTITION_LIST_ITEM"/>
        <xsl:with-param name="PartitionType" select="$PartitionType"/>
        <xsl:with-param name="ObjType" select="$ObjType"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
    </xsl:for-each>
   </xsl:when>
   <!-- range/list/hash partition -->
   <xsl:otherwise>
    <xsl:call-template name="ModifyParts">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$PartNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyDefaultAttr">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyDefaultAttr
ParentNode:sxml:PARTITION_LIST 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_TABLE_DEFAULT_ATTR</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY DEFAULT ATTRIBUTES FOR PARTITION </xsl:text>
       <xsl:value-of select="sxml:NAME"/>
       <!-- Segment_Attributes -->
       <xsl:call-template name="AlterSegmentAttributes">
        <xsl:with-param name="ParentNode" select="sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
       <!-- table_compression -->
       <xsl:call-template name="AlterCompress">
        <xsl:with-param name="ParentNode" select="$ParentNode/sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE"/>
       </xsl:call-template>
       <!-- PCTTHRESHOLD, index-org only 
            key_compression, index-org only 
            alter_overflow_clause, index-org only
            Done in AlterIot   -->
       <!-- LOb,LOB_parameters -->
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise/>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifySubparts">
  <xsl:param name="SubPartItems" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="PartName" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: ModifySubparts
ParentNode:sxml:SUBPARTITION_LIST 
******************************************************************** -->
  <xsl:if test="sxml:NAME/@value1">
   <xsl:call-template name="RenPartName">
    <xsl:with-param name="TableNode" select="$TableNode"/>
    <xsl:with-param name="ParentNode" select="$SubPartItems"/>
    <xsl:with-param name="PartType">SUBPARTITION</xsl:with-param>
    <xsl:with-param name="PartName" select="$PartName"/>
    <xsl:with-param name="ObjType" select="$ObjType"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="./@src or sxml:TABLESPACE/@value1 or sxml:COMPRESS/@value1">
   <xsl:call-template name="ModifySubpart">
    <xsl:with-param name="TableNode" select="$TableNode"/>
    <xsl:with-param name="PartName" select="$PartName"/>
    <xsl:with-param name="SubPartItems" select="$SubPartItems"/>
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="ObjType" select="$ObjType"/>
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="ModifySubpart">
    <xsl:with-param name="TableNode" select="$TableNode"/>
    <xsl:with-param name="PartName" select="$PartName"/>
    <xsl:with-param name="SubPartItems" select="$SubPartItems"/>
    <xsl:with-param name="PartitionType" select="$PartitionType"/>
    <xsl:with-param name="ObjType" select="$ObjType"/>
    <xsl:with-param name="Action">SQL</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ModifySubpart">
  <xsl:param name="SubPartItems" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="PartName" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifySubpart
ParentNode:sxml:SUBPARTITION_LIST 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_TABLE_SUBPARTITION</xsl:with-param>
      <xsl:with-param name="Value2">
       <xsl:choose>
        <xsl:when test="./@src='1'">
         <xsl:if test="$PartitionType='RANGE-LIST'">(DROP SUBPARTITION)</xsl:if>
        </xsl:when>
        <xsl:when test="./@src='2'">(ADD SUBPARTITION)</xsl:when>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">
       <xsl:choose>
        <xsl:when test="./@src='1'">
         <xsl:if test="$PartitionType !='RANGE-LIST'">DROP SUBPARTITION</xsl:if>
        </xsl:when>
        <xsl:when test="./@src='2'"/>
        <xsl:otherwise>
         <xsl:if test="sxml:VALUES/@value1">SUBPARTITION VALUES</xsl:if>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:choose>
     <xsl:when test="./@src='1'">
      <xsl:if test="$PartitionType='RANGE-LIST'">
       <xsl:element name="SQL_LIST">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:text>ALTER </xsl:text>
          <xsl:value-of select="$ObjType"/>
          <xsl:text> </xsl:text>
          <xsl:call-template name="SchemaName">
           <xsl:with-param name="ParentNode" select="$TableNode"/>
          </xsl:call-template>
          <xsl:text> DROP SUBPARTITION </xsl:text>
          <xsl:value-of select="sxml:NAME"/>
         </xsl:element>
        </xsl:element>
       </xsl:element>
      </xsl:if>
     </xsl:when>
     <xsl:when test="./@src='2'">
      <xsl:element name="SQL_LIST">
       <xsl:element name="SQL_LIST_ITEM">
        <xsl:element name="TEXT">
         <xsl:text>ALTER </xsl:text>
         <xsl:value-of select="$ObjType"/>
         <xsl:text> </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$TableNode"/>
         </xsl:call-template>
         <xsl:text> MODIFY PARTITION "</xsl:text>
         <xsl:value-of select="$PartName"/>
         <xsl:text>" ADD SUBPARTITION </xsl:text>
         <xsl:value-of select="sxml:NAME"/>
         <xsl:if test="sxml:VALUES">
          <xsl:text> VALUES (</xsl:text>
          <xsl:value-of select="sxml:VALUES"/>
          <xsl:text>) </xsl:text>
         </xsl:if>
         <xsl:text> TABLESPACE </xsl:text>
         <xsl:value-of select="sxml:TABLESPACE"/>
        </xsl:element>
       </xsl:element>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="sxml:TABLESPACE/@value1 or sxml:COMPRESS/@value1">
       <xsl:element name="SQL_LIST">
        <xsl:element name="SQL_LIST_ITEM">
         <xsl:element name="TEXT">
          <xsl:text>ALTER </xsl:text>
          <xsl:value-of select="$ObjType"/>
          <xsl:text> </xsl:text>
          <xsl:call-template name="SchemaName">
           <xsl:with-param name="ParentNode" select="$TableNode"/>
          </xsl:call-template>
          <xsl:text> MOVE SUBPARTITION </xsl:text>
          <xsl:value-of select="sxml:NAME"/>
          <!-- list_values_clause, this is unalteralbe -->
          <!-- xsl:if test="sxml:VALUES/@value1" -->
          <!-- tablespace -->
          <xsl:text> TABLESPACE "</xsl:text>
          <xsl:value-of select="sxml:TABLESPACE"/>
          <xsl:text>"</xsl:text>
          <xsl:call-template name="AlterCompress">
           <xsl:with-param name="ParentNode" select="."/>
          </xsl:call-template>
          <!-- overflow | tablespace -->
          <!-- LOB  -->
          <!-- VARRAY -->
         </xsl:element>
        </xsl:element>
       </xsl:element>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyParts">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: ModifyParts
ParentNode:sxml:PARTITION_LIST 
******************************************************************** -->
  <xsl:if test="sxml:NAME/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="RenPartName">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="PartType">PARTITION</xsl:with-param>
     <xsl:with-param name="PartName" select="sxml:NAME"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:if test="sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
     sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1 or
     sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
     sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE//@value1 or
     sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING/@value1 or
     sxml:COMPRESS/@value1 or
     sxml:COMPRESS/@src!='1' or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE//@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:COMPRESS/@src!='1' or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:PCTFREE/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:INITRANS/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:PCTUSED/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:STORAGE//@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:LOGGING/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:COMPRESS/@value1 or
     sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:COMPRESS/@src!='1' ">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="ModTabPart">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="ModTabPart">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- tablespace diff -->
  <xsl:if test="sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1 or sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1 or 
sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="MoveTabPart">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="MoveTabPart">
     <xsl:with-param name="TableNode" select="$TableNode"/>
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ObjType" select="$ObjType"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="MoveTabPart">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: MoveTabPart
ParentNode:sxml:PARTITION_LIST 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MOVE_TABLE_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> MOVE PARTITION </xsl:text>
       <xsl:value-of select="sxml:NAME"/>
       <xsl:text> TABLESPACE "</xsl:text>
       <xsl:value-of select="sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE|sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE | sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES/sxml:TABLESPACE"/>
       <xsl:text>"</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
    <!-- table_compression -->
    <xsl:call-template name="AlterCompress">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
    </xsl:call-template>
    <!-- PCTTHRESHOLD, index-org only -->
    <!-- key_compression, index-org only -->
    <!-- alter_overflow_clause, index-org only  -->
    <!-- LOb,LOB_parameters -->
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModTabPart">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModTabPart
ParentNode:sxml:PARTITION_LIST 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
					$PRS_CONSTRAINT_TYPE=1 or
					$PRS_CONSTRAINT_STATE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_TABLE_PARTITION</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER </xsl:text>
       <xsl:value-of select="$ObjType"/>
       <xsl:text> </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY PARTITION </xsl:text>
       <xsl:value-of select="sxml:NAME"/>
       <!-- Physical_Attributes -->
       <!-- xsl:call-template name="AlterSegmentAttributes" -->
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="sxml:SEGMENT_ATTRIBUTES |
sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES |
sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
       <!-- logging -->
       <xsl:call-template name="AlterLogging">
        <xsl:with-param name="ParentNode" select="sxml:SEGMENT_ATTRIBUTES |
sxml:PHYSICAL_PROPERTIES/sxml:HEAP_TABLE/sxml:SEGMENT_ATTRIBUTES |
sxml:PHYSICAL_PROPERTIES/sxml:INDEX_ORGANIZED_TABLE/sxml:SEGMENT_ATTRIBUTES"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="UnAlterTbs">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <!-- *******************************************************************
Template: UnAlterTbs
ParentNode:
******************************************************************** -->
  <xsl:if test="$ParentNode/@value1">
   <xsl:if test="$PRS_NAME=1 or 
        $PRS_CLAUSE_TYPE=1 or
	$PRS_CONSTRAINT_TYPE=1 or
	$PRS_CONSTRAINT_STATE=1 or
        $PRS_ALTERABLE=1 or
        $PRS_XPATH=1">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="$ParentNode"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="$TableNode/sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">TABLE TABLESPACE</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RenPartName">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="PartType" select="''"/>
  <xsl:param name="PartName" select="''"/>
  <xsl:param name="ObjType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: RenPartName
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="$PRS_NAME=1 or 
                  $PRS_CLAUSE_TYPE=1 or
                  $PRS_COLUMN_ATTRIBUTE=1 or
                  $PRS_ALTERABLE=1 or
                  $PRS_XPATH=1">
   <xsl:element name="PARSE_LIST">
    <xsl:call-template name="AddXPathParseItem">
     <xsl:with-param name="Node" select="$ParentNode"/>
    </xsl:call-template>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
     <xsl:with-param name="Item">NAME</xsl:with-param>
     <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
    </xsl:call-template>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
     <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
     <xsl:with-param name="Value1">
      <xsl:if test="$PartType='SUBPARTITION'">RENAME_SUBPARTITION_NAME</xsl:if>
      <xsl:if test="$PartType='PARTITION'">RENAME_PARTITION_NAME</xsl:if>
     </xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:element name="SQL_LIST">
   <xsl:element name="SQL_LIST_ITEM">
    <xsl:element name="TEXT">
     <xsl:text>ALTER </xsl:text>
     <xsl:value-of select="$ObjType"/>
     <xsl:text> </xsl:text>
     <xsl:call-template name="SchemaName">
      <xsl:with-param name="ParentNode" select="$TableNode"/>
     </xsl:call-template>
     <xsl:text> RENAME </xsl:text>
     <xsl:choose>
      <xsl:when test="$PartType='SUBPARTITION'">
       <xsl:text>SUBPARTITION </xsl:text>
      </xsl:when>
      <xsl:when test="$PartType='PARTITION'">
       <xsl:text>PARTITION </xsl:text>
      </xsl:when>
     </xsl:choose>
     <xsl:call-template name="QuotedName">
      <xsl:with-param name="NameNode" select="sxml:NAME/@value1"/>
     </xsl:call-template>
     <xsl:text> TO </xsl:text>
     <xsl:call-template name="QuotedName">
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterIntervalPartitioning">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <!-- *******************************************************************
Template: AlterIntervalPartitioning
ParentNode sxml:RANGE_PARTITIONING
TableNode  sxml:TABLE
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:INTERVAL">
   <xsl:choose>
    <xsl:when test="$ParentNode/sxml:INTERVAL/@src">
     <!-- interval to/from range -->
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="EnableDisableIntervalPartitioning">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="EnableDisableIntervalPartitioning">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:when test="$ParentNode/sxml:INTERVAL/@value1 or 
                $ParentNode/sxml:STORE_IN/@src='2' or
                $ParentNode/sxml:STORE_IN/sxml:STORE_IN_ITEM/@value1">
     <!-- modify interval or tablespace storage list -->
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="ModifyIntervalPartitioning">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="ModifyIntervalPartitioning">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:when test="$ParentNode/sxml:STORE_IN/@src='1'">
     <!-- delete tablespace storage list -->
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="DeleteIntervalPartitioningTBSList">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="DeleteIntervalPartitioningTBSList">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="TableNode" select="$TableNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="EnableDisableIntervalPartitioning">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: EnableDisableIntervalPartitioning:
 convert table between interval partitioned and range partitioned
ParentNode sxml:RANGE_PARTITIONING
TableNode  sxml:TABLE
Action     PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ENABLE_DISABLE_INTERVAL_PARTITIONING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> SET INTERVAL (</xsl:text>
       <xsl:value-of select="$ParentNode/sxml:INTERVAL[@src='2']"/>
       <xsl:text>)</xsl:text>
      </xsl:element>
     </xsl:element>
     <xsl:if test="$ParentNode/sxml:INTERVAL[@src='2'] and 
                ($ParentNode/sxml:STORE_IN/@src='2' or
                 $ParentNode/sxml:STORE_IN/sxml:STORE_IN_ITEM[@value1])">
      <xsl:element name="SQL_LIST_ITEM">
       <xsl:element name="TEXT">
        <xsl:text>ALTER TABLE </xsl:text>
        <xsl:call-template name="SchemaName">
         <xsl:with-param name="ParentNode" select="$TableNode"/>
        </xsl:call-template>
        <xsl:text> SET</xsl:text>
        <xsl:apply-templates select="$ParentNode/sxml:STORE_IN"/>
       </xsl:element>
      </xsl:element>
     </xsl:if>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ModifyIntervalPartitioning">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: ModifyIntervalPartitioning
ParentNode sxml:RANGE_PARTITIONING
TableNode  sxml:TABLE
Action     PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">MODIFY_INTERVAL_PARTITIONING</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:if test="$ParentNode/sxml:INTERVAL/@value1">
      <xsl:element name="SQL_LIST_ITEM">
       <xsl:element name="TEXT">
        <xsl:text>ALTER TABLE </xsl:text>
        <xsl:call-template name="SchemaName">
         <xsl:with-param name="ParentNode" select="$TableNode"/>
        </xsl:call-template>
        <xsl:text> SET</xsl:text>
        <xsl:apply-templates select="$ParentNode/sxml:INTERVAL"/>
       </xsl:element>
      </xsl:element>
     </xsl:if>
     <xsl:if test="$ParentNode/sxml:STORE_IN/@src='2' or
                $ParentNode/sxml:STORE_IN/sxml:STORE_IN_ITEM[@value1]">
      <xsl:element name="SQL_LIST_ITEM">
       <xsl:element name="TEXT">
        <xsl:text>ALTER TABLE </xsl:text>
        <xsl:call-template name="SchemaName">
         <xsl:with-param name="ParentNode" select="$TableNode"/>
        </xsl:call-template>
        <xsl:text> SET</xsl:text>
        <xsl:apply-templates select="$ParentNode/sxml:STORE_IN"/>
       </xsl:element>
      </xsl:element>
     </xsl:if>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DeleteIntervalPartitioningTBSList">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="TableNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DeleteIntervalPartitioningTBSList
ParentNode sxml:RANGE_PARTITIONING
TableNode  sxml:TABLE
Action     PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$ParentNode/sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DELETE_TABLESPACE_LIST</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <!-- bug 6890349: to delete the tablespace list, have to turn off
         interval partitioning, then turn it on again without the list -->
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> SET INTERVAL ()</xsl:text>
      </xsl:element>
     </xsl:element>
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TABLE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TableNode"/>
       </xsl:call-template>
       <xsl:text> SET</xsl:text>
       <xsl:apply-templates select="$ParentNode/sxml:INTERVAL"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
