<?xml version="1.0"?>
<!--
NAME
    kuatrig.xsl
DESCRIPTION
    Convert sxml TRIGGER diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    abodge      08/17/07 - On-object change not alterable
    lbarton     01/02/07 - more features
    rapayne     06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kustrigc.xsl"/>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:TRIGGER">
  <!-- *******************************************************************
Template: TRIGGER - top-level template for triggers.
******************************************************************** -->
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">TRIGGER</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <xsl:if test="sxml:SCHEMA[@value1] or
                  sxml:TRIGGER_TYPE[@value1] or
                  sxml:DML_EVENT//@src or
                  sxml:DDL_EVENT//@src or
                  sxml:DATABASE_EVENT//@src or
                  sxml:DML_EVENT//@value1 or
                  sxml:DDL_EVENT//@value1 or
                  sxml:DATABASE_EVENT//@value1">
     <xsl:call-template name="RecreateTrigger"/>
    </xsl:if>
    <xsl:if test="sxml:DISABLE[@src]">
     <xsl:call-template name="EnableDisableTrigger"/>
    </xsl:if>
    <xsl:if test="sxml:NAME[@value1]">
     <xsl:call-template name="RenameTrigger"/>
    </xsl:if>
    <!-- Added by CM to fix test case 49 -->
    <xsl:if test="sxml:DML_EVENT/sxml:SCHEMA//@value1 or
                  sxml:DML_EVENT/sxml:NAME//@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">ON_OBJECT</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:if>  
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="RecreateTrigger">
  <!-- *******************************************************************
Template: RecreateTrigger - generate CREATE OR REPLACE trigger
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="DoTrigParseList">
    <xsl:with-param name="ClauseType">REPLACE</xsl:with-param>
   </xsl:call-template>
   <xsl:element name="SQL_LIST">
    <xsl:element name="SQL_LIST_ITEM">
     <xsl:element name="TEXT">
      <xsl:call-template name="CreTrigger"/>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoTrigParseList">
  <xsl:param name="ClauseType" select="''"/>
  <!-- *******************************************************************
Template: DoTrigParseList - common template to generate parse list
 ClauseType - REPLACE, DISABLE, RENAME
******************************************************************** -->
  <xsl:if test="$PRS_NAME=1 or 
                $PRS_CLAUSE_TYPE=1 or
                $PRS_ALTERABLE=1 or
                $PRS_XPATH=1">
   <xsl:element name="PARSE_LIST">
    <xsl:choose>
     <xsl:when test="$ClauseType='REPLACE'">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="."/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="$ClauseType='DISABLE'">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="sxml:DISABLE"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="$ClauseType='RENAME'">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="sxml:NAME"/>
      </xsl:call-template>
     </xsl:when>
    </xsl:choose>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
     <xsl:with-param name="Item">NAME</xsl:with-param>
     <xsl:with-param name="Value1">
      <xsl:choose>
       <xsl:when test="sxml:NAME[@value1]">
        <xsl:value-of select="sxml:NAME/@value1"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="sxml:NAME"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
     <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
     <xsl:with-param name="Value1" select="$ClauseType"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="EnableDisableTrigger">
  <!-- *******************************************************************
Template: EnableDisableTrigger 
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="DoTrigParseList">
    <xsl:with-param name="ClauseType">DISABLE</xsl:with-param>
   </xsl:call-template>
   <xsl:element name="SQL_LIST">
    <xsl:element name="SQL_LIST_ITEM">
     <xsl:element name="TEXT">
      <xsl:text>ALTER TRIGGER </xsl:text>
      <xsl:call-template name="SchemaName">
       <xsl:with-param name="ParentNode" select="."/>
      </xsl:call-template>
      <xsl:choose>
       <xsl:when test="sxml:DISABLE/@src='1'"> ENABLE</xsl:when>
       <xsl:when test="sxml:DISABLE/@src='2'"> DISABLE</xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="RenameTrigger">
  <!-- *******************************************************************
Template: RenameTrigger 
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:call-template name="DoTrigParseList">
    <xsl:with-param name="ClauseType">RENAME</xsl:with-param>
   </xsl:call-template>
   <xsl:element name="SQL_LIST">
    <xsl:element name="SQL_LIST_ITEM">
     <xsl:element name="TEXT">
      <xsl:text>ALTER TRIGGER </xsl:text>
      <xsl:call-template name="SchemaName">
       <xsl:with-param name="ParentNode" select="."/>
      </xsl:call-template>
      <xsl:text> RENAME TO </xsl:text>
      <xsl:call-template name="QuotedName">
       <xsl:with-param name="NameNode" select="sxml:NAME"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
