<?xml version="1.0"?>
<!--
NAME
    kuaview.xsl
DESCRIPTION
    Convert sxml VIEW diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:VIEW">
  <xsl:element name="ALTER_XML">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">VIEW</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!--check if index is alterable  -->
    <xsl:call-template name="checkAlterable">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!--check if index is read_only -->
    <xsl:call-template name="checkReadOnly">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="checkAlterable">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: checkAlterable - Detects certain non-alterable cases
 1. View NAME change
 2. COL_LIST diffs
 3. SUBQUERY diffs
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 Action = "PARSE"
******************************************************************** -->
  <xsl:if test="$PRS_NAME=1 or 
                      $PRS_CLAUSE_TYPE=1 or
                      $PRS_ALTERABLE=1 or
                      $PRS_XPATH=1">
   <!-- Check for VIEW NAME differences -->
   <xsl:if test="./sxml:NAME/@value1">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:element name="PARSE_LIST">
      <xsl:call-template name="AddXPathParseItem">
       <xsl:with-param name="Node" select="./sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
       <xsl:with-param name="Item">NAME</xsl:with-param>
       <xsl:with-param name="Value1" select="sxml:NAME"/>
      </xsl:call-template>
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">VIEW_NAME</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:element>
   </xsl:if>
   <!-- Check for COL_LIST  difference -->
   <xsl:for-each select="./sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:if test="./@src or sxml:NAME/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="."/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
        <xsl:with-param name="Item">NAME</xsl:with-param>
        <xsl:with-param name="Value1" select="sxml:NAME"/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">COLUMNS</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
  <!-- Check for SUBQUERY differences -->
  <xsl:if test="./sxml:SUBQUERY/@value1">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="./sxml:SUBQUERY"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
             <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">SUBQUERY</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
      <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
      <xsl:with-param name="Value1">SUBQUERY</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="checkReadOnly">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: checkReadOnly- 
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:if test="./sxml:READ_ONLY/@src">
   <xsl:call-template name="alterReadOnlyView">
    <xsl:with-param name="Action">PARSE</xsl:with-param>
   </xsl:call-template>
   <xsl:if test="./sxml:EDITIONING_VIEW">
    <xsl:call-template name="alterReadOnlyView">
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="alterReadOnlyView">
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: alterReadOnlyView - only possible to alter EDITIONING VIEWS. 
      If READ_ONLY has been alter and not an editioning view then only
      a not alteralbe parse item is generated.
Parameters:
Action - PARSE or ACTION
******************************************************************** -->
  <xsl:if test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
   <!-- Check for READ_ONLY differences -->
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="./sxml:READ_ONLY"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="./sxml:READ_ONLY/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">READ_WRITE</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">READ_ONLY</xsl:with-param>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:if test="not (./sxml:EDITIONING_VIEW)">
      <xsl:call-template name="AddParseItem">
       <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
       <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
       <xsl:with-param name="Value1">NOT_EDITIONING_VIEW</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
