<?xml version="1.0"?>
<!-- 
NAME
    kucommon.xsl
DESCRIPTION
    Templates for common and utility functions
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    abodge      03/17/09 - Set VERSION param
    lbarton     11/02/07 - bug 6605086: escape single quote
    lbarton     10/31/07 - bug 6051635: map SYS_NC_ROWINFO$ to pseudocolumn
                           OBJECT_VALUE
    rapayne     10/02/07 - bug 6088114: add supertype_obj to schema obj template 
    sdavidso    11/08/05 - Fix error importing tables w/multi XMLtype cols
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     07/18/03 - Bug 3045926: move common PLSQL processing here
    lbarton     05/16/03 - bug 2949397: support INDEXTYPE options
    lbarton     04/11/03 - new param to SCHEMA_OBJ template
    lbarton     10/09/02 - add row parsing
    bmccarth    08/22/02 - Add EMIT_SCHEMA 
    htseng      08/02/02 - add grantee params
    htseng      07/25/02 - add BaseSchemaNode, BaseNameNode and BaseObjectType
    htseng      09/24/01 - fix missing kujob.xsl.
    htseng      09/04/01 - add STATS_OBJ.
    gclaborn    11/03/00 - change name
    lbarton	09/28/00 - add ColNameOrAttr
    gclaborn	06/27/00 - Remove <dummy/> element
    lbarton	06/23/00 - Multinested collections
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top-level parameters -->
 <xsl:param name="EMIT_SCHEMA">1</xsl:param>
 <xsl:param name="PRS_ROW">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="VERSION">9999999999</xsl:param>
 <!-- All DDL is text, and this is the only way to correctly render '<' -->
 <xsl:output method="text"/>
 <!-- Top level template for all objects -->
 <xsl:template match="/">
  <xsl:for-each select="RESULTSET/ROW | ROWSET/ROW">
   <xsl:if test="$PRS_ROW=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>D</xsl:text>
    <xsl:value-of select="position()"/>
    <xsl:value-of select="$PRS_DELIM"/>
   </xsl:if>
   <xsl:apply-templates/>
  </xsl:for-each>
 </xsl:template>
 <!-- Formats a schema object name -->
 <xsl:template match="SCHEMA_OBJ | BASE_OBJ | IMPL_OBJ | OPER_OBJ | STATS_OBJ
  | BASETYPE_OBJ | ARRAYTYPE_OBJ | SUPERTYPE_OBJ">
  <xsl:param name="TrailingBlank">1</xsl:param>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Schema" select="OWNER_NAME"/>
   <xsl:with-param name="Object" select="NAME"/>
  </xsl:call-template>
  <xsl:if test="$TrailingBlank!=0">
   <xsl:text>&#x20;</xsl:text>
  </xsl:if>
 </xsl:template>
 <!-- Utility routine to form a qualified schema object name; e.g,  "a"."b" -->
 <xsl:template name="QuoteObject">
  <xsl:param name="Schema"/>
  <xsl:param name="Object"/>
  <xsl:if test="$EMIT_SCHEMA=1">
   <xsl:if test="string-length($Schema)!=0">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="$Schema"/>
    <xsl:text>"</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="string-length($Object)!=0">
   <xsl:if test="$EMIT_SCHEMA=1">
    <xsl:if test="string-length($Schema)!=0">
     <xsl:text>.</xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:text>"</xsl:text>
   <xsl:value-of select="$Object"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
 </xsl:template>
 <!-- emit a column name or attrname depending on property bit -->
 <xsl:template name="ColNameOrAttr">
  <xsl:param name="ColItem">0</xsl:param>
  <!-- use FULLATTRNAME if it exists, otherwise use ATTRNAME if it exists, otherwise NAME
       (The old test was "1>($ColItem/PROPERTY mod 2)" -->
  <xsl:choose>
   <xsl:when test="$ColItem/FULLATTRNAME">
    <xsl:value-of select="$ColItem/FULLATTRNAME"/>
   </xsl:when>
   <xsl:when test="$ColItem/ATTRNAME">
    <xsl:value-of select="$ColItem/ATTRNAME"/>
    <!-- already in quotes -->
   </xsl:when>
   <xsl:when test="$ColItem/NAME='SYS_NC_ROWINFO$'">
     <!-- SQL Ref Manual says to use pseudocolumn OBJECT_VALUE instead of
          SYS_NC_ROWINFO$ -->
    <xsl:text>OBJECT_VALUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>"</xsl:text>
    <!-- must supply quotes -->
    <xsl:value-of select="$ColItem/NAME"/>
    <xsl:text>"</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <!-- Processes the logging bit in the FLAGS element -->
 <xsl:template name="DoLogging">
  <xsl:param name="FlagsNode" select="''"/>
  <!-- No Logging is bit 0x20 in FLAGS=1: MOD 64 to capture bit 0x20 in result,
     then test if high bit of result is on.
-->
  <xsl:choose>
   <xsl:when test="($FlagsNode mod 64)>=32">NOLOGGING</xsl:when>
   <xsl:otherwise>LOGGING</xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <!-- Emits terminating / with or without preceding lf -->
 <xsl:template name="DoTerminator">
  <xsl:param name="Text"/>
  <xsl:if test="$SQLTERMINATOR=1">
   <!-- test whether Text ends in lf; if not, insert lf before / -->
   <xsl:choose>
    <xsl:when test="substring($Text,string-length($Text),1)!=
            substring(normalize-space($Text),
                         string-length(normalize-space($Text)),1)">/</xsl:when>
    <xsl:otherwise>
/</xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <!-- Processes the parse items -->
 <xsl:template name="DoParse">
  <xsl:param name="Verb"/>
  <xsl:param name="ObjectType"/>
  <xsl:param name="SchemaNode" select="''"/>
  <xsl:param name="NameNode" select="''"/>
  <xsl:param name="Grantee" select="''"/>
  <xsl:param name="Grantor" select="''"/>
  <xsl:param name="BaseObjectType" select="''"/>
  <xsl:param name="BaseSchemaNode" select="''"/>
  <xsl:param name="BaseNameNode" select="''"/>
  <xsl:if test="$PRS_VERB=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AVERB</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$Verb"/>
  </xsl:if>
  <xsl:if test="$PRS_OBJECT_TYPE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AOBJECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$ObjectType"/>
  </xsl:if>
  <xsl:if test="$PRS_SCHEMA=1 and $SchemaNode != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$SchemaNode"/>
  </xsl:if>
  <xsl:if test="$PRS_NAME=1 and $NameNode != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ANAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$NameNode"/>
  </xsl:if>
  <xsl:if test="$PRS_GRANTEE=1 and $Grantee != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AGRANTEE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$Grantee"/>
  </xsl:if>
  <xsl:if test="$PRS_GRANTOR=1 and $Grantor != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AGRANTOR</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$Grantor"/>
  </xsl:if>
  <xsl:if test="$PRS_BASE_OBJECT_TYPE=1 and $BaseObjectType != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABASE_OBJECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$BaseObjectType"/>
  </xsl:if>
  <xsl:if test="$PRS_BASE_OBJECT_SCHEMA=1 and $BaseSchemaNode != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABASE_OBJECT_SCHEMA</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$BaseSchemaNode"/>
  </xsl:if>
  <xsl:if test="$PRS_BASE_OBJECT_NAME=1 and $BaseNameNode != ''">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ABASE_OBJECT_NAME</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="$BaseNameNode"/>
  </xsl:if>
  <xsl:if test="$PRS_DDL=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>C</xsl:text>
  </xsl:if>
 </xsl:template>
 <!-- common code for ku$_procobj_lines 
     (used by kuprocoj.xsl and kuidxwrk.xsl
 -->
 <xsl:template match="PLSQL">
  <xsl:param name="Objecttype">""</xsl:param>
  <xsl:param name="Schemanode">""</xsl:param>
  <xsl:param name="Namenode">""</xsl:param>
  <xsl:param name="Baseschemanode">""</xsl:param>
  <xsl:param name="Basenamenode">""</xsl:param>
  <xsl:param name="Baseobjecttype">""</xsl:param>
  <!-- Each PLSQL_ITEM is an anonymous PLSQL block -->
  <xsl:for-each select="PLSQL_ITEM">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="ObjectType" select="$Objecttype"/>
    <xsl:with-param name="SchemaNode" select="$Schemanode"/>
    <xsl:with-param name="NameNode" select="$Namenode"/>
    <xsl:with-param name="BaseSchemaNode" select="$Baseschemanode"/>
    <xsl:with-param name="BaseNameNode" select="$Basenamenode"/>
    <xsl:with-param name="BaseObjectType" select="$Baseobjecttype"/>
    <xsl:with-param name="Grantor" select="GRANTOR"/>
   </xsl:call-template>
   <!-- start with BEGIN -->
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>BEGIN </xsl:text>
   <!-- Each LOCS_ITEM is a line of code -->
   <xsl:for-each select="LOCS/LOCS_ITEM">
    <!-- NEWBLOCK = -2 means append this line to the previous one -->
    <xsl:if test="NEWBLOCK!=-2">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:value-of select="LINE_OF_CODE"/>
   </xsl:for-each>
   <!-- finish with COMMIT; END; -->
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>COMMIT; </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>END; </xsl:text>
   <xsl:text>&#xa;</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>/ </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="EscapeString">
  <xsl:param name="OrigStr"/>
  <xsl:param name="Leading"/>
  <xsl:param name="Trailing"/>
  <xsl:param name="NullVal"/>
  <!-- *******************************************************************
Template: EscapeString
  If a string has an apos in it, it needs 2 because of sql.
  So emit the string escaping the apos characters
Parameters:
 OrigString - string containing apos chars
 Leading    - string to precede
 Trailing   - string to trail
 NullVal    - what to put out if OrigString is null
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($OrigStr)=0">
    <xsl:value-of select="$NullVal"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:variable name="APOS">&apos;</xsl:variable>
    <xsl:value-of select="$Leading"/>
    <xsl:choose>
     <xsl:when test="contains($OrigStr, $APOS)">
      <xsl:value-of select="substring-before($OrigStr, $APOS)"/>
      <xsl:text>''</xsl:text>
      <xsl:call-template name="EscapeString">
       <xsl:with-param name="OrigStr" select="substring-after($OrigStr,$APOS)"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$OrigStr"/>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$Trailing"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

</xsl:stylesheet>
