<?xml version="1.0"?>
<!-- Copyright (c) 2006, 2009, Oracle and/or its affiliates.
All rights reserved. -->
<!-- 
  NAME
    kucot.xsl
  DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of COT ADTs
  NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

   MODIFIED   (MM/DD/YY)
     abodge    01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
     cchiappa  03/22/07 - DIMENSION USING support
     cchiappa  01/11/07 - WITH REDUCED PRECISION
     cchiappa  12/15/06 - Support all ET mappings
     cchiappa  09/11/06 - Support full syntax
     cchiappa  04/17/06 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <!-- Templates -->
  <xsl:template name="GenCubeObjWithQDR">
    <xsl:param name="Data" select="''"/>
  <!-- *******************************************************************
Template: GenCubeObjWithQDR - Generate a object reference, possibly with
                              a QDR
Parameters:
 Data - ku$_cube_fact_t object node for a single fact
******************************************************************** -->

    <!-- Object name -->
    <xsl:text>"</xsl:text>
    <xsl:value-of select="$Data/OBJ"/>
    <xsl:text>"</xsl:text>
    <!-- Object QDR, if it exists -->
    <xsl:if test="$Data/QDR">
      <xsl:text>("</xsl:text> 
      <xsl:value-of select="$Data/QDR"/>
      <xsl:text>" '</xsl:text>     
      <xsl:value-of select="$Data/QDRVAL"/>
      <xsl:text>')</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template name="GenCubeMapClause">
    <xsl:param name="KeyWord" select="''"/>
    <xsl:param name="Map" select="''"/>
  <!-- *******************************************************************
Template: GenCubeMapClause - Generate a generic column-aw object mapping
                             clause
Parameters:
 KeyWord - String to lead off mapping clause
 Map - ku$_cube_fact_t object node with the column name and object
******************************************************************** -->

    <xsl:value-of select="$KeyWord"/>
    <xsl:text> </xsl:text>
    <xsl:call-template name="GenCubeObjWithQDR">
      <xsl:with-param name="Data" select="$Map"/>
    </xsl:call-template>
    <!-- Does this have a corresponding column name to emit? -->
    <xsl:if test="$Map/COLNAME">
      <xsl:text> IS "</xsl:text>
      <xsl:value-of select="$Map/COLNAME"/>
      <xsl:text>"</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template name="GenCubeHierClause">
    <xsl:param name="Hier" select="''"/>
  <!-- *******************************************************************
Template: GenCubeHierClause - Generate a DIMENSION's HIERARCHY clause
Parameters:
 Hier - ku$_cube_hier_t object node for a single hierarchy
******************************************************************** -->

    <xsl:text> HIERARCHY "</xsl:text>
    <xsl:value-of select="$Hier/REL"/>
    <xsl:text>"</xsl:text>
    <xsl:choose>
      <!-- PARENT-CHILD hierarchy -->
      <xsl:when test="$Hier/LEVELS/LEVELS_ITEM/FLAGS=1">
        <xsl:text> PARENT "</xsl:text>
        <xsl:value-of select="$Hier/LEVELS/LEVELS_ITEM[last()]/COLNAME"/>
        <xsl:text>"</xsl:text>
      </xsl:when>
      <!-- LEVEL-based hierarchy -->
      <xsl:otherwise>
        <xsl:if test="$PRETTY=1">
          <xsl:text>&#xa;        </xsl:text>
        </xsl:if>
        <xsl:text> (</xsl:text>
        <!-- Enumerate through levels, which should have been sorted in
             order already by the view objects were retrieved from -->
        <xsl:for-each select="$Hier/LEVELS/LEVELS_ITEM">
          <xsl:call-template name="GenCubeObjWithQDR">
            <xsl:with-param name="Data" select="current()"/>
          </xsl:call-template>
          <xsl:if test="not(position()=last())">
            <xsl:text> CHILD OF </xsl:text>
            <xsl:if test="$PRETTY=1">
              <xsl:text>&#xa;          </xsl:text>
            </xsl:if>
          </xsl:if>
        </xsl:for-each>
        <xsl:text>)</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="GenCubeMapList">
    <xsl:param name="KeyWord" select="''"/>
    <xsl:param name="MapList" select="''"/>
  <!-- *******************************************************************
Template: GenCubeMapList - Generate a non-comma-separated list of MAPs
Parameters:
 KeyWord - Text to prepend before each element
 MapList - ku$_cube_fact_list_t object node list
******************************************************************** -->
    <xsl:for-each select="$MapList">
      <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;      </xsl:text>
      </xsl:if>
      <xsl:text> </xsl:text>     
      <xsl:call-template name="GenCubeMapClause">
        <xsl:with-param name="KeyWord" select="$KeyWord"/>
        <xsl:with-param name="Map" select="current()"/>
      </xsl:call-template>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="GenCubeDimClause">
    <xsl:param name="Dimen" select="''"/>
  <!-- *******************************************************************
Template: GenCubeDimClause - Generate a single DIMENSION clause for an
                              ORGANIZATION CUBE table
Parameters:
 Dimen - ku$_cube_dim_t object node for a single dimension
******************************************************************** -->

    <xsl:choose>
      <!-- If this dimension has an ET key, it has a full map
           available.  -->
      <xsl:when test="$Dimen/COLNAME">
        <xsl:call-template name="GenCubeMapClause">
          <xsl:with-param name="KeyWord">DIMENSION</xsl:with-param>
          <xsl:with-param name="Map" select="$Dimen"/>
        </xsl:call-template>
      </xsl:when>
      <!-- Level-based dimensions don't necessarily have a mapping
           column (the columns are all mapped to levels) so only
           output the dimension name -->
      <xsl:otherwise>
        <xsl:text>DIMENSION "</xsl:text>
        <xsl:value-of select="$Dimen/OBJ"/>
        <xsl:text>"</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$Dimen/DIMUSING">
      <xsl:text> USING "</xsl:text>
      <xsl:value-of select="$Dimen/DIMUSING"/>
      <xsl:text>"</xsl:text>
    </xsl:if>
    <!-- Unordered list of levels which are later assembled into a
         hierarchy in the HIERARCHY subclause -->
    <xsl:call-template name="GenCubeMapList">
      <xsl:with-param name="KeyWord">LEVEL</xsl:with-param>
      <xsl:with-param name="MapList" select="$Dimen/LEVELS/LEVELS_ITEM"/>
    </xsl:call-template>
    <!-- Generate HIERARCHY clause(s) for this dimension -->
    <xsl:for-each select="$Dimen/HIERS/HIERS_ITEM">
      <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;      </xsl:text>
      </xsl:if>
      <xsl:call-template name="GenCubeHierClause">
        <xsl:with-param name="Hier" select="current()"/>
      </xsl:call-template>
    </xsl:for-each>
    <!-- Generate GROUPING ID -->
    <xsl:call-template name="GenCubeMapList">
      <xsl:with-param name="KeyWord">GROUPING ID</xsl:with-param>
      <xsl:with-param name="MapList" select="$Dimen/GID/GID_ITEM"/>
    </xsl:call-template>
    <!-- Generate PARENT GROUPING ID -->
    <xsl:call-template name="GenCubeMapList">
      <xsl:with-param name="KeyWord">PARENT GROUPING ID</xsl:with-param>
      <xsl:with-param name="MapList" select="$Dimen/PGID/PGID_ITEM"/>
    </xsl:call-template>
    <!-- Generate ATTRIBUTEs -->
    <xsl:call-template name="GenCubeMapList">
      <xsl:with-param name="KeyWord">ATTRIBUTE</xsl:with-param>
      <xsl:with-param name="MapList" select="$Dimen/ATTRS/ATTRS_ITEM"/>
    </xsl:call-template>

  </xsl:template>

  <xsl:template name="GenCubeFactClause">
    <xsl:param name="Fact" select="''"/>
  <!-- *******************************************************************
Template: GenCubeFactClause -
Parameters:
 Fact - ku$_cube_fact_t object node for a single fact
******************************************************************** -->
    <xsl:call-template name="GenCubeMapClause">
      <xsl:with-param name="KeyWord">FACT</xsl:with-param>
      <xsl:with-param name="Map" select="$Fact"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="GenCubeTableClauses">
    <xsl:param name="CubeTab" select="''"/>
    <xsl:param name="PrettyCR" select="''"/>
  <!-- *******************************************************************
Template: GenCubeTableCaluses - generate information for ORGANIZATION CUBE
                                tables
Parameters:
 CubeTab - ku$_cube_tab_t object node for table
 PrettyCR - Whether a carriage return needs to be printed first when
            pretty-printing
  Emit the following:
   - ORGANIZATION CUBE clause including:
   -   ON awname
   -   FACTs
   -   DIMENSIONs and associated attributes
   - table partitioning
   - CACHE
   - parallel clause
   - row dependencies
   - row movement
******************************************************************** -->
    <!-- MV and TABLE output is different enough that we need to cheeze
         the output a little bit here to get something reasonable in
         both cases -->
    <xsl:if test="$PRETTY=1 and $PrettyCR=1">
      <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text> ORGANIZATION CUBE </xsl:text>
    <!-- If marked as being built on a pre-existing AW, name it here -->
    <xsl:if test="($CubeTab/FLAGS mod 2) = 1">
      <xsl:text>ON "</xsl:text>
      <xsl:value-of select="$CubeTab/AWNAME"/>
      <xsl:text>" </xsl:text>
    </xsl:if>
    <!-- Check for WITH REDUCED PRECISION -->
    <xsl:if test="($CubeTab/FLAGS mod 8) >= 4">
      <xsl:text>WITH REDUCED PRECISION </xsl:text>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <!-- If syntax was not automatically deduced, output it here -->
    <xsl:if test="not(($CubeTab/FLAGS mod 4) >= 2)">
      <xsl:text>( </xsl:text>
      <!-- Generate DIMENSION clauses first -->
      <xsl:for-each select="$CubeTab/DIMS/DIMS_ITEM">
        <xsl:call-template name="GenCubeDimClause">
          <xsl:with-param name="Dimen" select="current()"/>
        </xsl:call-template>
        <xsl:if test="not(position()=last()) or ../../FACTS/FACTS_ITEM or ../../CGID/CGID_ITEM">
          <xsl:text>,</xsl:text>
          <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa;     </xsl:text>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
      <!-- Now generate FACT clauses -->
      <xsl:for-each select="$CubeTab/FACTS/FACTS_ITEM">
        <xsl:call-template name="GenCubeFactClause">
          <xsl:with-param name="Fact" select="current()"/>
        </xsl:call-template>
        <xsl:if test="CCOLNAME">
          <xsl:text> COUNT IS "</xsl:text>
          <xsl:value-of select="CCOLNAME"/>
          <xsl:text>"</xsl:text>
        </xsl:if>
        <xsl:if test="not(position()=last()) or ../../CGID/CGID_ITEM">
          <xsl:text>, </xsl:text>
          <xsl:if test="$PRETTY=1">
            <xsl:text>&#xa;     </xsl:text>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
      <!-- Finally, the CGID clause -->
      <xsl:if test="$CubeTab/CGID/CGID_ITEM">
        <xsl:text>GROUPING ID (</xsl:text>
        <xsl:for-each select="$CubeTab/CGID/CGID_ITEM">
          <xsl:text>"</xsl:text>
          <xsl:value-of select="OBJ"/>
          <xsl:text>"</xsl:text>
          <xsl:if test="not(position()=last())">
            <xsl:text>, </xsl:text>
          </xsl:if>
        </xsl:for-each>
        <xsl:text>) IS "</xsl:text>
        <xsl:value-of select="$CubeTab/CGID/CGID_ITEM[1]/PCOLNAME"/>
        <xsl:text>"</xsl:text>
      </xsl:if>
      <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;   </xsl:text>
      </xsl:if>
      <xsl:text>) </xsl:text>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
