<?xml version="1.0"?>
<!-- 
NAME
    kuntab.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of nested tables
    (broken out of kutable.xsl for code hygiene)
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    htseng      05/21/07 - bug 5451654
    lbarton     01/20/06 - partition transportable 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kutabcon.xsl"/>
 <!-- Templates -->
 <xsl:template match="NT">
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: NT - Top-level nested table only.
       NT - parent node: NT/NTS is the list of nested tables
Parameters:
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <xsl:call-template name="DoNTStoreAs">
   <xsl:with-param name="Node" select="NTS"/>
   <xsl:with-param name="ParentObjNum" select="OBJ_NUM"/>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
  </xsl:call-template>
 </xsl:template>
 <!-- All levels of Nested Table -->
 <xsl:template name="DoNTStoreAs">
  <xsl:param name="Node" select="''"/>
  <xsl:param name="ParentObjNum">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoNTStoreAs
Parameters:
  Node - parent node of NTS_ITEM
  ParentObjNum - object number of parent table of nested tables
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************* -->
  <!-- bug 4347010: skip unused columns -->
  <xsl:for-each select="$Node/NTS_ITEM[OBJ_NUM=$ParentObjNum and
              (32768 > (COL/PROPERTY mod 65536))]">
   <xsl:sort select="INTCOL_NUM" data-type="number"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:choose>
    <!-- column is varray stored as table -->
    <xsl:when test="COL/TYPE_NUM='123'">
     <xsl:text> VARRAY </xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="COL"/>
     </xsl:call-template>
     <xsl:text> STORE AS TABLE </xsl:text>
    </xsl:when>
    <!-- column is nested table type;
         putting this code in the otherwise-tag
         allows this to work for 9.0 xml docs.
         Those docs don't have a COL/TYPE_NUM element.
         (Varrays stored as tables were not supported before 9.2
         so there was no need for a COL/TYPE_NUM element.) -->
    <xsl:otherwise>
     <xsl:text> NESTED TABLE </xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="COL"/>
     </xsl:call-template>
     <xsl:text> STORE AS </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="''"/>
    <xsl:with-param name="Object" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <!-- Add any needed Nested tabls storage clause parens -->
   <xsl:call-template name="EmitStorageTablePropertiesParen">
    <xsl:with-param name="Node" select="$Node"/>
    <xsl:with-param name="OpenParen">1</xsl:with-param>
   </xsl:call-template>
   <!-- Emit any needed constraints, inside separate parens -->
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 128)>=64">
     <!-- IOT -->
     <xsl:call-template name="TablePropertyParen">
      <xsl:with-param name="OpenParen">1</xsl:with-param>
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="IONT"/>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="IONT"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">0</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="TablePropertyParen">
      <xsl:with-param name="OpenParen">0</xsl:with-param>
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="IONT"/>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <!-- Heap -->
     <xsl:call-template name="TablePropertyParen">
      <xsl:with-param name="OpenParen">1</xsl:with-param>
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="HNT"/>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="HNT"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">0</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="TablePropertyParen">
      <xsl:with-param name="OpenParen">0</xsl:with-param>
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="HNT"/>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <!-- Emit non constraint storage properties -->
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 128)>=64">
     <!-- IOT -->
     <xsl:text> ORGANIZATION INDEX PCTTHRESHOLD </xsl:text>
     <xsl:value-of select="IONT/PCT_THRESH"/>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
     <xsl:text> </xsl:text>
     <xsl:if test="$SEGMENT_ATTRIBUTES=1">
      <xsl:apply-templates select="IONT/PCT_FREE">
       <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
      </xsl:apply-templates>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <!-- if this is equipartitioned table -->
     <!-- flags bit 131072: move partitioned rows -->
     <!-- not generate PCTFREE, PCTUSED,INTRANS,MAXTRAN --> 
     <xsl:if test="131072>= ((HNT/FLAGS) mod 262144)">
      <xsl:if test="$SEGMENT_ATTRIBUTES=1">
       <xsl:apply-templates select="HNT/PCT_FREE"/>
      </xsl:if>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="(HNT | IONT)/FLAGS"/>
    </xsl:call-template>
    <!-- nested table storage; if nested table is an IOT, dataobj#
         is stored in STORAGE/HWMINCR -->
    <xsl:apply-templates select="HNT/STORAGE">
     <xsl:with-param name="Nested">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="HNT/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="IONT/STORAGE">
     <xsl:with-param name="Nested">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="IONT/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="IONT/STORAGE/HWMINCR"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:apply-templates>
    <xsl:if test="$VERSION>=1000000000">
     <!-- Nested table tablespace -->
     <xsl:if test="$TABLESPACE=1">
      <xsl:if test="string-length(HNT/TS_NAME)!=0">
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa; </xsl:text>
       </xsl:if>
       <xsl:text> TABLESPACE "</xsl:text>
       <xsl:value-of select="HNT/TS_NAME"/>
       <xsl:text>" </xsl:text>
      </xsl:if>
      <xsl:if test="string-length(IONT/TS_NAME)!=0">
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa; </xsl:text>
       </xsl:if>
       <xsl:text> TABLESPACE "</xsl:text>
       <xsl:value-of select="IONT/TS_NAME"/>
       <xsl:text>" </xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:if>
   </xsl:if>
   <xsl:if test="(PROPERTY mod 256)>=128">
    <!-- IOV -->
    <xsl:call-template name="DoIOV">
     <xsl:with-param name="Node" select="IONT"/>
     <xsl:with-param name="Nested">1</xsl:with-param>
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
    </xsl:call-template>
   </xsl:if>
   <!-- LOB, VARRAY AS LOB -->
   <!--  PROPERTY bits:     16 = has array columns (VARRAY)
                       2048 = has internal LOB columns
                     262144 = has user-defined LOB columns
 -->
   <xsl:if test="((PROPERTY mod 32)>=16 or
                 (PROPERTY mod 4096)>=2048 or
                 (PROPERTY mod 524288)>=262144)">
    <xsl:call-template name="DoLOBCols">
     <xsl:with-param name="MetaType">
      <xsl:choose>
       <xsl:when test="(PROPERTY mod 64)>=32">PartLob</xsl:when>
       <xsl:otherwise>Lob</xsl:otherwise>
      </xsl:choose>
     </xsl:with-param>
     <xsl:with-param name="TabBlocksize" select="(HNT | IONT)/BLOCKSIZE"/>
    </xsl:call-template>
   </xsl:if>
   <!-- call self recursively if this NT contains NTs -->
   <xsl:if test="$Node/NTS_ITEM[OBJ_NUM=current()/NTAB_NUM]">
    <xsl:call-template name="DoNTStoreAs">
     <xsl:with-param name="Node" select="$Node"/>
     <xsl:with-param name="ParentObjNum" select="NTAB_NUM"/>
    </xsl:call-template>
   </xsl:if>
   <!-- Terminate any needed Nested tabls storage clause parens -->
   <xsl:call-template name="EmitStorageTablePropertiesParen">
    <xsl:with-param name="Node" select="$Node"/>
    <xsl:with-param name="OpenParen">0</xsl:with-param>
   </xsl:call-template>
   <xsl:choose>
    <xsl:when test="(FLAGS mod 64)>=32">RETURN AS LOCATOR</xsl:when>
    <xsl:otherwise>RETURN AS VALUE</xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="EmitStorageTablePropertiesParen">
  <xsl:param name="Node" select="''"/>
  <xsl:param name="OpenParen">1</xsl:param>
  <!-- *******************************************************************
Template: EmitStorageTablePropertiesParen
Current node: ku$_nt_t node
Parameters:
  Node - parent node of NTS_ITEM
  OpenParen - 1 = emit '('
             else ')'
Description:
 Generate open (or close) parens around storage table properties
     for nested table.  The logic is sufficiently baroque that
     it deserves its own template.
     The cases are:
     (1) User has asked for segment attributes
     (2) Nested table is an IOT (must emit ORGANIZATION INDEX etc.)
     (3) Nested table contains a CLOB or BLOB column
         (or a VARRAY column stored as a LOB)
         with a user-specified segment name
         (Must emit LOB STORE AS... or VARRAY ... STORE AS LOB...)
     (4) Nested table itself contains a nested table column
     (5) Need to emit non-referential constraints
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$SEGMENT_ATTRIBUTES=1">
    <xsl:call-template name="EmitParen">
     <xsl:with-param name="OpenParen" select="$OpenParen"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="(PROPERTY mod 128)>=64">
    <xsl:call-template name="EmitParen">
     <xsl:with-param name="OpenParen" select="$OpenParen"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="4>(COL_LIST/COL_LIST_ITEM[TYPE_NUM=112 or TYPE_NUM=113 or
                           TYPE_NUM=123]/LOBMD/SCHEMA_OBJ/FLAGS mod 8)">
    <xsl:call-template name="EmitParen">
     <xsl:with-param name="OpenParen" select="$OpenParen"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$Node/NTS_ITEM[OBJ_NUM=current()/NTAB_NUM]">
    <xsl:call-template name="EmitParen">
     <xsl:with-param name="OpenParen" select="$OpenParen"/>
    </xsl:call-template>
   </xsl:when>
   <!-- If constraints must be emitted -->
   <xsl:otherwise>
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <!-- IOT -->
      <xsl:call-template name="TablePropertyParen">
       <xsl:with-param name="OpenParen" select="$OpenParen"/>
       <xsl:with-param name="SchemaObjParent" select="$Node"/>
       <xsl:with-param name="ListParent" select="$Node/IONT"/>
       <xsl:with-param name="Property" select="$Node/PROPERTY"/>
       <xsl:with-param name="Nested">1</xsl:with-param>
       <xsl:with-param name="Storage">1</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <!-- Heap -->
      <xsl:call-template name="TablePropertyParen">
       <xsl:with-param name="OpenParen" select="$OpenParen"/>
       <xsl:with-param name="SchemaObjParent" select="$Node"/>
       <xsl:with-param name="ListParent" select="$Node/HNT"/>
       <xsl:with-param name="Property" select="$Node/PROPERTY"/>
       <xsl:with-param name="Nested">1</xsl:with-param>
       <xsl:with-param name="Storage">1</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenNestedTableConstraints">
  <xsl:param name="ListParent" select="''"/>
  <!-- *******************************************************************
Template: GenNestedTableConstraints
  Nested Table Constraints (when generated as ALTER TABLE)
Parameters:
  ListParent - parent of NTS_ITEM
******************************************************************** -->
  <xsl:for-each select="$ListParent/NTS_ITEM">
   <xsl:sort select="INTCOL_NUM" data-type="number"/>
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 128)>=64">
     <!-- IOT -->
     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="IONT"/>
      <xsl:with-param name="InColList">0</xsl:with-param>
      <xsl:with-param name="CommaNeeded">0</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
     <!-- For transportable, ENABLE Hidden (OID or SETID) constrs -->
     <xsl:if test="$TRANSPORTABLE=1">
      <xsl:for-each select="IONT/CON1_LIST/CON1_LIST_ITEM[OID_OR_SETID!=0]">
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;  </xsl:text>
       </xsl:if>
       <xsl:call-template name="DoHiddenConstraint">
        <xsl:with-param name="SchemaObjParent" select="../../.."/>
        <xsl:with-param name="ConstraintNode" select="current()"/>
       </xsl:call-template>
      </xsl:for-each>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <!-- Heap -->
     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="HNT"/>
      <xsl:with-param name="InColList">0</xsl:with-param>
      <xsl:with-param name="CommaNeeded">0</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
      <xsl:with-param name="Nested">1</xsl:with-param>
     </xsl:call-template>
     <!-- For transportable, ENABLE Hidden (OID or SETID) constrs -->
     <xsl:if test="$TRANSPORTABLE=1">
      <xsl:for-each select="HNT/CON1_LIST/CON1_LIST_ITEM[OID_OR_SETID!=0]">
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;  </xsl:text>
       </xsl:if>
       <xsl:call-template name="DoHiddenConstraint">
        <xsl:with-param name="SchemaObjParent" select="../../.."/>
        <xsl:with-param name="ConstraintNode" select="current()"/>
       </xsl:call-template>
      </xsl:for-each>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
