<?xml version="1.0"?>
<!-- Copyright (c) 2000, 2009, Oracle and/or its affiliates.
All rights reserved. -->
<!--
NAME
    kuprtobj.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_part_obj_t
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton     09/10/08 - bug 7362930: index (sub)partition UNUSABLE
    sdavidso    08/13/08 - bug 7272424: index on system partitioned table
    sdavidso    07/05/07 - subpartition compression
    rapayne     06/26/07 - Correct the version check for interval partitioning.
    htseng      03/14/07 - bug 5759921: transportable for subpartition template
    htseng      02/15/07 - bug 5752667: missing keyword LESS THAN in 
			   range subpartition template 
    abodge      01/16/07 - Restore workaround for bug 3543632
    lbarton     11/07/06 - bug 5607195: subpartition template in interval
                           partition
    lbarton     10/05/06 - more interval partitioning
    lbarton     09/13/06 - interval partitioning
    lbarton     08/28/06 - All composite partitioning combinations
    sdavidso    05/11/06 - clean up ref partition
    msakayed    05/09/06 - backout htseng system partitioning changes
    msakayed    04/30/06 - system partitioning support 
    htseng      05/02/06 - add partition by system support 
    htseng      04/13/06 - add partition by reference 
    lbarton     01/25/06 - add comments 
    htseng      12/16/05 - add transform param PARTITIONING 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    sdavidso    09/20/05 - fix compressed keys in partioned IOT 
    sdavidso    09/14/05 - deal with index NOCOMPRESS at the partition level 
    htseng      08/08/05 - bug 3560220: get correct behavior from processor 
    lbarton     05/09/05 - bug 4331909: use dataobj_num for OBJNO_REUSE in 
                           overflow seg 
    xshen       05/24/04 - java xdk/xdkc 2029 bug 3543632 workaround
    xshen       05/18/04 - xshen_changemgr_cixsls-0518
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    rpfau       04/16/04 - Fix bug 3488157 - values clause missing for
                           partition by list for piot.
    lbarton     12/02/03 - Bug 3283651: fix test for index local partition
    htseng      10/03/03 - Fix bug 2977027  
    lbarton     06/19/03 - Bug 3012732: tte storage params for list subpart'n
    htseng      04/10/03 - bug 2896047
    htseng      01/06/03 - fix bug 2711197
    htseng      11/14/02 - add GLOBAL keyword for INDEX Partition 
    htseng      10/09/02 - add space before keywrod LOCAL
    lbarton     08/02/02 - transportable export
    lbarton     01/07/02 - fix formatting
    dgagne      11/05/01 - remove row movement from partitions and tablespace
    dgagne      10/15/01 - add heap segment compression support
    dgagne      09/17/01 - add support for subpartition template
    dgagne      09/05/01 - add range-list composite partitioning
    dgagne      06/14/01 - Move storage PRETTY statements to kustorag
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     12/01/00 - PIOT bugfixes
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     10/25/00 - LRG 50204: sort part cols on pos_num
    lbarton     10/24/00 - sort in views, not xsl
    lbarton	10/16/00 - bugfix: use ColNameOrAttr for partition col names
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - List partitioning
    lbarton	05/15/00 - Params for new API
    lbarton	03/28/00 - Part. indexes, hash, composite
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kulob.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PARTITIONING">1</xsl:param>
 <!-- Templates -->
 <xsl:template name="DoPartObjSegAttrs">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <!-- *******************************************************************
Template: DoPartObjSegAttrs - emit default PCTFREE, PCTUSED, etc.
Parameters:
 ADT_type: "TABLE" or "INDEX"
******************************************************************** -->
  <xsl:apply-templates select="PART_OBJ/PARTOBJ/DEFPCTFREE">
   <xsl:with-param name="ADT_type" select="$ADT_type"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="DoPartObjLogging">
  <!-- *******************************************************************
Template: DoPartObjLogging - emit default LOGGING
******************************************************************** -->
  <xsl:apply-templates select="PART_OBJ/PARTOBJ/DEFLOGGING"/>
 </xsl:template>
 <xsl:template name="DoPartObjStorage">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoPartObjStorage - emit default STORAGE
Parameters:
 ADT_type: "TABLE" or "INDEX"
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:call-template name="DoDefStorage">
   <xsl:with-param name="Node" select="PART_OBJ/PARTOBJ"/>
   <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoPartObjTablespace">
  <!-- *******************************************************************
Template: DoPartObjTablespace - emit default tablespace
******************************************************************** -->
  <xsl:apply-templates select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
 </xsl:template>
 <xsl:template name="DoPartitionClause">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="PartCompress" select="false()"/>
  <!-- *******************************************************************
Template: DoPartitionClause - the rest of the partitioning clauses
          including PARTITION BY and the partition lists
Parameters:
 ADT_type: "TABLE" or "INDEX"
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
 PartCompress: TRUE = compress partition (for index partitions)
               defaults to FALSE
******************************************************************** -->
  <xsl:if test="$PARTITIONING=1">
   <!-- [ LOCAL | GLOBAL ] PARTITION BY ... -->
   <xsl:call-template name="DoParttype">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PartobjNode" select="PART_OBJ/PARTOBJ"/>
    <xsl:with-param name="TempSub" select="PART_OBJ/TSUBPARTS"/>
    <xsl:with-param name="ParentNode" select="PART_OBJ"/>
   </xsl:call-template>
   <!-- SUBPARTITION TEMPLATE ... -->
   <xsl:call-template name="SubpartTemplate">
    <xsl:with-param name="PartobjNode" select="PART_OBJ/PARTOBJ"/>
    <xsl:with-param name="TempSub" select="PART_OBJ/TSUBPARTS/TSUBPARTS_ITEM"/>
   </xsl:call-template>
   <!-- PARTITION list -->
   <xsl:call-template name="DoPartLists">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PartobjNode" select="PART_OBJ/PARTOBJ"/>
    <xsl:with-param name="Parttype" select="PART_OBJ/PARTOBJ/PARTTYPE"/>
    <xsl:with-param name="Subparttype" select="(PART_OBJ/PARTOBJ/SPARE2 mod 256)"/>
    <xsl:with-param name="Local">
     <xsl:choose>
      <xsl:when test="$ADT_type='INDEX'
          and (PART_OBJ/PARTOBJ/FLAGS mod 2)=1">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="ParentNode" select="PART_OBJ"/>
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
    <xsl:with-param name="PartCompress" select="$PartCompress"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoPIOTSegAttrs">
  <xsl:param name="Node" select="''"/>
  <!-- *******************************************************************
Template: DoPIOTSegAttrs - emit default PCTFREE, PCTUSED, etc.
Parameters:
 Node: parent of DEFPCTFREE
******************************************************************** -->
  <xsl:apply-templates select="$Node/DEFPCTFREE">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="DoPIOTLogging">
  <xsl:param name="Node" select="''"/>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoPIOTLogging - emit default LOGGING, TABLESPACE, STORAGE
Parameters:
 Node: parent of DEFLOGGING, DEFTS_NAME, STORAGE
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:apply-templates select="$Node/DEFLOGGING"/>
  <xsl:apply-templates select="$Node/DEFTS_NAME"/>
  <xsl:call-template name="DoDefStorage">
   <xsl:with-param name="Node" select="$Node"/>
   <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoPIOTPartitionClause">
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="PartCompress" select="false()"/>
  <!-- *******************************************************************
Template: DoPIOTPartitionClause - the rest of the partitioning clauses
          including PARTITION BY and the partition lists
Parameters:
 Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
 PartCompress: TRUE = compress partition (for index partitions)
               defaults to FALSE
******************************************************************** -->
  <xsl:call-template name="DoParttype">
   <xsl:with-param name="PartobjNode" select="PART_OBJ/TABPARTOBJ"/>
  </xsl:call-template>
  <xsl:call-template name="DoPartLists">
   <!-- Treat the PIOT as an ADT_type=INDEX so we don't put out Pctfree and
         storage clauses. But set PIOT to 1 so we can tell it is really a
         table. -->
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="PIOT">1</xsl:with-param>
   <xsl:with-param name="PartobjNode" select="PART_OBJ/TABPARTOBJ"/>
   <xsl:with-param name="Parttype" select="PART_OBJ/TABPARTOBJ/PARTTYPE"/>
   <xsl:with-param name="Subparttype" select="(PART_OBJ/TABPARTOBJ/SPARE2 mod 256)"/>
   <xsl:with-param name="Local">0</xsl:with-param>
   <xsl:with-param name="ParentNode" select="PART_OBJ"/>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
   <xsl:with-param name="PartCompress" select="$PartCompress"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoParttype">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="PartobjNode" select="''"/>
  <xsl:param name="TempSub" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: DoParttype
 This template does both partition type/cols and subpartition type/cols
Parameters:
 ADT_type: "TABLE" or "INDEX"
 PartobjNode: PARTOBJ node
 TempSub: TSUBPARTS node
 ParentNode -  the parent of the (COM)PART_LIST node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ADT_type='INDEX'
                  and ($PartobjNode/FLAGS mod 2)=1">
    <xsl:text> LOCAL</xsl:text>
   </xsl:when>
   <xsl:when test="$PartobjNode/PARTTYPE=1">
    <!-- range -->
    <xsl:if test="$ADT_type='INDEX'"> GLOBAL</xsl:if>
    <xsl:text> PARTITION BY RANGE </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
    <!-- INTERVAL clause: what we display depends on the EXPORT and VERSION
         params
EXPORT    VERSION    output
======    =======    ======
TRUE      ge 11.1    expose TRANSITION and all partitions
TRUE      lt 11.1    convert to range partition;
                      existing partitions move to range section
FALSE     any        generate the CREATE TABLE
                     as the user would have entered it
                     with no TRANSITION and no partitions
                     in the interval section 
 -->
    <xsl:if test="$PartobjNode/INTERVAL_STR and ($EXPORT=0 or $VERSION>=1100000000)">
     <xsl:text>INTERVAL (</xsl:text>
     <xsl:value-of select="$PartobjNode/INTERVAL_STR"/>
     <xsl:text>) </xsl:text>
     <!-- suppress TRANSITION if EXPORT=0 -->
     <xsl:if test="$EXPORT=1">
      <!-- TRANSITION clause: if there is a [COM]PART_LIST_ITEM with 
          the 0x8000 flag set (= partition is in the interval section) -->
      <xsl:choose>
       <xsl:when test="$ParentNode/PART_LIST/PART_LIST_ITEM[(FLAGS mod 65536)>=32768]">
        <xsl:for-each select="$ParentNode/PART_LIST/PART_LIST_ITEM[32768>(FLAGS mod 65536)]">
         <xsl:if test="position()=last()">
          <xsl:text>TRANSITION ("</xsl:text>
          <xsl:value-of select="./SCHEMA_OBJ/SUBNAME"/>
          <xsl:text>") </xsl:text>
         </xsl:if>
        </xsl:for-each>
       </xsl:when>
       <xsl:when test="$ParentNode/COMPART_LIST/COMPART_LIST_ITEM[(FLAGS mod 65536)>=32768]">
        <xsl:for-each select="$ParentNode/COMPART_LIST/COMPART_LIST_ITEM[32768>(FLAGS mod 65536)]">
         <xsl:if test="position()=last()">
          <xsl:text>TRANSITION ("</xsl:text>
          <xsl:value-of select="./SCHEMA_OBJ/SUBNAME"/>
          <xsl:text>") </xsl:text>
         </xsl:if>
        </xsl:for-each>
       </xsl:when>
      </xsl:choose>
     </xsl:if>
     <!-- STORE IN -->
     <xsl:for-each select="$PartobjNode/INSERT_TS_LIST/INSERT_TS_LIST_ITEM">
      <xsl:if test="position()=1">STORE IN (</xsl:if>
      <xsl:if test="(not(contains(NAME,'&quot;')))">"</xsl:if>
      <xsl:value-of select="NAME"/>
      <xsl:if test="(not(contains(NAME,'&quot;')))">"</xsl:if>
      <xsl:choose>
       <xsl:when test="position()=last()">) </xsl:when>
       <xsl:otherwise>, </xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
    </xsl:if>
    <!-- subpartition by -->
    <xsl:call-template name="DoSubparttype">
     <xsl:with-param name="ADT_type" select="$ADT_type"/>
     <xsl:with-param name="PartobjNode" select="$PartobjNode"/>
     <xsl:with-param name="TempSub" select="$TempSub"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$PartobjNode/PARTTYPE=2">
    <!-- hash -->
    <xsl:if test="$ADT_type='INDEX'"> GLOBAL</xsl:if>
    <xsl:text> PARTITION BY HASH </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
   </xsl:when>
   <xsl:when test="$PartobjNode/PARTTYPE=3">
    <!-- system -->
    <xsl:if test="$ADT_type='INDEX'"> GLOBAL</xsl:if>
    <xsl:text> PARTITION BY SYSTEM </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
   </xsl:when>
   <xsl:when test="$PartobjNode/PARTTYPE=4">
    <!-- list -->
    <xsl:text> PARTITION BY LIST </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../PARTCOLS"/>
    <xsl:call-template name="DoSubparttype">
     <xsl:with-param name="ADT_type" select="$ADT_type"/>
     <xsl:with-param name="PartobjNode" select="$PartobjNode"/>
     <xsl:with-param name="TempSub" select="$TempSub"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$PartobjNode/PARTTYPE=5">
    <!-- reference 
Here we assume there is exactly one referential constraint governing
the reference partitioning -->
    <xsl:text> PARTITION BY REFERENCE ("</xsl:text>
    <xsl:for-each select="CON2_LIST/CON2_LIST_ITEM">
     <xsl:if test="(FLAGS mod 1024)>=512">
      <xsl:value-of select="NAME"/>
     </xsl:if>
    </xsl:for-each>
    <xsl:text>") </xsl:text>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoSubparttype">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="PartobjNode" select="''"/>
  <xsl:param name="TempSub" select="''"/>
  <!-- *******************************************************************
Template: DoSubparttype
 This template does subpartition type/cols
Parameters:
 ADT_type: "TABLE" or "INDEX"
 PartobjNode: PARTOBJ node
 TempSub: TSUBPARTS node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="($PartobjNode/SPARE2 mod 256)=1">
    <!-- range subpart -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> SUBPARTITION BY RANGE </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../SUBPARTCOLS"/>
   </xsl:when>
   <xsl:when test="($PartobjNode/SPARE2 mod 256)=2">
    <!-- hash subpart -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> SUBPARTITION BY HASH </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../SUBPARTCOLS"/>
    <!-- number of subpartitions is bytes 2-3 of SPARE2 -->
    <xsl:if test="(floor(($PartobjNode/SPARE2) div 65536) mod 65536) > 0 and 
	$TempSub=''">
     <!-- template not need subpartitions quantity -->
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> SUBPARTITIONS </xsl:text>
     <xsl:value-of select="(floor(($PartobjNode/SPARE2) div 65536) mod 65536)"/>
    </xsl:if>
   </xsl:when>
   <xsl:when test="($PartobjNode/SPARE2 mod 256)=4">
    <!-- list subpart -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> SUBPARTITION BY LIST </xsl:text>
    <xsl:apply-templates select="$PartobjNode/../SUBPARTCOLS"/>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="PARTCOLS | SUBPARTCOLS">
  <!-- *******************************************************************
Template: PARTCOLS | SUBPARTCOLS
  List the partitioning columns
******************************************************************** -->
  <xsl:for-each select="PARTCOLS_ITEM | SUBPARTCOLS_ITEM">
   <xsl:if test="position()='1'">
    <xsl:text>(</xsl:text>
   </xsl:if>
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="COL"/>
   </xsl:call-template>
   <xsl:choose>
    <!-- Put out a comma if not the last col -->
    <xsl:when test="not(position()=last())">
     <xsl:text>,</xsl:text>
    </xsl:when>
    <xsl:otherwise>) </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="SubpartTemplate">
  <xsl:param name="PartobjNode" select="''"/>
  <xsl:param name="TempSub" select="''"/>
  <!-- *******************************************************************
Template: SubpartTemplate 
 This template Emit SUBPARTITION TEMPLATE 
Parameters:
 PartobjNode: PARTOBJ node
 TempSub: TSUBPARTS node
******************************************************************** -->
  <xsl:for-each select="$TempSub">
   <xsl:if test="(position()=1)">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> SUBPARTITION TEMPLATE ( </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:if test="not(position()=1)">
    <xsl:text>, </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:text> SUBPARTITION "</xsl:text>
   <xsl:value-of select="SPART_NAME"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="HIBOUNDLEN!=0">
    <xsl:choose>
     <!-- Range subpartition -->
     <xsl:when test="($PartobjNode/SPARE2 mod 256)=1">
      <xsl:text> VALUES LESS THAN ( </xsl:text>
     </xsl:when>
     <!-- List  subpartition -->
     <xsl:when test="($PartobjNode/SPARE2 mod 256)=4">
      <xsl:text> VALUES ( </xsl:text>
     </xsl:when>
    </xsl:choose>
    <xsl:value-of select="HIBOUNDVAL"/>
    <xsl:text> )</xsl:text>
   </xsl:if>
   <xsl:apply-templates select="TS_NAME"/>
   <xsl:apply-templates select="TLOBS/TLOBS_ITEM"/>
   <xsl:if test="position()=last()">
    <xsl:text> ) </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoPartLists">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="PIOT">0</xsl:param>
  <xsl:param name="PartobjNode" select="''"/>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="Subparttype">0</xsl:param>
  <xsl:param name="Local">0</xsl:param>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="PartCompress" select="false()"/>
  <!-- *******************************************************************
Template: DoPartLists
 Dispatch to processing for PART_LIST or COMPART_LIST
Parameters:
  ADT_type -	TABLE = tables
		INDEX = PIOTs
  PIOT -	1 = PIOT, 0 = not PIOT
  PartobjNode: PARTOBJ node
  Parttype -	1 = range
		2 = hash
		3 = system
  Subparttype -	1 = range
		2 = hash
		3 = system
		4 = list
  Local		1 = local index (sys.partobj$.flags)
  ParentNode -  the parent of the PARTOBJ node, usually PART_OBJ
  Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
  PartCompress: TRUE = compress partition (for index partitions)
               defaults to FALSE
******************************************************************** -->
  <!-- one of these templates should match -->
  <xsl:apply-templates select="$ParentNode/PART_LIST">
   <xsl:with-param name="ADT_type" select="$ADT_type"/>
   <xsl:with-param name="PIOT" select="$PIOT"/>
   <xsl:with-param name="PartobjNode" select="$PartobjNode"/>
   <xsl:with-param name="Parttype" select="$Parttype"/>
   <xsl:with-param name="Subparttype" select="$Subparttype"/>
   <xsl:with-param name="Local" select="$Local"/>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
   <xsl:with-param name="PartCompress" select="$PartCompress"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="$ParentNode/COMPART_LIST">
   <xsl:with-param name="ADT_type" select="$ADT_type"/>
   <xsl:with-param name="PIOT" select="$PIOT"/>
   <xsl:with-param name="PartobjNode" select="$PartobjNode"/>
   <xsl:with-param name="Parttype" select="$Parttype"/>
   <xsl:with-param name="Subparttype" select="$Subparttype"/>
   <xsl:with-param name="Local" select="$Local"/>
   <xsl:with-param name="UseDef">1</xsl:with-param>
   <xsl:with-param name="Pctspace" select="$Pctspace"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="PART_LIST | COMPART_LIST | SUBPARTS">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="PIOT">0</xsl:param>
  <xsl:param name="PartobjNode" select="''"/>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="Subparttype">0</xsl:param>
  <xsl:param name="Local">0</xsl:param>
  <xsl:param name="UseDef">0</xsl:param>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="PartCompress" select="false()"/>
  <!-- *******************************************************************
Template:  PART_LIST | COMPART_LIST | SUBPARTS
  List each [SUB]PARTITION clause
Parameters:
  ADT_type -	TABLE = tables
		INDEX = PIOTs and indexes
  PIOT -	1 = PIOT, 0 = not PIOT
  Parttype -	1 = range
		2 = hash
		3 = system
  Subparttype -	1 = range
		2 = hash
		3 = system
		4 = list
  Local		1 = local index (sys.partobj$.flags)
  UseDef        1 = use default (partition-level) attributes
                    in composite partition
  Subpartition  1 = this is a subpartition (0 = it isn't)
  Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
  PartCompress: TRUE = compress partition (for index partitions)
               defaults to FALSE
******************************************************************** -->
  <!-- if this is an interval partitioned table and EXPORT=0,
         then skip partitions in the interval section, i.e., return
         the DDL as the user entered it
    -->
  <xsl:for-each select="PART_LIST_ITEM[32768>(FLAGS mod 65536) or $EXPORT=1] |
                        COMPART_LIST_ITEM[32768>(FLAGS mod 65536) or $EXPORT=1] | 
                        SUBPARTS_ITEM[32768>(FLAGS mod 65536) or $EXPORT=1]">
   <!-- emit the initial open paren -->
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text> (</xsl:text>
   </xsl:if>
   <xsl:call-template name="DoPartListItem">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PIOT" select="$PIOT"/>
    <xsl:with-param name="PartobjNode" select="$PartobjNode"/>
    <xsl:with-param name="Parttype" select="$Parttype"/>
    <xsl:with-param name="Subparttype" select="$Subparttype"/>
    <xsl:with-param name="Local" select="$Local"/>
    <xsl:with-param name="UseDef" select="$UseDef"/>
    <xsl:with-param name="Subpartition" select="$Subpartition"/>
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
    <xsl:with-param name="PartCompress" select="$PartCompress"/>
   </xsl:call-template>
   <!-- 
         Put out a comma / LF if not the last partition
   -->
   <xsl:choose>
    <xsl:when test="not(position()=last())">
     <xsl:text>, </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>) </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoPartListItem">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="PIOT">0</xsl:param>
  <xsl:param name="PartobjNode" select="''"/>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="Subparttype">0</xsl:param>
  <xsl:param name="Local">0</xsl:param>
  <xsl:param name="UseDef">0</xsl:param>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="PartCompress" select="false()"/>
  <!-- *******************************************************************
Template: DoPartListItem
Parameters: (see above)
******************************************************************** -->
  <!--
      [SUB]PARTITION name VALUES
   -->
  <xsl:choose>
   <xsl:when test="$Subpartition=0">PARTITION "</xsl:when>
   <xsl:otherwise> SUBPARTITION "</xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
  <xsl:text>" </xsl:text>
  <xsl:if test="$Parttype=1 and $Local=0">
   <xsl:text> VALUES LESS THAN (</xsl:text>
   <xsl:value-of select="HIBOUNDVAL"/>
   <xsl:text>) </xsl:text>
  </xsl:if>
  <!-- Put out values clause for partition by list ($Parttype=4) for both
        tables and PIOT's. Note that $ADT_type='INDEX' and $PIOT=1 for a
        PIOT. -->
  <xsl:if test="$Parttype=4 and ($ADT_type ='TABLE' or ($ADT_type='INDEX'
                and $PIOT=1))">
   <xsl:text> VALUES (</xsl:text>
   <xsl:value-of select="HIBOUNDVAL"/>
   <xsl:text>) </xsl:text>
  </xsl:if>
  <!-- in a compressed partitioned index    BUG 4544267 -->
  <!--   some partitions can be NOCOMPRESS              -->
  <xsl:if test="($ADT_type = 'INDEX')
                 and ($Parttype=1) 
                 and $PartCompress
                 and ((FLAGS mod 2048) &lt; 1024)">
   <xsl:text>NOCOMPRESS </xsl:text>
  </xsl:if>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <!--
         partition segment attributes (PCTFREE, STORAGE, TABLESPACE, LOBS...)
    -->
   <xsl:call-template name="DoPartSegAttrs">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PIOT" select="$PIOT"/>
    <xsl:with-param name="Local" select="$Local"/>
    <xsl:with-param name="Parttype" select="$Parttype"/>
    <xsl:with-param name="UseDef" select="$UseDef"/>
    <xsl:with-param name="Subpartition" select="$Subpartition"/>
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
   </xsl:call-template>
  </xsl:if>
  <!--
       [NO]COMPRESS
   -->
  <xsl:if test="$Parttype!=2">
   <!-- not valid for hash part'n -->
   <xsl:if test="$ADT_type = 'TABLE'">
    <xsl:choose>
     <xsl:when test="SPARE2">
      <!-- exists if table is subpartitioned
             tabcompart$.spare2
             byte 0: compression attribute of the partition
                     0-NONE(UNSPECIFIED), 1-COMPRESS  2-NOCOMPRESS
         -->
      <xsl:call-template name="DoPartOBJCompress">
       <xsl:with-param name="Compress" select="SPARE2"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <!-- For leaf partition:
             ts$.spare1:
                   /* #define KTSSEGM_FLAG_COMPRESSED 0x0800 (2048) */
 -->
      <xsl:call-template name="DoSegCompress">
       <xsl:with-param name="Compress" select="STORAGE/FLAGS"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:if>
  <!--
        call this template recursively to list the subpartitions when
        (1) transportable import
            or
        (2) Data Pump import of an interval partitioned table and this
            partition is in the interval section
            or
        (3) the subpartitions don't match the template
            (N.B. SMATCH_TPL is new in 11g, so we have to test for its presence)
   -->
  <xsl:if test="$TRANSPORTABLE =1 or ($EXPORT!=0 and $PartobjNode/INTERVAL_STR and (FLAGS mod 65536)>=32768) or not (SMATCH_TPL and SMATCH_TPL=1)">
   <xsl:apply-templates select="SUBPARTS">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="PIOT" select="$PIOT"/>
    <xsl:with-param name="PartobjNode" select="$PartobjNode"/>
    <xsl:with-param name="Parttype" select="$Subparttype"/>
    <xsl:with-param name="Local" select="$Local"/>
    <xsl:with-param name="UseDef">0</xsl:with-param>
    <xsl:with-param name="Subpartition">1</xsl:with-param>
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
   </xsl:apply-templates>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoPartSegAttrs">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="PIOT">0</xsl:param>
  <xsl:param name="Local">0</xsl:param>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="UseDef">0</xsl:param>
  <xsl:param name="Subpartition">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoPartSegAttrs 
  Emit segment attributes for partition or subpartition
Parameters:
  ADT_type -	TABLE = tables
		INDEX = PIOTs and indexes
  PIOT -	1 = PIOT, 0 = not PIOT
  Local		1 = local index (sys.partobj$.flags)
  Parttype -	1 = range
		2 = hash
		3 = system
  UseDef        1 = use default (partition-level) attributes
                    in composite partition
  Subpartition  1 = this is a subpartition (0 = it isn't)
  Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:choose>
   <!-- hash part'n or hash/list subpartition -->
   <xsl:when test="$Parttype=2 or $Subpartition=1">
    <xsl:apply-templates select="LOBS">
     <xsl:with-param name="PartListItem" select="local-name()"/>
     <xsl:with-param name="Parttype" select="$Parttype"/>
     <xsl:with-param name="Subpartition" select="$Subpartition"/>
    </xsl:apply-templates>
    <xsl:choose>
     <xsl:when test="$TRANSPORTABLE=1">
      <xsl:apply-templates select="STORAGE">
       <xsl:with-param name="PARTITION">1</xsl:with-param>
       <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
       <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
      </xsl:apply-templates>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;  </xsl:text>
      </xsl:if>
      <xsl:text> TABLESPACE "</xsl:text>
      <xsl:value-of select="TS_NAME"/>
      <xsl:text>" </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <!-- default (partition-level) attibutes in composite partition -->
   <xsl:when test="$UseDef=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:apply-templates select="DEFPCTFREE">
     <xsl:with-param name="ADT_type" select="$ADT_type"/>
    </xsl:apply-templates>
    <xsl:call-template name="DoDefStorage">
     <xsl:with-param name="Node" select="."/>
     <xsl:with-param name="BlkSize" select="../../../BLOCKSIZE | BLOCKSIZE"/>
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
    </xsl:call-template>
    <xsl:apply-templates select="DEFTS_NAME"/>
    <xsl:apply-templates select="DEFLOGGING"/>
    <xsl:apply-templates select="LOBS">
     <xsl:with-param name="PartListItem" select="local-name()"/>
     <xsl:with-param name="Parttype" select="$Parttype"/>
     <xsl:with-param name="Subpartition" select="$Subpartition"/>
    </xsl:apply-templates>
   </xsl:when>
   <!-- range or list partition -->
   <xsl:otherwise>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="PCT_FREE">
     <xsl:with-param name="ADT_type" select="$ADT_type"/>
    </xsl:apply-templates>
    <!-- No Logging is bit 0x04 in FLAGS=1 (in tabpart$) -->
    <xsl:if test="(FLAGS mod 8)>=4"> NOLOGGING </xsl:if>
    <xsl:apply-templates select="STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="SCHEMA_OBJ/DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="LOBS">
     <xsl:with-param name="PartListItem" select="local-name()"/>
     <xsl:with-param name="Parttype" select="$Parttype"/>
     <xsl:with-param name="Subpartition" select="$Subpartition"/>
    </xsl:apply-templates>
    <xsl:if test="$PIOT=1">
     <xsl:call-template name="DoIOVList">
      <xsl:with-param name="List" select="../../IOV_LIST"/>
      <xsl:with-param name="PNUM" select="PART_NUM"/>
      <xsl:with-param name="Pctspace" select="$Pctspace"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoIOVList">
  <xsl:param name="List" select="''"/>
  <xsl:param name="PNUM">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: DoIOVList - Emit OVERFLOW for partition number PNUM
Parameters:
  List - parent of IOV_LIST_ITEM
  PNUM - partition number
  Pctspace: percentage by which space allocation is to be modified
           defaults to 100 (no modification)
******************************************************************** -->
  <xsl:if test="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> OVERFLOW </xsl:text>
   <xsl:apply-templates select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/PCT_FREE"/>
   <xsl:if test="($List/IOV_LIST_ITEM[PART_NUM=$PNUM]/FLAGS mod 8)>=4"> NOLOGGING </xsl:if>
   <xsl:choose>
    <xsl:when test="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/DATAOBJ_NUM">
     <xsl:apply-templates select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/STORAGE">
      <xsl:with-param name="PARTITION">1</xsl:with-param>
      <xsl:with-param name="BlkSize" select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/BLOCKSIZE"/>
      <xsl:with-param name="Dataobjnum" select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/DATAOBJ_NUM"/>
      <xsl:with-param name="Pctspace" select="$Pctspace"/>
     </xsl:apply-templates>
    </xsl:when>
    <xsl:otherwise>
     <!-- An old Data Pump dump file may not have DATAOBJ_NUM.
          But sometimes OBJ_NUM will contain the same value.
          So use it as the value of Dataobjnum and hope we're lucky -->
     <xsl:apply-templates select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/STORAGE">
      <xsl:with-param name="PARTITION">1</xsl:with-param>
      <xsl:with-param name="BlkSize" select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/BLOCKSIZE"/>
      <xsl:with-param name="Dataobjnum" select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]/OBJ_NUM"/>
      <xsl:with-param name="Pctspace" select="$Pctspace"/>
     </xsl:apply-templates>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="LOBS">
  <xsl:param name="PartListItem" select="''"/>
  <xsl:param name="Parttype">0</xsl:param>
  <xsl:param name="Subpartition">0</xsl:param>
  <!-- *******************************************************************
Template: LOBS - emit clauses for LOBS, VARRAYs, etc. in this [sub]part'n
Parameters:
  PartListItem - PART_LIST_ITEM node or SUBPARTS_ITEM node
  Parttype -	1 = range
		2 = hash
		3 = system
  Subpartition  1 = this is a subpartition (0 = it isn't)
******************************************************************** -->
  <xsl:for-each select="LOBS_ITEM">
   <xsl:choose>
    <xsl:when test="$PartListItem='PART_LIST_ITEM'">
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType">LobFrag</xsl:with-param>
      <xsl:with-param name="Parttype" select="$Parttype"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
      <xsl:with-param name="ColList" select="../../../../../COL_LIST"/>
      <xsl:with-param name="Intcolnum" select="INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="../../../../../BLOCKSIZE | BLOCKSIZE"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$PartListItem='COMPART_LIST_ITEM'">
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType">LobComppart</xsl:with-param>
      <xsl:with-param name="Parttype" select="$Parttype"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
      <xsl:with-param name="ColList" select="../../../../../COL_LIST"/>
      <xsl:with-param name="Intcolnum" select="INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="../../../../../BLOCKSIZE | BLOCKSIZE"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$PartListItem='SUBPARTS_ITEM'">
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType">LobFrag</xsl:with-param>
      <xsl:with-param name="Parttype" select="$Parttype"/>
      <xsl:with-param name="Subpartition" select="$Subpartition"/>
      <xsl:with-param name="ColList" select="../../../../../../../COL_LIST"/>
      <xsl:with-param name="Intcolnum" select="INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="../../../../../../../BLOCKSIZE | BLOCKSIZE"/>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoUnusablePartitions">
  <xsl:param name="Idx" select="''"/>
  <!-- *******************************************************************
Template: DoUnusablePartitions - Handle UNUSABLE (sub)partitions
Parameters:
  Idx - index node
******************************************************************** -->
  <xsl:for-each select="$Idx/PART_OBJ/PART_LIST/PART_LIST_ITEM[(FLAGS mod 2) >=1]">
   <xsl:call-template name="Do1PartUnusable">
    <xsl:with-param name="Idx" select="$Idx"/>
    <xsl:with-param name="PartNode" select="."/>
   </xsl:call-template>
  </xsl:for-each>
  <xsl:for-each select="$Idx/PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM">
   <xsl:for-each select="SUBPARTS/SUBPARTS_ITEM[(FLAGS mod 2) >=1]">
    <xsl:call-template name="Do1PartUnusable">
     <xsl:with-param name="Idx" select="$Idx"/>
     <xsl:with-param name="PartNode" select="."/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="Do1PartUnusable">
  <xsl:param name="Idx" select="''"/>
  <xsl:param name="PartNode" select="''"/>
  <!-- *******************************************************************
Template: Do1PartUnusable - Handle one UNUSABLE (sub)partition
Parameters:
  Idx - index node
  PartNode - (sub)partition node
******************************************************************** -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="$Idx/SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="$Idx/SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> ALTER INDEX </xsl:text>
  <xsl:apply-templates select="$Idx/SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test="local-name($PartNode)='SUBPARTS_ITEM'"> MODIFY SUBPARTITION "</xsl:when>
   <xsl:otherwise> MODIFY PARTITION "</xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="$PartNode/SCHEMA_OBJ/SUBNAME"/>
  <xsl:text>" UNUSABLE</xsl:text>
  <!-- Terminate the SQL statement -->
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
