<?xml version="1.0"?>
<!-- 
NAME
    kurole.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_role_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge      05/19/08 - 
    pkaliren    05/14/08 - Merge 11GC functionality
    xshen       09/20/04 - show dummy passwd for encrypted values (em)
    xshen       05/18/04 - xshen_changemgr_cixsls-0518
    lbarton     05/04/06 - strong verification
    dgagne      02/07/06 - fix revoke code 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	04/17/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="REVOKE_FROM" select="''"/>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="ROLE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">ROLE</xsl:with-param>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:text> CREATE ROLE </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="NAME"/>
  </xsl:call-template>
  <xsl:if test="PASSWORD !=''">
   <xsl:choose>
    <xsl:when test="PASSWORD='APPLICATION'">
     <xsl:text> IDENTIFIED USING </xsl:text>
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Object" select="SCHEMA"/>
     </xsl:call-template>
     <xsl:text>.</xsl:text>
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Object" select="PACKAGE"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="PASSWORD='GLOBAL'">
     <xsl:text> IDENTIFIED GLOBALLY</xsl:text>
    </xsl:when>
    <xsl:when test="PASSWORD='EXTERNAL'">
     <xsl:text> IDENTIFIED EXTERNALLY</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> IDENTIFIED BY VALUES '</xsl:text>
    <xsl:if test="SPARE4">
     <xsl:value-of select="SPARE4"/>
     <xsl:text>;</xsl:text>
    </xsl:if>
     <xsl:value-of select="PASSWORD"/>
     <xsl:text>'</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <xsl:if test="string-length($REVOKE_FROM)!=0 and
                (string-length(PASSWORD) = 0 or PASSWORD != 'GLOBAL')">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">REVOKE</xsl:with-param>
    <xsl:with-param name="ObjectType">ROLE</xsl:with-param>
    <xsl:with-param name="NameNode" select="NAME"/>
   </xsl:call-template>
   <xsl:text> REVOKE </xsl:text>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Object" select="NAME"/>
   </xsl:call-template>
   <xsl:text> FROM </xsl:text>
   <xsl:value-of select="$REVOKE_FROM"/>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
    <!-- Terminate the SQL statement -->
   </xsl:if>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
