<?xml version="1.0"?>
<!--
NAME
    kus1cnsd.xsl
DESCRIPTION
    Convert SXML document for a single constraint to constraint
    definition DDL. Used by Change Management Pack.

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge      05/19/08 - Merge 11GC functionality
    abodge      02/14/08 - Need DEFERRABLE
    abodge      01/31/08 - ENABLE/DISABLE
    abodge      12/28/06 - Update from RDBMS_MAIN_LINUX_061206 + rapayne_alt
    abodge      11/29/06 - 
    hakali      09/12/06 - 
    abodge      05/12/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kuscnstd.xsl"/>
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuacnstr.xsl"/>
 <xsl:output method="text"/>
 <!-- Templates -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">0</xsl:param>
 <xsl:template name="AddConstrPrelude">
      <xsl:text> ADD </xsl:text>
      <xsl:if test="sxml:NAME">
       <xsl:text>CONSTRAINT </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="sxml:NAME"/>
       </xsl:call-template>
      </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:CHECK_CONSTRAINT_LIST_ITEM">
  <xsl:call-template name="AddConstrPrelude"/>
  <xsl:call-template name="GetConstraint">
   <xsl:with-param name="ConsType" select="'CHECK'"/>
   <xsl:with-param name="ColListItems" select="sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
     <!-- ENABLE/DISABLE -->
     <xsl:call-template name="ConstraintState2">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:PRIMARY_KEY_CONSTRAINT_LIST_ITEM">
  <xsl:call-template name="AddConstrPrelude"/>
  <xsl:call-template name="GetConstraint">
   <xsl:with-param name="ConsType" select="'PRIMARY'"/>
   <xsl:with-param name="ColListItems" select="sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
  </xsl:call-template>
     <xsl:call-template name="ConstraintState1">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
     <!-- ENABLE/DISABLE -->
     <xsl:call-template name="ConstraintState2">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:UNIQUE_KEY_CONSTRAINT_LIST_ITEM">
  <xsl:call-template name="AddConstrPrelude"/>
  <xsl:call-template name="GetConstraint">
   <xsl:with-param name="ConsType" select="'UNIQUE'"/>
   <xsl:with-param name="ColListItems" select="sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
  </xsl:call-template>
     <!-- ENABLE/DISABLE -->
     <xsl:call-template name="ConstraintState2">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM">
  <xsl:call-template name="AddConstrPrelude"/>
  <xsl:call-template name="GetConstraint">
   <xsl:with-param name="ConsType" select="'FOREIGN'"/>
   <xsl:with-param name="ColListItems" select="sxml:COL_LIST/sxml:COL_LIST_ITEM"/>
  </xsl:call-template>
     <!-- ENABLE/DISABLE -->
     <xsl:call-template name="ConstraintState2">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
