<?xml version="1.0"?>
<!--
NAME
    kusclus.xsl
DESCRIPTION
    Convert mdapi CLUSTER_T document to CLUSTER document (SXML)

MODIFIED        MM/DD/YY
    abodge     01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge     11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge     05/19/08 - Merge 11GC functionality
    rapayne    05/03/07 - 
    lbarton    11/28/06 - missing import
    htseng     20/12/05 - add transform param
    htseng     01/12/05 - Remove PHYSICAL_PROPERTIES element for 
		          PHYSICAL_ATTRIBUTES clause 
    lbarton    11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne    11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng     23/05/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kusstorg.xsl"/>
 <xsl:import href="kustbphy.xsl"/>
 <xsl:import href="kuscnstr.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template:CLUSTER_T - top-level template for CLUSTER.
  This template puts out
   - the opening CLUSTER element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="CLUSTER_T">
  <xsl:element name="CLUSTER">
   <!-- See note about xmlns attribute in kustable.xsl -->
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   </xsl:element>
   <!-- column_list -->
   <xsl:element name="COL_LIST">
    <xsl:for-each select="COL_LIST/COL_LIST_ITEM">
     <xsl:element name="COL_LIST_ITEM">
      <xsl:call-template name="ColumnDefinition"/>
     </xsl:element>
    </xsl:for-each>
   </xsl:element>
   <!-- physical_attributes_clause -->
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:call-template name="PhysicalAttributes">
     <xsl:with-param name="ParentNode" select="."/>
     <xsl:with-param name="Partitioned" select="0"/>
     <xsl:with-param name="ObjType" select="TABLE"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="SIZE_T >0">
    <xsl:element name="SIZE">
     <xsl:value-of select="SIZE_T"/>
    </xsl:element>
   </xsl:if>
   <!--Tablespace -->
   <xsl:if test="$TABLESPACE=1">
    <xsl:element name="TABLESPACE">
     <xsl:value-of select="TS_NAME"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="HASHKEYS!=0">
    <!-- hashkeys_clause -->
    <xsl:element name="HASHKEYS">
     <xsl:if test="FLAGS mod 131072>=65536">
      <!-- Single table 0x010000-->
      <xsl:element name="SINGLE_TABLE"/>
     </xsl:if>
     <xsl:if test="HASHKEYS!=0">
      <xsl:element name="VALUES">
       <xsl:value-of select="HASHKEYS"/>
      </xsl:element>
     </xsl:if>
     <xsl:choose>
      <xsl:when test="FUNCTION=0 and HASHKEYS !=0">
       <xsl:element name="HASH_EXPR">
        <xsl:value-of select="COL_LIST/COL_LIST_ITEM/NAME"/>
       </xsl:element>
      </xsl:when>
      <xsl:when test="FUNCTION=2 and string-length(FUNCLEN)> 0">
       <xsl:element name="HASH_EXPR">
        <xsl:choose>
         <xsl:when test="FUNC_CLOB">
          <xsl:call-template name="Trim_string">
           <xsl:with-param name="String" select="FUNC_CLOB"/>
           <xsl:with-param name="TrimAllWS">1</xsl:with-param>
          </xsl:call-template>
         </xsl:when>
         <xsl:when test="FUNC_VCNT">
          <xsl:call-template name="Trim_string">
           <xsl:with-param name="String" select="FUNC_VCNT"/>
           <xsl:with-param name="TrimAllWS">1</xsl:with-param>
          </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
          <xsl:call-template name="Trim_string">
           <xsl:with-param name="String" select="FUNCTXT"/>
           <xsl:with-param name="TrimAllWS">1</xsl:with-param>
          </xsl:call-template>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:element>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:if>
   <!--parallel_clause -->
   <xsl:call-template name="ParallelClause">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- row dependencies -->
   <xsl:if test="(FLAGS mod 16777216)>=8388608">
    <xsl:element name="ROW_DEPENDENCIES"/>
   </xsl:if>
   <!-- cache -->
   <xsl:if test="(FLAGS mod 16)>=8">
    <xsl:element name="CACHE"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
