<?xml version="1.0"?>
<!--
NAME
    kusclusd.xsl
DESCRIPTION
    Convert CLUSTER (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge      05/19/08 - Merge 11GC functionality
    htseng      12/22/05 - 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    htseng      05/23/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kustabld.xsl"/>
 <xsl:import href="kusstorg.xsl"/>
 <xsl:import href="kustbphd.xsl"/>
 <xsl:import href="kusindxd.xsl"/>
 <!-- Top-level parameters -->
  <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for CLUSTER.


******************************************************************** -->
 <xsl:template match="sxml:CLUSTER">
  <xsl:text>CREATE CLUSTER </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <!-- column_list -->
  <xsl:text>( </xsl:text>
  <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;    </xsl:text>
   </xsl:if>
   <xsl:text>"</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>" </xsl:text>
   <xsl:call-template name="Datatype"/>
   <xsl:apply-templates select="sxml:SORT"/>
   <xsl:if test="position()!=last()">, </xsl:if>
  </xsl:for-each>
  <xsl:text>) </xsl:text>
  <!-- SIZE -->
  <xsl:if test="sxml:SIZE">
   <xsl:text> SIZE </xsl:text>
   <xsl:value-of select="sxml:SIZE"/>
  </xsl:if>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:call-template name="PhysicalAttributes">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="(sxml:TABLESPACE) and ($TABLESPACE=1)">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> TABLESPACE "</xsl:text>
    <xsl:value-of select="sxml:TABLESPACE"/>
    <xsl:text>"</xsl:text>
   </xsl:if>
  </xsl:if>
  <!--hashkeys_clause -->
  <xsl:if test="sxml:HASHKEYS">
   <xsl:if test="sxml:HASHKEYS/sxml:SINGLE_TABLE">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>SINGLE TABLE </xsl:text>
   </xsl:if>
   <xsl:if test="sxml:HASHKEYS/sxml:VALUES">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>HASHKEYS </xsl:text>
    <xsl:value-of select="sxml:HASHKEYS/sxml:VALUES"/>
   </xsl:if>
   <xsl:if test="sxml:HASHKEYS/sxml:HASH_EXPR">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>HASH IS </xsl:text>
    <xsl:value-of select="sxml:HASHKEYS/sxml:HASH_EXPR"/>
   </xsl:if>
  </xsl:if>
  <xsl:if test="sxml:ROW_DEPENDENCIES">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>ROWDEPENDENCIES </xsl:text>
  </xsl:if>
  <!-- parallel_clause  -->
  <xsl:call-template name="DoParallel">
   <xsl:with-param name="AttNode" select="."/>
  </xsl:call-template>
  <xsl:if test="sxml:CACHE">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>CACHE </xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
