<?xml version="1.0"?>
<!--
 Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
NAME
    kuscnstd.xsl
DESCRIPTION
    Convert CONSTRAINTS in TABLE document (SXML) to creation DDL.
    Also handle SUPPLEMENTAL LOGGING

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    rapayne     10/25/08 - bug: 7475384: use NOVALIDATE if @src=2.
    rapayne     07/05/08 - SET_NULL expression missing a single quote.
    rapayne     05/05/08 - ON_DELETE value SET_NULL needs to generate 'SET NULL' ddl.
    rapayne     03/01/08 - filter out PRIMARY_KEY_CONSTRAINT_LIST_ITEMs which are being deleted. 
    rapayne     02/20/08 - fix NOVALIDATE - account for diff attributes correctly.
    lbarton     11/27/07 - bug 6474004: RELY
    lbarton     11/20/06 - remove ENABLE VALIDATE
    lbarton     11/03/06 - USING_INDEX transform param
    lbarton     10/18/06 - import kuscommc
    lbarton     09/15/06 - PARSED_CONDITION
    lbarton     03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS params 
                           for SXMLDDL 
    lbarton     11/10/05 - bug 4724986: handle quoted names 
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     01/17/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <xsl:import href="kusidxwd.xsl"/>
 <xsl:import href="kusparsd.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="USING_INDEX">1</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:NOT_NULL">
  <!-- *******************************************************************
Template: NOT_NULL: not null constraint for column item
Current node: NOT_NULL
******************************************************************** -->
  <xsl:if test="sxml:NAME and not(sxml:NAME/@src='1')">
   <xsl:text> CONSTRAINT "</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:text> NOT NULL</xsl:text>
  <xsl:call-template name="ConstraintState">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ConstraintState">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: ConstraintState
Parameters:
 ParentNode: parent of DISABLE, etc.
******************************************************************** -->
  <xsl:call-template name="ConstraintState1">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:call-template name="ConstraintState2">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ConstraintState1">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: ConstraintState1 - DEFERRABLE, INITIALLY DEFERRED, RELY
 (Apparently these clauses must precede USING INDEX)
Parameters:
 ParentNode: parent of DISABLE, etc.
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:DEFERRABLE"> DEFERRABLE</xsl:if>
  <xsl:if test="$ParentNode/sxml:INITIALLY_DEFERRED"> INITIALLY DEFERRED</xsl:if>
  <xsl:if test="$ParentNode/sxml:RELY"> RELY</xsl:if>
 </xsl:template>
 <xsl:template name="ConstraintState2">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: ConstraintState2 - 
 (Apparently these clauses must follow USING INDEX)
Parameters:
 ParentNode: parent of DISABLE, etc.

 If the element has the src attribute set to '1', we know the element
 is in a diff doc and came from document 1.  When constraint states differ,
 we only want the state from document 2, so we skip constraint state values
 from document 1.
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:DISABLE">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:DISABLE/@src='1'">
      <xsl:text> ENABLE</xsl:text>
      <xsl:call-template name="DoValidate">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="Enable">1</xsl:with-param>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> DISABLE</xsl:text>
      <xsl:call-template name="DoValidate">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
       <xsl:with-param name="Enable">0</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> ENABLE</xsl:text>
    <xsl:call-template name="DoValidate">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Enable">1</xsl:with-param>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoValidate">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Enable">0</xsl:param>
  <!-- *******************************************************************
Template: DoValidate: emit VALIDATE or NOVALIDATE depending on
    whether ENABLE or DISABLE is specified.  VALIDATE is the default
    for ENABLE so it can be omitted; ditto NOVALIDATE for DISABLE
    Note: if the target doc (i.e., src=2) explicitly has NOVALIDATE then use it.
Parameters:
 ParentNode: parent of DISABLE, etc.
 Enable: 0 = DISABLE specified, 1 = ENABLE specified
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:NOVALIDATE">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:NOVALIDATE/@src='2'"> NOVALIDATE</xsl:when>
     <xsl:when test="$ParentNode/sxml:NOVALIDATE/@src='1'">
      <xsl:if test="$Enable='0'"> VALIDATE</xsl:if>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="$Enable='1'"> NOVALIDATE</xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$Enable='0'"> VALIDATE</xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="Constraints">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="IOT">0</xsl:param>
  <!-- *******************************************************************
Template: Constraints
Current node: TABLE
Parameters:
 ParentNode - Parent of *_CONSTRAINT_LIST
 IOT - non-0 = this is an IOT
******************************************************************** -->
  <xsl:if test="$CONSTRAINTS!=0">
   <xsl:apply-templates select="$ParentNode/sxml:CHECK_CONSTRAINT_LIST">
    <xsl:with-param name="IOT" select="$IOT"/>
   </xsl:apply-templates>
  </xsl:if>
  <xsl:if test="$CONSTRAINTS!=0 or $IOT!=0">
   <xsl:apply-templates select="$ParentNode/sxml:PRIMARY_KEY_CONSTRAINT_LIST"/>
  </xsl:if>
  <xsl:if test="$CONSTRAINTS!=0">
   <xsl:apply-templates select="$ParentNode/sxml:UNIQUE_KEY_CONSTRAINT_LIST"/>
  </xsl:if>
  <xsl:if test="$REF_CONSTRAINTS!=0">
   <xsl:apply-templates select="$ParentNode/sxml:FOREIGN_KEY_CONSTRAINT_LIST"/>
  </xsl:if>
  <xsl:if test="$CONSTRAINTS!=0">
   <xsl:apply-templates select="$ParentNode/sxml:SCOPE_CONSTRAINT_LIST"/>
   <xsl:apply-templates select="$ParentNode/sxml:ROWID_CONSTRAINT_LIST"/>
   <xsl:apply-templates select="$ParentNode/sxml:SUPPLEMENTAL_LOGGING"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:CHECK_CONSTRAINT_LIST">
  <xsl:param name="IOT">0</xsl:param>
  <!-- *******************************************************************
Template: CHECK_CONSTRAINT_LIST
Parameters:
 IOT - non-0 = this is an IOT
******************************************************************** -->
  <xsl:for-each select="sxml:CHECK_CONSTRAINT_LIST_ITEM">
   <xsl:call-template name="CheckConstraint">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                (../../sxml:FOREIGN_KEY_CONSTRAINT_LIST and $REF_CONSTRAINTS!=0) or
                (../../sxml:PRIMARY_KEY_CONSTRAINT_LIST and ($CONSTRAINTS!=0 or $IOT!=0)) or
                ((../../sxml:UNIQUE_KEY_CONSTRAINT_LIST or
                ../../sxml:SCOPE_CONSTRAINT_LIST or
                ../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="CheckConstraint">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: CheckConstraint - emit a check constraint
Parameters:
 ParentNode: CHECK_CONSTRAINT_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:NAME">
   <xsl:text>CONSTRAINT "</xsl:text>
   <xsl:value-of select="$ParentNode/sxml:NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text>CHECK (</xsl:text>
  <!-- either CONDITION or PARSED_CONDITION will be present but not both -->
  <xsl:value-of select="$ParentNode/sxml:CONDITION"/>
  <xsl:apply-templates select="sxml:PARSED_CONDITION"/>
  <xsl:text>)</xsl:text>
  <xsl:call-template name="ConstraintState">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:PRIMARY_KEY_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: PRIMARY_KEY_CONSTRAINT_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:PRIMARY_KEY_CONSTRAINT_LIST_ITEM[not(@src='1')]">
  <xsl:call-template name="PrimaryKeyConstraint">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                (../../sxml:FOREIGN_KEY_CONSTRAINT_LIST and $REF_CONSTRAINTS!=0) or
                ((../../sxml:UNIQUE_KEY_CONSTRAINT_LIST or
                ../../sxml:SCOPE_CONSTRAINT_LIST or
                ../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="PrimaryKeyConstraint">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: PrimaryKeyConstraint - emit a primary key constraint
Parameters:
 ParentNode: PRIMARY_KEY_CONSTRAINT_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:NAME">
   <xsl:text>CONSTRAINT "</xsl:text>
   <xsl:value-of select="$ParentNode/sxml:NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text>PRIMARY KEY (</xsl:text>
  <xsl:for-each select="$ParentNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
   </xsl:call-template>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
  <xsl:call-template name="ConstraintState1">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <xsl:call-template name="UsingIndex"/>
  <xsl:call-template name="ConstraintState2">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="UsingIndex">
  <!-- *******************************************************************
Template: UsingIndex
Current Node: parent of USING_INDEX
******************************************************************** -->
  <xsl:if test="sxml:USING_INDEX and $SEGMENT_ATTRIBUTES!=0 and $USING_INDEX!=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> USING INDEX</xsl:text>
   <xsl:choose>
    <xsl:when test="sxml:USING_INDEX/sxml:INDEX_ATTRIBUTES">
     <xsl:call-template name="IndexProperties">
      <xsl:with-param name="IndNode" select="sxml:USING_INDEX"/>
      <xsl:with-param name="ConstraintIndex">1</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="sxml:USING_INDEX/sxml:INDEX">
     <xsl:text> (</xsl:text>
     <xsl:call-template name="DoIndex">
      <xsl:with-param name="IndNode" select="sxml:USING_INDEX/sxml:INDEX"/>
      <xsl:with-param name="ConstraintIndex">1</xsl:with-param>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:UNIQUE_KEY_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: UNIQUE_KEY_CONSTRAINT_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:UNIQUE_KEY_CONSTRAINT_LIST_ITEM">
   <xsl:call-template name="UniqueKeyConstraint">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                (../../sxml:FOREIGN_KEY_CONSTRAINT_LIST and $REF_CONSTRAINTS!=0) or
                ((../../sxml:SCOPE_CONSTRAINT_LIST or
                ../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="UniqueKeyConstraint">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: UniqueKeyConstraint - emit a unique key constraint
Parameters:
 ParentNode: UNIQUE_KEY_CONSTRAINT_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:if test="sxml:NAME">
   <xsl:text>CONSTRAINT "</xsl:text>
   <xsl:value-of select="$ParentNode/sxml:NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text>UNIQUE (</xsl:text>
  <xsl:for-each select="$ParentNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
   </xsl:call-template>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
  <xsl:call-template name="ConstraintState1">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
  <xsl:call-template name="UsingIndex"/>
  <xsl:call-template name="ConstraintState2">
   <xsl:with-param name="ParentNode" select="$ParentNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:FOREIGN_KEY_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: FOREIGN_KEY_CONSTRAINT_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:FOREIGN_KEY_CONSTRAINT_LIST_ITEM">
   <xsl:call-template name="ForeignKeyConstraint">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                ((../../sxml:SCOPE_CONSTRAINT_LIST or
                ../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="ForeignKeyConstraint">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: ForeignKeyConstraint - emit a foreign key constraint
Parameters:
 ParentNode: FOREIGN_KEY_CONSTRAINT_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:NAME">
   <xsl:text>CONSTRAINT "</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text>FOREIGN KEY (</xsl:text>
  <xsl:for-each select="$ParentNode/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="sxml:NAME"/>
   </xsl:call-template>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
  <xsl:if test="$PRETTY">
   <xsl:text>&#xa;	</xsl:text>
  </xsl:if>
  <xsl:text> REFERENCES </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$ParentNode/sxml:REFERENCES"/>
  </xsl:call-template>
  <xsl:if test="$ParentNode/sxml:REFERENCES/sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:text> (</xsl:text>
   <xsl:for-each select="$ParentNode/sxml:REFERENCES/sxml:COL_LIST/sxml:COL_LIST_ITEM">
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="sxml:NAME"/>
    </xsl:call-template>
    <xsl:if test="position()!=last()">,</xsl:if>
   </xsl:for-each>
   <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:apply-templates select="$ParentNode/sxml:REFERENCES/sxml:ON_DELETE"/>
  <xsl:call-template name="ConstraintState">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:ON_DELETE">
  <!-- *******************************************************************
Template: ON_DELETE
Description: valid values are CASCADE and SET_NULL. However,
     SET_NULL needs to generate 'SET NULL' ddl.
******************************************************************** -->
  <xsl:text> ON DELETE </xsl:text>
  <xsl:choose>
   <xsl:when test=". = 'SET_NULL'">
    <xsl:text>SET NULL</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="."/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:SCOPE_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: SCOPE_CONSTRAINT_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:SCOPE_CONSTRAINT_LIST_ITEM">
   <xsl:call-template name="ScopeConstraint">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                ((../../sxml:ROWID_CONSTRAINT_LIST or
                ../../sxml:SUPPLEMENTAL_LOGGING) and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="ScopeConstraint">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: ScopeConstraint - emit a scope constraint
Parameters:
 ParentNode: SCOPE_CONSTRAINT_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:text>SCOPE FOR ("</xsl:text>
  <xsl:value-of select="$ParentNode/sxml:COL"/>
  <xsl:text>") IS </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="$ParentNode/sxml:REFERENCES"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template match="sxml:ROWID_CONSTRAINT_LIST">
  <!-- *******************************************************************
Template: ROWID_CONSTRAINT_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:ROWID_CONSTRAINT_LIST_ITEM">
   <xsl:call-template name="RowidConstraint">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                (../../sxml:SUPPLEMENTAL_LOGGING and $CONSTRAINTS!=0)">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="RowidConstraint">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: RowidConstraint - emit a rowid constraint
Parameters:
 ParentNode: ROWID_CONSTRAINT_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:text>REF (</xsl:text>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:COL"/>
  </xsl:call-template>
  <xsl:text>) WITH ROWID</xsl:text>
  <xsl:if test="$ParentNode/sxml:ALLOW_PRIMARY_KEY">
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;	</xsl:text>
   </xsl:if>
   <xsl:text>REF (</xsl:text>
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:COL"/>
   </xsl:call-template>
   <xsl:text>) ALLOW PRIMARY KEY</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SUPPLEMENTAL_LOGGING">
  <!-- *******************************************************************
Template: SUPPLEMENTAL_LOGGING
******************************************************************** -->
  <xsl:apply-templates select="sxml:GROUP_LIST"/>
  <xsl:apply-templates select="sxml:ID_LIST"/>
 </xsl:template>
 <xsl:template match="sxml:GROUP_LIST">
  <!-- *******************************************************************
Template: GROUP_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:GROUP_LIST_ITEM">
   <xsl:call-template name="GroupListItem">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last() or
                ../../sxml:ID_LIST">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="GroupListItem">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: GroupListItem
Parameters:
 ParentNode: GROUP_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:text>SUPPLEMENTAL LOG GROUP </xsl:text>
  <xsl:call-template name="QuotedName">
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
  </xsl:call-template>
  <xsl:text> </xsl:text>
  <xsl:call-template name="ColumnList">
   <xsl:with-param name="ColListNode" select="$ParentNode/sxml:COL_LIST"/>
   <xsl:with-param name="NoLog">1</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="$ParentNode/sxml:ALWAYS"> ALWAYS</xsl:if>
 </xsl:template>
 <xsl:template match="sxml:ID_LIST">
  <!-- *******************************************************************
Template: ID_LIST
******************************************************************** -->
  <xsl:for-each select="sxml:ID_LIST_ITEM">
   <xsl:call-template name="IdListItem">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="position()!=last()">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="IdListItem">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: IdListItem
Parameters:
 ParentNode: ID_LIST_ITEM
******************************************************************** -->
  <xsl:if test="$PRETTY">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:text>SUPPLEMENTAL LOG DATA (</xsl:text>
  <xsl:choose>
   <xsl:when test="$ParentNode/sxml:COLUMNS='ALL'">ALL</xsl:when>
   <xsl:when test="$ParentNode/sxml:COLUMNS='PRIMARY_KEY'">PRIMARY KEY</xsl:when>
   <xsl:when test="$ParentNode/sxml:COLUMNS='UNIQUE'">UNIQUE INDEX</xsl:when>
   <xsl:when test="$ParentNode/sxml:COLUMNS='FOREIGN_KEY'">FOREIGN KEY</xsl:when>
  </xsl:choose>
  <xsl:text>) COLUMNS</xsl:text>
 </xsl:template>
</xsl:stylesheet>
