<?xml version="1.0"?>
<!--
NAME
    kusfgad.xsl
DESCRIPTION
    Convert FGA_POLICY (SXML) document to creation DDL.

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     07/07/05 - 
    htseng      04/12/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for  FGA_POLICY.


******************************************************************** -->
 <xsl:template match="sxml:FGA_POLICY">
  <xsl:text>  BEGIN DBMS_FGA.ADD_POLICY('</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:POLICY_NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:AUDIT_CONDITION">
    <xsl:text>'</xsl:text>
    <xsl:value-of select="sxml:AUDIT_CONDITION"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:AUDIT_COLUMN_LIST">
    <xsl:text>'</xsl:text>
    <xsl:for-each select="sxml:AUDIT_COLUMN_LIST/sxml:AUDIT_COLUMN_LIST_ENTRY">
     <xsl:text>"</xsl:text>
     <xsl:value-of select="sxml:NAME"/>
     <xsl:text>"</xsl:text>
     <xsl:if test="position()!=last()">,</xsl:if>
    </xsl:for-each>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:HANDLER_SCHEMA">
    <xsl:text>'</xsl:text>
    <xsl:value-of select="sxml:HANDLER_SCHEMA"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:HANDLER_MODULE">
    <xsl:text>'</xsl:text>
    <xsl:value-of select="sxml:HANDLER_MODULE"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:ENABLE='Y'">
    <xsl:text>TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,'</xsl:text>
  <xsl:for-each select="sxml:STATEMENT_TYPE_LIST/sxml:STATEMENT_TYPE_LIST_ENTRY/sxml:NAME">
   <xsl:value-of select="."/>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>',DBMS_FGA.</xsl:text>
  <xsl:value-of select="sxml:AUDIT_TRAIL"/>
  <xsl:text>,DBMS_FGA.</xsl:text>
  <xsl:value-of select="sxml:AUDIT_COLUMN_OPTS"/>
  <xsl:text>')</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
