<?xml version="1.0"?>
<!--
 Copyright (c) 2005, 2009, Oracle and/or its affiliates.All rights reserved. 
NAME
    kusidxwk.xsl
DESCRIPTION
    Common functions for converting mdapi IND/INDEX_T to SXML
MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton     09/30/08 - bug 7334782 (again): more xmltype virtual columns
    sdavidso    08/19/08 - bug 7272424: index on system partitioned table
    lbarton     06/18/08 - bug 7188926: parameters in partitioned domain index
    abodge      05/19/08 - Merge 11GC functionality
    lbarton     01/17/08 - Bug 6724820: table compression
    pkaliren    01/09/08 - No null tags for statistics
    pkaliren    11/28/07 - optimizer statistics
    abodge      10/10/07 - Get BJI fixes
    rapayne     01/10/07 - 
    lbarton     06/23/06 - PARSE_EXPRESSIONS param 
    sdavidso    05/09/06 - support invisible index attribute 
    sdavidso    05/01/06 - support parameters in domain index partitions
    htseng      16/12/05 - add transform param PARTITIONING
    lbarton     11/08/05 - Initial version
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kusstorg.xsl"/>
 <xsl:import href="kuspar.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PARTITIONING">1</xsl:param>
  <xsl:param name="STATISTICS">0</xsl:param>
 <!-- Templates -->
 <xsl:template name="DoIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: DoIndex - used for INDEX_T and IND in constraints
  This template puts out
   - the opening INDEX element (with xmlns and version attributes)
   - BITMAP or UNIQUE elements (optional)
   - SCHEMA and NAME elements
  then calls one of
   - ClusterIndex
   - BitmapJoinIndex
   - TableIndex
Parameters:
 IndNode - INDEX_T node or IND node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:element name="INDEX">
   <!-- See note about xmlns attribute in kustable.xsl -->
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- BITMAP and UNIQUE not valid for cluster index -->
   <xsl:if test="$IndNode/BASE_OBJ/TYPE_NUM!=3">
    <xsl:choose>
     <xsl:when test="$IndNode/TYPE_NUM='2'">
      <xsl:element name="BITMAP"/>
     </xsl:when>
     <xsl:when test="($IndNode/PROPERTY mod 2)=1">
      <xsl:element name="UNIQUE"/>
     </xsl:when>
    </xsl:choose>
   </xsl:if>
   <!-- the SCHEMA_OBJ template is in kuscomm.xsl -->
   <xsl:apply-templates select="$IndNode/SCHEMA_OBJ"/>
   <!-- dispatch to appropriate template: cluster index,
      bitmap join index, or table index -->
   <xsl:choose>
    <xsl:when test="$IndNode/BASE_OBJ/TYPE_NUM=3">
     <xsl:element name="CLUSTER_INDEX">
      <xsl:call-template name="ClusterIndex">
       <xsl:with-param name="IndNode" select="$IndNode"/>
       <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:when test="($IndNode/PROPERTY mod 2048)>=1024">
     <xsl:element name="BITMAP_JOIN_INDEX">
      <xsl:call-template name="BitmapJoinIndex">
       <xsl:with-param name="IndNode" select="$IndNode"/>
       <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="TABLE_INDEX">
      <xsl:call-template name="TableIndex">
       <xsl:with-param name="IndNode" select="$IndNode"/>
       <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
      </xsl:call-template>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="(string(ROWCNT) and not ($STATISTICS=0))">
    <xsl:element name="STATISTICS">
     <xsl:call-template name="CreIndexStats"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
<xsl:template name="CreIndexStats">
  <!-- *******************************************************************
Template: CreIndexStats - processing index stats
Current node: INDEX_T
  Emit the following:
ROWCNT
 BLKCNT
 EMPCNT
 AVGSPC
 CHNCNT
 AVGRLN
 AVGSPC_FLB
 FLBCNT
 ANALYZETIME
 SAMPLESIZE
 BLEVEL
 LEAFCNT
 DISTKEY
 LBLKKEY
 DBLKKEY
******************************************************************** -->
  <xsl:element name="ROWCNT">
   <xsl:value-of select="ROWCNT"/>
  </xsl:element>
  <xsl:element name="BLEVEL">
  <xsl:value-of select="BLEVEL"/>
 </xsl:element>
 <xsl:element name="LEAFCNT">
  <xsl:value-of select="LEAFCNT"/>
 </xsl:element>
  <xsl:element name="DISTKEY">
  <xsl:value-of select="DISTKEY"/>
 </xsl:element>
  <xsl:element name="LBLKKEY">
  <xsl:value-of select="LBLKKEY"/>
 </xsl:element>
  <xsl:element name="DBLKKEY">
  <xsl:value-of select="DBLKKEY"/>
 </xsl:element>
  <xsl:element name="CLUFAC">
  <xsl:value-of select="CLUFAC"/>
  </xsl:element>
 </xsl:template>
 <xsl:template name="ClusterIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: ClusterIndex
Parameters:
 IndNode - INDEX_T node or IND node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:element name="ON_CLUSTER">
   <xsl:apply-templates select="$IndNode/BASE_OBJ"/>
  </xsl:element>
  <xsl:call-template name="IndexAttributes">
   <xsl:with-param name="IndNode" select="$IndNode"/>
   <xsl:with-param name="StorageParentNode" select="$IndNode"/>
   <xsl:with-param name="Partitioned">0</xsl:with-param>
   <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
  </xsl:call-template>
  <!-- Check if index is USABLE and/or if MONITORING is enabled -->
  <xsl:call-template name="CheckIndUsage">
   <xsl:with-param name="IndNode" select="$IndNode"/>
   <xsl:with-param name="IndFlags" select="$IndNode/FLAGS"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="TableIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: TableIndex
Parameters:
 IndNode - INDEX_T node or IND node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:element name="ON_TABLE">
   <xsl:apply-templates select="$IndNode/BASE_OBJ"/>
  </xsl:element>
  <!-- column list -->
  <xsl:element name="COL_LIST">
   <xsl:for-each select="$IndNode/COL_LIST/COL_LIST_ITEM">
    <xsl:element name="COL_LIST_ITEM">
     <xsl:choose>
      <!-- check PROPERTY flags: functional index virt column is marked
         both virtual and hidden
                    /* 0x0020 =      32 = hidden column                      */
                /* 0x00010000 =   65536 = virtual column                     */
         In such case we put out col$.default$ which contains the
         defining functional expression.
         HOWEVER, if this bit
                /* 0x0008 =       8 = virtual column                         */
         is also set and these bits are clear:
                /* 0x0100 =     256 = system-generated column                */
                /* 0x0200 =     512 = rowinfo column of typed table/view     */
                /* 0x4000 =   16384 = dropped column                         */
         that means it is an XMLType virtual column, and we should use the
         column name.
     -->
      <xsl:when test="(COL/PROPERTY mod 16 >= 8) and
                      (COL/PROPERTY mod 64 >= 32) and
                      (COL/PROPERTY mod 131052 >= 65536) and
                      (256 > (COL/PROPERTY mod 512)) and
                      (512 > (COL/PROPERTY mod 1024)) and
                      (16384 > (COL/PROPERTY mod 32768))">
       <!-- xmltype virtual column: use column name -->
       <xsl:call-template name="ColName">
        <xsl:with-param name="ColNode" select="COL"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="((COL/PROPERTY mod 64)>=32 
                 and (COL/PROPERTY mod 131072)>=65536)">
       <!-- functional index -->
       <xsl:choose>
        <xsl:when test="$PARSE_EXPRESSIONS=1 and COL/COL_EXPR">
         <xsl:element name="COLUMN_EXPRESSION">
          <xsl:copy-of select="COL/COL_EXPR/*"/>
         </xsl:element>
        </xsl:when>
        <xsl:otherwise>
         <xsl:element name="NAME">
          <xsl:value-of select="COL/DEFAULT_VAL"/>
         </xsl:element>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="ColName">
        <xsl:with-param name="ColNode" select="COL"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
     <!-- DESCending order index is bit 0x20000 (131072) in col$.property -->
     <xsl:if test="(COL/PROPERTY mod 262144)>=131072">
      <xsl:element name="DESC"/>
     </xsl:if>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
  <!-- if this is an index on a temporary table, skip segment attrs -->
  <xsl:if test="2>($IndNode/BASE_OBJ/FLAGS mod 4)">
   <!-- index properties -->
   <xsl:call-template name="IndexProperties">
    <xsl:with-param name="IndNode" select="$IndNode"/>
    <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
   </xsl:call-template>
  </xsl:if>
  <!-- Check if the index is USABLE and/or if MONITORING is enabled -->
  <xsl:call-template name="CheckIndUsage">
   <xsl:with-param name="IndNode" select="$IndNode"/>
   <xsl:with-param name="IndFlags" select="$IndNode/FLAGS"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="IndexProperties">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: IndexProperties
Parameters:
 IndNode - INDEX_T node or IND node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:choose>
   <!-- domain index -->
   <xsl:when test="$IndNode/TYPE_NUM=9">
    <xsl:element name="DOMAIN_INDEX_PROPERTIES">
     <xsl:call-template name="DomainIndex">
      <xsl:with-param name="IndNode" select="$IndNode"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <!-- partitioned index -->
   <xsl:when test="$IndNode/PART_OBJ">
    <!-- index attributes -->
    <xsl:call-template name="IndexAttributes">
     <xsl:with-param name="IndNode" select="$IndNode"/>
     <xsl:with-param name="StorageParentNode" select="$IndNode/PART_OBJ/PARTOBJ"/>
     <xsl:with-param name="Partitioned">1</xsl:with-param>
     <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
     <xsl:with-param name="DefaultBlocksize" select="$IndNode/BLOCKSIZE"/>
    </xsl:call-template>
    <xsl:if test="$PARTITIONING =1">
     <xsl:choose>
      <!-- local partitioning -->
      <xsl:when test="($IndNode/PART_OBJ/PARTOBJ/FLAGS mod 2)=1">
       <xsl:call-template name="LocalPartitionedIndex">
        <xsl:with-param name="IndNode" select="$IndNode"/>
       </xsl:call-template>
      </xsl:when>
      <!-- global partitioning -->
      <xsl:otherwise>
       <xsl:call-template name="GlobalPartitionedIndex">
        <xsl:with-param name="IndNode" select="$IndNode"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
   </xsl:when>
   <!-- non-partitioned index -->
   <xsl:otherwise>
    <xsl:call-template name="IndexAttributes">
     <xsl:with-param name="IndNode" select="$IndNode"/>
     <xsl:with-param name="StorageParentNode" select="$IndNode"/>
     <xsl:with-param name="Partitioned">0</xsl:with-param>
     <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="BitmapJoinIndex">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!-- *******************************************************************
Template: BitmapJoinIndex
Parameters:
 IndNode - INDEX_T node or IND node
 ConstraintIndex - 1 = INDEX SXML in constraint
******************************************************************** -->
  <xsl:element name="ON_TABLE">
   <xsl:apply-templates select="$IndNode/BASE_OBJ"/>
  </xsl:element>
  <!-- column list -->
  <xsl:element name="COL_LIST">
   <xsl:for-each select="$IndNode/COL_LIST/COL_LIST_ITEM">
    <xsl:element name="COL_LIST_ITEM">
     <xsl:call-template name="JijoinSchemaName">
      <xsl:with-param name="JijoinTabsNode" select="$IndNode/JIJOIN_TABS"/>
      <xsl:with-param name="TabObjNum" select="BO_NUM"/>
     </xsl:call-template>
     <xsl:element name="COL">
      <xsl:value-of select="COL/NAME"/>
     </xsl:element>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
  <!-- join table list -->
  <xsl:element name="JOIN_TABLE_LIST">
   <xsl:for-each select="$IndNode/JIJOIN_TABS/JIJOIN_TABS_ITEM">
    <xsl:element name="JOIN_TABLE_LIST_ITEM">
     <xsl:element name="SCHEMA">
      <xsl:value-of select="OWNER_NAME"/>
     </xsl:element>
     <xsl:element name="NAME">
      <xsl:value-of select="NAME"/>
     </xsl:element>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
  <!-- where list -->
  <xsl:element name="WHERE_LIST">
   <xsl:for-each select="$IndNode/JIJOIN/JIJOIN_ITEM">
    <xsl:element name="WHERE_LIST_ITEM">
     <xsl:element name="JOIN_LIST">
      <xsl:element name="JOIN_LIST_ITEM">
       <xsl:call-template name="JijoinSchemaName">
        <xsl:with-param name="JijoinTabsNode" select="$IndNode/JIJOIN_TABS"/>
        <xsl:with-param name="TabObjNum" select="TAB1OBJ_NUM"/>
       </xsl:call-template>
       <xsl:element name="COL">
        <xsl:value-of select="TAB1COL/NAME"/>
       </xsl:element>
      </xsl:element>
      <xsl:element name="JOIN_LIST_ITEM">
       <xsl:call-template name="JijoinSchemaName">
        <xsl:with-param name="JijoinTabsNode" select="$IndNode/JIJOIN_TABS"/>
        <xsl:with-param name="TabObjNum" select="TAB2OBJ_NUM"/>
       </xsl:call-template>
       <xsl:element name="COL">
        <xsl:value-of select="TAB2COL/NAME"/>
       </xsl:element>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
  <!-- index attributes -->
  <xsl:call-template name="IndexAttributes">
   <xsl:with-param name="IndNode" select="$IndNode"/>
   <xsl:with-param name="StorageParentNode" select="$IndNode/PART_OBJ/PARTOBJ | $IndNode"/>
   <xsl:with-param name="Partitioned">
    <xsl:choose>
     <xsl:when test="$IndNode/PART_OBJ">1</xsl:when>
     <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="ConstraintIndex" select="$ConstraintIndex"/>
   <xsl:with-param name="DefaultBlocksize" select="$IndNode/BLOCKSIZE"/>
  </xsl:call-template>
  <!-- local partitioned index -->
  <xsl:if test="(PART_OBJ) and ($PARTITIONING=1)">
   <xsl:call-template name="LocalPartitionedIndex">
    <xsl:with-param name="IndNode" select="$IndNode"/>
   </xsl:call-template>
  </xsl:if>
    
  <!-- Check if index is USABLE and/or if MONITORING is enabled -->
  <xsl:call-template name="CheckIndUsage">
   <xsl:with-param name="IndNode" select="$IndNode"/>
   <xsl:with-param name="IndFlags" select="$IndNode/FLAGS"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="JijoinSchemaName">
  <xsl:param name="JijoinTabsNode" select="''"/>
  <xsl:param name="TabObjNum" select="''"/>
  <!-- *******************************************************************
Template: JijoinSchemaName - This template emits SCHEMA and NAME
 for a column list item in a bitmap join index. The column list
 entry has the table object number (TabObjNum).  JIJOIN_TABS
 is a list of JIJOIN_TABS_ITEM entries, one for each table
 in the join index, with the table schema and name.
Parameters:
 JijoinTabsNode - JIJOIN_TABS node
 TabObjNum      - value of TABOBJ_NUM (object number of table)
******************************************************************** -->
  <xsl:element name="SCHEMA">
   <xsl:value-of select="$JijoinTabsNode/JIJOIN_TABS_ITEM[TABOBJ_NUM=$TabObjNum]/OWNER_NAME"/>
  </xsl:element>
  <xsl:element name="NAME">
   <xsl:value-of select="$JijoinTabsNode/JIJOIN_TABS_ITEM[TABOBJ_NUM=$TabObjNum]/NAME"/>
  </xsl:element>
 </xsl:template>
 <xsl:template name="IndexAttributes">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="StorageParentNode" select="''"/>
  <xsl:param name="Partitioned" select="''"/>
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <xsl:param name="DefaultBlocksize" select="''"/>
  <!-- *******************************************************************
Template: IndexAttributes
Parameters:
  IndNode - INDEX_T node
  StorageParentNode - Parent node of STORAGE, TS_NAME, PCT_FREE, etc.
  Partitioned - 0 = non-partitioned, non-0 = partitioned
  ConstraintIndex - 1 = INDEX SXML in constraint
  DefaultBlocksize - DefaultBlocksize for PhysicalAttributes
******************************************************************** -->
  <xsl:if test="not ($PHYSICAL_PROPERTIES=0) and not ($SEGMENT_ATTRIBUTES=0)">
   <xsl:element name="INDEX_ATTRIBUTES">
    <xsl:call-template name="PhysicalAttributes">
     <xsl:with-param name="ParentNode" select="$StorageParentNode"/>
     <xsl:with-param name="Partitioned" select="$Partitioned"/>
     <xsl:with-param name="ObjType" select="INDEX"/>
     <xsl:with-param name="DefaultBlocksize" select="$DefaultBlocksize"/>
    </xsl:call-template>
    <xsl:call-template name="Tablespace">
     <xsl:with-param name="ParentNode" select="$StorageParentNode"/>
    </xsl:call-template>
    <!-- logging clause (non-partitioned indexes have a different
       encoding for logging than tables, so we have to do special
       processing) -->
    <xsl:choose>
     <xsl:when test="$Partitioned=0">
      <xsl:element name="LOGGING">
       <xsl:choose>
        <xsl:when test="($StorageParentNode/FLAGS mod 8)>=4">N</xsl:when>
        <xsl:otherwise>Y</xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:when>
     <!-- for partitioned indexes we can use common code -->
     <xsl:otherwise>
      <xsl:call-template name="LoggingClause">
       <xsl:with-param name="Partitioned" select="$Partitioned"/>
       <xsl:with-param name="FlagsNode" select="''"/>
       <xsl:with-param name="DefloggingNode" select="$StorageParentNode/DEFLOGGING"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
    <!-- key compression:
       ind$.flags
           key compression enabled : 0x20
       ind$.spare2 (which we call NUMKEYCOLS)
           number of key columns in compressed prefix
    -->
    <xsl:if test="($IndNode/FLAGS mod 64)>=32
             and $IndNode/NUMKEYCOLS">
     <xsl:element name="KEYCOMPRESS">
      <xsl:value-of select="$IndNode/NUMKEYCOLS"/>
     </xsl:element>
    </xsl:if>
    <!-- REVERSE -->
    <xsl:if test="($IndNode/PROPERTY mod 8)>=4">
     <xsl:element name="REVERSE"/>
    </xsl:if>
    <!-- INVISIBLE -->
    <xsl:if test="($IndNode/FLAGS mod 4194304)>=2097152">
     <xsl:element name="INVISIBLE"/>
    </xsl:if>
    <!-- parallel clause -->
    <xsl:if test="$ConstraintIndex=0">
     <xsl:call-template name="ParallelClause">
      <xsl:with-param name="ParentNode" select="$IndNode"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DomainIndex">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: DomainIndex
Parameters:
  IndNode - INDEX_T node
******************************************************************** -->
  <xsl:element name="INDEXTYPE">
   <xsl:element name="SCHEMA">
    <xsl:value-of select="$IndNode/INDTYPE_OWNER"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="$IndNode/INDTYPE_NAME"/>
   </xsl:element>
  </xsl:element>
  <!-- parallel clause -->
  <xsl:call-template name="ParallelClause">
   <xsl:with-param name="ParentNode" select="$IndNode"/>
  </xsl:call-template>
  <!-- parameters -->
  <xsl:choose>
   <!-- partitioned -->
   <xsl:when test="$IndNode/PART_OBJ">
    <xsl:if test="$IndNode/PART_OBJ/PARTOBJ/DEFPARAMETERS">
     <xsl:element name="PARAMETERS">
      <xsl:value-of select="$IndNode/PART_OBJ/PARTOBJ/DEFPARAMETERS"/>
     </xsl:element>
    </xsl:if>
    <xsl:element name="LOCAL_PARTITIONING">
     <xsl:element name="PARTITION_LIST">
      <xsl:for-each select="$IndNode/PART_OBJ/PART_LIST/PART_LIST_ITEM">
       <xsl:element name="PARTITION_LIST_ITEM">
        <xsl:element name="NAME">
         <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
        </xsl:element>
        <xsl:if test="PARAMETERS">
         <xsl:element name="PARAMETERS">
          <xsl:value-of select="PARAMETERS"/>
         </xsl:element>
        </xsl:if>
       </xsl:element>
      </xsl:for-each>
     </xsl:element>
    </xsl:element>
   </xsl:when>
   <!-- non-partitioned -->
   <xsl:when test="$IndNode/SPARE4">
    <xsl:element name="PARAMETERS">
     <xsl:value-of select="$IndNode/SPARE4"/>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="LocalPartitionedIndex">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: LocalPartitionedIndex
Parameters:
  IndNode - INDEX_T node
******************************************************************** -->
  <xsl:element name="LOCAL_PARTITIONING">
   <!--
  <xsl:call-template name="DoPartColList">
   <xsl:with-param name="PartcolsNode" select="$IndNode/PART_OBJ/PARTCOLS"/>
  </xsl:call-template>
-->
   <xsl:choose>
    <xsl:when test="$IndNode/PART_OBJ/PART_LIST/PART_LIST_ITEM">
     <xsl:call-template name="IndexPartitionList">
      <xsl:with-param name="PartListNode" select="$IndNode/PART_OBJ/PART_LIST"/>
      <xsl:with-param name="PartitionType">
       <xsl:choose>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=1">RANGE</xsl:when>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=2">HASH</xsl:when>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=3">SYSTEM</xsl:when>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=4">LIST</xsl:when>
       </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="TabBlocksize" select="$IndNode/BLOCKSIZE"/>
      <xsl:with-param name="Local">1</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$IndNode/PART_OBJ/COMPART_LIST">
     <xsl:call-template name="IndexPartitionList">
      <xsl:with-param name="PartListNode" select="$IndNode/PART_OBJ/COMPART_LIST"/>
      <xsl:with-param name="PartitionType">
       <xsl:choose>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=1">RANGE</xsl:when>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=2">HASH</xsl:when>
        <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=4">LIST</xsl:when>
       </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="TabBlocksize" select="$IndNode/BLOCKSIZE"/>
      <xsl:with-param name="Local">1</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <xsl:template name="GlobalPartitionedIndex">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: GlobalPartitionedIndex
Parameters:
  IndNode - INDEX_T node
******************************************************************** -->
  <xsl:element name="GLOBAL_PARTITIONING">
   <xsl:choose>
    <!-- range partitioning-->
    <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=1">
     <xsl:call-template name="GlobalRangePartitionedIndex">
      <xsl:with-param name="IndNode" select="$IndNode"/>
     </xsl:call-template>
    </xsl:when>
    <!-- hash partitioning-->
    <xsl:when test="$IndNode/PART_OBJ/PARTOBJ/PARTTYPE=2">
     <xsl:call-template name="GlobalHashPartitionedIndex">
      <xsl:with-param name="IndNode" select="$IndNode"/>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <xsl:template name="GlobalRangePartitionedIndex">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: GlobalRangePartitionedIndex
Parameters:
  IndNode - INDEX_T node
******************************************************************** -->
  <xsl:element name="RANGE_PARTITIONING">
   <xsl:call-template name="DoPartColList">
    <xsl:with-param name="PartcolsNode" select="$IndNode/PART_OBJ/PARTCOLS"/>
   </xsl:call-template>
   <xsl:call-template name="IndexPartitionList">
    <xsl:with-param name="PartListNode" select="$IndNode/PART_OBJ/PART_LIST"/>
    <xsl:with-param name="PartitionType">RANGE</xsl:with-param>
    <xsl:with-param name="TabBlocksize" select="$IndNode/BLOCKSIZE"/>
    <!--  BUG 4544267: In a compressed partitioned index           -->
    <!--   some partitions can be NOCOMPRESS. We pass a parameter  -->
    <!--   to indicate that compression is enabled.                -->
    <xsl:with-param name="PartCompress" select="(($IndNode/FLAGS mod 64)>=32) 
              and $IndNode/NUMKEYCOLS 
              and ($IndNode/NUMKEYCOLS > 0)"/>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="GlobalHashPartitionedIndex">
  <xsl:param name="IndNode" select="''"/>
  <!-- *******************************************************************
Template: GlobalHashPartitionedIndex
Parameters:
  IndNode - INDEX_T node
******************************************************************** -->
  <xsl:element name="HASH_PARTITIONING">
   <xsl:call-template name="DoPartColList">
    <xsl:with-param name="PartcolsNode" select="$IndNode/PART_OBJ/PARTCOLS"/>
   </xsl:call-template>
   <xsl:call-template name="IndexPartitionList">
    <xsl:with-param name="PartListNode" select="$IndNode/PART_OBJ/PART_LIST"/>
    <xsl:with-param name="PartitionType">HASH</xsl:with-param>
    <xsl:with-param name="TabBlocksize" select="$IndNode/BLOCKSIZE"/>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CheckIndUsage">
  <xsl:param name="IndNode" select="''"/>
  <xsl:param name="IndFlags" select="''"/>
  <!-- *******************************************************************
Template: CheckIndUsage - used for setting UNUSABLE and/or MONITORING_USAGE
Parameters:
 IndNode - INDEX_T node or IND node
 IndFlags - <1> = UNUSABLE
                  <?> = MONITORING enabled
******************************************************************** -->
  <xsl:if test="($IndFlags mod 2)=1">
   <xsl:element name="UNUSABLE"/>
  </xsl:if>
  <xsl:if test="($IndFlags mod 2)=1">
   <xsl:element name="MONITORING_USAGE"> </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
