<?xml version="1.0"?>
<!--
NAME
    kusmvl.xsl
DESCRIPTION
    Convert mdapi M_VIEW_LOG_T document to MATERIALIZED_VIEW_LOG document (SXML)

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton     11/28/06 - missing import
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne     11/03/05 - Bug 4715313: Reformat with XMLSpy
    htseng      07/15/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kusstorg.xsl"/>
 <xsl:import href="kuspar.xsl"/>
 <xsl:import href="kustbphy.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template:  M_VIEW_LOG_T - top-level template for MATERIALIZED_VIEW_LOG.
  This template puts out
   - the opening MATERIALIZED_VIEW_LOG element
     (with xmlns and version attributes)
   - NAME elements
******************************************************************** -->
 <xsl:template match="M_VIEW_LOG_T">
  <xsl:element name="MATERIALIZED_VIEW_LOG">
  <!-- See note about xmlns attribute in kustable.xsl --> 
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="ON_TABLE">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="MVIEWLOG/MOWNER"/>
    </xsl:element>
    <xsl:element name="NAME">
     <xsl:value-of select="MVIEWLOG/MASTER"/>
    </xsl:element>
   </xsl:element>
   <!-- segment_attributes_clause if non-partitioned -->
   <xsl:choose>
    <xsl:when test="MVIEWLOG_TAB/PART_OBJ"/>
    <xsl:otherwise>
     <xsl:call-template name="SegmentAttributes">
      <xsl:with-param name="ParentNode" select="MVIEWLOG_TAB"/>
      <xsl:with-param name="Partitioned">0</xsl:with-param>
      <xsl:with-param name="ObjType">TABLE</xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="(MVIEWLOG_TAB/FLAGS mod 16)>=8">
    <xsl:element name="CACHE"/>
   </xsl:if>
   <!-- Parallel -->
   <xsl:call-template name="ParallelClause">
    <xsl:with-param name="ParentNode" select="MVIEWLOG_TAB"/>
   </xsl:call-template>
   <!-- table partitioning -->
   <xsl:if test="MVIEWLOG_TAB/PART_OBJ">
    <xsl:call-template name="TablePartitioning">
     <xsl:with-param name="PartobjNode" select="MVIEWLOG_TAB/PART_OBJ"/>
     <xsl:with-param name="PropertyNode" select="MVIEWLOG_TAB/PROPERTY"/>
     <xsl:with-param name="ColListNode" select="MVIEWLOG_TAB/PART_OBJ/PARTCOLS"/>
     <xsl:with-param name="TabBlocksize" select="MVIEWLOG_TAB/BLOCKSIZE"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="((MVIEWLOG/FLAG mod 1024) >= 512) or
               ((MVIEWLOG/FLAG mod 4) >= 2) or
               ((MVIEWLOG/FLAG mod 2) >= 1) or
               ((MVIEWLOG/FLAG mod 8) >= 4) or
               ((MVIEWLOG/FLAG mod 2048) >= 1024)">
    <xsl:element name="RECORDS">
     <xsl:if test="(MVIEWLOG/FLAG mod 1024) >= 512">
      <xsl:element name="OBJECT_ID"/>
     </xsl:if>
     <xsl:if test="(MVIEWLOG/FLAG mod 4) >= 2">
      <xsl:element name="PRIMARY_KEY"/>
     </xsl:if>
     <xsl:if test="(MVIEWLOG/FLAG mod 2) = 1">
      <xsl:element name="ROWID"/>
     </xsl:if>
     <xsl:if test="(MVIEWLOG/FLAG mod 2048) >= 1024">
      <xsl:element name="SEQUENCE"/>
     </xsl:if>
     <!-- column_list -->
     <xsl:if test="(MVIEWLOG/FLAG mod 8) >= 4">
      <xsl:element name="COL_LIST">
       <xsl:for-each select="MVIEWLOG/FC_LIST/FC_LIST_ITEM">
        <xsl:element name="COL_LIST_ITEM">
         <xsl:element name="NAME">
          <xsl:value-of select="COLNAME"/>
         </xsl:element>
        </xsl:element>
       </xsl:for-each>
      </xsl:element>
     </xsl:if>
    </xsl:element>
   </xsl:if>
   <xsl:if test="(MVIEWLOG/FLAG mod 32) >= 16">
    <xsl:element name="INCLUDING_NEW_VALUES"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
