<?xml version="1.0"?>
<!--
NAME
    kusrlsd.xsl
DESCRIPTION
    Convert RLS_POLICY document (SXML) to creation DDL.
    Convert RLS_GROUP document (SXML) to creation DDL.
    Convert RLS_CONTEXT document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton    08/10/05 - lbarton_mddiff
    htseng     07/20/05 - 
    lbarton    07/08/05 - 
    htseng     04/11/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: top-level template for  RLS_POLICY.
Template: top-level template for  RLS_GROUP.
Template: top-level template for  RLS_CONTEXT.
  

******************************************************************** -->
 <xsl:template match="sxml:RLS_POLICY">
  <xsl:text>  BEGIN DBMS_RLS.ADD_GROUPED_POLICY('</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:POLICY_GROUP"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:POLICY_NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:FUNCTION_SCHEMA"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:POLICY_FUNCTION"/>
  <xsl:text>','</xsl:text>
  <xsl:for-each select="sxml:STATEMENT_TYPE_LIST/sxml:STATEMENT_TYPE_LIST_ENTRY/sxml:NAME">
   <xsl:value-of select="."/>
   <xsl:if test="position()!=last()">,</xsl:if>
  </xsl:for-each>
  <xsl:text>',</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:UPDATE_CHECK='Y'">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="sxml:ENABLE='Y'">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="sxml:STATIC_POLICY='Y'">
    <xsl:text>TRUE,</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="sxml:POLICY_TYPE"/>
  <xsl:text>,</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:LONG_PREDICATE='Y'">
    <xsl:text>TRUE,'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>FALSE,'</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- list of security relevant cols, ok to have empty str:
       will have something like '' (empty list) or '"COL1","COL2"'
  -->
  <xsl:for-each select="sxml:RELEVANT_COLUMN_LIST/sxml:RELEVANT_COLUMN_LIST_ENTRY/sxml:NAME">
   <xsl:text>"</xsl:text>
   <xsl:value-of select="."/>
   <xsl:text>"</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>,</xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>',</xsl:text>
  <!-- security relevant cols option -->
  <xsl:choose>
   <xsl:when test="sxml:ALL_ROWS">
    <xsl:text>dbms_rls.ALL_ROWS</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>)</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator"/>
 </xsl:template>
 <!-- Template to recreate RLS_GROUP -->
 <xsl:template match="sxml:RLS_GROUP">
  <xsl:text>  BEGIN DBMS_RLS.CREATE_POLICY_GROUP('</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:POLICY_GROUP"/>
  <xsl:text>')</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
 <!-- Template to recreate RLS_CONTEXT -->
 <xsl:template match="sxml:RLS_CONTEXT">
  <xsl:text>  BEGIN DBMS_RLS.ADD_POLICY_CONTEXT('</xsl:text>
  <xsl:value-of select="sxml:SCHEMA"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:NAMESPACE"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="sxml:ATTRIBUTE"/>
  <xsl:text>')</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
