<?xml version="1.0"?>
<!-- Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
All rights reserved. -->
<!--
NAME
    kusstorg.xsl
DESCRIPTION
    This is a utility stylesheet for generating SXML syntax for
    physical attributes:
     - segment_attributes_clause
     - physical_attributes_clause
     - storage_clause

MODIFIED        MM/DD/YY
    abodge      04/20/09 - Fix lrg 3860916
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge      05/19/08 - Merge 11GC functionality
    lbarton     02/11/08 - reference/system partitioning
    lbarton     03/19/08 - deferred segment creation
    slynn       10/12/06 - smartfile->securefile
    htseng      07/31/06 - add lobretention/maxsize support
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     09/12/05 - Move no blocksize error to StorageClause 
    lbarton     08/10/05 - lbarton_mddiff
    lbarton     11/04/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <!-- Templates -->
 <xsl:template name="SegmentAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Partitioned" select="''"/>
  <xsl:param name="ObjType">TABLE</xsl:param>
  <xsl:param name="PartitionType" select="''"/>
  <xsl:param name="PROPERTY2" select="''"/>
  <xsl:param name="DefaultBlocksize" select="''"/>
 <!-- *******************************************************************
Template: SegmentAttributes
Parameters:
  ParentNode - Parent node of TS_NAME, BLOCKSIZE, PCT_FREE, etc.
  Partitioned - 0 = non-partitioned, non-0 = partitioned
                Used to locate/interpret the storage and logging information.
                For non-partitioned objects storage information (INIEXTS, etc.)
                is stored under STORAGE (a peer of PCT_FREE, etc.);
                for partitioned objects the information (DEFINIEXTS, etc.)
                is at the same level as DEFPCTFREE, etc.
                The location and encoding of logging information is
                different for partitioned/non-partitioned objects.
                See "LoggingClause", below.
  ObjType - One of
              "TABLE" (default)
              "INDEX" (used for both indexes and IOTs)
              "ROLLBACK"
              "TABLESPACE"
              "PARTITION"
              "PIOT_PARTITION"
 PartitionType - RANGE, HASH, LIST, ''
 PROPERTY2 - PROPERTY2 node (bit 0x04 = deferred segment creation)
  DefaultBlocksize - For StorageClause
******************************************************************** -->
  <!-- Change Manager also looks at PHYSICAL_PROPERTIES -->
  <xsl:if test="not ($SEGMENT_ATTRIBUTES=0) and not ($PHYSICAL_PROPERTIES=0)">
   <xsl:element name="SEGMENT_ATTRIBUTES">
    <xsl:if test="$PartitionType!='HASH'">
     <xsl:call-template name="PhysicalAttributes">
      <xsl:with-param name="ParentNode" select="$ParentNode"/>
      <xsl:with-param name="Partitioned" select="$Partitioned"/>
      <xsl:with-param name="ObjType" select="$ObjType"/>
      <xsl:with-param name="PROPERTY2" select="$PROPERTY2"/>
      <xsl:with-param name="DefaultBlocksize" select="$DefaultBlocksize"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="Tablespace">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
    </xsl:call-template>
    <!--xsl:if test="$ObjType!='PARTITION' and $ObjType!='PIOT_PARTITION'"-->
    <xsl:if test="$PartitionType!='HASH'">
     <xsl:call-template name="LoggingClause">
      <xsl:with-param name="Partitioned" select="$Partitioned"/>
      <xsl:with-param name="FlagsNode" select="$ParentNode/FLAGS"/>
      <xsl:with-param name="DefloggingNode" select="$ParentNode/DEFLOGGING"/>
      <xsl:with-param name="PartitionType" select="$PartitionType"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="PhysicalAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Partitioned" select="''"/>
  <xsl:param name="ObjType">TABLE</xsl:param>
  <xsl:param name="DefaultBlocksize" select="''"/>
  <xsl:param name="PROPERTY2" select="''"/>
 <!-- *******************************************************************
Template: PhysicalAttributes
Parameters:
  ParentNode - Parent node of TS_NAME, BLOCKSIZE, PCT_FREE, etc.
  Partitioned - 0 = non-partitioned, non-0 = partitioned
  ObjType - One of
              "TABLE" (default)
              "INDEX" (used for both indexes and IOTs)
              "ROLLBACK"
              "TABLESPACE"
              "PARTITION"
              "PIOT_PARTITION"
  DefaultBlocksize - For StorageClause
  PROPERTY2 - PROPERTY2 node (bit 0x04 = deferred segment creation)
******************************************************************** -->
  <xsl:if test="$PROPERTY2 and ($PROPERTY2 mod 8)>=4">
   <xsl:element name="SEGMENT_CREATION_DEFERRED"/>
  </xsl:if>
  <xsl:element name="PCTFREE">
   <xsl:value-of select="$ParentNode/PCT_FREE"/>
   <xsl:value-of select="$ParentNode/DEFPCTFREE"/>
  </xsl:element>
  <xsl:if test="($ObjType!='INDEX') and ($ObjType!='PIOT_PARTITION')">
   <xsl:element name="PCTUSED">
    <xsl:value-of select="$ParentNode/PCT_USED"/>
    <xsl:value-of select="$ParentNode/DEFPCTUSED"/>
   </xsl:element>
  </xsl:if>
  <xsl:element name="INITRANS">
   <xsl:value-of select="$ParentNode/INITRANS"/>
   <xsl:value-of select="$ParentNode/DEFINITRANS"/>
  </xsl:element>
  <!-- STORAGE -->
  <xsl:choose>
   <!-- non-partitioned -->
   <xsl:when test="$Partitioned=0">
    <xsl:choose>
     <!-- omit storage clause if segment creation deferred -->
     <xsl:when test="$PROPERTY2 and ($PROPERTY2 mod 8)>=4"/>
     <xsl:when test="string-length($ParentNode/BLOCKSIZE)!=0">
      <xsl:call-template name="StorageClause">
       <xsl:with-param name="StorageNode" select="$ParentNode/STORAGE"/>
       <xsl:with-param name="BlkSize" select="$ParentNode/BLOCKSIZE"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="string-length($DefaultBlocksize)!=0">
      <xsl:call-template name="StorageClause">
       <xsl:with-param name="StorageNode" select="$ParentNode/STORAGE"/>
       <xsl:with-param name="BlkSize" select="$DefaultBlocksize"/>
      </xsl:call-template>
     </xsl:when>
    </xsl:choose>
   </xsl:when>
   <!-- partitioned -->
   <xsl:otherwise>
    <xsl:choose>
     <xsl:when test="string-length($ParentNode/BLOCKSIZE)!=0 or
                    string-length($ParentNode/DEFBLOCKSIZE)!=0">
      <xsl:call-template name="StorageClause">
       <xsl:with-param name="StorageNode" select="$ParentNode"/>
       <xsl:with-param name="BlkSize" select="$ParentNode/BLOCKSIZE | $ParentNode/DEFBLOCKSIZE"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="string-length($DefaultBlocksize)!=0">
      <xsl:call-template name="StorageClause">
       <xsl:with-param name="StorageNode" select="$ParentNode"/>
       <xsl:with-param name="BlkSize" select="$DefaultBlocksize"/>
      </xsl:call-template>
     </xsl:when>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="StorageClause">
  <xsl:param name="StorageNode" select="''"/>
  <xsl:param name="ObjType">TABLE</xsl:param>
  <xsl:param name="BlkSize">0</xsl:param>
  <!-- *******************************************************************
Template: StorageClause
Parameters:
  StorageNode - STORAGE node
  ObjType - One of
              "TABLE" (default)
              "INDEX" (used for both indexes and IOTs)
              "ROLLBACK"
              "TABLESPACE"
              "PARTITION"
              "PIOT_PARTITION"
  BlkSize - tablespace blocksize
******************************************************************** -->
  <xsl:if test="not ($STORAGE=0)">
   <xsl:element name="STORAGE">
    <xsl:if test="$StorageNode/DEFINIEXTS or $StorageNode/INIEXTS
             or $StorageNode/DFLINIT">
     <xsl:if test="$BlkSize=0">
      <xsl:text>
       **** kusstorg.xsl/StorageClause ERROR: No BLOCKSIZE VALUE ***
</xsl:text>
     </xsl:if>
     <xsl:element name="INITIAL">
      <xsl:choose>
       <xsl:when test="$StorageNode/INIEXTS">
        <xsl:value-of select="($StorageNode/INIEXTS)*$BlkSize"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DEFINIEXTS">
        <xsl:value-of select="($StorageNode/DEFINIEXTS)*$BlkSize"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DFLINIT">
        <xsl:value-of select="($StorageNode/DFLINIT)*$BlkSize"/>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:if>
    <xsl:if test="$StorageNode/DEFEXTSIZE or $StorageNode/EXTSIZE
             or $StorageNode/DFLINCR">
     <xsl:if test="$BlkSize=0">
      <xsl:text>
       **** kusstorg.xsl/StorageClause ERROR: No BLOCKSIZE VALUE ***
</xsl:text>
     </xsl:if>
     <xsl:element name="NEXT">
      <xsl:choose>
       <xsl:when test="$StorageNode/EXTSIZE">
        <xsl:value-of select="($StorageNode/EXTSIZE)*$BlkSize"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DEFEXTSIZE">
        <xsl:value-of select="($StorageNode/DEFEXTSIZE)*$BlkSize"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DFLINCR">
        <xsl:value-of select="($StorageNode/DFLINCR)*$BlkSize"/>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:if>
    <xsl:if test="$StorageNode/DEFMINEXTS or $StorageNode/MINEXTS
             or $StorageNode/DFLMINEXT">
     <xsl:element name="MINEXTENTS">
      <xsl:choose>
       <xsl:when test="$StorageNode/MINEXTS">
        <xsl:value-of select="($StorageNode/MINEXTS)"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DEFMINEXTS">
        <xsl:value-of select="($StorageNode/DEFMINEXTS)"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DFLMINEXT">
        <xsl:value-of select="($StorageNode/DFLMINEXT)"/>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:if>
    <xsl:if test="$StorageNode/DEFMAXEXTS or $StorageNode/MAXEXTS
             or $StorageNode/DFLMAXEXT">
     <xsl:element name="MAXEXTENTS">
      <xsl:choose>
       <xsl:when test="$StorageNode/MAXEXTS">
        <xsl:value-of select="($StorageNode/MAXEXTS)"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DEFMAXEXTS">
        <xsl:value-of select="($StorageNode/DEFMAXEXTS)"/>
       </xsl:when>
       <xsl:when test="$StorageNode/DFLMAXEXT">
        <xsl:value-of select="($StorageNode/DFLMAXEXT)"/>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:if>
    <xsl:if test="not($ObjType='ROLLBACK')">
     <xsl:if test="$StorageNode/DEFEXTPCT or $StorageNode/EXTPCT
              or $StorageNode/DFLEXTPCT">
      <xsl:element name="PCTINCREASE">
       <xsl:choose>
        <xsl:when test="$StorageNode/EXTPCT">
         <xsl:value-of select="($StorageNode/EXTPCT)"/>
        </xsl:when>
        <xsl:when test="$StorageNode/DEFEXTPCT">
         <xsl:value-of select="($StorageNode/DEFEXTPCT)"/>
        </xsl:when>
        <xsl:when test="$StorageNode/DFLEXTPCT">
         <xsl:value-of select="($StorageNode/DFLEXTPCT)"/>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:if>
    </xsl:if>
    <xsl:if test="($ObjType != 'ROLLBACK') or
                ($ObjType != 'TABLESPACE')">
     <xsl:if test="2097152 > ($StorageNode/FLAGS mod 4194304)">
      <xsl:if test="$StorageNode/DEFLISTS > 0 or $StorageNode/LISTS">
       <xsl:element name="FREELISTS">
        <xsl:value-of select="$StorageNode/LISTS"/>
        <xsl:value-of select="$StorageNode/DEFLISTS"/>
       </xsl:element>
      </xsl:if>
      <xsl:if test="$StorageNode/DEFGROUPS > 0 or $StorageNode/GROUPS">
       <xsl:element name="FREELIST_GROUPS">
        <xsl:value-of select="$StorageNode/GROUPS"/>
        <xsl:value-of select="$StorageNode/DEFGROUPS"/>
       </xsl:element>
      </xsl:if>
     </xsl:if>
     <!-- MAXSIZE clause -->
     <!-- 11g: BITMAPRANGES => MAXSIZE -->
     <xsl:if test="$StorageNode/BITMAPRANGES and 
        ($StorageNode/FLAGS mod 8388608)>=4194304 or $StorageNode/DEFMAXSIZE">
      <xsl:call-template name="DoMAXSIZE">
       <xsl:with-param name="MaxSize" select="$StorageNode/BITMAPRANGES | $StorageNode/DEFMAXSIZE"/>
       <xsl:with-param name="BlkSize" select="$BlkSize"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="$StorageNode/CACHEHINT or $StorageNode/DEFBUFPOOL">
      <xsl:element name="BUFFER_POOL">
       <xsl:apply-templates select="$StorageNode/CACHEHINT |
                                  $StorageNode/DEFBUFPOOL"/>
      </xsl:element>
     </xsl:if>
    </xsl:if>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template match="CACHEHINT | DEFBUFPOOL">
  <!-- *******************************************************************
Template: CACHEHINT | DEFBUFPOOL - output BUFFER_POOL value
******************************************************************** -->
  <!-- BUFFER_POOL is the least significant 2 bits (bit [0-1]) -->
  <xsl:choose>
   <xsl:when test="(. mod 4)=1">KEEP</xsl:when>
   <xsl:when test="(. mod 4)=2">RECYCLE</xsl:when>
   <xsl:otherwise>DEFAULT</xsl:otherwise>
  </xsl:choose>
  <!-- FLASH_CACHE and CELL_FLASH_CACHE needs to be handled separately -->
 </xsl:template>
 <xsl:template name="Tablespace">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: Tablespace
Parameters:
  ParentNode - Parent node of TS_NAME or DEFTS_NAME
******************************************************************** -->
  <xsl:if test="not ($TABLESPACE=0)">
   <xsl:if test="$ParentNode/TS_NAME or $ParentNode/DEFTS_NAME">
    <xsl:element name="TABLESPACE">
     <xsl:value-of select="$ParentNode/TS_NAME"/>
     <xsl:value-of select="$ParentNode/DEFTS_NAME"/>
    </xsl:element>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="LoggingClause">
  <xsl:param name="Partitioned" select="''"/>
  <xsl:param name="FlagsNode" select="''"/>
  <xsl:param name="DefloggingNode" select="''"/>
  <xsl:param name="PartitionType" select="''"/>
  <!-- *******************************************************************
Template: LoggingClause
Parameters:
  Partitioned - 0 = non-partitioned, non-0 = partitioned
  FlagsNode - FLAGS node with logging/nologging bit (tab$.flags)
  DefloggingNode - DEFLOGGING node (partobj$.deflogging)
  PartitionType - RANGE, HASH, LIST, ''
******************************************************************** -->
  <xsl:choose>
   <!-- non-partitioned, either a non-partitioned table or
        a leaf partition -->
   <xsl:when test="$Partitioned=0">
    <xsl:choose>
     <xsl:when test="string-length($PartitionType)=0">
      <xsl:element name="LOGGING">
       <xsl:choose>
        <xsl:when test="($FlagsNode mod 64)>=32">N</xsl:when>
        <xsl:otherwise>Y</xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:when>
     <!-- a leaf partition: NoLogging is bit 0x04 in FLAGS=1 (in tabpart$) -->
     <xsl:when test="($FlagsNode mod 8)>=4">
      <xsl:element name="LOGGING">N</xsl:element>
     </xsl:when>
    </xsl:choose>
   </xsl:when>
   <!-- partitioned -->
   <xsl:otherwise>
    <xsl:choose>
     <xsl:when test="$DefloggingNode=1">
      <xsl:element name="LOGGING">Y</xsl:element>
     </xsl:when>
     <xsl:when test="$DefloggingNode=2">
      <xsl:element name="LOGGING">N</xsl:element>
     </xsl:when>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="ParallelClause">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: ParallelClause
Parameters:
  ParentNode - Parent node of DEGREE
******************************************************************** -->
  <!-- For compatibility support both old and new syntax -->
  <xsl:if test="$ParentNode/DEGREE">
   <xsl:choose>
    <!-- old syntax: PARALLEL (DEGREE n [INSTANCES m])
          For this we use a PARALLEL_DEGREE element -->
    <xsl:when test="32767>($ParentNode/INSTANCES)">
     <xsl:element name="PARALLEL_DEGREE">
      <xsl:choose>
       <xsl:when test="$ParentNode/DEGREE=32767">
        <xsl:element name="DEGREE">DEFAULT</xsl:element>
       </xsl:when>
       <xsl:otherwise>
        <xsl:element name="DEGREE">
         <xsl:value-of select="$ParentNode/DEGREE"/>
        </xsl:element>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
       <xsl:when test="$ParentNode/INSTANCES=32767">
        <xsl:element name="INSTANCES">DEFAULT</xsl:element>
       </xsl:when>
       <xsl:when test="32767>$ParentNode/INSTANCES">
        <xsl:element name="INSTANCES">
         <xsl:value-of select="$ParentNode/INSTANCES"/>
        </xsl:element>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:when>
    <!-- new syntax PARALLEL [n] -->
    <xsl:otherwise>
     <xsl:element name="PARALLEL">
      <xsl:choose>
       <xsl:when test="32767>($ParentNode/DEGREE)">
        <xsl:value-of select="$ParentNode/DEGREE"/>
       </xsl:when>
       <xsl:otherwise>AUTOMATIC</xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoLOBRETENTION">
  <xsl:param name="LobRet">0</xsl:param>
  <xsl:param name="MinTime">0</xsl:param>
  <!--  *******************************************************************
Template: DoLOBRETENTION
Parameters:
 LobRet:  LOB Retention (NONE | AUTO | MIN integer | MAX)
 MinTime: LOB MIN Retention time
********************************************************************-->
  <xsl:choose>
   <!-- RETENTION = NONE -->
   <xsl:when test="$LobRet=0">
    <xsl:element name="RETENTION">
     <xsl:text>NONE</xsl:text>
    </xsl:element>
   </xsl:when>
   <!-- RETENTION = AUTO -->
   <xsl:when test="$LobRet=1">
    <xsl:element name="RETENTION">
     <xsl:text>AUTO</xsl:text>
    </xsl:element>
   </xsl:when>
   <!-- RETENTION = MIN -->
   <xsl:when test="$LobRet=2">
    <xsl:element name="RETENTION">
     <xsl:text>MIN </xsl:text>
    </xsl:element>
    <xsl:element name="MINTIME">
     <xsl:value-of select="$MinTime"/>
    </xsl:element>
   </xsl:when>
   <!-- RETENTION = MAX -->
   <xsl:when test="$LobRet=3">
    <xsl:element name="RETENTION">
     <xsl:text>MAX</xsl:text>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise/>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoMAXSIZE">
  <xsl:param name="MaxSize">0</xsl:param>
  <xsl:param name="BlkSize">0</xsl:param>
  <!--  *******************************************************************
Template: DoMAXSIZE
Parameters:
 MaxSize: Maxsimum Size
 BlkSize: Block Size
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$MaxSize=0">
   </xsl:when>
   <xsl:when test="$MaxSize=4294967295 or $MaxSize=2147483645">
   </xsl:when>
   <xsl:otherwise>
    <xsl:element name="MAXSIZE">
     <xsl:choose>
      <xsl:when test="($MaxSize * $BlkSize) >= (2147483646 * 512)">
       <xsl:text>UNLIMITED</xsl:text>
      </xsl:when>
      <xsl:when test="($MaxSize * $BlkSize) > 2147483647">
       <xsl:value-of select="floor(($MaxSize * $BlkSize) div 1048576)"/>
       <xsl:text>M</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$MaxSize * $BlkSize"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
