<?xml version="1.0"?>
<!--
NAME
    kussyn.xsl
DESCRIPTION
    Convert mdapi SYNONYM_T document to SYNONYM document (SXML)

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     12/09/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: SYNONYM_T - top-level template for SYNONYM.
  This template puts out
   - the opening SYNONYM element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="SYNONYM_T">
  <xsl:element name="SYNONYM">
  <!-- See note about xmlns attribute in kustable.xsl --> 
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:choose>
     <xsl:when test="SYN_LONG_NAME">
      <xsl:value-of select="SYN_LONG_NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:element name="OBJECT_SCHEMA">
    <xsl:value-of select="OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="OBJECT_NAME">
    <xsl:choose>
     <xsl:when test="OBJ_LONG_NAME">
      <xsl:value-of select="OBJ_LONG_NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="NAME"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:if test="DB_LINK">
    <xsl:element name="DB_LINK">
     <xsl:value-of select="DB_LINK"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
