<?xml version="1.0"?>
<!--
 Copyright (c) 2005, 2009, Oracle and/or its affiliates.All rights reserved. 
NAME
    kustbls.xsl
DESCRIPTION
    Convert mdapi TABLESPACE_T document to TABLESPACE document (SXML)

MODIFIED        MM/DD/YY
    abodge     01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    lbarton    01/17/08 - Bug 6724820: table compression
    lbarton    11/29/06 - fix IS_OMF test
    lbarton    02/20/06 - bug 4752442: BIGFILE 
    htseng     24/10/05 - fix MINIMUM_EXTENT 
    sdavidso   08/29/05 - handle OMF datafiles in tablespaces
                          remove non-functional REUSE handling
    htseng     25/01/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kusstorg.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="STORAGE">1</xsl:param>
 <!-- *******************************************************************
Template: TABLESPACE_T - top-level template for TABLESPACE.
  This template puts out
   - the opening TABLESPACE element (with xmlns and version attributes)
   - optional BIGFILE element
   - TYPE element
   - NAME element
   - datafile list
  then calls one of
   - DoUndoTS
   - DoPermanentTS
   - DoTemporaryTS
******************************************************************** -->
 <xsl:template match="TABLESPACE_T">
  <xsl:element name="TABLESPACE">
   <xsl:attribute name="xmlns">http://xmlns.oracle.com/ku</xsl:attribute>
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:if test="(FLAGS mod 512)>=256">
    <xsl:element name="BIGFILE"/>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="CONTENTS = 0">
     <xsl:choose>
      <xsl:when test="(FLAGS mod 32) >= 16">
       <xsl:element name="TYPE">UNDO</xsl:element>
       <xsl:call-template name="TSName"/>
       <xsl:call-template name="DatafileList">
        <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
       </xsl:call-template>
       <xsl:call-template name="DoUndoTS">
        <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:element name="TYPE">PERMANENT</xsl:element>
       <xsl:call-template name="TSName"/>
       <xsl:call-template name="DatafileList">
        <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
       </xsl:call-template>
       <xsl:call-template name="DoPermanentTS">
        <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="TYPE">TEMPORARY</xsl:element>
     <xsl:call-template name="TSName"/>
     <xsl:call-template name="DatafileList">
      <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
     </xsl:call-template>
     <xsl:call-template name="DoTemporaryTS">
      <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: TSName - emit tablespace name
Current node: TABLESPACE_T
******************************************************************** -->
 <xsl:template name="TSName">
  <xsl:element name="NAME">
   <xsl:value-of select="NAME"/>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: DatafileList
Current node: TABLESPACE_T
Parameters:
 BlkSize - value of BLOCKSIZE
******************************************************************** -->
 <xsl:template name="DatafileList">
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:element name="DATAFILE_LIST">
   <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
    <xsl:element name="DATAFILE_LIST_ITEM">
     <xsl:call-template name="DoDataFile">
      <xsl:with-param name="BlkSize" select="$BlkSize"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:for-each>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: DoPermanentTS
Current node: 
  This template puts out
  - MINIMUM_EXTENT
  - BLOCKSIZE
  - FORCE_LOGGING
  - DEFAULT table_compression storage
  - OFFLINE
  - extent_management_clause
  - segment_management_clause
  - FLASHBACK_OFF
Parameters:
 BlkSize - value of BLOCKSIZE
******************************************************************** -->
 <xsl:template name="DoPermanentTS">
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:if test="(FLAGS mod 4) = 0  and DFLMINLEN !=0">
   <xsl:element name="MINIMUM_EXTENT">
    <xsl:value-of select="DFLMINLEN * $BlkSize"/>
   </xsl:element>
  </xsl:if>
  <xsl:element name="BLOCKSIZE">
   <xsl:value-of select="$BlkSize"/>
  </xsl:element>
  <xsl:element name="LOGGING">
   <xsl:choose>
    <xsl:when test="(DFLOGGING mod 2) = 0">
     <xsl:text>N</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>Y</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
  <xsl:if test="(DFLOGGING mod 4) >= 2">
   <xsl:element name="FORCE_LOGGING"/>
  </xsl:if>
  <xsl:element name="DEFAULT">
   <xsl:call-template name="DoTSCompress">
    <xsl:with-param name="Compress" select="FLAGS"/>
   </xsl:call-template>
   <xsl:if test="(FLAGS mod 4) = 0">
     <!-- STORAGE clause not valid for user-managed tablespace -->
    <xsl:call-template name="StorageClause">
     <xsl:with-param name="StorageNode" select="."/>
     <xsl:with-param name="BlkSize" select="$BlkSize"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:element>
  <xsl:if test="STATUS!=1 and STATUS!=4">
   <xsl:element name="OFFLINE"/>
  </xsl:if>
  <!-- extent_management_clause-->
  <xsl:call-template name="ExtentManagement">
   <xsl:with-param name="BlkSize" select="$BlkSize"/>
  </xsl:call-template>
  <!-- segment_management_clause -->
  <xsl:if test="BITMAPPED != 0">
   <xsl:element name="SEGMENT_SPACE_MANAGEMENT">
    <xsl:choose>
     <xsl:when test="((FLAGS mod 64) >= 32)">
      <xsl:text>AUTO</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>MANUAL</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:if>
  <!-- How to detect FLASHBACK OFF?  -->
 </xsl:template>
 <!-- *******************************************************************
Template: DoUndoTS
  This template puts out
  - extent_management_clause
  - RETENTION_GUARANTEE
Parameters:
 BlkSize - value of BLOCKSIZE
******************************************************************** -->
 <xsl:template name="DoUndoTS">
  <xsl:param name="BlkSize">0</xsl:param>
  <!-- extent_management_clause-->
  <xsl:call-template name="ExtentManagement">
   <xsl:with-param name="BlkSize" select="$BlkSize"/>
  </xsl:call-template>
  <xsl:if test="(FLAGS mod 1024) >= 512">
   <xsl:element name="RETENTION_GUARANTEE"/>
  </xsl:if>
 </xsl:template>
 <!-- *******************************************************************
Template: DoTemporaryTS
  This template puts out
  - tablespace_group_clause
  - extent_management_clause
Parameters:
 BlkSize - value of BLOCKSIZE
******************************************************************** -->
 <xsl:template name="DoTemporaryTS">
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:if test="string-length(GROUPNAME)!=0">
   <xsl:element name="TABLESPACE_GROUP">
    <xsl:value-of select="GROUPNAME"/>
   </xsl:element>
  </xsl:if>
  <!-- extent_management_clause-->
  <xsl:element name="EXTENT_MANAGEMENT">
   <xsl:element name="TYPE">
    <xsl:text>LOCAL</xsl:text>
   </xsl:element>
   <xsl:element name="ALLOCATION_TYPE">
    <xsl:text>UNIFORM</xsl:text>
   </xsl:element>
   <xsl:element name="SIZE">
    <xsl:value-of select="DFLINIT * $BlkSize"/>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <!-- *******************************************************************
Template: DoDataFile
Current node: FILESPEC_ITEM
  This template puts out
  - NAME
  - SIZE
  - autoextend_clause
Parameters:
 BlkSize - value of BLOCKSIZE
******************************************************************** -->
 <xsl:template name="DoDataFile">
  <xsl:param name="BlkSize">0</xsl:param>
  <!-- IS_OMF is not necessarily in the document -->
  <xsl:choose>
   <xsl:when test="IS_OMF!=0"/>
   <xsl:otherwise>
    <xsl:element name="NAME">
     <xsl:value-of select="FNAME"/>
    </xsl:element>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:element name="SIZE">
   <xsl:value-of select="FSIZE * $BlkSize"/>
  </xsl:element>
  <!-- autoextend_clause -->
  <xsl:if test="MAXEXTEND > 0">
   <xsl:element name="AUTOEXTEND">
    <xsl:element name="NEXT">
     <xsl:value-of select="INC * $BlkSize"/>
    </xsl:element>
    <xsl:element name="MAXSIZE">
     <xsl:choose>
      <xsl:when test="(MAXEXTEND * $BlkSize) > 2147483647">
       <xsl:value-of select="floor((MAXEXTEND * $BlkSize) div 1048576)"/>
       <xsl:text>M</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="MAXEXTEND * $BlkSize"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <!-- *******************************************************************
Template: ExtentManagement - emit EXTENT_MANAGEMENT element
Current node: TABLESPACE_T
Parameters:
 BlkSize - value of BLOCKSIZE
******************************************************************** -->
 <xsl:template name="ExtentManagement">
  <xsl:param name="BlkSize">0</xsl:param>
  <xsl:element name="EXTENT_MANAGEMENT">
   <xsl:element name="TYPE">
    <xsl:choose>
     <xsl:when test="BITMAPPED = 0">
      <xsl:text>DICTIONARY</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>LOCAL</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="(FLAGS mod 4) = 2">
     <xsl:element name="ALLOCATION_TYPE">
      <xsl:text>UNIFORM</xsl:text>
     </xsl:element>
     <xsl:element name="SIZE">
      <xsl:value-of select="DFLINIT * $BlkSize"/>
     </xsl:element>
    </xsl:when>
    <xsl:when test="(FLAGS mod 2) = 1">
     <xsl:element name="ALLOCATION_TYPE">
      <xsl:text>AUTOALLOCATE</xsl:text>
     </xsl:element>
    </xsl:when>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <xsl:template name="DoTSCompress">
  <xsl:param name="Compress">0</xsl:param>
  <!-- *******************************************************************
Template: DoTSCompress - emit [NO]COMPRESS value for tablespaces
             ts$.flags:
              /* #define KTT_COMPRESSED               0x40 (64)              */
              /* #define KTT_OLTP_COMPRESSION   0x10000(65536)   */
Parameters:
  Compress: Node with the compression bit
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="($Compress mod 128)>=64 and ($Compress mod 131072)>=65536 and ($VERSION>=1100000000)">
    <xsl:element name="COMPRESS">ALL</xsl:element>
   </xsl:when>
   <xsl:when test="($Compress mod 128) >= 64">
    <xsl:element name="COMPRESS">DIRECT_LOAD</xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:element name="COMPRESS">N</xsl:element>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
