<?xml version="1.0"?>
<!-- Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
All rights reserved. -->
<!--
NAME
    kustbphd.xsl
DESCRIPTION
    Convert PHYSICAL_PROPERTIES in TABLE document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    abodge      04/20/09 - Fix lrg 3860916
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge      05/19/08 - Merge 11GC functionality
    lbarton     01/15/08 - Bug 6724820: table compression
    lbarton     03/19/08 - deferred segment creation
    htseng      01/11/08 - bug 6702825 : 0 value of PCTFREE/PCTUSED/INITRANS
    abodge      08/22/07 - Use TargetSchemaName for CLUSTER_TABLE
    abodge      02/09/07 - Exclude src=1 elements
    lbarton     10/09/06 - import kuscommc
    slynn       10/30/06 - 
    htseng      07/31/06 - support LOBRETENTION, MAXSIZE
    lbarton     11/15/05 - Bug 4724986: transform params 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     09/16/05 - SXML syntax changes 
    lbarton     08/10/05 - lbarton_mddiff
    htseng      06/07/05 - 
    lbarton     03/10/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <!-- Templates -->
 <xsl:template match="sxml:PHYSICAL_PROPERTIES |
                     sxml:DEFAULT_PHYSICAL_PROPERTIES">
  <xsl:param name="DoCompress">Y</xsl:param>
  <!-- *******************************************************************
Template: PHYSICAL_PROPERTIES, DEFAULT_PHYSICAL_PROPERTIES
Parameters:
 DoCompress - Y = emit [NO]COMPRESS
******************************************************************** -->
  <!-- one of the following will match -->
  <xsl:apply-templates select="sxml:INDEX_ORGANIZED_TABLE[not(@src='1')]"/>
  <xsl:apply-templates select="sxml:CLUSTER_TABLE[not(@src='1')]"/>
  <xsl:apply-templates select="sxml:EXTERNAL_TABLE[not(@src='1')]"/>
  <xsl:apply-templates select="sxml:HEAP_TABLE[not(@src='1')]">
   <xsl:with-param name="DoCompress" select="$DoCompress"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="sxml:INDEX_ORGANIZED_TABLE">
  <!-- *******************************************************************
Template: INDEX_ORGANIZED_TABLE
******************************************************************** -->
  <xsl:text> ORGANIZATION INDEX</xsl:text>
  <xsl:choose>
   <xsl:when test="sxml:KEYCOMPRESS">
    <xsl:apply-templates select="sxml:KEYCOMPRESS"/>
   </xsl:when>
   <xsl:otherwise> NOCOMPRESS</xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="sxml:SEGMENT_ATTRIBUTES"/>
  <xsl:if test="sxml:MAPPING_TABLE"> MAPPING TABLE</xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:PCTTHRESHOLD"/>
  <xsl:apply-templates select="sxml:OVERFLOW"/>
 </xsl:template>
 <xsl:template match="sxml:HEAP_TABLE">
  <xsl:param name="DoCompress">Y</xsl:param>
  <!-- *******************************************************************
Template: HEAP_TABLE
Parameters:
 DoCompress - Y = emit [NO]COMPRESS
******************************************************************** -->
  <!-- HEAP is the default; no need to emit this -->
  <!--xsl:text> ORGANIZATION HEAP</xsl:text-->
  <xsl:apply-templates select="sxml:SEGMENT_ATTRIBUTES">
   <xsl:with-param name="DoCompress" select="$DoCompress"/>
  </xsl:apply-templates>
  <!--
  We use the above kludgy way of doing COMPRESS
  in order to produce the same output as GET_DDL.
  A more straightforward way is:

   <xsl:if test="local-name(.)='PHYSICAL_PROPERTIES'">
    <xsl:call-template name="DoCompress">
     <xsl:with-param name="Compress" select="sxml:COMPRESS"/>
    </xsl:call-template>
   </xsl:if>
-->
 </xsl:template>
 <xsl:template name="DoCompress">
  <xsl:param name="Compress" select="''"/>
  <!-- *******************************************************************
Template: DoCompress
Parameters:
  Compress - COMPRESS node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Compress='ALL'">
    <xsl:choose>
     <xsl:when test="$VERSION>=1100000000"> COMPRESS FOR ALL OPERATIONS</xsl:when>
     <xsl:otherwise> COMPRESS</xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$Compress='DIRECT_LOAD'"> COMPRESS</xsl:when>
   <xsl:when test="$Compress='N'"> NOCOMPRESS</xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:SEGMENT_ATTRIBUTES">
  <xsl:param name="DoCompress">N</xsl:param>
  <!-- *******************************************************************
Template: SEGMENT_ATTRIBUTES
Parameters:
 DoCompress - Y = emit [NO]COMPRESS
******************************************************************** -->
  <xsl:call-template name="DoSegmentAttributes">
   <xsl:with-param name="ParentNode" select="."/>
   <xsl:with-param name="DoCompress" select="$DoCompress"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoSegmentAttributes">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="DoCompress">N</xsl:param>
  <!-- *******************************************************************
Template: DoSegmentAttributes
Parameters:
 ParentNode - parent of PCTFREE, etc.
 DoCompress - Y = emit [NO]COMPRESS
******************************************************************** -->
  <xsl:if test="$SEGMENT_ATTRIBUTES!=0">
   <!-- SEGMENT CREATION (IMMEDIATE/DEFERRED) syntax is new in 11.2;
        not valid for partitioned tables
                      IOTs
                      clustered tables
                      temporary tables
                      typed tables
                      AQ tables
                      external tables
                      tables owned by SYS, SYSTEM, PUBLIC, OUTLN, XDB
        To know whether to emit SEGMENT CREATION IMMEDIATE, we check if
        the path is
      TABLE/RELATIONAL_TABLE/PHYSICAL_PROPERTIES/HEAP_TABLE/SEGMENT_ATTRIBUTES
    -->
   <xsl:if test="$VERSION>=1102000000">
    <xsl:choose>
     <xsl:when test="$ParentNode/sxml:SEGMENT_CREATION_DEFERRED">
   <xsl:apply-templates select="$ParentNode/sxml:SEGMENT_CREATION_DEFERRED"/>
     </xsl:when>
     <xsl:when test="local-name($ParentNode)='SEGMENT_ATTRIBUTES' and
                     local-name($ParentNode/..)='HEAP_TABLE' and
                     local-name($ParentNode/../..)='PHYSICAL_PROPERTIES' and
                     local-name($ParentNode/../../..)='RELATIONAL_TABLE' and
                     local-name($ParentNode/../../../..)='TABLE' and
                     $ParentNode/../../../../sxml:SCHEMA!='SYS' and
                     $ParentNode/../../../../sxml:SCHEMA!='SYSTEM' and
                     $ParentNode/../../../../sxml:SCHEMA!='OUBLIC' and
                     $ParentNode/../../../../sxml:SCHEMA!='OUTLN' and
                     $ParentNode/../../../../sxml:SCHEMA!='XDB'">
      <xsl:text> SEGMENT CREATION IMMEDIATE</xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa; </xsl:text>
      </xsl:if>
     </xsl:when>
    </xsl:choose>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:PCTFREE !='0' or $ParentNode/sxml:SEGMENT_CREATION_DEFERRED">
    <xsl:apply-templates select="$ParentNode/sxml:PCTFREE"/>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:PCTUSED !='0'">
    <xsl:apply-templates select="$ParentNode/sxml:PCTUSED"/>
   </xsl:if>
   <xsl:if test="$ParentNode/sxml:INITRANS !='0'">
    <xsl:apply-templates select="$ParentNode/sxml:INITRANS"/>
   </xsl:if>
   <xsl:if test="$DoCompress='Y'">
    <xsl:call-template name="DoCompress">
     <xsl:with-param name="Compress" select="$ParentNode/parent::node()/sxml:COMPRESS"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:apply-templates select="$ParentNode/sxml:LOGGING"/>
   <xsl:apply-templates select="$ParentNode/sxml:STORAGE"/>
   <xsl:if test="$TABLESPACE!=0 and $ParentNode/sxml:TABLESPACE">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$ParentNode/sxml:TABLESPACE"/>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SEGMENT_CREATION_DEFERRED">
  <!-- *******************************************************************
Template: SEGMENT_CREATION_DEFERRED
******************************************************************** -->
  <xsl:text> SEGMENT CREATION DEFERRED</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:PCTFREE | sxml:PCTUSED | sxml:INITRANS |
                     sxml:INITIAL | sxml:NEXT | sxml:MINEXTENTS |
                     sxml:MAXEXTENTS | sxml:PCTINCREASE | sxml:FREELISTS |
                     sxml:FREELIST_GROUPS| 
                     sxml:MAXSIZE | sxml:BUFFER_POOL | sxml:FLASH_CACHE | sxml:CELL_FLASH_CACHE |
                     sxml:TABLESPACE | sxml:PCTTHRESHOLD | sxml:COMPRESS |
                     sxml:INCLUDING | sxml:DEFAULT_DIRECTORY |
                     sxml:REJECT_LIMIT | sxml:RETURN_AS | sxml:STORE_AS |
                     sxml:CHUNK | sxml:PCTVERSION">
  <!-- *******************************************************************
Template: PCTFREE, PCTUSED, INITRANS,
          INITIAL, NEXT, MINEXTENTS, MAXEXTENTS, PCTINCREASE, FREELISTS,
          FREELIST_GROUPS, MAXSIZE, BUFFER_POOL, FLASH_CACHE, CELL_FLASH_CACHE
	  TABLESPACE, PCTTHRESHOLD,
          COMPRESS, INCLUDING, DEFAULT_DIRECTORY, REJECT_LIMIT,
          RETURN_AS, STORE_AS, CHUNK, PCTVERSION
******************************************************************** -->
  <xsl:text> </xsl:text>
  <xsl:choose>
   <xsl:when test="local-name(.)='FREELIST_GROUPS'">FREELIST GROUPS </xsl:when>
   <xsl:when test="local-name(.)='DEFAULT_DIRECTORY'">DEFAULT DIRECTORY "</xsl:when>
   <xsl:when test="local-name(.)='REJECT_LIMIT'">REJECT LIMIT </xsl:when>
   <xsl:when test="local-name(.)='RETURN_AS'">RETURN AS </xsl:when>
   <xsl:when test="local-name(.)='STORE_AS'">STORE AS </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="local-name(.)"/>
    <xsl:text> </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="local-name(.)='TABLESPACE'">"</xsl:if>
  <xsl:if test="local-name(.)='INCLUDING'">"</xsl:if>
  <xsl:value-of select="."/>
  <xsl:if test="local-name(.)='TABLESPACE'">"</xsl:if>
  <xsl:if test="local-name(.)='INCLUDING'">"</xsl:if>
  <xsl:if test="local-name(.)='DEFAULT_DIRECTORY'">"</xsl:if>
 </xsl:template>
 <xsl:template match="sxml:LOGGING">
  <!-- *******************************************************************
Template: LOGGING
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='Y'"> LOGGING</xsl:when>
   <xsl:when test=".='N'"> NOLOGGING</xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="sxml:STORAGE">
  <!-- *******************************************************************
Template: STORAGE
******************************************************************** -->
  <xsl:if test="$STORAGE!=0">
   <xsl:if test="sxml:INITIAL or sxml:NEXT or sxml:MINEXTENTS or 
                 sxml:MAXEXTENTS or sxml:PCTINCREASE or sxml:FREELISTS or 
                 sxml:FREELIST_GROUPS or sxml:MAXSIZE or sxml:BUFFER_POOL or
                 sxml:FLASH_CACHE or sxml:CELL_FLASH_CACHE">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> STORAGE(</xsl:text>
    <xsl:apply-templates select="sxml:INITIAL"/>
    <xsl:apply-templates select="sxml:NEXT"/>
    <xsl:apply-templates select="sxml:MINEXTENTS"/>
    <xsl:apply-templates select="sxml:MAXEXTENTS"/>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="sxml:PCTINCREASE"/>
    <xsl:apply-templates select="sxml:FREELISTS"/>
    <xsl:apply-templates select="sxml:FREELIST_GROUPS"/>
    <xsl:apply-templates select="sxml:MAXSIZE"/>
    <xsl:apply-templates select="sxml:BUFFER_POOL"/>
    <xsl:apply-templates select="sxml:FLASH_CACHE"/>
    <xsl:apply-templates select="sxml:CELL_FLASH_CACHE"/>
    <xsl:text>)</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:OVERFLOW">
  <!-- *******************************************************************
Template: OVERFLOW
******************************************************************** -->
  <xsl:apply-templates select="sxml:INCLUDING"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> OVERFLOW</xsl:text>
  <xsl:apply-templates select="sxml:SEGMENT_ATTRIBUTES"/>
 </xsl:template>
 <xsl:template match="sxml:EXTERNAL_TABLE">
  <!-- *******************************************************************
Template: EXTERNAL_TABLE
******************************************************************** -->
  <xsl:text> ORGANIZATION EXTERNAL</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> ( TYPE </xsl:text>
  <xsl:value-of select="sxml:ACCESS_DRIVER_TYPE"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:DEFAULT_DIRECTORY"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> ACCESS PARAMETERS </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> ( </xsl:text>
  <xsl:value-of select="sxml:ACCESS_PARAMETERS"/>
  <xsl:text>) </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> LOCATION </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> ( </xsl:text>
  <xsl:for-each select="sxml:LOCATION/sxml:LOCATION_ITEM">
   <xsl:if test="sxml:DIRECTORY">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="sxml:DIRECTORY"/>
    <xsl:text>":</xsl:text>
   </xsl:if>
   <xsl:text>'</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>'</xsl:text>
   <xsl:if test="position()!=last()">,</xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:text> ) </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> ) </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="sxml:REJECT_LIMIT"/>
 </xsl:template>
 <xsl:template match="sxml:CLUSTER_TABLE">
  <!-- *******************************************************************
Template: CLUSTER_TABLE
******************************************************************** -->
  <xsl:text> CLUSTER </xsl:text>
  <xsl:call-template name="TargetSchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:text> (</xsl:text>
  <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
   <xsl:choose>
    <xsl:when test="substring(sxml:NAME,1,1)='&quot;'">
     <xsl:value-of select="sxml:NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>"</xsl:text>
     <xsl:value-of select="sxml:NAME"/>
     <xsl:text>"</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="position()!=last()">, </xsl:if>
  </xsl:for-each>
  <xsl:text>)</xsl:text>
 </xsl:template>
</xsl:stylesheet>
