<?xml version="1.0"?>
<!--
 Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
NAME
    kustbphy.xsl
DESCRIPTION
    This is a utility stylesheet for generating SXML syntax for
    table physical properties and table column properties.
    Used when converting mdapi TABLE_T document to TABLE document (SXML)

MODIFIED        MM/DD/YY
    abodge      01/14/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    lbarton     08/28/08 - xmltype virtual columns
    lbarton     01/15/08 - Bug 6724820: table compression
    lbarton     03/19/08 - deferred segment creation
    abodge      01/11/08 - Gen INDEX_ORGANIZED_TABLE regardless of PHYS_PROP
                           setting
    rapayne     12/20/06 - fix sfretention parameter syntax
    lbarton     12/13/06 - securefile changes
    slynn       11/20/06 - Remove unimplemented keywords
    slynn       10/12/06 - smartfile->securefile
    slynn       07/31/06 - Change LOCAL to SMARTFILE
    htseng      08/01/06 - fix validate
    jforsyth    03/03/06 - adding ENCRYPT, COMPRESS LOW/MED/HIGH, LOB/OBJECT 
                           SHARE and SHARE VALIDATE 
    kkunchit    11/01/05 - project-18204: inode: LOCAL/NOLOCAL support 
    mbaloglu    12/23/05 - Project 18207: Adding SYNC/ASYNC and CACHE 
                           NOLOGGING 
    lbarton     03/28/06 - bug: nested IOT 
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton     09/14/05 - SXML syntax changes required by XML schema 
    lbarton     08/10/05 - lbarton_mddiff
    htseng      05/27/05 - pass TabNode to TablePhysicalProperties 
    lbarton     11/04/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kusstorg.xsl"/>
 <xsl:import href="kuscnstr.xsl"/>
 <!-- Templates -->
 <xsl:template name="TablePhysicalProperties">
  <xsl:param name="TabNode" select="."/>
  <xsl:param name="PROPERTY" select="''"/>
  <xsl:param name="PROPERTY2" select="''"/>
  <!-- *******************************************************************
Template: TablePhysicalProperties
Parameters:
 TabNode - TABLE_T or the equivalent
 PROPERTY - PROPERTY node
 PROPERTY2 - PROPERTY2 node
******************************************************************** -->
  <!-- Move this check further down
  <xsl:if test="not ($PHYSICAL_PROPERTIES=0)">
  -->
   <xsl:element name="PHYSICAL_PROPERTIES">
    <xsl:choose>
     <xsl:when test="($PROPERTY mod 128)>=64">
      <!-- IOT -->
      <xsl:element name="INDEX_ORGANIZED_TABLE">
      <xsl:if test="not ($PHYSICAL_PROPERTIES=0)">
       <xsl:if test="$SEGMENT_ATTRIBUTES!=0">
        <xsl:call-template name="SegmentAttributes">
         <xsl:with-param name="ParentNode" select="$TabNode"/>
         <xsl:with-param name="Partitioned">0</xsl:with-param>
         <xsl:with-param name="ObjType">INDEX</xsl:with-param>
        </xsl:call-template>
       </xsl:if>
       <xsl:if test="($TabNode/FLAGS mod 536870912) >= 268435456">
        <xsl:element name="MAPPING_TABLE"/>
       </xsl:if>
       <xsl:element name="PCTTHRESHOLD">
        <xsl:value-of select="$TabNode/PCT_THRESH"/>
       </xsl:element>
       <xsl:if test="$TabNode/NUMKEYCOLS>0">
        <xsl:element name="KEYCOMPRESS">
         <xsl:value-of select="$TabNode/NUMKEYCOLS"/>
        </xsl:element>
       </xsl:if>
       <xsl:if test="($PROPERTY mod 256)>=128">
        <!-- IOV -->
        <xsl:call-template name="DoIOV">
         <xsl:with-param name="IOVNode" select="$TabNode/IOV"/>
         <xsl:with-param name="InclcolName" select="$TabNode/INCLCOL_NAME"/>
         <xsl:with-param name="Partitioned">0</xsl:with-param>
        </xsl:call-template>
       </xsl:if>
      </xsl:if>
      </xsl:element>
     </xsl:when>
     <xsl:when test="($PROPERTY mod 2048)>=1024">
      <!-- clustered table -->
      <xsl:element name="CLUSTER_TABLE">
       <xsl:apply-templates select="$TabNode/TABCLUSTER/SCHEMA_OBJ"/>
       <xsl:call-template name="SimpleColumnList">
        <xsl:with-param name="ColListNode" select="$TabNode/TABCLUSTER/COL_LIST"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:when>
     <xsl:when test="($PROPERTY mod 4294967296)>=2147483648">
      <!-- External -->
      <xsl:element name="EXTERNAL_TABLE">
       <xsl:element name="ACCESS_DRIVER_TYPE">
        <xsl:value-of select="$TabNode/EXTTAB/TYPE"/>
       </xsl:element>
       <xsl:element name="DEFAULT_DIRECTORY">
        <xsl:value-of select="$TabNode/EXTTAB/DEFAULT_DIR"/>
       </xsl:element>
       <xsl:if test="$TabNode/EXTTAB/PARAM_CLOB">
        <xsl:element name="ACCESS_PARAMETERS">
         <xsl:value-of select="$TabNode/EXTTAB/PARAM_CLOB"/>
        </xsl:element>
       </xsl:if>
       <xsl:element name="LOCATION">
        <xsl:for-each select="$TabNode/EXTTAB/LOCATION/LOCATION_ITEM">
         <xsl:element name="LOCATION_ITEM">
          <xsl:if test="DIR">
           <xsl:element name="DIRECTORY">
            <xsl:value-of select="DIR"/>
           </xsl:element>
          </xsl:if>
          <xsl:element name="NAME">
           <xsl:value-of select="NAME"/>
          </xsl:element>
         </xsl:element>
        </xsl:for-each>
       </xsl:element>
       <xsl:if test="$TabNode/EXTTAB/REJECT_LIMIT > 0">
        <xsl:element name="REJECT_LIMIT">
         <xsl:choose>
          <xsl:when test="$TabNode/EXTTAB/REJECT_LIMIT=2147483647">UNLIMITED</xsl:when>
          <xsl:otherwise>
           <xsl:value-of select="$TabNode/EXTTAB/REJECT_LIMIT"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:element>
       </xsl:if>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <!-- heap table -->
      <xsl:element name="HEAP_TABLE">
      <xsl:if test="not ($PHYSICAL_PROPERTIES=0)">
       <xsl:choose>
        <xsl:when test="$TabNode/PART_OBJ/PARTOBJ">
         <!-- TabNode = MVIEW_TAB -->
         <xsl:call-template name="SegmentAttributes">
          <xsl:with-param name="ParentNode" select="$TabNode/PART_OBJ/PARTOBJ"/>
          <xsl:with-param name="Partitioned">0</xsl:with-param>
          <xsl:with-param name="ObjType">TABLE</xsl:with-param>
         </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="SegmentAttributes">
          <xsl:with-param name="ParentNode" select="$TabNode"/>
          <xsl:with-param name="Partitioned">0</xsl:with-param>
          <xsl:with-param name="ObjType">TABLE</xsl:with-param>
          <xsl:with-param name="PROPERTY2" select="PROPERTY2"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:if test="local-name(.)!='MVIEWLOG_TAB'">
        <xsl:call-template name="DoSegCompress">
         <xsl:with-param name="Compress" select="$TabNode/STORAGE/FLAGS"/>
        </xsl:call-template>
       </xsl:if>
      </xsl:if>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  <!-- Moving the $PHYSICAL_PROPERTIES check deeper into the tree
  </xsl:if>
  -->
 </xsl:template>
 <xsl:template name="DoSegCompress">
  <xsl:param name="Compress" select="''"/>
  <!-- *******************************************************************
Template: DoSegCompress
Parameters:
  Compress - segment flags (seg$.spare1)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="($Compress mod 4096)>=2048 and ($Compress mod 33554432)>=16777216 and ($VERSION>=1100000000)">
    <xsl:element name="COMPRESS">ALL</xsl:element>
   </xsl:when>
   <xsl:when test="($Compress mod 4096)>=2048">
    <xsl:element name="COMPRESS">DIRECT_LOAD</xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <xsl:element name="COMPRESS">N</xsl:element>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoIOV">
  <xsl:param name="IOVNode" select="''"/>
  <xsl:param name="InclcolName" select="''"/>
  <xsl:param name="Partitioned" select="''"/>
  <!-- *******************************************************************
Template: DoIOV - index_org_overflow_clause
Parameters:
  IOVNode - IOV node
  InclcolName - INCLCOL_NAME
  Partitioned - 0 = non-partitioned, non-0 = partitioned
******************************************************************** -->
  <xsl:element name="OVERFLOW">
   <xsl:if test="string-length($InclcolName)!=0">
    <xsl:element name="INCLUDING">
     <xsl:value-of select="$InclcolName"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="$SEGMENT_ATTRIBUTES!=0">
    <xsl:call-template name="SegmentAttributes">
     <xsl:with-param name="ParentNode" select="$IOVNode"/>
     <xsl:with-param name="Partitioned" select="$Partitioned"/>
     <xsl:with-param name="ObjType">TABLE</xsl:with-param>
    </xsl:call-template>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <xsl:template name="TableColumnProperties">
  <xsl:param name="ColListParent" select="''"/>
  <xsl:param name="NTNode" select="''"/>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <!-- *******************************************************************
Template: TableColumnProperties
Parameters:
  ColListParent: Parent of COL_LIST, e.g., TABLE_T or MVIEW_TAB or MVIEWLOG_TAB
  NTNode - NT node  (TABLE_T/NT/NTS/NTS_ITEM, etc.)
  TabBlocksize - BLOCKSIZE at table level
******************************************************************** -->
  <!-- See whether there are any table column properties:
      - object column SUBSTITUTABLE AT ALL LEVELS
      - object column NOT SUBSTITUTABLE AT ALL LEVELS
      - object column IS OF TYPE
      - nested table columns
      - varray columns that are not system-generated
          but have collection storage
      - lob columns that are not system-generated (PROPERTY bit 0x100 256)
      - opaque columns stored as LOB
      - schema-based XMLTYPE columns
      (ignore column SYS_NC_ROWINFO$ - 
       this represents the type of an object table;
       ignore unused columns (PROPERTY bit 0x8000 32768))
 -->
  <xsl:if test="($ColListParent/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=121)
          and not (NAME='SYS_NC_ROWINFO$')
          and (32768>(PROPERTY mod 65536))
          and ((TYPEMD/FLAGS mod 4096)>= 2048 or
               (TYPEMD/FLAGS mod 2048)>= 1024 or
               (TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/FLAGS mod 4)=3)])
        or
        ($ColListParent/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=122)
                              and (32768>(PROPERTY mod 65536))])
        or
        ($ColListParent/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=123)
                              and (256>(PROPERTY mod 512))
                              and (32768>(PROPERTY mod 65536))
                              and (((TYPEMD/FLAGS mod 128)>=64)
                              or   ((TYPEMD/FLAGS mod 8)>=4))])
        or
        ($ColListParent/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=112 or TYPE_NUM=113)
                              and (32768>(PROPERTY mod 65536))
                              and (256>(PROPERTY mod 512))]
                              and not ($SEGMENT_ATTRIBUTES=0)
                              and not ($PHYSICAL_PROPERTIES=0)
                              and not ($TABLESPACE=0))
        or
        ($ColListParent/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=58) 
                              and (32768>(PROPERTY mod 65536))
                              and (256>(PROPERTY mod 512))
                              and not ((OPQMD/FLAGS mod 4)>=2)]/LOBMD)
        or
        ($ColListParent/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=58)
                              and not (NAME='SYS_NC_ROWINFO$')
                              and (32768>(PROPERTY mod 65536))
                              and (TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS')
                              and (TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE')
                              and (OPQMD/SCHEMA_ELMT)])">
   <xsl:element name="COLUMN_PROPERTIES">
    <xsl:element name="COL_LIST">
     <xsl:for-each select="$ColListParent/COL_LIST/COL_LIST_ITEM">
      <!-- is this column interesting? -->
      <!-- TYPE_NUM:
           121: UDT
           122: NESTED_TABLE
           123: VARRAY
           112: CLOB or NCLOB
           113: BLOB
            58: OPAQUE (including XMLTYPE)
    -->
      <xsl:if test="(32768>(PROPERTY mod 65536)) and (
           ((TYPE_NUM=58) and (256>(PROPERTY mod 512)) and LOBMD))
           or (not (NAME='SYS_NC_ROWINFO$') and
           (TYPE_NUM=121 and (TYPEMD/FLAGS mod 4096)>= 2048)
           or
           (TYPE_NUM=121 and (TYPEMD/FLAGS mod 2048)>= 1024)
           or
           (TYPE_NUM=121 and
            (TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/FLAGS mod 4) =3)
           or
           (TYPE_NUM=122)
           or
           ((TYPE_NUM=123) and (256>(PROPERTY mod 512))
                           and ((TYPEMD/FLAGS mod 128)>=64
                           or   (TYPEMD/FLAGS mod 8)>=4))
           or
           ((TYPE_NUM=112 or TYPE_NUM=113) and (256>(PROPERTY mod 512)))
           or
           ((TYPE_NUM=58) and (TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS')
                                        and (TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE')
                                        and (OPQMD/SCHEM_ELMT)))">
       <!-- It is: start the COL_LIST_ITEM element and put in
          the NAME and DATATYPE children -->
       <xsl:element name="COL_LIST_ITEM">
        <xsl:call-template name="ColNameType">
         <xsl:with-param name="ColListItem" select="."/>
        </xsl:call-template>
        <!-- now do the property -->
        <!-- object column SUBSTITUTABLE AT ALL LEVELS -->
        <xsl:if test="TYPE_NUM=121 and (TYPEMD/FLAGS mod 4096)>= 2048">
         <xsl:element name="SUBSTITUTABLE">Y</xsl:element>
        </xsl:if>
        <!-- object column NOT SUBSTITUTABLE AT ALL LEVELS -->
        <xsl:if test="TYPE_NUM=121 and (TYPEMD/FLAGS mod 2048)>= 1024">
         <xsl:element name="SUBSTITUTABLE">N</xsl:element>
        </xsl:if>
        <!-- object column IS OF TYPE -->
        <xsl:if test="TYPE_NUM=121 and
                  (TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/FLAGS mod 4) =3">
         <xsl:element name="OF_TYPE">
          <xsl:value-of select="TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/SCHEMA_OBJ/NAME"/>
         </xsl:element>
        </xsl:if>
        <!-- nested table columns -->
        <xsl:if test="TYPE_NUM=122">
         <xsl:call-template name="NestedTableColProperties">
          <xsl:with-param name="NTNode" select="$NTNode"/>
          <xsl:with-param name="IntcolNum" select="INTCOL_NUM"/>
         </xsl:call-template>
        </xsl:if>
        <!-- varray columns -->
        <xsl:if test="TYPE_NUM=123">
         <xsl:element name="VARRAY_PROPERTIES">
          <xsl:element name="STORE_AS">
           <xsl:choose>
            <xsl:when test="LOBMD | PLOBMD">
             <xsl:text>LOB</xsl:text>
            </xsl:when>
            <xsl:otherwise>TABLE</xsl:otherwise>
           </xsl:choose>
          </xsl:element>
          <xsl:choose>
           <!-- LOB storage -->
           <xsl:when test="PLOBMD">
            <xsl:call-template name="LobColProperties">
             <xsl:with-param name="LobNode" select="PLOBMD"/>
             <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
            </xsl:call-template>
           </xsl:when>
           <xsl:when test="LOBMD">
            <xsl:call-template name="LobColProperties">
             <xsl:with-param name="LobNode" select="LOBMD"/>
             <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
            </xsl:call-template>
           </xsl:when>
           <!-- TABLE storage -->
           <xsl:otherwise>
            <xsl:call-template name="NestedTableColProperties">
             <xsl:with-param name="NTNode" select="$NTNode"/>
             <xsl:with-param name="IntcolNum" select="INTCOL_NUM"/>
            </xsl:call-template>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:element>
        </xsl:if>
        <!-- xmltype columns -->
        <xsl:if test="TYPE_NUM=58 and 
                   TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS' and
                   TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'">
         <xsl:element name="XMLTYPE_PROPERTIES">
          <xsl:choose>
           <!-- Schema-based XMLType column -->
           <xsl:when test="OPQMD/SCHEMA_ELMT">
            <xsl:call-template name="XMLTypeStorage">
             <xsl:with-param name="ColNode" select="."/>
             <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
            </xsl:call-template>
            <xsl:call-template name="XMLSchemaSpec">
             <xsl:with-param name="ColNode" select="."/>
            </xsl:call-template>
           </xsl:when>
           <xsl:otherwise>
            <xsl:element name="XMLTYPE_STORAGE">
             <xsl:element name="STORE_AS">
              <xsl:choose>
               <xsl:when test="OPQMD and (OPQMD/FLAGS mod 128) >=64">
                <xsl:text>BINARY_XML</xsl:text>
               </xsl:when>
               <xsl:when test="LOBMD | PLOBMD">
                <xsl:text>LOB</xsl:text>
               </xsl:when>
               <xsl:otherwise>OBJECT_RELATIONAL</xsl:otherwise>
              </xsl:choose>
             </xsl:element>
             <xsl:choose>
              <!-- LOB storage -->
              <xsl:when test="PLOBMD">
               <xsl:call-template name="LobColProperties">
                <xsl:with-param name="LobNode" select="PLOBMD"/>
                <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
               </xsl:call-template>
              </xsl:when>
              <xsl:when test="LOBMD">
               <xsl:call-template name="LobColProperties">
                <xsl:with-param name="LobNode" select="LOBMD"/>
                <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
               </xsl:call-template>
              </xsl:when>
             </xsl:choose>
            </xsl:element>
            <xsl:call-template name="XMLTypeAllowDisallow">
             <xsl:with-param name="ColNode" select="."/>
            </xsl:call-template>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:element>
        </xsl:if>
        <!-- lob columns -->
        <xsl:if test="TYPE_NUM=112 or TYPE_NUM=113 or 
                  (TYPE_NUM=58 and
                  (TYPEMD/SCHEMA_OBJ/OWNER_NAME!='SYS' or
                   TYPEMD/SCHEMA_OBJ/NAME!='XMLTYPE'))">
         <xsl:choose>
          <!-- LOB storage -->
          <xsl:when test="PLOBMD">
           <xsl:call-template name="LobColProperties">
            <xsl:with-param name="LobNode" select="PLOBMD"/>
            <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
           </xsl:call-template>
          </xsl:when>
          <xsl:when test="LOBMD">
           <xsl:call-template name="LobColProperties">
            <xsl:with-param name="LobNode" select="LOBMD"/>
            <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
           </xsl:call-template>
          </xsl:when>
         </xsl:choose>
        </xsl:if>
       </xsl:element>
      </xsl:if>
     </xsl:for-each>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="NestedTableColProperties">
  <xsl:param name="NTNode" select="''"/>
  <xsl:param name="IntcolNum" select="''"/>
  <!-- *******************************************************************
Template: NestedTableColProperties
Parameters:
  NTNode - NT node  (TABLE_T/NT/NTS/NTS_ITEM, etc.)
  IntcolNum - INTCOL_NUM of current COL_LIST_ITEM entry 
******************************************************************** -->
  <xsl:element name="NESTED_TABLE_PROPERTIES">
   <xsl:element name="STORAGE_TABLE">
    <xsl:apply-templates select="$NTNode/NTS/NTS_ITEM[INTCOL_NUM=$IntcolNum]/SCHEMA_OBJ"/>
    <!-- Primary key (for IOT) and physical properties.
       The nested table is either a heap table or an IOT:
       select both; only one will match -->
    <xsl:apply-templates select="$NTNode/NTS/NTS_ITEM[INTCOL_NUM=$IntcolNum]/HNT"/>
    <xsl:apply-templates select="$NTNode/NTS/NTS_ITEM[INTCOL_NUM=$IntcolNum]/IONT"/>
    <!-- Table properties (for LOB columns) -->
    <xsl:call-template name="NTItemColProperties">
     <xsl:with-param name="NTItem" select="$NTNode/NTS/NTS_ITEM[INTCOL_NUM=$IntcolNum]"/>
    </xsl:call-template>
   </xsl:element>
   <xsl:element name="RETURN_AS">
    <xsl:choose>
     <xsl:when test="($NTNode/NTS/NTS_ITEM[INTCOL_NUM=$IntcolNum]/FLAGS mod 64)
         >=32">LOCATOR</xsl:when>
     <xsl:otherwise>VALUE</xsl:otherwise>
    </xsl:choose>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template match="HNT | IONT">
  <!-- *******************************************************************
Template: HNT | IONT - put out physical properties of NT
******************************************************************** -->
  <!-- an IOT will have a primary key constraint -->
  <xsl:if test="local-name(.)='IONT'">
   <xsl:call-template name="PKConstraints">
    <xsl:with-param name="Property" select="PROPERTY"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:call-template name="TablePhysicalProperties">
   <xsl:with-param name="PROPERTY" select="PROPERTY"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="NTItemColProperties">
  <xsl:param name="NTItem" select="''"/>
  <!-- *******************************************************************
Template: NTItemColProperties - Col properties in a nested table
Parameters:
  NTItem - NT/NTS/NTS_ITEM
******************************************************************** -->
  <!-- See whether there are any table column properties:
      - object column SUBSTITUTABLE AT ALL LEVELS
      - object column NOT SUBSTITUTABLE AT ALL LEVELS
      - object column IS OF TYPE
      - nested table columns
      - varray columns that are not system-generated
          but have collection storage
      - lob columns that are not system-generated
      - opaque or XMLType columns that are not hidden
      (ignore column SYS_NC_ROWINFO$ - 
       this represents the type of an object table)
  -->
  <xsl:if test="(($NTItem/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=121) and not
                    (NAME='SYS_NC_ROWINFO$')]/TYPEMD/FLAGS mod 4096)>= 2048)
        or
        (($NTItem/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=121) and not 
                     (NAME='SYS_NC_ROWINFO$')]/TYPEMD/FLAGS mod 2048)>= 1024)
        or
        (($NTItem/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=121) and not
 (NAME='SYS_NC_ROWINFO$')]/TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/FLAGS mod 4)
           =3)
        or
        ($NTItem/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=122)])
        or
        ($NTItem/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=123)
                              and (256>(PROPERTY mod 512))
                              and (((TYPEMD/FLAGS mod 128)>=64)
                              or   ((TYPEMD/FLAGS mod 8)>=4))])
        or
        ($NTItem/COL_LIST/COL_LIST_ITEM[(TYPE_NUM=112 or TYPE_NUM=113)
                              and (256>(PROPERTY mod 512))])
        or
        ($NTItem/COL_LIST/COL_LIST_ITEM[not (NAME='SYS_NC_ROWINFO$')
                              and 32>(PROPERTY mod 64)]/OPQMD)">
   <xsl:element name="TABLE_PROPERTIES">
    <xsl:call-template name="TableColumnProperties">
     <xsl:with-param name="ColListParent" select="$NTItem"/>
     <xsl:with-param name="NTNode" select="$NTItem/NT"/>
     <xsl:with-param name="TabBlocksize" select="$NTItem/HNT/BLOCKSIZE | $NTItem/IONT/BLOCKSISE"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="LobColProperties">
  <xsl:param name="LobNode" select="''"/>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <xsl:param name="PartitioningStorage">0</xsl:param>
  <!-- *******************************************************************
Template: LobColProperties - STORAGE_TABLE element and all children
Parameters:
  LobNode - LOBMD node or PLOBMD node or LOBS_ITEM node
  TabBlocksize - BLOCKSIZE at table level
  ParitioningStorage - non-0 = This is partitioning storage,
                               i.e., lob storage specified for a 
                               subpartition
******************************************************************** -->
  <xsl:element name="LOB_PROPERTIES">
   <xsl:element name="STORAGE_TABLE">
    <xsl:if test="4>($LobNode/SCHEMA_OBJ/FLAGS mod 8)">
     <!-- not sys-generated name -->
     <xsl:element name="SCHEMA">
      <xsl:value-of select="$LobNode/SCHEMA_OBJ/OWNER_NAME"/>
     </xsl:element>
     <!-- for partitioned lob use the subname -->
     <xsl:element name="NAME">
      <xsl:choose>
       <xsl:when test="local-name($LobNode)='LOBS_ITEM'">
        <xsl:value-of select="$LobNode/SCHEMA_OBJ/SUBNAME"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="$LobNode/SCHEMA_OBJ/NAME"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:if>
    <xsl:if test="not ($SEGMENT_ATTRIBUTES=0) and not ($PHYSICAL_PROPERTIES=0)">
     <xsl:if test="not ($TABLESPACE=0)">
      <xsl:call-template name="Tablespace">
       <xsl:with-param name="ParentNode" select="$LobNode"/>
      </xsl:call-template>
     </xsl:if>
     <xsl:if test="($LobNode/PROPERTY mod 4096) >= 2048 or ($LobNode/DEFPRO mod 4096) >= 2048">
      <xsl:element name="SECUREFILE"/>
     </xsl:if>
     <!-- If partitioning storage, omit the following items -->
     <xsl:if test="$PartitioningStorage=0">
      <xsl:if test="($LobNode/PROPERTY mod 4) >= 2 or ($LobNode/DEFPRO mod 4) >= 2">
       <xsl:element name="STORAGE_IN_ROW"/>
      </xsl:if>
      <xsl:choose>
       <xsl:when test="$LobNode/STORAGE">
        <xsl:call-template name="StorageClause">
         <xsl:with-param name="StorageNode" select="$LobNode/STORAGE"/>
         <xsl:with-param name="ObjType">TABLE</xsl:with-param>
         <xsl:with-param name="BlkSize" select="$TabBlocksize"/>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
        <xsl:call-template name="StorageClause">
         <xsl:with-param name="StorageNode" select="$LobNode"/>
         <xsl:with-param name="ObjType">TABLE</xsl:with-param>
         <xsl:with-param name="BlkSize" select="$TabBlocksize"/>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:element name="CHUNK">
       <xsl:choose>
        <xsl:when test="$LobNode/CHUNK">
         <xsl:value-of select="($LobNode/CHUNK) * ($TabBlocksize)"/>
        </xsl:when>
        <xsl:when test="$LobNode/DEFCHUNK">
         <xsl:value-of select="($LobNode/DEFCHUNK) * ($TabBlocksize)"/>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
      <!-- Process RETENTION for securefiles and
                           RETENTION or PCTVERSION for basicfile lobs
-->
      <xsl:call-template name="DoRETENTION">
       <xsl:with-param name="LobNode" select="$LobNode"/>
       <xsl:with-param name="StorageNode" select="$LobNode/STORAGE"/>
       <xsl:with-param name="Properties" select="$LobNode/PROPERTY | $LobNode/DEFPRO"/>
       <xsl:with-param name="Flags" select="$LobNode/FLAGS | $LobNode/DEFFLAGS"/>
      </xsl:call-template>
      <xsl:choose>
       <xsl:when test="$LobNode/FLAGS">
        <xsl:call-template name="DoCache">
         <xsl:with-param name="FlagsNode" select="$LobNode/FLAGS"/>
         <xsl:with-param name="PropNode" select="$LobNode/PROPERTY"/>
        </xsl:call-template>
       </xsl:when>
       <xsl:when test="$LobNode/DEFFLAGS">
        <xsl:call-template name="DoCache">
         <xsl:with-param name="FlagsNode" select="$LobNode/DEFFLAGS"/>
         <xsl:with-param name="PropNode" select="$LobNode/DEFPRO"/>
        </xsl:call-template>
       </xsl:when>
      </xsl:choose>
     </xsl:if>
    </xsl:if>
   </xsl:element>
   <!-- end of STORAGE_TABLE element -->
  </xsl:element>
  <!-- end of LOB_PROPERTIES element -->
 </xsl:template>
 <!-- *******************************************************************
Template: DoRETENTION - Do RETENTION element 
        This template processes the RETENTION element for both
        BASICFILE and SECUREFILE. 
        Note: if BASICFILE, PCTVERSION is additionally processed.
Parameters:
  LobNode - LOBMD node or PLOBMD node or LOBS_ITEM node
  StorageNode - STORAGE node
     *******************************************************************-->
 <xsl:template name="DoRETENTION">
  <xsl:param name="LobNode"/>
  <xsl:param name="StorageNode"/>
  <xsl:param name="Properties"/>
  <xsl:param name="Flags"/>
  <xsl:choose>
   <xsl:when test="($Properties mod 4096) >= 2048">
    <!--- SECUREFILE RETENTION -->
    <xsl:choose>
     <xsl:when test="$StorageNode/LISTS">
      <xsl:call-template name="SFretention">
       <xsl:with-param name="Retention" select="$StorageNode/LISTS"/>
       <xsl:with-param name="MinTime" select="$StorageNode/GROUPS"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:variable name="LobRet">
       <xsl:choose>
        <xsl:when test="$LobNode/RETENTION">
         <xsl:value-of select="$LobNode/RETENTION"/>
        </xsl:when>
        <xsl:when test="$LobNode/DEFRETENTION">
         <xsl:value-of select="$LobNode/DEFRETENTION"/>
        </xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
       </xsl:choose>
      </xsl:variable>
      <xsl:call-template name="SFretention">
       <xsl:with-param name="Retention" select="$LobRet"/>
       <xsl:with-param name="MinTime" select="$LobNode/MINTIME | $LobNode/DEFMINTIME "/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <!--- BASICFILE RETENTION and PCTVERSION-->
    <xsl:call-template name="BFretention">
     <xsl:with-param name="LobNode" select="$LobNode"/>
     <xsl:with-param name="Flags" select="$Flags"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <!-- *******************************************************************
Template: BFretention - BASICFILE RETENTION element 
******************************************************************** -->
 <xsl:template name="BFretention">
  <xsl:param name="LobNode" select="''"/>
  <xsl:param name="Flags" select="''"/>
  <xsl:choose>
   <xsl:when test="($Flags mod 64) >= 32">
    <xsl:element name="RETENTION"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:element name="PCTVERSION">
     <xsl:value-of select="$LobNode/PCTVERSION"/>
     <xsl:value-of select="$LobNode/DEFPCTVERSION"/>
    </xsl:element>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <!-- *******************************************************************
Template: SFretention - SECUREFILE RETENTION element 
Parameters:
  Retention - Retention parameter value
  MinTime   - MinTime if "MIN" specified for Retention
******************************************************************** -->
 <!-- 11glob: LOB RENTENTION clause -->
 <xsl:template name="SFretention">
  <xsl:param name="Retention" select="''"/>
  <xsl:param name="MinTime" select="''"/>
  <xsl:choose>
   <!-- LOB RETENTION = NONE -->
   <xsl:when test="$Retention=0">
    <xsl:element name="RETENTION">
     <xsl:text>NONE</xsl:text>
    </xsl:element>
   </xsl:when>
   <!-- LOB RETENTION = AUTO -->
   <xsl:when test="$Retention=1">
    <xsl:element name="RETENTION">
     <xsl:text>AUTO</xsl:text>
    </xsl:element>
   </xsl:when>
   <!-- LOB RETENTION = MIN -->
   <xsl:when test="$Retention=2">
    <xsl:element name="RETENTION">
     <xsl:text>MIN </xsl:text>
    </xsl:element>
    <xsl:element name="MINTIME">
     <xsl:value-of select="$MinTime"/>
    </xsl:element>
   </xsl:when>
   <!-- LOB RETENTION = MAX -->
   <xsl:when test="$Retention=3">
    <xsl:element name="RETENTION">
     <xsl:text>MAX</xsl:text>
    </xsl:element>
   </xsl:when>
   <xsl:otherwise/>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoCache">
  <xsl:param name="FlagsNode" select="''"/>
  <xsl:param name="PropNode" select="''"/>
  <!-- *******************************************************************
Template: DoCache - put out the CACHE element
Parameters:
  FlagsNode - FLAGS or DEFFLAGS
See KKBCLATTR flag definitions in rdbms/src/server/dict/if/kkb.h
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="($FlagsNode mod 1024)>=512">
    <xsl:element name="CACHE">Y</xsl:element>
    <xsl:element name="LOGGING">Y</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 512)>=256">
    <xsl:element name="CACHE">Y</xsl:element>
    <xsl:element name="LOGGING">N</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 32)>=16">
    <xsl:element name="CACHE">READS</xsl:element>
    <xsl:element name="LOGGING">N</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 16)>=8">
    <xsl:element name="CACHE">READS</xsl:element>
    <xsl:element name="LOGGING">Y</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 4)>=2">
    <xsl:element name="CACHE">N</xsl:element>
    <xsl:element name="LOGGING">N</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 2)>=1">
    <xsl:element name="CACHE">N</xsl:element>
    <xsl:element name="LOGGING">Y</xsl:element>
   </xsl:when>
   <xsl:otherwise>
    <!-- both CACHE NOLOGGING and CACHE LOGGING are illegal for BASIC LOBs-->
    <xsl:element name="CACHE">Y</xsl:element>
   </xsl:otherwise>
  </xsl:choose>
  <!-- encryption -->
  <xsl:if test="($FlagsNode mod 8192)>=4096">
   <xsl:element name="LOBENCRYPT"/>
  </xsl:if>
  <!-- compression -->
  <xsl:choose>
   <xsl:when test="($FlagsNode mod 65536)>=32768">
    <xsl:element name="LOBCOMPRESS">HIGH</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 32768)>=16384">
    <xsl:element name="LOBCOMPRESS">MEDIUM</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 16384)>=8192">
    <xsl:element name="LOBCOMPRESS">LOW</xsl:element>
   </xsl:when>
  </xsl:choose>
  <!-- sharing granularity -->
  <xsl:choose>
   <xsl:when test="($FlagsNode mod 262144)>=131072">
    <xsl:element name="DEDUPLICATE">OBJECT</xsl:element>
   </xsl:when>
   <xsl:when test="($FlagsNode mod 131072)>=65536">
    <xsl:element name="DEDUPLICATE">LOB</xsl:element>
   </xsl:when>
  </xsl:choose>
  <!-- sharing validation -->
  <xsl:choose>
   <xsl:when test="($FlagsNode mod 524288)>=262144">
    <xsl:element name="VALIDATE">Y</xsl:element>
   </xsl:when>
   <xsl:when test="($PropNode mod 4096)>=2048">
    <xsl:element name="VALIDATE">N</xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="XMLTypeStorage">
  <xsl:param name="ColNode" select="''"/>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <!-- *******************************************************************
Template: XMLTypeStorage
Parameters:
  ColNode - COL_LIST_ITEM node
  TabBlocksize - table BLOCKSIZE
******************************************************************** -->
  <xsl:element name="XMLTYPE_STORAGE">
   <xsl:choose>
    <xsl:when test="$ColNode/OPQMD and ($ColNode/OPQMD/FLAGS mod 128) >=64">
     <xsl:element name="STORE_AS">BINARY_XML</xsl:element>
     <xsl:call-template name="LobColProperties">
      <xsl:with-param name="LobNode" select="$ColNode/LOBMD"/>
      <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="$ColNode/LOBMD">
     <xsl:element name="STORE_AS">LOB</xsl:element>
     <xsl:call-template name="LobColProperties">
      <xsl:with-param name="LobNode" select="$ColNode/LOBMD"/>
      <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="STORE_AS">OBJECT_RELATIONAL</xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
 <xsl:template name="XMLSchemaSpec">
  <xsl:param name="ColNode" select="''"/>
  <!-- *******************************************************************
Template: XMLSchemaSpec
Parameters:
  ColNode - COL_LIST_ITEM node
******************************************************************** -->
  <xsl:element name="XMLSCHEMA">
   <xsl:value-of select="$ColNode/OPQMD/SCHEMA_ELMT/XMLSCHEMA"/>
  </xsl:element>
  <xsl:element name="ELEMENT">
   <xsl:value-of select="$ColNode/OPQMD/SCHEMA_ELMT/ELEMENT_NAME"/>
  </xsl:element>
  <xsl:element name="ID">
   <xsl:value-of select="$ColNode/OPQMD/SCHEMA_ELMT/ELEMNUM"/>
  </xsl:element>
  <xsl:call-template name="XMLTypeAllowDisallow">
   <xsl:with-param name="ColNode" select="$ColNode"/>
  </xsl:call-template>
  <xsl:if test="(($ColNode/OPQMD/FLAGS) mod 64)>=32">
   <xsl:element name="OUT_OF_LINE"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="XMLTypeAllowDisallow">
  <xsl:param name="ColNode" select="''"/>
  <!-- *******************************************************************
Template: XMLTypeAllowDisallow
Parameters:
  ColNode - COL_LIST_ITEM node
******************************************************************** -->
  <xsl:if test="(($ColNode/OPQMD/FLAGS) mod 256)>=128">
   <xsl:element name="ALLOW_ANYSCHEMA"/>
  </xsl:if>
  <xsl:if test="(($ColNode/OPQMD/FLAGS) mod 512)>=256">
   <xsl:element name="DISALLOW_NONSCHEMA"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="XMLTypeVirtualColumns">
  <xsl:param name="VirtualCols" select="''"/>
  <!-- *******************************************************************
Template: XMLTypeVirtualColumns
Parameters:
  VirtualCols - set of COL_LIST_ITEM node for virtual columns
Note: virtual columns are inserted in reverse order, so we must sort.
******************************************************************** -->
  <xsl:if test="count($VirtualCols) > 0">
   <xsl:element name="XMLTYPE_VIRTUAL_COLUMNS">
    <xsl:element name="COL_LIST">
     <xsl:for-each select="$VirtualCols">
      <xsl:sort select="INTCOL_NUM" data-type="number" order="descending"/>
      <xsl:element name="COL_LIST_ITEM">
       <xsl:element name="NAME">
        <xsl:value-of select="NAME"/>
       </xsl:element>
       <xsl:element name="VIRTUAL">
        <xsl:value-of select="DEFAULT_VAL"/>
       </xsl:element>
      </xsl:element>
     </xsl:for-each>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
