<?xml version="1.0"?>
<!-- 
NAME
    kusyn.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_synonym_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    abodge      11/21/08 - Need SQLTERMINATOR set
    abodge      11/11/08 - Update from RDBMS_MAIN_LINUX_081110
    abodge      05/19/08 - 
    pkaliren    05/14/08 - Merge 11GC functionality
    xshen       05/26/04 - turn on sqlterminator
    xshen       05/18/04 - xshen_changemgr_cixsls-0518
    xshen       01/18/07 - turn on sql terminator
    mjangir     11/20/07 - bug 5607386: support emit schema option
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      11/21/03 - bug 3258753 
    htseng      12/18/02 - add EXPORT parameter
    dgagne      08/15/02 - add OR REPLACE to CREATE statement
    htseng      08/02/02 - add grantee parse param
    htseng      07/29/02 - add more parse params
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	10/04/00 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="SYNONYM_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">SYNONYM</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode">
    <xsl:choose>
     <xsl:when test="SYN_LONG_NAME">
      <xsl:value-of select="SYN_LONG_NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE</xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="SCHEMA_OBJ/OWNER_NAME='PUBLIC'">
    <xsl:text> PUBLIC SYNONYM "</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> SYNONYM "</xsl:text>
    <xsl:if test="$EMIT_SCHEMA=1">
     <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:text>"."</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="SYN_LONG_NAME">
    <xsl:value-of select="SYN_LONG_NAME"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>" FOR </xsl:text>
  <xsl:if test="$EMIT_SCHEMA=1">
   <xsl:if test="OWNER_NAME">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="OWNER_NAME"/>
    <xsl:text>".</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:text>"</xsl:text>
  <xsl:choose>
   <xsl:when test="OBJ_LONG_NAME">
    <xsl:value-of select="OBJ_LONG_NAME"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="NAME"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>"</xsl:text>
  <xsl:if test="DB_LINK">
   <xsl:text>@"</xsl:text>
   <xsl:value-of select="DB_LINK"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
