<?xml version="1.0"?>
<!-- 
NAME
    kutypspc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_type_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     10/30/08 - bug 7506545: fix CONSTRUCTOR function and
                           handle optional parameter and element list.
    rapayne     11/30/05 - Bug 3337571 - Add REGEN_DEFN support to regenerate 
                                       create ddl from dictionary xml.
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      12/08/03 - compiler switches support
    htseng      09/19/03 - compiler switches support 
    lbarton     07/07/03 - Bug 3016951: call PATCH_TYPEID
    gclaborn    06/04/03 - Add OID transform for INC_TYPE
    lbarton     04/08/03 - Bug 2844111: DoSourceLines
    lbarton     02/03/03 - INC_TYPE
    htseng      12/18/02 - add EXPORT parameter
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	07/17/00 - bugfix: use DoTerminator
    lbarton	06/02/00 - support parsing
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kusource.xsl"/>
 <xsl:import href="kuproc.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="SPECIFICATION">1</xsl:param>
 <xsl:param name="BODY">1</xsl:param>
 <!-- OID, TIMESTAMP, TRANSPORTABLE are only for export -->
 <xsl:param name="OID">0</xsl:param>
 <xsl:param name="TIMESTAMP">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="SIZE_BYTE_KEYWORD">0</xsl:param>
 <xsl:param name="DoLF">1</xsl:param>
 <xsl:param name="REGEN_DEFN">0</xsl:param>
 <!-- Incomplete type definition -->
 <xsl:template match="INC_TYPE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TYPE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>TYPE </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Schema" select="OWNER_NAME"/>
   <xsl:with-param name="Object" select="NAME"/>
  </xsl:call-template>
  <xsl:if test="$OID=1">
   <xsl:call-template name="EmitLFTab">
  </xsl:call-template>
   <xsl:text>  OID '</xsl:text>
   <xsl:value-of select="OID"/>
   <xsl:text>' </xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>
/</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TYPE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TYPE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>TYPE </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <!-- timestamp and OID clauses -->
  <xsl:if test="$TIMESTAMP=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  TIMESTAMP '</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/MTIME"/>
   <xsl:text>' </xsl:text>
  </xsl:if>
  <xsl:if test="$OID=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  OID '</xsl:text>
   <xsl:value-of select="OID"/>
   <xsl:text>' </xsl:text>
  </xsl:if>
  <!-- If the REGEN_DEFN transform parameter is NOT set (i.e., the default)
         then we are going to simply use the sql from source$ as we have 
         always done in the past.
   -->
  <xsl:choose>
   <xsl:when test="$REGEN_DEFN=0">
    <xsl:call-template name="GetSourceDDL">
     <xsl:with-param name="TypeNode" select="."/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <!-- If the REGEN_DEFN transform parameter is set then we are 
           going to regenerate the CREATE DDL from dictionary xml  rather 
           than simply using the sql from source$.
-->
    <xsl:choose>
     <xsl:when test="(PROPERTIES mod 512)>=256">
      <!-- incomplete type -->
      <xsl:text>;</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="RegenTypeDDL">
       <xsl:with-param name="TypeNode" select="."/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <!-- 
 Call the patch_typeid procedure.  This is only called if the
 type is part of an inheritance hierarchy (otherwise TYPEID is null)
 and the (undocumented, impdp-only) TRANSPORTABLE param is set.
 See prvtmetu.sql for more information.
-->
 <xsl:template match="TYPEID">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_METADATA.PATCH_TYPEID</xsl:with-param>
   <xsl:with-param name="ObjectType">TYPE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="../SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="../SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>
BEGIN DBMS_METADATA.PATCH_TYPEID('</xsl:text>
  <xsl:value-of select="../SCHEMA_OBJ/OWNER_NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="../SCHEMA_OBJ/NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="."/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="../HASHCODE"/>
  <xsl:text>'); END;</xsl:text>
  <xsl:if test="($SQLTERMINATOR=1)">
   <xsl:text>
/</xsl:text>
  </xsl:if>
  <xsl:text>&#xa;</xsl:text>
 </xsl:template>
 <xsl:template name="GetSourceDDL">
  <xsl:param name="TypeNode"/>
  <!-- *******************************************************************
Template:GetSourceDDL - retreive ddl from SOURCE_LINE
Parameters:
  TypeNode
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0">
    <xsl:apply-templates select="SOURCE_LINES"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoSourceLines">
     <xsl:with-param name="SourceLines" select="SOURCE_LINES"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text" select="SOURCE_LINES/SOURCE_LINES_ITEM[position()=last()]/SOURCE"/>
  </xsl:call-template>
  <!-- Property check first -->
  <xsl:if test="$TRANSPORTABLE=1">
   <xsl:apply-templates select="TYPEID"/>
  </xsl:if>
  <xsl:if test="$EXPORT=1 and COMPILER_INFO">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">
     <xsl:choose>
      <xsl:when test="local-name(.)='TYPE_BODY_T'">TYPE</xsl:when>
      <xsl:when test="local-name(.)='TYPE_T'">TYPE</xsl:when>
      <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text>&#xa;</xsl:text>
   <xsl:text>ALTER </xsl:text>
   <xsl:call-template name="ProcObjType">
    <xsl:with-param name="NodeName" select="local-name(.)"/>
   </xsl:call-template>
   <xsl:text> </xsl:text>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>  COMPILE </xsl:text>
   <xsl:call-template name="COMPILER_SWITCH"/>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>/</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="RegenTypeDDL">
  <xsl:param name="TypeNode"/>
  <!-- *******************************************************************
Template:RegenTypeDDL - Generate TYPE DDL from dictionary
Parameters:
  TypeNode
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="TYPE_NUM=108">
    <xsl:call-template name="DoObject">
     <xsl:with-param name="TypeNode" select="$TypeNode"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="TYPE_NUM=122">
    <xsl:call-template name="DoCollectionType">
     <xsl:with-param name="TypeNode" select="$TypeNode"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>*****Unsupported Type*****</xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoObject">
  <xsl:param name="TypeNode">0</xsl:param>
  <!-- *******************************************************************
Template:DoObject -  Generate Object Type ddl
Parameters:
  TypeNode  - <TYPE_T>
******************************************************************** -->
  <xsl:if test="PROPERTIES mod 32768 >= 16384">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>AUTHID CURRENT_USER </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="($TypeNode/PROPERTIES mod 16384)>=8192">
    <xsl:text>UNDER </xsl:text>
    <xsl:apply-templates select="$TypeNode/SUPERTYPE_OBJ"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>AS OBJECT </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- process SQLJ clause if appropriate -->
  <xsl:if test="EXTERNNAME ">
   <xsl:call-template name="sqljClause">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>   (</xsl:text>
  <xsl:call-template name="DoAttributeList">
   <xsl:with-param name="TypeNode" select="."/>
  </xsl:call-template>
  <!-- generate METHOD information -->
  <xsl:variable name="NeedComma">
   <xsl:choose>
    <xsl:when test="./ATTR_LIST/ATTR_LIST_ITEM[XFLAGS=0]">1</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="DoMethodList">
   <xsl:with-param name="TypeNode" select="."/>
   <xsl:with-param name="NeedComma" select="$NeedComma"/>
  </xsl:call-template>
  <xsl:text>&#xa;</xsl:text>
  <xsl:text>   ) </xsl:text>
  <!-- Check for NOT FINAL type -->
  <xsl:if test="(PROPERTIES mod 16) >= 8">
   <xsl:text>NOT FINAL </xsl:text>
  </xsl:if>
  <!-- Check for NOT INstantiable  type -->
  <xsl:if test="(PROPERTIES mod 131072) >= 65536">
   <xsl:text>NOT INSTANTIABLE </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoCollectionType">
  <xsl:param name="TypeNode">0</xsl:param>
  <!-- *******************************************************************
Template:DoCollectionType -  Generate Varray or Nested Table Type ddl
               COLLECTION/COLL_TYPE/TYPE_NUM
                      247 == VARRAY
                      248 == NESTED TABLE
Parameters:
  TypeNode  - <TYPE_T>
******************************************************************** -->
  <xsl:text>AS </xsl:text>
  <!-- TYPE_NAME will contain either VARYING ARRAY or TABLE -->
  <xsl:value-of select="$TypeNode/COLLECTION/COLL_TYPE/TYPE_NAME"/>
  <xsl:if test="$TypeNode/COLLECTION/UPPER_BOUND">
   <xsl:text>(</xsl:text>
   <xsl:value-of select="$TypeNode/COLLECTION/UPPER_BOUND"/>
   <xsl:text>)</xsl:text>
  </xsl:if>
  <xsl:text> OF </xsl:text>
  <!-- TheTYPE_NUM  template will handle the REF if necessary.
-->
  <xsl:apply-templates select="$TypeNode/COLLECTION/TYPEMD/TYPE_NUM">
   <xsl:with-param name="ParentNode" select="$TypeNode/COLLECTION"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="DoAttributeList">
  <xsl:param name="TypeNode">0</xsl:param>
  <!-- *******************************************************************
Template:DoAttributeList
Parameters:
   TypeNode - <TYPE_T>
******************************************************************** -->
  <xsl:for-each select="$TypeNode/ATTR_LIST/ATTR_LIST_ITEM">
   <xsl:sort select="$TypeNode/ATTRIBUTE_NUM" data-type="number"/>
   <!-- We only are going to process local attribute and NOT ones
that have been inherited from a supertype. We must retain the characteristic of a subtype
-->
   <xsl:if test="XFLAGS =0">
    <!-- Tab the column list -->
    <xsl:if test="$PRETTY and $DoLF=1">
     <xsl:text>	</xsl:text>
    </xsl:if>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="NAME"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <!-- Decode TYPE_NUM -->
    <xsl:apply-templates select="TYPEMD/TYPE_NUM">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:apply-templates>
    <xsl:if test="EXTERNNAME ">
     <xsl:text> EXTERNAL NAME '</xsl:text>
     <xsl:value-of select="EXTERNNAME"/>
     <xsl:text>'</xsl:text>
    </xsl:if>
    <xsl:if test="not(position()=last())">
     <xsl:call-template name="EmitCommaLF">
      <xsl:with-param name="DoLF" select="$DoLF"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoMethodList">
  <xsl:param name="TypeNode">0</xsl:param>
  <xsl:param name="NeedComma">1</xsl:param>
  <!-- *******************************************************************
Template:DoMethodList -  process all of the methods that make
     up this type
Parameters:
  TypeNode
  NeedComma - if there were no ATTRIBUTE_LIST_ITEMS then we do NOT 
                         need a comma before generating METHOD clauses
******************************************************************** -->
  <xsl:for-each select="$TypeNode/METHOD_LIST/METHOD_LIST_ITEM">
   <xsl:sort select="$TypeNode/METHOD_NUM" data-type="number"/>
   <!-- We only are going to process local methods and NOT ones
that have been inherited from a supertype. We must retain
the characteristic of a subtype.
-->
   <xsl:if test="XFLAGS = 0">
    <xsl:if test="$NeedComma=1">
     <xsl:call-template name="EmitCommaLF">
      <xsl:with-param name="DoLF" select="$DoLF"/>
     </xsl:call-template>
    </xsl:if>
    <!-- Tab the column list -->
    <xsl:if test="$PRETTY and $DoLF=1">
     <xsl:text>	</xsl:text>
    </xsl:if>
    <!-- Process inheritance flags 
           - first NOT FINAL and then NOT INSTANTIABLE
   -->
    <xsl:if test="8>(PROPERTIES mod 16)">
     <xsl:text>FINAL </xsl:text>
    </xsl:if>
    <xsl:if test="(PROPERTIES mod 131072>=65536)">
     <xsl:text>NOT INSTANTIABLE </xsl:text>
    </xsl:if>
    <xsl:if test="PROPERTIES mod 262144 >= 131072">
     <xsl:element name="OVERRIDING"/>
    </xsl:if>
    <!-- Generate Method qualifers -->
    <xsl:if test="(PROPERTIES mod 16>=8) and 
       (not(PROPERTIES mod 512>=256))">
     <xsl:text>STATIC </xsl:text>
    </xsl:if>
    <xsl:if test="(PROPERTIES mod 1024>=512)">
     <xsl:text>MAP </xsl:text>
    </xsl:if>
    <xsl:if test="(PROPERTIES mod 4096>=2048)">
     <xsl:text>ORDER </xsl:text>
    </xsl:if>
    <!-- only generate MEMBER if this is not a constructor function. -->
    <xsl:if test="(PROPERTIES mod 512>=256) and
                       not(PROPERTIES mod  64>= 32)">
     <xsl:text>MEMBER </xsl:text>
    </xsl:if>
    <xsl:choose>
     <xsl:when test="PROPERTIES mod  2048>= 1024">
      <xsl:text>PROCEDURE </xsl:text>
      <xsl:value-of select="NAME"/>
      <!-- Parse all of the arguments for current function -->
      <xsl:call-template name="DoMethodArgs">
       <xsl:with-param name="ArgCount" select="PARAMETERS_NUM"/>
       <xsl:with-param name="ArgList" select="ARGUMENT_LIST"/>
       <xsl:with-param name="Properties" select="PROPERTIES"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="PROPERTIES mod  64>= 32">CONSTRUCTOR </xsl:if>
      <xsl:text>FUNCTION </xsl:text>
      <xsl:text>"</xsl:text>
      <xsl:value-of select="NAME"/>
      <xsl:text>"</xsl:text>
      <!-- Parse all of the arguments for current function -->
      <xsl:call-template name="DoMethodArgs">
       <xsl:with-param name="ArgCount" select="PARAMETERS_NUM"/>
       <xsl:with-param name="ArgList" select="ARGUMENT_LIST"/>
       <xsl:with-param name="Properties" select="PROPERTIES"/>
      </xsl:call-template>
      <!-- Call out to process RETURN clause -->
      <xsl:call-template name="DoReturnClause">
       <xsl:with-param name="methodNode" select="."/>
       <xsl:with-param name="retArgNode" select="ARGUMENT_LIST/ARGUMENT_LIST_ITEM[POSITION_NUM=0]"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
    <!-- if FLAGS = 0 -->
   </xsl:if>
   <!-- call  PRAGMA function if appropriate for current method-->
   <xsl:if test="PROPERTIES mod  8192 >= 4096 or
   PROPERTIES mod  16384 >= 8192 or
   PROPERTIES mod  32768 >= 16384 or
   PROPERTIES mod  65536 >= 32768">
    <xsl:call-template name="DoPragmaClause">
     <xsl:with-param name="methodNode" select="."/>
    </xsl:call-template>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoMethodArgs">
  <xsl:param name="ArgCount" select="''"/>
  <xsl:param name="ArgList" select="''"/>
  <xsl:param name="Properties" select="''"/>
  <!-- *******************************************************************
Template: DoMethodArgs
Parameters:
   ArgCount  <PARAMETER_NUM>
   ArgList  <ARGUMENT/ARGUMENT_LIST>
   Properties <PROPERTIES>
******************************************************************** -->
  <xsl:if test="$ArgCount >=2 or
              ($ArgCount = 1 and not (($Properties mod 512) > 256))">
   <xsl:text> (</xsl:text>
  </xsl:if>
  <xsl:for-each select="$ArgList/ARGUMENT_LIST_ITEM[POSITION_NUM!=0]">
   <xsl:sort select="POSITION_NUM" data-type="number"/>
   <xsl:if test="ARGUMENT != 'SELF'">
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="ARGUMENT"/>
    </xsl:call-template>
    <!-- Process OUT or IN OUT qualifier. Note. IN is the default and is not displayed -->
    <xsl:text> </xsl:text>
    <xsl:if test="IN_OUT=1">
     <xsl:text>OUT </xsl:text>
    </xsl:if>
    <xsl:if test="IN_OUT=2">
     <xsl:text>IN OUT </xsl:text>
    </xsl:if>
    <xsl:if test="PROCEDURE_NUM > 0">
     <xsl:call-template name="DoPLSType">
      <xsl:with-param name="ParentNode" select="."/>
     </xsl:call-template>
     <xsl:if test="POSITION_NUM != $ArgCount">
      <xsl:call-template name="EmitCommaLF">
       <xsl:with-param name="DoLF" select="$DoLF"/>
      </xsl:call-template>
      <!-- TAB space the next procedure arg -->
      <xsl:if test="$PRETTY=1">
       <xsl:text>	</xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
  <!-- If there were parameters for this method then we need to close the parens -->
  <xsl:if test="$ArgCount >=2 or
              ($ArgCount = 1 and not (($Properties mod 512) > 256))">
   <xsl:text>) </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoReturnClause">
  <xsl:param name="methodNode" select="''"/>
  <xsl:param name="retArgNode" select="''"/>
  <!-- *******************************************************************
Template: DoReturnClause
Parameters:
   methodNode  <METHOD_LIST_ITEM>
   retArgNode  <ARGUMENT_LIST_ITEM[POSITION_NUM=0]>

******************************************************************** -->
  <!--xsl:call-template name="DoPLSType">
   <xsl:with-param name="ParentNode" select="$retArgNode"/
  </xsl:call-template>  
-->
  <xsl:text> RETURN </xsl:text>
  <xsl:choose>
   <xsl:when test="$methodNode/PROPERTIES mod 64 >= 32">
    <xsl:text>SELF AS RESULT </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="$retArgNode/PLS_TYPE">
     <!-- TYPE_NUM wants to put in things like CHAR (length) which we don't need here!-->
     <xsl:value-of select="$retArgNode/PLS_TYPE"/>
    </xsl:if>
    <xsl:if test="$retArgNode/TYPE_NAME">
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Schema" select="$retArgNode/TYPE_OWNER"/>
      <xsl:with-param name="Object" select="$retArgNode/TYPE_NAME"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="$methodNode/PROCJAVA">
     <xsl:text> </xsl:text>
     <xsl:call-template name="DoJavaCallSpec">
      <xsl:with-param name="ParentNode" select="$methodNode/PROCJAVA"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="$methodNode/PROCC">
     <xsl:text> </xsl:text>
     <xsl:call-template name="DoCCallSpec">
      <xsl:with-param name="ParentNode" select="$methodNode"/>
     </xsl:call-template>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoJavaCallSpec">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: DoJavaCallSpec
Parameters:
   ParentNode   - <PROCJAVA>
******************************************************************** -->
  <xsl:text>AS LANGUAGE JAVA NAME </xsl:text>
  <xsl:text>'</xsl:text>
  <xsl:value-of select="$ParentNode/USERSIGNATURE"/>
  <xsl:text>'</xsl:text>
 </xsl:template>
 <xsl:template name="DoCCallSpec">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: DoCCallSpec
Notes:  RAPRAP - not sure where to get the actual C procname
Parameters:
   ParentNode   - <METHOD_ITEM_LIST>
******************************************************************** -->
  <xsl:text>AS LANGUAGE C NAME </xsl:text>
  <xsl:value-of select="$ParentNode/PROCEDUREINFO/PROCEDURENAME"/>
 </xsl:template>
 <xsl:template name="DoPragmaClause">
  <xsl:param name="methodNode" select="''"/>
  <!-- *******************************************************************
Template: DoPragmaClause - 
Note: The pragma_clause has been depricated in 11.0 and therefore is NOT supported
          with regards to sxml. However, it remains here for consistency sake.
Parameters:
   methodNode  - <METHOD_LIST_ITEM>
******************************************************************** -->
  <xsl:call-template name="EmitCommaLF">
   <xsl:with-param name="DoLF" select="$DoLF"/>
  </xsl:call-template>
  <!-- TAB space the next procedure arg -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:text>PRAGMA RESTRICT_REFERENCES (</xsl:text>
  <xsl:value-of select="NAME"/>
  <!-- If appropriate, specify RNDS to enforce the constraint reads no database state, which means
that the method does not query database tables.-->
  <xsl:if test="$methodNode/PROPERTIES mod 8192 >= 4096">
   <xsl:text>, RNDS</xsl:text>
  </xsl:if>
  <!-- If appropriate, specify WNDS to enforce the constraint writes no database state, which means
that the method does not modify database tables. -->
  <xsl:if test="$methodNode/PROPERTIES mod 16384 >= 8192">
   <xsl:text>, WNDS</xsl:text>
  </xsl:if>
  <!-- If appropriate, specify RNPS to enforce the constraint reads no package state, which means
that the method does not reference package variables. -->
  <xsl:if test="$methodNode/PROPERTIES mod 32768 >= 16384">
   <xsl:text>, RNPS</xsl:text>
  </xsl:if>
  <!-- If appropriate,  specify WNPS to enforce the constraint writes no package state, which means
that the method does not modify packaged variables.-->
  <xsl:if test="$methodNode/PROPERTIES mod 65536 >= 32768">
   <xsl:text>, WNPS</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template name="EmitLFTab">
  <xsl:param name="DoLF">1</xsl:param>
  <!-- *******************************************************************
Template: EmitLFTab
 Emit a linefeed and a tab spacer
Parameters:
******************************************************************** -->
  <xsl:if test="$PRETTY=1 and $DoLF=1">
   <xsl:text>&#xa;	</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoPLSType">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: DoPLSType - if the PLS_TYPE node is present we use
      this to describe the object type. Otherwise we assume UDT and
      use TYPE_OWNER.TYPE_NAME
Parameters:
   ParentNode - parent of PLS_TYPE and TYPE_OWNER
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ParentNode/PLS_TYPE">
    <xsl:value-of select="$ParentNode/PLS_TYPE"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="$ParentNode/TYPE_OWNER"/>
    </xsl:call-template>
    <xsl:text>.</xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="$ParentNode/TYPE_NAME"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="sqljClause">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: sqljClause - 
Parameters:
   ParentNode - parent of EXTERNTYPE, EXTERNNAME
******************************************************************** -->
  <xsl:call-template name="EmitLFTab"/>
  <xsl:text>EXTERNAL NAME '</xsl:text>
  <xsl:value-of select="$ParentNode/EXTERNNAME"/>
  <xsl:text>'</xsl:text>
  <xsl:call-template name="EmitLFTab"/>
  <xsl:text>LANGUAGE  JAVA </xsl:text>
  <xsl:choose>
   <xsl:when test="$ParentNode/EXTERNTYPE = 1">
    <xsl:call-template name="EmitLFTab"/>
    <xsl:text>USING SQLData</xsl:text>
   </xsl:when>
   <xsl:when test="$ParentNode/EXTERNTYPE = 2">
    <xsl:call-template name="EmitLFTab"/>
    <xsl:text>USING CUSTOMDATUM</xsl:text>
   </xsl:when>
   <xsl:when test="$ParentNode/EXTERNTYPE = 5">
    <xsl:call-template name="EmitLFTab"/>
    <xsl:text>USING ORADATA</xsl:text>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
