<?xml version="1.0"?>
<!-- 
 Copyright (c) 2001, 2009, Oracle and/or its affiliates.All rights reserved. 
NAME
    kuuser.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_user_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     01/18/07 - bug 5584945: restrict password access to
                           EXP_FULL_DATABASE
    lbarton     04/03/06 - strong verification
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      08/02/02 - add grantee parse param
    htseng      07/29/02 - add more parse params
    htseng      09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	04/17/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="USER_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">USER</xsl:with-param>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="NAME='SYS' or NAME='SYSTEM'">
    <xsl:text> ALTER USER </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> CREATE USER </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="PASSWORD='GLOBAL'">
    <xsl:text> IDENTIFIED GLOBALLY AS '</xsl:text>
    <xsl:value-of select="EXT_USERNAME"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:when test="PASSWORD='EXTERNAL'">
    <xsl:text> IDENTIFIED EXTERNALLY </xsl:text>
   </xsl:when>
   <xsl:when test="PASSWORD">
    <xsl:text> IDENTIFIED BY VALUES '</xsl:text>
    <xsl:if test="SPARE4">
     <xsl:value-of select="SPARE4"/>
     <xsl:text>;</xsl:text>
    </xsl:if>
    <xsl:value-of select="PASSWORD"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="DATATS !='SYSTEM'">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> DEFAULT TABLESPACE </xsl:text>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Object" select="DATATS"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="TEMPTS !='SYSTEM'">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> TEMPORARY TABLESPACE </xsl:text>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Object" select="TEMPTS"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="PROFNUM != 0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
    <xsl:text>    </xsl:text>
   </xsl:if>
   <xsl:text> PROFILE </xsl:text>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Object" select="PROFNAME"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="ASTATUS != 0">
   <xsl:if test="(ASTATUS mod 4)> 0">
    <!-- KTSUCPEX =1 | KTSUCPEG =2  -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> PASSWORD EXPIRE</xsl:text>
   </xsl:if>
   <xsl:if test="ASTATUS >=4">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
     <xsl:text>    </xsl:text>
    </xsl:if>
    <xsl:text> ACCOUNT LOCK</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
