<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%--
  -- Page:        globalAwrReport.jsp
  -- Controller:  db/adm/inst/GlobalAwrReportController.java
  --
  -- Description: Page for creating global awr reports
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.swrf.AwrReportConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="globalReportForm"
               method="post"
	       destination ="globalAwrReport"              
               copyParams="target,type">
      <uix:formValue name="dbID" 
                     valueBinding="dbID@globalAwrReportBean@servletRequest"/>         
      <uix:formValue name="pageName" 
                     value="/database/awr/globalAwrReport"/>
  
        <uix:pageLayout titleBinding="AWR_REPORT@DBMsg">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- START: report input contents starts here --%>   
            <uix:spacer height="5"/>

            <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="AWR_GLOBAL_RPT_TIP@DBMsg" />
            <uix:spacer width="30"/>
	    <uix:submitButton textBinding="AWR_RPT_GENERATE@DBMsg" 
			      shortDescBinding="AWR_RPT_GENERATE@DBMsg"
			      name="event"
			      value ="<%= AwrReportConst.GENERATE_REPORT %>"/>
            </uix:rowLayout>
            <uix:spacer height="5"/>
            <uix:tableLayout>
            <uix:rowLayout >
               <oem:radioButton name="inputType"
                                textBinding="AWR_RPT_BASELINE@DBMsg"
                                value="<%= AwrReportConst.INPUT_BY_BSLN %>"
                                selectedValueBinding="inputType@globalAwrReportBean@servletRequest" />
            </uix:rowLayout >
            <uix:rowLayout>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt  promptBinding="BSLN@DBMsg" 
                                    labeledNodeId="baselineId" />
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
	        <uix:messageLovField name="baseline"
                             id="baselineId"
                             textBinding="baseline@globalAwrReportBean@servletRequest"
                             searchDescBinding="BSLN@DBMsg"
                               onClick= "preserveCase();setBindSqlParm('dbID'); startLov('baseline', 'ListBaselines')"  />

              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout >
               <oem:radioButton name="inputType"
                                textBinding="AWR_RPT_SNAPSHOT@DBMsg"
                                value="<%= AwrReportConst.INPUT_BY_SS %>"
                                selectedValueBinding="inputType@globalAwrReportBean@servletRequest" /> 
            </uix:rowLayout >
            <uix:rowLayout>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt  promptBinding="AWR_RPT_BEGIN_SS@DBMsg" 
                                    labeledNodeId="beginSSId" />
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
                <uix:messageLovField name="beginSS"
                             id="beginSSId"
                             textBinding="beginSS@globalAwrReportBean@servletRequest"
                             searchDescBinding="AWR_RPT_BEGIN_SS@DBMsg"
                               onClick= "startLov('beginSS', 'ListSnapshots')"  />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
            <uix:spacer height="5"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt  promptBinding="AWR_RPT_END_SS@DBMsg" 
                                    labeledNodeId="endSSId" />
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
                <uix:messageLovField name="endSS"
                             id="endSSId"
                             textBinding="endSS@globalAwrReportBean@servletRequest"
                             searchDescBinding="AWR_RPT_END_SS@DBMsg"
                               onClick= "startLov('endSS', 'ListSnapshots')"  />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
              <uix:spacer width="15"/>
       <uix:hideShow 
            undisclosedTextBinding="AWR_RPT_SHOW_INSTS@DBMsg"
            disclosedTextBinding="AWR_RPT_HIDE_INSTS@DBMsg"
            renderedBinding="isRac@servletRequest"
            id="hideShowInstances" 
            partialRenderMode="self"
            disclosedBinding="isShowInstances@servletRequest"
            formSubmitted="true">
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt  promptBinding="AWR_RPT_INSTS@DBMsg" 
                                    labeledNodeId="instancesNameId"/>
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
		<uix:switcher childNameBinding="setModeBsln@globalAwrReportBean@servletRequest">
		<uix:case name="false">
                <uix:messageLovField name="instanceNames"
                             id="instancesNameId"
                             textBinding="instanceNames@globalAwrReportBean@servletRequest"
                             searchDescBinding="AWR_RPT_INSTS@DBMsg"
                               onClick= "preserveCase();selectMultiple();setBindSqlParm('dbID');setBindSqlParm('beginSS');setBindSqlParm('endSS');startLov('instanceNames', 'ListInstancesSS')"  />
		</uix:case>
		<uix:case name="true">
                <uix:messageLovField name="instanceNames"
                             id="instancesNameId"
                             textBinding="instanceNames@globalAwrReportBean@servletRequest"
                             searchDescBinding="AWR_RPT_INSTS@DBMsg"
                               onClick= "preserveCase();selectMultiple();setBindSqlParm('dbID');setBindSqlParm('baseline');startLov('instanceNames', 'ListInstancesBsln')"  />
		</uix:case>
		</uix:switcher>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
                <uix:tip>
                  <uix:contents>
                        <uix:styledText styleClass="OraTipText" 
                              textBinding="AWR_RPT_INST_TIP@DBMsg"/>
                  </uix:contents>
                </uix:tip>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:hideShow>

	  <uix:spacer height="15"/>
          <%-- END: report input contents ends here --%>   
	<uix:header textBinding ="AWR_RPT_RESULTS@DBMsg" renderedBinding="showReport@globalAwrReportBean@servletRequest">
	  <uix:spacer height="5"/>
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:submitButton textBinding="SAVE_TO_FILE@DBMsg" 
                    name="event" value="saveToFile" />
               </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout width="100%" >
              <uix:rawText textBinding="awrReport@globalAwrReportBean@servletRequest" />
            </uix:tableLayout>
          </uix:header>

        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
