<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.ctlr.BaselineConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.view.AlertConfigurationPage" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.view.EditThresholdsPage" %>

<%-- JavaScript functions --%>

<script language="JavaScript">
function getSelectedMetric()
{
  var metricC =
   document.thresholdsForm.elements['selectedMetrics:length'].value;
  var metricI;

  for (metricI = 0; metricI < metricC; metricI++)
  {
    if (document.thresholdsForm.elements["selectedMetrics:selected"][metricI].checked)
    {
      document.goEditForm.<%= BaselineConstants.PARAM_METRICID %>.value =
       document.thresholdsForm.elements["selectedMetrics:<%= BaselineConstants.PARAM_METRICID %>:"+metricI].value;
    }
  }

  return true;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="msgs" class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineConstants.ATTRNAME_PAGEBEAN+"@servletRequest" %>'>

      <uix:body>
        <uix:pageLayout titleBinding="TITLE_PAGE_BASELINEMETRICTHRESHOLDS@msgs">

          <%@ include file="/database/global.jspf" %>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
               <uix:contents>
                <uix:link textBinding="TITLE_TAB_ALERTCONFIGURATION@msgs"/>
                <uix:link textBinding="TITLE_TAB_METRICANALYSIS@msgs"
                          destinationBinding="metricAnalysisURL"/>
               </uix:contents>
              </uix:subTabBar>
            </uix:subTabs>

           <uix:contents>
            <uix:stackLayout>

<uix:form name="goEditForm"
          destination="<%= request.getContextPath()+BaselineConstants.CONSOLE_DIR+EditThresholdsPage.URL_PATH %>"
          onSubmit="return getSelectedMetric()">
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETNAME %>"
                 valueBinding="targetName"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETTYPE %>"
                 valueBinding="targetType"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_METRICID %>"/>
</uix:form>

<uix:form name="thresholdsForm"
          method="POST">
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETNAME %>"
                 valueBinding="targetName"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETTYPE %>"
                 valueBinding="targetType"/>
  <uix:formValue name="event"
                 value="<%= BaselineConstants.EVENT_FILTER %>"/>

              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat><uix:spacer width="1" height="35"/></uix:cellFormat>
                  <uix:cellFormat hAlign="right">
                    <uix:button textBinding="ACTION_QUICKCONFIG@msgs"
                                destinationBinding="quickConfigPopupURL"
                                shortDescBinding="ACTION_QUICKCONFIG@msgs"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:messageChoice promptBinding="ACTION_FILTERMETRICS@msgs"
                                     name="<%= BaselineConstants.PARAM_METRICFILTER %>"
                                     selectedValueBinding="metricFilter"
                                     shortDescBinding="SHORTDESC_FILTERTYPE@msgs"
                                     onChange="document.thresholdsForm.submit()">
                    <uix:option textBinding="CHOICE_INEFFECT@msgs"
                                value="<%= BaselineConstants.METRICFILTER_INEFFECT %>"/>
                    <uix:option textBinding="CHOICE_PREFERRED@msgs"
                                value="<%= BaselineConstants.METRICFILTER_PREFERRED %>"/>
                    <uix:option textBinding="CHOICE_BASELINED@msgs"
                                value="<%= BaselineConstants.METRICFILTER_NONE %>"/>
                  </uix:messageChoice>
                  <uix:cellFormat width="100%"><uix:spacer width="5" height="10"/></uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout><uix:spacer width="1" height="15"/></uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat columnSpan="2">

  <uix:table id="selectedMetrics"
             summaryBinding="TITLE_TABLE_THRESHOLDS@msgs"
             alternateTextBinding="EMPTY_TABLE_THRESHOLDS@msgs"
             formSubmitted="false"
             tableDataBinding="thresholdSettings"
             width="100%">

    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="ATTRNAME_CATEGORYNAME@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                        width="38%"/>
     <uix:contents>
      <uix:rowLayout>
        <uix:image renderedBinding="expandable"
                   sourceBinding="toggleExpandSource"
                   destinationBinding="toggleExpandDest"
                   shortDescBinding="toggleExpandLabel"/>
        <uix:spacer renderedBinding="expandable"
                    width="2" height="2"/>
        <uix:spacer renderedBinding="inexpandable"
                    width="30" height="24"/>
        <uix:cellFormat vAlign="bottom">
          <uix:styledText textBinding="metricLabel"
                          styleClassBinding="metricStyle"
                          destinationBinding="editThresholdsDest"/>
        </uix:cellFormat>
      </uix:rowLayout>
     </uix:contents>
    </uix:column>

    <uix:column>
      <uix:columnHeader>
        <uix:stackLayout>
          <uix:styledText textBinding="ATTRNAME_ALERTCOUNTS@msgs"/>
          <uix:styledText textBinding="LABEL_ALERTCOUNT_QUALIFIER@msgs"/>
        </uix:stackLayout>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="<%= UIConstants.NUMBER_FORMAT %>"
                        width="10%"/>
     <uix:contents>
      <uix:rowLayout>
        <uix:styledText textBinding="criticalCount"
                        inlineStyleBinding="criticalStyle"
                        shortDescBinding="criticalDesc"/>
        <uix:spacer width="5" height="2"/>
        <uix:cellFormat width="16" hAlign="right">
          <uix:styledText textBinding="warningCount"
                          inlineStyleBinding="warningStyle"
                          shortDescBinding="warningDesc"/>
        </uix:cellFormat>
      </uix:rowLayout>
     </uix:contents>
    </uix:column>

    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="ATTRNAME_AWRBASELINE@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                        width="23%"/>
     <uix:contents>
      <uix:styledText textBinding="baselineLabel"/>
     </uix:contents>
    </uix:column>

    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="ATTRNAME_THRESHOLDTYPE@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                        cellNoWrapFormat="true"
                        width="17%"/>
     <uix:contents>
      <uix:styledText textBinding="thresholdingMethodLabel"
                      shortDescBinding="thresholdingMethodDesc"/>
     </uix:contents>
    </uix:column>

    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="ATTRNAME_ADAPTIVE@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                        width="5%"/>
     <uix:contents>
      <uix:image sourceBinding="adaptive"/>
     </uix:contents>
    </uix:column>

    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="ACTION_EDITSETTINGS@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                        width="10%"/>
     <uix:contents>
      <uix:image renderedBinding="inexpandable"
                 source="/em/images/updateicon_enabled.gif"
                 destinationBinding="editThresholdsDest"
                 shortDescBinding="ACTION_EDITSETTINGS@msgs"/>
     </uix:contents>
    </uix:column>
  </uix:table>

                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
</uix:form>

            </uix:stackLayout>
           </uix:contents>
          </uix:subTabLayout>

          <oem:relatedLinks/>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
