<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.model.BSLNConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.ctlr.BaselineConstants" %>

<%-- JavaBean references --%>

<jsp:useBean id="pageBean"
             scope="request"
             type="oracle.sysman.dbTarget.db.bsln.view.EditThresholdsPage"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
function onChangeBaseline()
{
  var bslnElt =
   document.editThresholdsForm.<%= BaselineConstants.PARAM_BASELINE %>;
  document.updateDisplayForm.<%= BaselineConstants.PARAM_BASELINE %>.value =
   bslnElt.options[bslnElt.selectedIndex].value;
  submitForm('updateDisplayForm',1,{'event':'<%= BaselineConstants.EVENT_DOLOAD %>'});
}

function onChangeThresholdingMethod()
{
  var thrMethodElt =
   document.editThresholdsForm.<%= BaselineConstants.PARAM_THRMETHOD %>;
  document.updateDisplayForm.<%= BaselineConstants.PARAM_THRMETHOD %>.value =
   thrMethodElt.options[thrMethodElt.selectedIndex].value;
  submitForm('updateDisplayForm',1,{'event':'<%= BaselineConstants.EVENT_SWITCHMETHOD %>'});
}

function getThresholdParams()
{
  var warningInput = document.editThresholdsForm.<%= BaselineConstants.PARAM_WARNINGPARAM %>;
  var criticalInput = document.editThresholdsForm.<%= BaselineConstants.PARAM_CRITICALPARAM %>;
  var occursInput = document.editThresholdsForm.<%= BaselineConstants.PARAM_OCCURRENCES %>;
<% if (BSLNConstants.METHOD_SIGLVL.equals(pageBean.getThreshold().getSetting().getThresholdingMethod())) { %>
  warningInput = warningInput.options[warningInput.selectedIndex];
  criticalInput = criticalInput.options[criticalInput.selectedIndex];
<% } %>
  document.updateDisplayForm.<%= BaselineConstants.PARAM_WARNINGPARAM %>.value = warningInput.value;
  document.updateDisplayForm.<%= BaselineConstants.PARAM_CRITICALPARAM %>.value = criticalInput.value;
  document.updateDisplayForm.<%= BaselineConstants.PARAM_OCCURRENCES %>.value = occursInput.value;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="msgs" class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineConstants.ATTRNAME_PAGEBEAN+"@servletRequest" %>'>

      <uix:body>
        <uix:pageLayout titleBinding="title">

          <%@ include file="/database/global.jspf" %>

<%
boolean preferred = BSLNConstants.STATUS_PREFERRED.equals(pageBean.getThreshold().getSetting().getMetric().getStatus());
%>

          <uix:tableLayout width="100%">
            <%--
              == Warning message that statistics are required for this
              == page.
              --%>
            <uix:rowLayout renderedBinding="noStatisticsAvailable">
              <uix:messageStyledText textBinding="statisticsRequiredMessage"
                                     styleClass="OraTipText"
                                     messageType="<%= UIConstants.MESSAGE_TYPE_WARNING %>"/>
            </uix:rowLayout>

            <%--
              == Last updated date
              --%>
            <uix:rowLayout hAlign="right">
              <uix:flowLayout>
                <uix:styledText textBinding="LAST_UPDATED@sdkMsgs"
                                styleClass="OraTipText"/>
                <uix:spacer width="4"/>
                <uix:styledText textBinding="lastUpdated"
                                styleClass="OraTipLabel"/>
              </uix:flowLayout>
            </uix:rowLayout>

            <%--
              == Non-preferred metric message area.
              --%>
            <uix:rowLayout rendered="<%= new Boolean(!preferred).toString() %>"><uix:spacer width="1" height="5"/></uix:rowLayout>
            <uix:rowLayout rendered="<%= new Boolean(!preferred) %>">
              <uix:styledText textBinding="nonPreferredMessage"
                              styleClass="OraDataText"/>
            </uix:rowLayout>
            <uix:rowLayout rendered="<%= new Boolean(!preferred) %>"><uix:spacer width="1" height="5"/></uix:rowLayout>
            <uix:rowLayout rendered="<%= new Boolean(!preferred) %>">
              <uix:styledText textBinding="DESC_NONPREFERRED_NOSIGLVL@msgs"
                              styleClass="OraPromptText"/>
            </uix:rowLayout>
            <uix:rowLayout rendered="<%= new Boolean(!preferred) %>"><uix:spacer width="1" height="5"/></uix:rowLayout>
            <uix:rowLayout rendered="<%= new Boolean(!preferred) %>">
              <uix:styledText textBinding="DESC_NONPREFERRED_NOPERMINUTE@msgs"
                              styleClass="OraPromptText"/>
            </uix:rowLayout>

          </uix:tableLayout>

          <uix:tableLayout>
            <uix:rowLayout>

<%--
  == The editThresholds form is the form submitted to make a change to the
  ==  threshold settings.  It has a different action than the one that loaded
  ==  this page.
  --%>
<uix:form name="editThresholdsForm"
          destinationBinding="eventURL">

  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETNAME %>"
                 valueBinding="targetName"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETTYPE %>"
                 valueBinding="targetType"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_METRICID %>"
                 valueBinding="metricId@setting@threshold@pageBean@servletRequest"/>

              <uix:cellFormat width="350" vAlign="top">
                <uix:stackLayout>

                  <uix:dataScope currentDataBinding="threshold">

                    <uix:header textBinding="HEADER_AWRBASELINE@msgs">
                      <uix:tableLayout>
                        <uix:rowLayout><uix:spacer width="1" height="10"/></uix:rowLayout>
                        <uix:rowLayout>
                          <uix:spacer width="10" height="1"/>
                          <uix:cellFormat vAlign="center">
                            <uix:messageChoice promptBinding="NAME@sdkMsgs"
                                               name="<%= BaselineConstants.PARAM_BASELINE %>"
                                               selectedValueBinding="guid@baseline@setting@threshold@pageBean@servletRequest"
                                               shortDescBinding="ATTRNAME_AWRBASELINE@msgs"
                                               onChange="onChangeBaseline()">
                             <uix:contents childDataBinding="baselines@pageBean@servletRequest">
                              <uix:option textBinding="baselineName"
                                          valueBinding="guid"/>
                             </uix:contents>
                            </uix:messageChoice>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout><uix:spacer width="1" height="<%= pageBean.getMetricCalendar().getMasterDayHeight().intValue()-36 %>"/></uix:rowLayout>
                      </uix:tableLayout>
                    </uix:header>

                    <uix:header textBinding="HEADER_THRESHOLDSETTINGS@msgs">
                      <uix:tableLayout cellSpacing="3">

                        <uix:rowLayout>
                          <uix:cellFormat rowSpan="6">
                            <uix:spacer width="8" height="1"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="right" wrappingDisabled="true">
                            <uix:styledText textBinding="ATTRNAME_THRESHOLDTYPE@msgs"
                                            styleClass="OraPromptText"/>
                          </uix:cellFormat>
                          <uix:cellFormat rowSpan="6"><uix:spacer width="5" height="1"/></uix:cellFormat>
                          <uix:dataScope currentDataBinding="setting">
                          <uix:choice name="<%= BaselineConstants.PARAM_THRMETHOD %>"
                                      selectedValueBinding="thresholdingMethod"
                                      shortDescBinding="ATTRNAME_THRESHOLDTYPE@msgs"
                                      onChange="onChangeThresholdingMethod()">
                            <uix:option textBinding="ATTRVAL_SIGLVL@msgs"
                                        value="<%= BSLNConstants.METHOD_SIGLVL %>"
                                        rendered="<%= new Boolean(preferred) %>"/>
                            <uix:option textBinding="ATTRVAL_PCTMAX@msgs"
                                        value="<%= BSLNConstants.METHOD_PCTMAX %>"/>
                            <uix:option textBinding="ATTRVAL_ABSVAL@msgs"
                                        value="<%= BSLNConstants.METHOD_ABSVAL %>"/>
                          </uix:choice>
                          </uix:dataScope>
                          <uix:cellFormat rowSpan="6" width="100%"><uix:spacer width="1" height="1"/></uix:cellFormat>
                        </uix:rowLayout>

                        <%--
                          ==  Critical threshold parameter
                          --%>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right" wrappingDisabled="true">
                            <uix:messagePrompt promptBinding="CRITICAL@sdkMsgs"
                                               messageTypeBinding='<%= BaselineConstants.PARAM_CRITICALPARAM+"MsgType@errorBean@servletRequest" %>'/>
                            <uix:spacer width="3" height="1"/>
                            <uix:image source="/em/images/critical.gif"
                                       shortDescBinding="CRITICAL@sdkMsgs"/>
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:dataScope currentDataBinding="setting">
                            <uix:switcher childNameBinding="thresholdingMethod">
                              <uix:case name="<%= BSLNConstants.METHOD_SIGLVL %>">
                                <uix:choice name="<%= BaselineConstants.PARAM_CRITICALPARAM %>"
                                            selectedValueBinding="criticalParam"
                                            shortDescBinding="ATTRNAME_CRITICALLEVEL@msgs">
                                  <uix:option textBinding="ATTRVAL_NONE@msgs"
                                              value="<%= BSLNConstants.NULL_DOUBLE %>"/>
                                  <uix:option textBinding="highPercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_95 %>"/>
                                  <uix:option textBinding="veryHighPercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_99 %>"/>
                                  <uix:option textBinding="severePercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_999 %>"/>
                                  <uix:option textBinding="extremePercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_9999 %>"/>
                                </uix:choice>
                              </uix:case>
                              <uix:case name="<%= BSLNConstants.METHOD_PCTMAX %>">
                                <uix:flowLayout>
                                  <uix:messageTextInput name="<%= BaselineConstants.PARAM_CRITICALPARAM %>"
                                                        textBinding="criticalValue@threshold@pageBean@servletRequest"
                                                        messageBinding='<%= BaselineConstants.PARAM_CRITICALPARAM+"Msg@errorBean@servletRequest" %>'
                                                        shortDescBinding="ATTRNAME_CRITICALLEVEL@msgs"
                                                        columns="3">
                                   <uix:end>
                                    <uix:styledText text="%" styleClass="OraDataText"/>
                                   </uix:end>
                                  </uix:messageTextInput>
                                </uix:flowLayout>
                              </uix:case>
                              <uix:case name="<%= BSLNConstants.METHOD_ABSVAL %>">
                                <uix:messageTextInput name="<%= BaselineConstants.PARAM_CRITICALPARAM %>"
                                                      textBinding="criticalValue@threshold@pageBean@servletRequest"
                                                      messageBinding='<%= BaselineConstants.PARAM_CRITICALPARAM+"Msg@errorBean@servletRequest" %>'
                                                      shortDescBinding="LABEL_CRITICALTHRESHOLD@msgs"
                                                      columns="5"/>
                              </uix:case>
                            </uix:switcher>
                            </uix:dataScope>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <%--
                          ==  Warning threshold parameter
                          --%> 
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right" wrappingDisabled="true">
                            <uix:messagePrompt promptBinding="WARNING@sdkMsgs"
                                               messageTypeBinding='<%= BaselineConstants.PARAM_WARNINGPARAM+"MsgType@errorBean@servletRequest" %>'/>
                            <uix:spacer width="3" height="1"/>
                            <uix:image source="/em/images/warning.gif"
                                       shortDescBinding="WARNING@sdkMsgs"/>
                          </uix:cellFormat>
                          <uix:cellFormat width="200">
                            <uix:dataScope currentDataBinding="setting">
                            <uix:switcher childNameBinding="thresholdingMethod">
                              <uix:case name="<%= BSLNConstants.METHOD_SIGLVL %>">
                                <uix:choice name="<%= BaselineConstants.PARAM_WARNINGPARAM %>"
                                            selectedValueBinding="warningParam"
                                            shortDescBinding="ATTRNAME_WARNINGLEVEL@msgs">
                                  <uix:option textBinding="ATTRVAL_NONE@msgs"
                                              value="<%= BSLNConstants.NULL_DOUBLE %>"/>
                                  <uix:option textBinding="highPercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_95 %>"/>
                                  <uix:option textBinding="veryHighPercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_99 %>"/>
                                  <uix:option textBinding="severePercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_999 %>"/>
                                  <uix:option textBinding="extremePercentileLabel@pageBean@servletRequest"
                                              value="<%= BSLNConstants.SIGLVL_9999 %>"/>
                                </uix:choice>
                              </uix:case>
                              <uix:case name="<%= BSLNConstants.METHOD_PCTMAX %>">
                                <uix:flowLayout>
                                  <uix:messageTextInput name="<%= BaselineConstants.PARAM_WARNINGPARAM %>"
                                                        textBinding="warningValue@threshold@pageBean@servletRequest"
                                                        messageBinding='<%= BaselineConstants.PARAM_WARNINGPARAM+"Msg@errorBean@servletRequest" %>'
                                                        shortDescBinding="ATTRNAME_WARNINGLEVEL@msgs"
                                                        columns="3">
                                   <uix:end>
                                    <uix:styledText text="%" styleClass="OraDataText"/>
                                   </uix:end>
                                  </uix:messageTextInput>
                                </uix:flowLayout>
                              </uix:case>
                              <uix:case name="<%= BSLNConstants.METHOD_ABSVAL %>">
                                <uix:messageTextInput name="<%= BaselineConstants.PARAM_WARNINGPARAM %>"
                                                      textBinding="warningValue@threshold@pageBean@servletRequest"
                                                      messageBinding='<%= BaselineConstants.PARAM_WARNINGPARAM+"Msg@errorBean@servletRequest" %>'
                                                      shortDescBinding="LABEL_WARNINGTHRESHOLD@msgs"
                                                      columns="5"/>
                              </uix:case>
                            </uix:switcher>
                            </uix:dataScope>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <%--
                          ==  Occurrences threshold parameter
                          --%>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt promptBinding="ATTRNAME_OCCURRENCES@msgs"
                                               messageTypeBinding='<%= BaselineConstants.PARAM_OCCURRENCES+"MsgType@errorBean@servletRequest" %>'/>
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:messageTextInput name="<%= BaselineConstants.PARAM_OCCURRENCES %>"
                                                  textBinding="occurrencesValue"
                                                  messageBinding='<%= BaselineConstants.PARAM_OCCURRENCES+"Msg@errorBean@servletRequest" %>'
                                                  shortDescBinding="ATTRNAME_OCCURRENCES@msgs"
                                                  columns="2"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:spacer width="1" height="60"/>
                          <uix:cellFormat hAlign="left" vAlign="top"
                                          width="100%">
                            <uix:submitButton textBinding="ACTION_UPDATEDISPLAY@msgs"
                                              formName="updateDisplayForm"
                                              event="<%= BaselineConstants.EVENT_UPDATE %>"
                                              onClick="getThresholdParams()"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout><uix:spacer width="1" height="68"/></uix:rowLayout>

                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right" columnSpan="4">
                            <uix:tableLayout>
                              <uix:rowLayout vAlign="bottom">
                                <uix:cellFormat columnSpan="3" hAlign="right">
                                  <uix:styledText textBinding="HEADER_LEGEND@msgs"
                                                  styleClass="OraHeaderSubSub"/>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout vAlign="bottom" hAlign="right">
                                <uix:cellFormat height="10" wrappingDisabled="true">
                                  <uix:styledText textBinding="LABEL_METRICDATA@msgs"
                                                  styleClass="OraTipText"/>
                                </uix:cellFormat>
                                <uix:spacer width="5" height="10"/>
                                <uix:cellFormat height="1" vAlign="center">
                                  <uix:rawText><table><tr><td style='<%= "background-color:"+pageBean.getMetricCalendar().getTrendColorAttribute() %>'><script>t(10,1)</script></td></tr></table></uix:rawText>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout vAlign="bottom" hAlign="right">
                                <uix:cellFormat height="10" wrappingDisabled="true">
                                  <uix:styledText textBinding="LABEL_CRITICALTHRESHOLD@msgs"
                                                  styleClass="OraTipText"/>
                                </uix:cellFormat>
                                <uix:spacer width="5" height="10"/>
                                <uix:cellFormat height="1" vAlign="center">
                                  <uix:rawText><table><tr><td style='<%= "background-color:"+pageBean.getMetricCalendar().getExtremeColorAttribute() %>'><script>t(10,1)</script></td></tr></table></uix:rawText>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout vAlign="bottom" hAlign="right">
                                <uix:cellFormat height="10" wrappingDisabled="true">
                                  <uix:styledText textBinding="LABEL_WARNINGTHRESHOLD@msgs"
                                                  styleClass="OraTipText"/>
                                </uix:cellFormat>
                                <uix:spacer width="5" height="10"/>
                                <uix:cellFormat height="1" vAlign="center">
                                  <uix:rawText><table><tr><td style='<%= "background-color:"+pageBean.getMetricCalendar().getSevereColorAttribute() %>'><script>t(10,1)</script></td></tr></table></uix:rawText>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout vAlign="bottom" hAlign="right">
                                <uix:cellFormat height="10" wrappingDisabled="true">
                                  <uix:styledText textBinding="typicalValuesLabel@pageBean@servletRequest"
                                                  styleClass="OraTipText"/>
                                </uix:cellFormat>
                                <uix:spacer width="5" height="15"/>
                                <uix:cellFormat height="10">
                                  <uix:rawText><table><tr><td style='<%= "background-color:"+pageBean.getMetricCalendar().getNormalColorAttribute() %>'><script>t(10,10)</script></td></tr></table></uix:rawText>
                                </uix:cellFormat>
                              </uix:rowLayout>
                            </uix:tableLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:header>

                  </uix:dataScope>

                </uix:stackLayout>

              </uix:cellFormat>

</uix:form>

<%--
  == The updateDisplay form is submitted via the Update Display button.
  == It does nothing more than transfer the editThresholds form values for
  ==  a refresh, but we use a different form for apply/clear settings events
  ==  because they are for different actions.
  --%>
<uix:form name="updateDisplayForm">
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETNAME %>"
                 valueBinding="targetName"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_TARGETTYPE %>"
                 valueBinding="targetType"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_BASELINE %>"
                 valueBinding="guid@baseline@setting@threshold@pageBean@servletRequest"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_OCCURRENCES %>"
                 valueBinding="occurrencesValue@threshold@pageBean@servletRequest"/>
  <uix:dataScope currentDataBinding="setting@threshold@pageBean@servletRequest">
  <uix:formValue name="<%= BaselineConstants.PARAM_METRICID %>"
                 valueBinding="metricId"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_THRMETHOD %>"
                 valueBinding="thresholdingMethod"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_WARNINGPARAM %>"
                 valueBinding="warningParam"/>
  <uix:formValue name="<%= BaselineConstants.PARAM_CRITICALPARAM %>"
                 valueBinding="criticalParam"/>
  </uix:dataScope>
  <uix:formValue name="<%= BaselineConstants.PARAM_DATE %>"
                 value="<%= pageBean.getMetricCalendar().getDate() %>"/>

              <uix:cellFormat vAlign="top">

                <%@ include file="metricCalendar.jspf" %>

              </uix:cellFormat>

</uix:form>

            </uix:rowLayout>

          </uix:tableLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@sdkMsgs"
                          destinationBinding="alertConfigurationURL"/>
              <uix:submitButton textBinding="ACTION_UNSETTHRESHOLDS@msgs"
                                formName="editThresholdsForm"
                                event="<%= BaselineConstants.EVENT_CLEARSETTING %>"/>
              <uix:submitButton textBinding="ACTION_APPLYTHRESHOLDS@msgs"
                                formName="editThresholdsForm"
                                event="<%= BaselineConstants.EVENT_APPLYSETTING %>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <oem:relatedLinks/>

        </uix:pageLayout>

      </uix:body>

    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
